/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.CSH;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManifestClasspathInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ManifestClasspathInspector.class);
    private static String LIST_NAME = localStrings.getLocalString("ui.manifestclasspathinspector.list_name", "List");
    private static String LIST_DESC = localStrings.getLocalString("ui.manifestclasspathinspector.list_desc", "This is a list of items");
    private static String MFC_BOXTITLE = localStrings.getLocalString("ui.manifestclasspathinspector.boxtitle", "JARs in Manifest Classpath:");
    private static String INSPECTOR_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.inspector_button", "Manifest Classpath...");
    private static String ADD_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.add_button", "Add>");
    private static String REMOVE_BUTTON = localStrings.getLocalString("ui.manifestclasspathinspector.remove_button", "<Remove");
    private static char ADD_BUTTON_MNEMONIC = localStrings.getLocalString("ui.manifestclasspathinspector.add_button_mnemonic", "a").charAt(0);
    private static char REMOVE_BUTTON_MNEMONIC = localStrings.getLocalString("ui.manifestclasspathinspector.remove_button_mnemonic", "r").charAt(0);
    private static char INSPECTOR_BUTTON_MNEMONIC = localStrings.getLocalString("ui.manifestclasspathinspector.inspector_button_mnemonic", "M").charAt(0);
    private static String helpSetMapID = "ManifestClasspath";

    private static String DIALOG_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.manifestclasspathinspector.dialogtitle_for", "Manifest Classpath for {0}", new Object[]{v0});
    }

    private static String JARLIST_TITLE_FOR(String v0) {
        return localStrings.getLocalString("ui.manifestclasspathinspector.jarlisttitle_for", "Library JARs in {0}", new Object[]{v0});
    }

    private ManifestClasspathInspector() {
    }

    public static class DialogDisplayButton
    extends UIButton
    implements ActionListener {
        private UpdateListener target = null;
        private Descriptor appDescriptor = null;
        private String archName = null;
        private ListModel listModel = null;
        private ManifestClasspathDialog dialog = null;

        public DialogDisplayButton(UpdateListener target) {
            super(INSPECTOR_BUTTON, INSPECTOR_BUTTON_MNEMONIC);
            this.target = target;
            super.setActionCommand("show");
            super.addActionListener(this);
        }

        public void setDescriptor(Descriptor desc) {
            this.appDescriptor = desc;
            if (this.dialog != null) {
                this.dialog.setDescriptor(this.appDescriptor);
            }
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
            if (this.dialog != null) {
                this.dialog.setUpdateListener(this.target);
            }
        }

        public void setManifestClasspathInspector(ListModel listModel, String archName, Descriptor descriptor) {
            Application app = null;
            if (descriptor == null) {
                app = null;
            } else if (descriptor instanceof Application) {
                app = (Application)descriptor;
            } else if (DescriptorTools.isStandAlone(descriptor)) {
                app = null;
            } else if (descriptor instanceof EjbDescriptor) {
                app = ((EjbDescriptor)descriptor).getApplication();
                if (app == null) {
                    Print.dprintln((String)"EjbDescriptor returned null Application");
                }
            } else if (descriptor instanceof BundleDescriptor) {
                app = ((BundleDescriptor)descriptor).getApplication();
                if (app == null) {
                    Print.dprintln((String)"BundleDescriptor returned null Application");
                }
            } else {
                app = null;
                Print.dprintln((String)("Unable to obtain Application from class " + DT.className(descriptor)));
            }
            this.setManifestClasspathInspector(listModel, archName, descriptor, (Descriptor)app);
        }

        public void setManifestClasspathInspector(ListModel listModel, String name, Descriptor d, Descriptor app) {
            this.archName = name != null ? name : (d != null ? d.getDisplayName() : "");
            this.listModel = listModel;
            this.setDescriptor(app != null ? app : d);
            if (this.dialog != null) {
                this.dialog.setListModel(this.listModel, this.archName);
            }
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.dialog == null) {
                Window window = WinTools.getAncestorWindow(this);
                this.dialog = window instanceof Dialog ? new ManifestClasspathDialog((Dialog)window) : new ManifestClasspathDialog((Frame)window);
                this.dialog.setUpdateListener(this.target);
                this.dialog.setDescriptor(this.appDescriptor);
            }
            this.dialog.setListModel(this.listModel, this.archName);
            this.dialog.show();
        }
    }

    private static class ManifestClasspathDialog
    extends UIDialog
    implements ActionListener {
        private UpdateListener target = null;
        private Descriptor appDescriptor = null;
        private UITitledList jarListPanel = null;
        private UITitledList classpathPanel = null;
        private JButton addLibJarButton = null;
        private JButton delLibJarButton = null;

        public ManifestClasspathDialog(Frame owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        public ManifestClasspathDialog(Dialog owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        private void initDialog(Window window) {
            CSH.setHelpIDString((Component)this, (String)helpSetMapID);
            this.doNothingOnClose();
            UIControlButtonBox windowPanel = new UIControlButtonBox(null, false);
            windowPanel.setControlButtonLocation(101);
            this.setContentPane(windowPanel);
            UITitledBox box = new UITitledBox(null, false);
            windowPanel.setView(box);
            GridBagConstraints gbc = box.getGBConstraints();
            gbc.gridx = -1;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 3, 5);
            this.jarListPanel = new UITitledList("<updated-later>", false);
            JList jl = new JList();
            jl.getAccessibleContext().setAccessibleName(LIST_NAME);
            jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
            this.jarListPanel.setListView(jl);
            box.addWithGBConstraints(this.jarListPanel);
            this.jarListPanel.getListView().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ManifestClasspathDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        ManifestClasspathDialog.access$400(this.this$0).setEnabled(!ManifestClasspathDialog.access$300(this.this$0).isSelectionEmpty());
                    }
                }
            });
            UIPanel buttons = new UIPanel(localStrings.getLocalString("ui.manifestclasspathinspector.list_name", "Panel"), localStrings.getLocalString("ui.manifestclasspathinspector.list_desc", "This is the panel for the buttons"));
            buttons.setLayout(new GridBagLayout());
            GridBagConstraints bc = new GridBagConstraints();
            bc.weightx = 0.0;
            bc.weighty = 0.0;
            bc.gridx = 0;
            bc.gridy = -1;
            bc.insets = new Insets(5, 0, 0, 0);
            bc.fill = 2;
            bc.anchor = 10;
            Insets margin = new Insets(3, 5, 3, 5);
            this.addLibJarButton = new UIButton(ADD_BUTTON, ADD_BUTTON_MNEMONIC, "add", this);
            this.addLibJarButton.setMargin(margin);
            buttons.add((Component)this.addLibJarButton, bc);
            this.delLibJarButton = new UIButton(REMOVE_BUTTON, REMOVE_BUTTON_MNEMONIC, "del", this);
            this.delLibJarButton.setMargin(margin);
            buttons.add((Component)this.delLibJarButton, bc);
            gbc = box.getGBConstraintsCopy();
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.fill = 0;
            box.add((Component)buttons, gbc);
            this.classpathPanel = new UITitledList(MFC_BOXTITLE, false);
            jl = new JList();
            jl.getAccessibleContext().setAccessibleName(LIST_NAME);
            jl.getAccessibleContext().setAccessibleDescription(LIST_DESC);
            this.classpathPanel.setListView(jl);
            box.addWithGBConstraints(this.classpathPanel);
            this.classpathPanel.getListView().addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ManifestClasspathDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        ManifestClasspathDialog.access$1200(this.this$0).setEnabled(!ManifestClasspathDialog.access$1100(this.this$0).isSelectionEmpty());
                    }
                }
            });
            UIButton okBtn = UIButton.createOkButton(this);
            windowPanel.addControlButton(okBtn);
            UIButton cancelBtn = UIButton.createCancelButton(this);
            windowPanel.addControlButton(cancelBtn);
            UIHelpButton helpBtn = new UIHelpButton(helpSetMapID);
            windowPanel.addControlButton(helpBtn);
            Rectangle b = window.getBounds();
            b.x += 20;
            b.y += 20;
            b.width = 525;
            b.height = 250;
            this.setBounds(b);
        }

        public void setDescriptor(Descriptor desc) {
            this.appDescriptor = desc;
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
        }

        public void setListModel(ListModel listModel, String archName) {
            this.setTitle(ManifestClasspathInspector.DIALOG_TITLE_FOR(archName));
            String appName = this.appDescriptor != null ? this.appDescriptor.getDisplayName() : "<?>";
            this.jarListPanel.setTitle(ManifestClasspathInspector.JARLIST_TITLE_FOR(appName));
            this.classpathPanel.getListView().setModel(listModel);
            this.delLibJarButton.setEnabled(false);
            DefaultListModel appJarsListModel = new DefaultListModel();
            if (this.appDescriptor != null) {
                ModuleArchive appMod = ModuleArchive.getModuleArchive(this.appDescriptor);
                ListTools.toListModel(appMod.getLibraryJarEntries(), appJarsListModel);
            } else {
                Print.dprintln((String)"'appDescriptor' is null");
            }
            this.jarListPanel.getListView().setModel(appJarsListModel);
            this.addLibJarButton.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            String cmd = ((JButton)ae.getSource()).getActionCommand();
            if (cmd.equals("add")) {
                this.addAction();
            } else if (cmd.equals("del")) {
                this.removeAction();
            } else if (cmd.equals("ok")) {
                if (this.target != null) {
                    this.target.manifestClasspathUpdated(this.classpathPanel.getListView().getModel());
                    this.hide();
                }
            } else if (cmd.equals("cancel")) {
                this.hide();
            } else if (cmd.equals("help")) {
                // empty if block
            }
        }

        private void addAction() {
            Object[] list = this.jarListPanel.getSelectedValues();
            DefaultListModel mfcModel = (DefaultListModel)this.classpathPanel.getModel();
            for (int i = 0; i < list.length; ++i) {
                if (mfcModel.contains(list[i])) continue;
                mfcModel.addElement(list[i]);
            }
        }

        private void removeAction() {
            Object[] list = this.classpathPanel.getSelectedValues();
            DefaultListModel mfcModel = (DefaultListModel)this.classpathPanel.getModel();
            for (int i = 0; i < list.length; ++i) {
                mfcModel.removeElement(list[i]);
            }
        }

        static /* synthetic */ UITitledList access$300(ManifestClasspathDialog x0) {
            return x0.jarListPanel;
        }

        static /* synthetic */ JButton access$400(ManifestClasspathDialog x0) {
            return x0.addLibJarButton;
        }

        static /* synthetic */ UITitledList access$1100(ManifestClasspathDialog x0) {
            return x0.classpathPanel;
        }

        static /* synthetic */ JButton access$1200(ManifestClasspathDialog x0) {
            return x0.delLibJarButton;
        }
    }

    public static interface UpdateListener {
        public void manifestClasspathUpdated(ListModel var1);
    }
}

