/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.common.dd.MessageDestination;
import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.ResourceRef;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.ejb.EjbRefsInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonDescriptorUtil;
import com.sun.enterprise.tools.deployment.ui.shared.sunone.CommonUtil;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class JndiNameInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JndiNameInspector.class);
    private static final String REFTYPE_EJB = localStrings.getLocalString("ui.jndinameinspector.ref_type.ejb", "EJB");
    private static final String REFTYPE_EJB_REF = localStrings.getLocalString("ui.jndinameinspector.ref_type.ejb_ref", "EJB Ref");
    private static final String REFTYPE_RESOURCE = localStrings.getLocalString("ui.jndinameinspector.ref_type.resource_ref", "Resource");
    private static final String REFTYPE_ENV_RESOURCE = localStrings.getLocalString("ui.jndinameinspector.ref_type.env_resource", "Env Resource");
    private static final String COMPONENT_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.gen_title", "Components");
    private static final String WEB_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.web_title", "Web Components");
    private static final String EJB_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.ejb_title", "EJBs");
    private static final String CLI_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.appclient_title", "App Clients");
    private static final String APP_TITLE = localStrings.getLocalString("ui.jndinameinspector.component.app_title", "Application");
    private static final String COMP_TABLE_TOOLTIP = localStrings.getLocalString("ui.jndinameinspector.component.tooltip", "Component JNDI names");
    private static final String COMP_COL_COMP_TYPE = localStrings.getLocalString("ui.jndinameinspector.component.comp_type", "Component Type");
    private static final String COMP_COL_COMPONENT = localStrings.getLocalString("ui.jndinameinspector.component.component", "Component");
    private static final String COMP_COL_JNDINAME = localStrings.getLocalString("ui.jndinameinspector.component.jndiname", "JNDI Name");
    private static final String REFERENCES = localStrings.getLocalString("ui.jndinameinspector.reference.title", "References");
    private static final String REF_TABLE_TOOLTIP = localStrings.getLocalString("ui.jndinameinspector.reference.tooltip", "Reference JNDI names");
    private static final String REF_COL_REF_TYPE = localStrings.getLocalString("ui.jndinameinspector.reference.ref_type", "Ref. Type");
    private static final String REF_COL_REF_BY = localStrings.getLocalString("ui.jndinameinspector.reference.ref_by", "Referenced By");
    private static final String REF_COL_REF_NAME = localStrings.getLocalString("ui.jndinameinspector.reference.ref_name", "Reference Name");
    private static final String REF_COL_JNDI_NAME = localStrings.getLocalString("ui.jndinameinspector.reference.jndiname", "JNDI Name");
    private static final String MESSAGE_DESTINATIONS = localStrings.getLocalString("ui.jndinameinspector.msgdest.title", "Message Destinations");
    private static final String MSG_DEST_TABLE_TOOLTIP = localStrings.getLocalString("ui.jndinameinspector.msgdest.tooltip", "Message Destination JNDI names");
    private static final String MSG_DEST_COL_DEST_NAME = localStrings.getLocalString("ui.jndinameinspector.msgdest.dest_name", "Destination Name");
    private static final String MSG_DEST_COL_DISPLAY_NAME = localStrings.getLocalString("ui.jndinameinspector.msgdest.display_name", "Display Name");
    private static final String MSG_DEST_COL_JNDI_NAME = localStrings.getLocalString("ui.jndinameinspector.msgdest.jndi_name", "JNDI Name");
    private static final String MISSING_JNDI = localStrings.getLocalString("at.jndinameinspector.missing_jndi", "All components must have a JNDI name");
    private static final String TABNAME = localStrings.getLocalString("ui.jndinameinspector.tabname", "JNDI Names");
    private static String wizardHelpID = "JNDI";
    private static String deployHelpID = "JNDI";
    private Descriptor descriptor = null;
    private SunBaseBean sunDescriptor = null;
    private Hashtable msgHashtable = null;
    private Hashtable referant2CommonDescriptorMap = null;
    private UITitledBox compJndiBox = null;
    private UITitledTable compJndiView = null;
    private ComponentJndiTable compJndiTable = null;
    private UITitledTable refJndiView = null;
    private ReferenceJndiTable refJndiTable = null;
    private UITitledTable msgDestView = null;
    private MsgDestTable msgDestTable = null;
    private Hashtable ejbJndiHashTable = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new JndiNameInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return this.descriptor != null ? this.descriptor.getClass() : Descriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc;
            if (desc instanceof Application) {
                CommonUtil.initEjbDescriptors((Application)desc);
                CommonUtil.initReferences((Application)desc, this.getReferant2CommonDescriptorMap());
            } else if (desc instanceof BundleDescriptor) {
                Application app = ((BundleDescriptor)desc).getApplication();
                CommonUtil.initEjbDescriptors(app);
                CommonUtil.initReferences(app, this.getReferant2CommonDescriptorMap());
                this.initMsgHashtable();
            }
            this.initEjbJndiHashTable(true);
            this.compJndiTable.clearTableData();
            this.refJndiTable.clearTableData();
            this.compJndiBox.setVisible(!(desc instanceof WebBundleDescriptor));
        }
        this.invokeRefresh();
    }

    public Hashtable getReferant2CommonDescriptorMap() {
        if (this.referant2CommonDescriptorMap == null) {
            this.referant2CommonDescriptorMap = new Hashtable();
        }
        return this.referant2CommonDescriptorMap;
    }

    public CommonDescriptorUtil getCommonDescriptor(Descriptor desc) {
        Hashtable map = this.getReferant2CommonDescriptorMap();
        CommonDescriptorUtil commonDesc = (CommonDescriptorUtil)map.get(desc);
        if (commonDesc == null) {
            commonDesc = new CommonDescriptorUtil(desc);
            map.put(desc, commonDesc);
        }
        return commonDesc;
    }

    private void initMsgHashtable() {
        this.sunDescriptor = SunOneUtils.getSunDescriptor((Descriptor)((BundleDescriptor)this.descriptor));
        if (this.sunDescriptor instanceof SunEjbJar) {
            this.initMsgHashtable(((SunEjbJar)this.sunDescriptor).getEnterpriseBeans().getMessageDestination());
        } else if (this.sunDescriptor instanceof SunWebApp) {
            this.initMsgHashtable(((SunWebApp)this.sunDescriptor).getMessageDestination());
        } else if (this.sunDescriptor instanceof SunApplicationClient) {
            this.initMsgHashtable(((SunApplicationClient)this.sunDescriptor).getMessageDestination());
        }
    }

    private void initMsgHashtable(MessageDestination[] msgDArray) {
        this.msgHashtable = new Hashtable();
        if (msgDArray != null) {
            for (int i = 0; i < msgDArray.length; ++i) {
                this.msgHashtable.put(msgDArray[i].getMessageDestinationName(), msgDArray[i]);
            }
        }
    }

    private JndiNameInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.compJndiBox = new UITitledBox(null, false);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.compJndiBox, c);
        GridBagConstraints cjb_gc = this.compJndiBox.getGBConstraints();
        cjb_gc.weighty = 0.5;
        cjb_gc.gridy = 0;
        cjb_gc.gridwidth = 1;
        cjb_gc.gridheight = 1;
        cjb_gc.insets = new Insets(0, 0, 0, 0);
        cjb_gc.fill = 1;
        this.compJndiView = new UITitledTable("", true);
        cjb_gc.weightx = 0.75;
        cjb_gc.gridx = 0;
        this.compJndiBox.add((Component)this.compJndiView, cjb_gc);
        this.compJndiTable = new ComponentJndiTable(new ComponentJndiTableModel());
        this.compJndiView.setTableView(this.compJndiTable);
        cjb_gc.weightx = 0.25;
        cjb_gc.gridx = 1;
        this.compJndiBox.add((Component)new UIPanel(), cjb_gc);
        this.refJndiView = new UITitledTable(REFERENCES, true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.refJndiView, c);
        this.refJndiTable = new ReferenceJndiTable(new ReferenceJndiTableModel());
        this.refJndiView.setTableView(this.refJndiTable);
        this.msgDestView = new UITitledTable(MESSAGE_DESTINATIONS, true);
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.msgDestView, c);
        this.msgDestTable = new MsgDestTable(new MsgDestTableModel());
        this.msgDestView.setTableView(this.msgDestTable);
    }

    public void refresh() {
        if (this.descriptor instanceof EjbBundleDescriptor) {
            this.compJndiView.setTitle(EJB_TITLE);
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            this.compJndiView.setTitle(WEB_TITLE);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            this.compJndiView.setTitle(CLI_TITLE);
        } else if (this.descriptor instanceof Application) {
            this.compJndiView.setTitle(APP_TITLE);
        } else {
            this.compJndiView.setTitle(COMPONENT_TITLE);
        }
        this.initEjbJndiHashTable(false);
        Vector[] jndiNames = JndiNameInspector.getJndiNames(this.descriptor);
        Vector comp = jndiNames[0];
        Vector ref = jndiNames[1];
        if (!(this.descriptor instanceof WebBundleDescriptor)) {
            this.compJndiTable.updateTableData(comp, this.descriptor instanceof Application);
        }
        this.refJndiTable.updateTableData(ref);
        if (this.descriptor instanceof BundleDescriptor) {
            this.msgDestView.updateTableData(((BundleDescriptor)this.descriptor).getMessageDestinations());
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.compJndiView.setReadOnly(state);
        this.refJndiView.setReadOnly(state);
    }

    private static Vector[] getJndiNames(Descriptor desc) {
        EjbBundleDescriptor d;
        Vector<CMPJndiRef> cmpJndiMisc = null;
        Vector refPairs = null;
        if (desc instanceof EjbBundleDescriptor) {
            d = (EjbBundleDescriptor)desc;
            refPairs = d.getNamedReferencePairs();
            CMPJndiRef cjr = JndiNameInspector.createCMPJndiRef(d);
            if (cjr != null) {
                if (cmpJndiMisc == null) {
                    cmpJndiMisc = new Vector<CMPJndiRef>();
                }
                cmpJndiMisc.add(cjr);
            }
        } else if (desc instanceof WebBundleDescriptor) {
            d = (WebBundleDescriptor)desc;
            refPairs = d.getNamedReferencePairs();
        } else if (desc instanceof ApplicationClientDescriptor) {
            d = (ApplicationClientDescriptor)desc;
            refPairs = d.getNamedReferencePairs();
        } else if (desc instanceof Application) {
            d = (Application)desc;
            refPairs = d.getNamedReferencePairs();
            Set ejbs = d.getEjbBundleDescriptors();
            Iterator i = ejbs.iterator();
            while (i.hasNext()) {
                EjbBundleDescriptor ejbd = (EjbBundleDescriptor)i.next();
                CMPJndiRef cjr = JndiNameInspector.createCMPJndiRef(ejbd);
                if (cjr == null) continue;
                if (cmpJndiMisc == null) {
                    cmpJndiMisc = new Vector();
                }
                cmpJndiMisc.add(cjr);
            }
        } else {
            refPairs = new Vector();
        }
        Vector<NamedReferencePair> comp = new Vector<NamedReferencePair>();
        Vector<Object> ref = new Vector<Object>();
        Enumeration e = refPairs.elements();
        while (e.hasMoreElements()) {
            NamedReferencePair nrp = (NamedReferencePair)e.nextElement();
            NamedDescriptor referee = nrp.getReferee();
            Descriptor referant = nrp.getReferant();
            if (referant.getDisplayName().equals(referee.getName())) {
                if (referee instanceof EjbEntityDescriptor || referee instanceof EjbSessionDescriptor) {
                    if (!((EjbDescriptor)referee).isRemoteInterfacesSupported()) continue;
                    comp.add(nrp);
                    continue;
                }
                comp.add(nrp);
                continue;
            }
            if (referee instanceof EjbReferenceDescriptor) {
                if (((EjbReferenceDescriptor)referee).isLocal()) continue;
                ref.add(nrp);
                continue;
            }
            ref.add(nrp);
        }
        if (cmpJndiMisc != null) {
            ref.addAll(cmpJndiMisc);
        }
        return new Vector[]{comp, ref};
    }

    private void clearEjbJndiHashTable() {
        this.ejbJndiHashTable = null;
    }

    private Hashtable getEjbJndiHashTable() {
        if (this.ejbJndiHashTable != null) {
            return this.ejbJndiHashTable;
        }
        return this.initEjbJndiHashTable(true);
    }

    private Hashtable initEjbJndiHashTable(boolean create) {
        if (create || this.ejbJndiHashTable == null) {
            this.ejbJndiHashTable = new Hashtable();
            Vector ejbList = null;
            if (this.descriptor instanceof Application) {
                ejbList = ((Application)this.descriptor).getEjbDescriptors();
            } else if (this.descriptor instanceof BundleDescriptor) {
                Application app = ((BundleDescriptor)this.descriptor).getApplication();
                if (app != null) {
                    ejbList = app.getEjbDescriptors();
                }
            } else {
                ejbList = new Vector();
                Print.dprintln((String)("Invalid descriptor: " + DT.className(this.descriptor)));
            }
            if (ejbList != null) {
                Iterator itr = ejbList.iterator();
                while (itr.hasNext()) {
                    String jndiN;
                    EjbDescriptor ejb = (EjbDescriptor)itr.next();
                    if (ejb instanceof EjbMessageBeanDescriptor || (jndiN = ((Ejb)SunOneUtils.getSunDescriptor((Descriptor)ejb)).getJndiName()) == null || "".equals(jndiN)) continue;
                    this.ejbJndiHashTable.put(jndiN, ejb);
                }
            }
        }
        return this.ejbJndiHashTable;
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.compJndiTable.getRowWithValue(2, "") != null) {
            if (showErrors) {
                UIOptionPane.showErrorDialog(this, MISSING_JNDI);
            }
            return false;
        }
        this.clearEjbJndiHashTable();
        return true;
    }

    private StringBuffer _validateJndiNames(Vector list, StringBuffer sb) {
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            boolean localOnly = false;
            String jndiName = null;
            String refereeName = null;
            if (obj instanceof NamedReferencePair) {
                EjbAbstractDescriptor ejb;
                String remote;
                NamedDescriptor referee = ((NamedReferencePair)obj).getReferee();
                jndiName = JndiNameInspector._getJndiName(referee);
                refereeName = referee.getName();
                if ((jndiName == null || jndiName.equals("")) && referee instanceof EjbAbstractDescriptor && ((remote = (ejb = (EjbAbstractDescriptor)referee).getRemoteClassName()) == null || remote.equals(""))) {
                    jndiName = "LOCAL:" + refereeName;
                }
            } else {
                jndiName = ((CMPJndiRef)obj).getJndiName();
                refereeName = ((CMPJndiRef)obj).getRefName();
            }
            if (jndiName != null && !jndiName.equals("")) continue;
            sb.append("\n    ").append(refereeName);
        }
        return sb;
    }

    private static CMPJndiRef createCMPJndiRef(EjbBundleDescriptor ejbd) {
        ResourceReferenceDescriptor rrd = ejbd.getCMPResourceReference();
        return rrd != null ? new CMPJndiRef(ejbd, rrd) : null;
    }

    private static String getRefereeTypeName(NamedReferencePair nd) {
        switch (nd.getPairType()) {
            case 1: {
                return REFTYPE_EJB;
            }
            case 2: {
                return REFTYPE_EJB_REF;
            }
            case 3: {
                return REFTYPE_RESOURCE;
            }
            case 4: {
                return REFTYPE_ENV_RESOURCE;
            }
        }
        return "?";
    }

    private static String _getJndiName(NamedDescriptor ref) {
        String jndiName = ref.getJndiName();
        if (jndiName == null && ref instanceof EjbReferenceDescriptor) {
            jndiName = EjbRefsInspector.getEjbReferenceJndiName((EjbReferenceDescriptor)ref);
        }
        return jndiName;
    }

    private static void _setJndiName(NamedDescriptor ref, String value) {
        if (ref instanceof EjbReferenceDescriptor) {
            ((EjbReferenceDescriptor)ref).setEjbDescriptor(null);
        }
        ref.setJndiName(value);
        if (ref instanceof Descriptor) {
            ((Descriptor)ref).changed();
        }
    }

    public class MsgDestTableModel
    extends InspectorTableModel {
        public MsgDestTableModel() {
            super(new String[]{MSG_DEST_COL_DEST_NAME, MSG_DEST_COL_DISPLAY_NAME, MSG_DEST_COL_JNDI_NAME});
            super.setDataOrdering(1, 0, 2);
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col == 2;
        }

        public Object getObjectValue(Object obj, int col) {
            String value = "<???>";
            MessageDestinationDescriptor ref = (MessageDestinationDescriptor)obj;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getDisplayName();
                    if (value != null && !value.equals("")) break;
                    value = ref.getName();
                    break;
                }
                case 2: {
                    value = ((MessageDestination)JndiNameInspector.this.msgHashtable.get(ref.getName())).getJndiName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ((MessageDestinationDescriptor)obj).setJndiName((String)value);
                    ((MessageDestination)JndiNameInspector.this.msgHashtable.get(((MessageDestinationDescriptor)obj).getName())).setJndiName((String)value);
                }
            }
        }
    }

    private class MsgDestTable
    extends InspectorTable {
        public MsgDestTable(TableModel model) {
            super(model);
            this.setToolTipText(MSG_DEST_TABLE_TOOLTIP);
        }
    }

    public class ReferenceJndiTableModel
    extends InspectorTableModel {
        public ReferenceJndiTableModel() {
            super(new String[]{REF_COL_REF_TYPE, REF_COL_REF_BY, REF_COL_REF_NAME, REF_COL_JNDI_NAME});
            super.setDataOrdering(1, 0, 2);
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col == 3;
        }

        public Object getObjectValue(Object obj, int col) {
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = obj instanceof NamedReferencePair ? JndiNameInspector.getRefereeTypeName((NamedReferencePair)obj) : ((CMPJndiRef)obj).getRefType();
                    break;
                }
                case 1: {
                    value = obj instanceof NamedReferencePair ? ((NamedReferencePair)obj).getReferant().getDisplayName() : ((CMPJndiRef)obj).getRefBy();
                    break;
                }
                case 2: {
                    value = obj instanceof NamedReferencePair ? ((NamedReferencePair)obj).getReferee().getName() : ((CMPJndiRef)obj).getRefName();
                    break;
                }
                case 3: {
                    if (obj instanceof NamedReferencePair) {
                        Descriptor desc = ((NamedReferencePair)obj).getReferant();
                        NamedDescriptor referee = ((NamedReferencePair)obj).getReferee();
                        value = referee instanceof EjbReferenceDescriptor ? DescriptorTools.getRefJndiName(desc, (EjbReferenceDescriptor)referee) : referee.getJndiName();
                        break;
                    }
                    value = ((CMPJndiRef)obj).getJndiName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (obj instanceof NamedReferencePair) {
                        NamedReferencePair jndiRef = (NamedReferencePair)obj;
                        NamedDescriptor referee = jndiRef.getReferee();
                        Descriptor referant = jndiRef.getReferant();
                        CommonDescriptorUtil commonDesc = JndiNameInspector.this.getCommonDescriptor(referant);
                        int pairType = jndiRef.getPairType();
                        if (pairType == 2) {
                            EjbDescriptor ejbd = (EjbDescriptor)JndiNameInspector.this.getEjbJndiHashTable().get(value);
                            referee = DescriptorTools.convertEjbReference((EjbReferenceDescriptor)referee);
                            EjbRefsInspector.setRefJndiName(referant, (EjbReferenceDescriptor)referee, (String)value, ejbd);
                        } else if (pairType == 4) {
                            ResourceEnvRef rer;
                            referee.setJndiName((String)value);
                            if (referee instanceof Descriptor) {
                                ((Descriptor)referee).changed();
                            }
                            if ((rer = commonDesc.getResourceEnvRef(referee.getName())) == null) {
                                commonDesc.addResourceEnvRef(referee.getName(), (String)value);
                            }
                            commonDesc.getResourceEnvRef(referee.getName()).setJndiName((String)value);
                            commonDesc.changed();
                        } else if (pairType == 3) {
                            ResourceRef rr;
                            referee.setJndiName((String)value);
                            if (referee instanceof Descriptor) {
                                ((Descriptor)referee).changed();
                            }
                            if ((rr = commonDesc.getResourceRef(referee.getName())) == null) {
                                commonDesc.addResourceRef(referee.getName(), (String)value, null, null);
                            }
                            commonDesc.getResourceRef(referee.getName()).setJndiName((String)value);
                            commonDesc.changed();
                        }
                        if (JndiNameInspector.this.descriptor == null) break;
                        JndiNameInspector.this.descriptor.changed();
                        break;
                    }
                    ((CMPJndiRef)obj).setJndiName((String)value);
                }
            }
        }
    }

    private class ReferenceJndiTable
    extends InspectorTable {
        public ReferenceJndiTable(TableModel model) {
            super(model);
            this.setToolTipText(REF_TABLE_TOOLTIP);
            this.setSelectionMode(0);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 3: {
                    Object obj = this.getRowObject(row);
                    String type = (String)this.getObjectValue(this.getRowObject(row), 0);
                    if (type.equals(REFTYPE_EJB_REF)) {
                        Vector v = new Vector(JndiNameInspector.this.getEjbJndiHashTable().keySet());
                        v.add("");
                        rtn = this.getComboBoxEditor(v);
                        ((InspectorTable.TableComboBoxEditor)rtn).setEditable(true);
                        break;
                    }
                    rtn = super.getCellEditor(row, col);
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    public class ComponentJndiTableModel
    extends InspectorTableModel {
        public ComponentJndiTableModel() {
            super(new String[]{COMP_COL_COMP_TYPE, COMP_COL_COMPONENT, COMP_COL_JNDINAME});
            super.setDataOrdering(1, 0, 1);
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col == 2;
        }

        public Object getObjectValue(Object obj, int col) {
            NamedReferencePair jndiRef = (NamedReferencePair)obj;
            NamedDescriptor referee = jndiRef.getReferee();
            Descriptor referant = jndiRef.getReferant();
            String value = "<???>";
            switch (col) {
                case 0: {
                    value = JndiNameInspector.getRefereeTypeName(jndiRef);
                    break;
                }
                case 1: {
                    value = referee.getName();
                    break;
                }
                case 2: {
                    value = referee.getJndiName();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            NamedReferencePair jndiRef = (NamedReferencePair)obj;
            NamedDescriptor referee = jndiRef.getReferee();
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (value.equals("")) break;
                    if (referee instanceof Descriptor) {
                        String oldname = "";
                        if (referee instanceof EjbDescriptor) {
                            Application app = ((EjbDescriptor)referee).getApplication();
                            if (!(referee instanceof EjbMessageBeanDescriptor) && !SunOneUtils.isJndiUnique(app, (String)value)) break;
                            oldname = ((Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)referee))).getJndiName();
                            if (oldname == null) {
                                oldname = "";
                            }
                            if (oldname.equals(value)) break;
                            Object ejbDesc = JndiNameInspector.this.getEjbJndiHashTable().get(oldname);
                            if (ejbDesc != null) {
                                JndiNameInspector.this.getEjbJndiHashTable().remove(oldname);
                                JndiNameInspector.this.getEjbJndiHashTable().put((String)value, ejbDesc);
                            }
                            ((Ejb)SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)referee))).setJndiName((String)value);
                        }
                        if (!oldname.equals("") && !oldname.equals(value)) {
                            Object test;
                            while ((test = JndiNameInspector.this.refJndiTable.getRowWithValue(3, oldname)) != null) {
                                JndiNameInspector.this.refJndiTable.setObjectValue(test, 3, value);
                            }
                        }
                        referee.setJndiName((String)value);
                        ((Descriptor)referee).changed();
                    } else {
                        referee.setJndiName((String)value);
                    }
                    if (JndiNameInspector.this.descriptor == null) break;
                    JndiNameInspector.this.descriptor.changed();
                }
            }
        }
    }

    private class ComponentJndiTable
    extends InspectorTable {
        public ComponentJndiTable(TableModel model) {
            super(model);
            this.setToolTipText(COMP_TABLE_TOOLTIP);
            this.setSelectionMode(0);
        }

        public void updateTableData(Vector v, boolean showTypeColumn) {
            super.updateTableData(v);
            super.setColumnHidden(0, !showTypeColumn);
        }
    }

    private static class CMPJndiRef {
        private EjbBundleDescriptor ejbd = null;
        private ResourceReferenceDescriptor rrd = null;

        public CMPJndiRef(EjbBundleDescriptor ejbd, ResourceReferenceDescriptor rrd) {
            this.ejbd = ejbd;
            this.rrd = rrd;
        }

        public String getRefType() {
            return REFTYPE_RESOURCE;
        }

        public String getRefBy() {
            return this.ejbd.getDisplayName();
        }

        public String getRefName() {
            return "CMP:" + this.ejbd.getDisplayName();
        }

        public String getJndiName() {
            return this.rrd.getJndiName();
        }

        public void setJndiName(String jndiName) {
            this.rrd.setJndiName(jndiName);
        }
    }
}

