/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.SunBaseBean;
import com.sun.enterprise.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.webapp.SunWebApp;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;

public class DescriptorTools {
    private static final String DIRTY_FLAG = "ui.isDirty";
    private static final String SPEC_VERSION = "ui.specVersion";
    private static final String DEBUG_TRACE_SETDIRTY = "ui.debugMode.trace_setDirty";
    private static final int VALIDATION_SIZE = 32;
    private static final String VALIDATION_ATTR = "ui.tabValidation";
    public static final String REFRESH_NOTIFICATION = "RefreshOnly";

    private DescriptorTools() {
    }

    public static void clearDirty(Descriptor d) {
        DescriptorTools.setDirty(d, false);
    }

    public static void setDirty(Descriptor d) {
        DescriptorTools.setDirty(d, true);
    }

    public static void setDirty(Descriptor d, boolean dirty) {
        if (d != null) {
            if (dirty) {
                if (!DescriptorTools.isDirty(d)) {
                    if (UIConfig.debugMode() && UIConfig.getConfigBoolean(DEBUG_TRACE_SETDIRTY)) {
                        Print.dprintStackTrace((String)("Setting dirty: " + DescriptorTools.getDisplayName(d)));
                    }
                    d.getExtraAttributes().put(DIRTY_FLAG, DIRTY_FLAG);
                }
            } else if (DescriptorTools.isDirty(d)) {
                d.getExtraAttributes().remove(DIRTY_FLAG);
            }
        }
    }

    public static boolean isDirty(Descriptor d) {
        return d != null ? d.getExtraAttributes().containsKey(DIRTY_FLAG) : false;
    }

    public static BitSet getTabValidation(Descriptor d) {
        if (d != null) {
            String key = VALIDATION_ATTR;
            BitSet b = (BitSet)d.getExtraAttributes().get(key);
            if (b == null) {
                b = new BitSet(32);
                b.set(0, 32);
                d.getExtraAttributes().put(key, b);
            }
            return b;
        }
        Print.dprintln((String)"Descriptor is null");
        return new BitSet();
    }

    public static boolean hasTabErrors(Descriptor d) {
        if (!DescriptorTools.isTabValid(d)) {
            return true;
        }
        Iterator i = null;
        if (d instanceof Application) {
            i = ((Application)d).getBundleDescriptors().iterator();
        } else if (d instanceof EjbBundleDescriptor) {
            i = ((EjbBundleDescriptor)d).getEjbs().iterator();
        } else if (d instanceof WebBundleDescriptor) {
            i = ((WebBundleDescriptor)d).getWebComponentDescriptorsSet().iterator();
        }
        if (i != null) {
            while (i.hasNext()) {
                if (!DescriptorTools.hasTabErrors((Descriptor)i.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isTabValid(Descriptor d) {
        if (d != null) {
            BitSet b = DescriptorTools.getTabValidation(d);
            return b.cardinality() == 32;
        }
        return true;
    }

    public static boolean isTabValid(Descriptor d, int ndx) {
        return d != null ? DescriptorTools.getTabValidation(d).get(ndx) : true;
    }

    public static void setTabValid(Descriptor d, int ndx, boolean valid) {
        BitSet b;
        if (d != null && valid != (b = DescriptorTools.getTabValidation(d)).get(ndx)) {
            b.set(ndx, valid);
            DT.tabValidationChanged();
        }
    }

    public static void sendRefreshNotification(Descriptor d) {
        NotificationEvent ne = new NotificationEvent((Object)d, Descriptor.DESCRIPTOR_CHANGED, (Object)d, (Object)REFRESH_NOTIFICATION);
        List listenersClone = d.getNotificationListeners();
        Iterator e = listenersClone.iterator();
        while (e.hasNext()) {
            NotificationListener nl = (NotificationListener)e.next();
            nl.notification(ne);
        }
    }

    public static boolean isStandAlone(Descriptor d) {
        if (d instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)d;
            if (bd.getApplication() == null) {
                return true;
            }
            if (bd.getModuleDescriptor().isStandalone()) {
                return true;
            }
        }
        return false;
    }

    public static String createUniqueName(String trialName, Enumeration otherNames) {
        return DescriptorTools.createUniqueName(trialName, ListTools.toList(otherNames));
    }

    public static String createUniqueName(String trialName, BundleDescriptor bd, Iterator iter) {
        String retVal = trialName;
        ModuleArchive t = ModuleArchive.getModuleArchive((Descriptor)bd);
        File bdArchive = null;
        if (null != t) {
            bdArchive = t.getArchiveFile();
        }
        ArrayList<String> col = new ArrayList<String>();
        while (iter.hasNext()) {
            BundleDescriptor i = (BundleDescriptor)iter.next();
            String otherName = i.getDisplayName();
            t = ModuleArchive.getModuleArchive((Descriptor)i);
            if (null != t) {
                File iArchive = t.getArchiveFile();
                if (null != bdArchive && null != iArchive && bdArchive.getAbsolutePath().equals(iArchive.getAbsolutePath())) {
                    return retVal;
                }
            }
            col.add(i.getDisplayName());
        }
        return DescriptorTools.createUniqueName(trialName, col);
    }

    public static String createUniqueName(String trialName, Application app, Iterator iter) {
        String retVal = trialName;
        ModuleArchive t = ModuleArchive.getModuleArchive((Descriptor)app);
        File appArchive = null;
        if (null != t) {
            appArchive = t.getArchiveFile();
        }
        ArrayList<String> col = new ArrayList<String>();
        while (iter.hasNext()) {
            Application i = (Application)iter.next();
            String otherName = i.getDisplayName();
            t = ModuleArchive.getModuleArchive((Descriptor)i);
            if (null != t) {
                File iArchive = t.getArchiveFile();
                if (null != appArchive && null != iArchive && appArchive.getAbsolutePath().equals(iArchive.getAbsolutePath())) {
                    return retVal;
                }
            }
            col.add(i.getDisplayName());
        }
        return DescriptorTools.createUniqueName(trialName, col);
    }

    public static String createUniqueName(String trialName, Collection otherNames) {
        int p;
        HashSet<String> testList = new HashSet<String>();
        Iterator i = otherNames.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Descriptor) {
                testList.add(DescriptorTools.getDisplayName(obj));
                continue;
            }
            testList.add(obj.toString());
        }
        if (!testList.contains(trialName)) {
            return trialName;
        }
        for (p = trialName.length() - 1; p >= 0 && Character.isDigit(trialName.charAt(p)); --p) {
        }
        int ndx = 1;
        if (++p < trialName.length()) {
            try {
                ndx = Integer.parseInt(trialName.substring(p));
            }
            catch (NumberFormatException nfe) {
                Print.printStackTrace((String)("Unexpected number error: " + trialName));
            }
        }
        String baseName = trialName.substring(0, p);
        while (true) {
            String testName;
            String string = testName = ndx > 0 ? baseName + ndx : baseName;
            if (!testList.contains(testName)) {
                return testName;
            }
            ++ndx;
        }
    }

    public static String createUniqueDisplayName(BundleDescriptor bd, String name) {
        if (bd instanceof EjbBundleDescriptor) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorDisplayNames(((EjbBundleDescriptor)bd).getEjbs()));
        }
        if (bd instanceof WebBundleDescriptor) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorDisplayNames(((WebBundleDescriptor)bd).getWebDescriptors()));
        }
        return name;
    }

    public static String createUniqueComponentName(BundleDescriptor bd, String name) {
        if (bd instanceof EjbBundleDescriptor) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorComponentNames(((EjbBundleDescriptor)bd).getEjbs()));
        }
        if (bd instanceof WebBundleDescriptor) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorComponentNames(((WebBundleDescriptor)bd).getWebDescriptors()));
        }
        return name;
    }

    public static String createUniqueFilename(String trialName, Collection otherNames) {
        int p = trialName.lastIndexOf(".");
        if (p < 0) {
            return DescriptorTools.createUniqueName(trialName, otherNames);
        }
        String ext = trialName.substring(p);
        String file = trialName.substring(0, p);
        HashSet<String> nameList = new HashSet<String>();
        Iterator i = otherNames.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            String name = obj instanceof Descriptor ? ((Descriptor)obj).getDisplayName() : obj.toString();
            if (!name.endsWith(ext)) continue;
            nameList.add(name.substring(0, name.length() - ext.length()));
        }
        return DescriptorTools.createUniqueName(file, nameList) + ext;
    }

    public static String createUniqueModuleName(Application app, Descriptor d) {
        String name = "Module";
        String ext = ".jar";
        if (d instanceof Application) {
            name = "application";
            ext = ".ear";
        } else if (d instanceof WebBundleDescriptor) {
            name = "war-ic";
            ext = ".war";
        } else if (d instanceof EjbBundleDescriptor) {
            name = "ejb-jar-ic";
            ext = ".jar";
        } else if (d instanceof ConnectorDescriptor) {
            name = "connector-ic";
            ext = ".rar";
        } else if (d instanceof ApplicationClientDescriptor) {
            name = "app-client-ic";
            ext = ".jar";
        }
        if (app != null) {
            HashSet<String> matchSet = new HashSet<String>();
            List entries = ModuleArchive.getModuleArchive((Descriptor)app).getEntryNames();
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!key.startsWith(name) || !key.endsWith(ext)) continue;
                matchSet.add(key.substring(0, key.length() - ext.length()));
            }
            return DescriptorTools.createUniqueName(name, matchSet) + ext;
        }
        return name + ext;
    }

    public static String getModuleExtension(Descriptor d) {
        if (d == null) {
            return null;
        }
        if (d instanceof Application) {
            return ".ear";
        }
        if (d instanceof WebBundleDescriptor) {
            return ".war";
        }
        if (d instanceof EjbBundleDescriptor) {
            return ".jar";
        }
        if (d instanceof ConnectorDescriptor) {
            return ".rar";
        }
        if (d instanceof ApplicationClientDescriptor) {
            return ".jar";
        }
        return "";
    }

    public static boolean checkSpecVersion(RootDeploymentDescriptor rdd) {
        ParseSpecVersion specVer = (ParseSpecVersion)rdd.getExtraAttributes().get(SPEC_VERSION);
        if (specVer == null) {
            specVer = new ParseSpecVersion(rdd);
            rdd.getExtraAttributes().put(SPEC_VERSION, specVer);
        }
        boolean isNew = true;
        if (rdd instanceof Application) {
            isNew = specVer.compare(1, 4);
        } else if (rdd instanceof WebBundleDescriptor) {
            isNew = specVer.compare(2, 4);
        } else if (rdd instanceof EjbBundleDescriptor) {
            isNew = specVer.compare(2, 1);
        } else if (rdd instanceof ConnectorDescriptor) {
            isNew = specVer.compare(1, 5);
        } else if (rdd instanceof ApplicationClientDescriptor) {
            isNew = specVer.compare(1, 4);
        }
        return isNew;
    }

    public static boolean copyExtraAttributes(Descriptor from, Descriptor to) {
        DescriptorTools.setDirty(to, DescriptorTools.isDirty(from));
        SunOneUtils.copySunDescriptor(from, to);
        if (from instanceof Application || from instanceof BundleDescriptor) {
            // empty if block
        }
        return true;
    }

    public static Set getEjbReferants(Descriptor referee, Descriptor container) {
        Hashtable localRefs = DescriptorTools.getReferencedLocalBeans(container, null);
        if (referee instanceof EjbDescriptor) {
            EjbDescriptor ejb = (EjbDescriptor)referee;
            return (HashSet)localRefs.get(ejb.getDisplayName());
        }
        if (referee instanceof EjbBundleDescriptor) {
            HashSet referants = new HashSet();
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)referee;
            Set ejbSet = ebd.getEjbs();
            Iterator i = ejbSet.iterator();
            while (i.hasNext()) {
                EjbDescriptor ejb = (EjbDescriptor)i.next();
                HashSet hs = (HashSet)localRefs.get(ejb.getDisplayName());
                if (hs == null) continue;
                Iterator h = hs.iterator();
                while (h.hasNext()) {
                    Object d = h.next();
                    if (d instanceof EjbDescriptor) {
                        if (((EjbDescriptor)d).getEjbBundleDescriptor() == ebd) continue;
                        referants.add(d);
                        continue;
                    }
                    referants.add(d);
                }
            }
            return !referants.isEmpty() ? referants : null;
        }
        return null;
    }

    private static Hashtable getReferencedLocalBeans(Descriptor container, Hashtable localRefs) {
        Iterator i;
        if (localRefs == null) {
            localRefs = new Hashtable();
        }
        Vector<Object> refList = new Vector<Object>();
        if (container instanceof Application) {
            Application app = (Application)container;
            Set warSet = app.getWebBundleDescriptors();
            Iterator i2 = warSet.iterator();
            while (i2.hasNext()) {
                DescriptorTools.getReferencedLocalBeans((Descriptor)i2.next(), localRefs);
            }
            Set ejbSet = app.getEjbBundleDescriptors();
            i = ejbSet.iterator();
            while (i.hasNext()) {
                DescriptorTools.getReferencedLocalBeans((Descriptor)i.next(), localRefs);
            }
        } else if (container instanceof WebBundleDescriptor) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)container;
            refList.add(wbd);
        } else if (container instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)container;
            refList.add(ebd);
            refList.addAll(ebd.getEjbs());
        } else {
            Print.dprintStackTrace((String)"Not Supported");
        }
        Iterator r = refList.iterator();
        while (r.hasNext()) {
            Descriptor d = (Descriptor)r.next();
            if (d instanceof WritableJndiNameEnvironment) {
                Set refSet = ((WritableJndiNameEnvironment)d).getEjbReferenceDescriptors();
                i = refSet.iterator();
                while (i.hasNext()) {
                    EjbReferenceDescriptor ref = (EjbReferenceDescriptor)i.next();
                    if (!ref.isLocal() || !ref.isLinked()) continue;
                    DescriptorTools._addLocalRef(ref.getLinkName(), d, localRefs);
                }
            }
            if (!(d instanceof EjbBundleDescriptor)) continue;
            Set relSet = ((EjbBundleDescriptor)d).getRelationships();
            i = relSet.iterator();
            while (i.hasNext()) {
                RelationshipDescriptor rd = (RelationshipDescriptor)i.next();
                DescriptorTools._addLocalRef(rd.getSource().getOwner().getDisplayName(), d, localRefs);
                DescriptorTools._addLocalRef(rd.getSink().getOwner().getDisplayName(), d, localRefs);
            }
        }
        return localRefs;
    }

    private static void _addLocalRef(String refereeName, Descriptor ref, Hashtable localRefs) {
        if (refereeName != null && !refereeName.equals("")) {
            HashSet<Descriptor> referant = (HashSet<Descriptor>)localRefs.get(refereeName);
            if (referant == null) {
                referant = new HashSet<Descriptor>();
                localRefs.put(refereeName, referant);
            }
            referant.add(ref);
        } else {
            Print.dprintln((String)"EJB referee name is blank");
        }
    }

    public static RootDeploymentDescriptor getRootDeploymentDescriptor(Descriptor d) {
        if (d instanceof Application) {
            return (RootDeploymentDescriptor)d;
        }
        if (d instanceof BundleDescriptor) {
            return (RootDeploymentDescriptor)d;
        }
        return DescriptorTools.getBundleDescriptor(d);
    }

    public static BundleDescriptor getBundleDescriptor(Descriptor desc) {
        if (desc == null) {
            return null;
        }
        if (desc instanceof ServerDescriptor) {
            return null;
        }
        if (desc instanceof Application) {
            Print.dprintStackTrace((String)("Not a Bundle component: " + DT.className(desc)));
            return null;
        }
        if (desc instanceof BundleDescriptor) {
            return (BundleDescriptor)desc;
        }
        if (desc instanceof EjbDescriptor) {
            EjbBundleDescriptor bd = ((EjbDescriptor)desc).getEjbBundleDescriptor();
            if (bd == null) {
                Print.dprintStackTrace((String)("Ejb Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof WebComponentDescriptor) {
            WebBundleDescriptor bd = ((WebComponentDescriptor)desc).getWebBundleDescriptor();
            if (bd == null) {
                Print.dprintStackTrace((String)("WebComponent Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof WebServicesDescriptor) {
            BundleDescriptor bd = ((WebServicesDescriptor)desc).getBundleDescriptor();
            if (bd == null) {
                Print.dprintStackTrace((String)("WebServices Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof WebService) {
            BundleDescriptor bd;
            WebService ws = (WebService)desc;
            BundleDescriptor bundleDescriptor = bd = ws.getWebServicesDescriptor() != null ? ws.getBundleDescriptor() : null;
            if (bd == null) {
                Print.dprintStackTrace((String)("WebServices Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof WebServiceEndpoint) {
            BundleDescriptor bd;
            WebService ws = ((WebServiceEndpoint)desc).getWebService();
            BundleDescriptor bundleDescriptor = bd = ws != null ? ws.getBundleDescriptor() : null;
            if (bd == null) {
                Print.dprintStackTrace((String)("WebServiceEndpoint Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof ServiceReferenceDescriptor) {
            BundleDescriptor bd = ((ServiceReferenceDescriptor)desc).getBundleDescriptor();
            if (bd == null) {
                Print.dprintStackTrace((String)("ServiceReference Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        if (desc instanceof MessageDestinationDescriptor) {
            BundleDescriptor bd = ((MessageDestinationDescriptor)desc).getBundleDescriptor();
            if (bd == null) {
                Print.dprintStackTrace((String)("MessageDestination Bundle is null: " + DT.className(desc)));
            }
            return bd;
        }
        Print.dprintStackTrace((String)("Not a Bundle component: " + DT.className(desc)));
        return null;
    }

    public static Descriptor getModuleDescriptor(Descriptor d) {
        if (d instanceof ServerDescriptor) {
            return null;
        }
        if (d instanceof Application) {
            if (((Application)d).isVirtual()) {
                Set bundles = ((Application)d).getBundleDescriptors();
                if (bundles.size() > 0 && !DescriptorTools.isStandAlone(d = (Descriptor)bundles.iterator().next())) {
                    Print.dprintln((String)"Virtual Application contains non-StandAlone bundle");
                }
                if (bundles.size() != 1) {
                    Print.dprintln((String)("Virtual Application bundle count = " + bundles.size()));
                }
            }
        } else if (!(d instanceof BundleDescriptor)) {
            d = DescriptorTools.getBundleDescriptor(d);
        }
        if (DescriptorTools.isModuleDescriptor(d)) {
            return d;
        }
        if (d instanceof BundleDescriptor) {
            Application app = ((BundleDescriptor)d).getApplication();
            return app != null ? app : d;
        }
        return null;
    }

    public static boolean isModuleDescriptor(Descriptor d) {
        if (d instanceof Application && !((Application)d).isVirtual()) {
            return true;
        }
        return DescriptorTools.isStandAlone(d);
    }

    public static boolean isConnectorDescriptor(Descriptor d) {
        boolean isConnector = false;
        if (d instanceof ConnectorDescriptor) {
            isConnector = true;
        }
        return isConnector;
    }

    public static List getBundleComponentDisplayNames(Descriptor bundleDesc) {
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(bundleDesc);
        if (bd instanceof EjbBundleDescriptor) {
            return DescriptorTools.getDescriptorDisplayNames(((EjbBundleDescriptor)bd).getEjbs());
        }
        if (bd instanceof WebBundleDescriptor) {
            return DescriptorTools.getDescriptorDisplayNames(((WebBundleDescriptor)bd).getWebDescriptors());
        }
        return null;
    }

    public static List getDescriptorDisplayNames(Collection list) {
        if (list != null) {
            Vector<String> n = new Vector<String>();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object d = i.next();
                if (!(d instanceof Descriptor)) continue;
                n.add(DescriptorTools.getDisplayName(d));
            }
            return n;
        }
        return null;
    }

    public static List getDescriptorComponentNames(Collection list) {
        if (list != null) {
            Vector<String> n = new Vector<String>();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object d = i.next();
                if (!(d instanceof Descriptor)) continue;
                n.add(DescriptorTools.getComponentName(d));
            }
            return n;
        }
        return null;
    }

    public static String getDisplayName(Object d) {
        if (d instanceof Descriptor) {
            String name = ((Descriptor)d).getDisplayName();
            return !name.equals("") ? name : DescriptorTools.getComponentName(d);
        }
        if (d instanceof Class) {
            return ((Class)d).getName();
        }
        if (d instanceof File) {
            return ((File)d).getPath();
        }
        return "";
    }

    public static String getComponentName(Object d) {
        if (d instanceof WebComponentDescriptor) {
            return ((WebComponentDescriptor)d).getCanonicalName();
        }
        if (d instanceof EjbDescriptor) {
            return ((EjbDescriptor)d).getName();
        }
        if (d instanceof WebService) {
            return ((WebService)d).getWebServiceName();
        }
        if (d instanceof WebServiceEndpoint) {
            return ((WebServiceEndpoint)d).getEndpointName();
        }
        if (d instanceof MessageDestinationDescriptor) {
            return ((MessageDestinationDescriptor)d).getName();
        }
        if (d instanceof Descriptor) {
            return ((Descriptor)d).getName();
        }
        return "";
    }

    public static Collection getWebServiceEndpoints(Descriptor d) {
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        if (bd != null) {
            if (d instanceof EjbDescriptor) {
                return bd.getWebServices().getEndpointsImplementedBy((EjbDescriptor)d);
            }
            if (d instanceof WebComponentDescriptor) {
                return bd.getWebServices().getEndpointsImplementedBy((WebComponentDescriptor)d);
            }
        } else {
            Print.dprintStackTrace((String)("Can't determine BundleDescriptor: " + DescriptorTools.getDisplayName(d)));
        }
        return null;
    }

    public static WebServiceEndpoint getWebServiceEndpoint(Descriptor d) {
        Collection wse = DescriptorTools.getWebServiceEndpoints(d);
        if (wse == null || wse.size() == 0) {
            return null;
        }
        if (wse.size() == 1) {
            return (WebServiceEndpoint)wse.iterator().next();
        }
        List sorted = ListTools.sortList(wse);
        return (WebServiceEndpoint)sorted.get(0);
    }

    public static void removeWebServiceEndpoints(Descriptor d) {
        Collection wseList = DescriptorTools.getWebServiceEndpoints(d);
        if (wseList != null) {
            Iterator i = wseList.iterator();
            while (i.hasNext()) {
                WebServiceEndpoint wse = (WebServiceEndpoint)i.next();
                WebService ws = wse.getWebService();
                if (ws == null) continue;
                ws.removeEndpoint(wse);
            }
        }
    }

    public static boolean isEndpoint(Descriptor d) {
        return DescriptorTools.hasWebServiceEndpoint(d);
    }

    public static boolean hasWebServiceEndpoint(Descriptor d) {
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        if (bd != null) {
            if (d instanceof EjbDescriptor) {
                return bd.getWebServices().hasEndpointsImplementedBy((EjbDescriptor)d);
            }
            if (d instanceof WebComponentDescriptor) {
                return bd.getWebServices().hasEndpointsImplementedBy((WebComponentDescriptor)d);
            }
        } else {
            Print.dprintStackTrace((String)("Can't determine BundleDescriptor: " + DescriptorTools.getDisplayName(d)));
        }
        return false;
    }

    public static String createUniqueEndpointName(WebServicesDescriptor wsd, String name) {
        if (wsd != null) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorComponentNames(wsd.getEndpoints()));
        }
        return name;
    }

    public static String createUniqueWebServiceName(WebServicesDescriptor wsd, String name) {
        if (wsd != null) {
            return DescriptorTools.createUniqueName(name, DescriptorTools.getDescriptorComponentNames(wsd.getWebServices()));
        }
        return name;
    }

    public static Collection getMessageDestinations(Descriptor d) {
        Descriptor rd = DescriptorTools.getModuleDescriptor(d);
        HashSet mdList = new HashSet();
        if (rd instanceof BundleDescriptor) {
            mdList.addAll(((BundleDescriptor)rd).getMessageDestinations());
        } else if (rd instanceof Application) {
            Set allBD = ((Application)rd).getArchivableDescriptors();
            Iterator i = allBD.iterator();
            while (i.hasNext()) {
                BundleDescriptor bd = (BundleDescriptor)i.next();
                mdList.addAll(bd.getMessageDestinations());
            }
        }
        return mdList;
    }

    public static Collection getMessageDestinationNames(Descriptor d) {
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        String bdArchUri = bd != null ? bd.getModuleDescriptor().getArchiveUri() : "";
        int bdp = bdArchUri != null ? bdArchUri.lastIndexOf("/") : -1;
        Vector bdArchPaths = bdp >= 0 ? ListTools.toList(new StringTokenizer(bdArchUri.substring(0, bdp), "/")) : new Vector();
        ListTools.OrderedSet mdNames = new ListTools.OrderedSet();
        Collection mdList = DescriptorTools.getMessageDestinations(d);
        Iterator i = mdList.iterator();
        while (i.hasNext()) {
            int m;
            MessageDestinationDescriptor mdd = (MessageDestinationDescriptor)i.next();
            String mddn = mdd.getName();
            BundleDescriptor mddBD = mdd.getBundleDescriptor();
            if (bd == mddBD) {
                mdNames.add(mddn);
                continue;
            }
            String mdArchUri = mddBD.getModuleDescriptor().getArchiveUri();
            int mdp = mdArchUri.lastIndexOf("/");
            String mdArchName = mdp >= 0 ? mdArchUri.substring(mdp + 1) : mdArchUri;
            Vector mdArchPaths = mdp >= 0 ? ListTools.toList(new StringTokenizer(mdArchUri.substring(0, mdp), "/")) : new Vector();
            for (int mdRelNdx = 0; mdRelNdx < bdArchPaths.size() && mdRelNdx < mdArchPaths.size() && bdArchPaths.get(mdRelNdx).equals(mdArchPaths.get(mdRelNdx)); ++mdRelNdx) {
            }
            StringBuffer mdRelUri = new StringBuffer();
            for (m = mdRelNdx; m < bdArchPaths.size(); ++m) {
                mdRelUri.append("..").append("/");
            }
            for (m = mdRelNdx; m < mdArchPaths.size(); ++m) {
                mdRelUri.append(mdArchPaths.get(m)).append("/");
            }
            mdRelUri.append(mdArchName);
            mdNames.add(mdRelUri.toString() + "#" + mddn);
        }
        return mdNames;
    }

    public static boolean addMessageDestination(Descriptor d, String destName) {
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(d);
        if (bd != null) {
            boolean found = false;
            Set mdList = bd.getMessageDestinations();
            Iterator i = bd.getMessageDestinations().iterator();
            while (i.hasNext()) {
                String n = ((MessageDestinationDescriptor)i.next()).getName();
                if (!destName.equals(n)) continue;
                found = true;
                break;
            }
            if (!found) {
                MessageDestinationDescriptor mdd = new MessageDestinationDescriptor(destName, "");
                mdd.setDisplayName(destName);
                bd.addMessageDestination(mdd);
                return true;
            }
        }
        return false;
    }

    public static EjbReferenceDescriptor convertEjbReference(EjbReferenceDescriptor ref) {
        if (ref.getEjbDescriptor() != null) {
            ref.setEjbDescriptor(null);
        }
        return ref;
    }

    public static String getRefJndiName(Descriptor desc, EjbReferenceDescriptor refDesc) {
        String refName = refDesc.getName();
        EjbRef[] ejbRefs = null;
        EjbRef ref = null;
        SunBaseBean sbb = null;
        if (desc instanceof EjbDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((EjbDescriptor)desc));
            ejbRefs = ((Ejb)sbb).getEjbRef();
        } else if (desc instanceof WebBundleDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((WebBundleDescriptor)desc));
            ejbRefs = ((SunWebApp)sbb).getEjbRef();
        } else if (desc instanceof ApplicationClientDescriptor) {
            sbb = SunOneUtils.getSunDescriptor((Descriptor)((ApplicationClientDescriptor)desc));
            ejbRefs = ((SunApplicationClient)sbb).getEjbRef();
        }
        if (ejbRefs != null) {
            for (int i = 0; i < ejbRefs.length; ++i) {
                if (!ejbRefs[i].getEjbRefName().equals(refName)) continue;
                ref = ejbRefs[i];
                break;
            }
        }
        return ref == null ? "" : ref.getJndiName();
    }

    public static EjbDescriptor getEjbOfServiceReferenceDescriptor(ServiceReferenceDescriptor srd) {
        if (srd == null) {
            return null;
        }
        String name = srd.getDisplayName();
        BundleDescriptor bd = srd.getBundleDescriptor();
        if (!(bd instanceof EjbBundleDescriptor)) {
            return null;
        }
        Set ejbSet = ((EjbBundleDescriptor)bd).getEjbs();
        Iterator i = ejbSet.iterator();
        while (i.hasNext()) {
            EjbDescriptor ejb = (EjbDescriptor)i.next();
            if (ejb.getServiceReferenceByName(name) == null) continue;
            return ejb;
        }
        return null;
    }

    public static void debugCheckApplicationModules(Descriptor d) {
        if (!UIConfig.debugMode()) {
            return;
        }
        if (!(d instanceof Application)) {
            return;
        }
        Application app = (Application)d;
        Print.dprintln((String)("Checking App Modules: " + app.getDisplayName()));
        Iterator i = app.getModules();
        while (i.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)i.next();
            Print.dprintln((String)("Module : " + md.getDisplayName()));
            Print.dprintln((String)("   Type: " + md.getModuleType()));
            Print.dprintln((String)("   URI : " + md.getArchiveUri()));
            BundleDescriptor bd = md.getDescriptor();
            Print.dprintln((String)("   BD  : " + (bd != null ? bd.getDisplayName() : "null")));
        }
    }

    public static boolean isCmpBeanPresent(EjbBundleDescriptor descriptor) {
        boolean retValue = false;
        EjbDescriptor ejbDescriptor = null;
        Iterator ejbs = descriptor.getEjbs().iterator();
        while (ejbs.hasNext()) {
            String persistenceType;
            ejbDescriptor = (EjbDescriptor)ejbs.next();
            if (!ejbDescriptor.getType().equals(EjbEntityDescriptor.TYPE) || !(persistenceType = ((EjbEntityDescriptor)ejbDescriptor).getPersistenceType()).equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE)) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    public static ArrayList getPossibleEjbLinkNames(Descriptor desc) {
        ArrayList<String> ejbNames = new ArrayList<String>();
        BundleDescriptor bd = DescriptorTools.getBundleDescriptor(desc);
        if (bd != null) {
            Collection coll = null;
            Application app = bd.getApplication();
            if (app != null) {
                coll = app.getEjbDescriptors();
            } else if (DescriptorTools.isStandAlone((Descriptor)bd) && bd instanceof EjbBundleDescriptor) {
                coll = ((EjbBundleDescriptor)bd).getEjbs();
            }
            if (coll != null) {
                Iterator iter = coll.iterator();
                while (iter.hasNext()) {
                    EjbDescriptor ejbDesc = (EjbDescriptor)iter.next();
                    if (ejbDesc instanceof EjbMessageBeanDescriptor) continue;
                    String nm = null;
                    nm = DescriptorTools.isStandAlone((Descriptor)bd) ? ejbDesc.getDisplayName() : ModuleArchive.getArchiveUri((Descriptor)ejbDesc.getEjbBundleDescriptor()) + "#" + ejbDesc.getDisplayName();
                    ejbNames.add(nm);
                }
            }
        }
        return ejbNames;
    }

    private static class ParseSpecVersion {
        private ModuleType moduleType = null;
        private String specVersion = "";
        private float specVersionFloat = 0.0f;
        private int specMajor = 0;
        private int specMinor = 0;

        public ParseSpecVersion(RootDeploymentDescriptor rdd) {
            this(rdd.getModuleType(), rdd.getSpecVersion());
        }

        public ParseSpecVersion(ModuleType modType, String specVers) {
            this.moduleType = modType;
            if (specVers != null) {
                this.specVersion = specVers;
                try {
                    this.specVersionFloat = Float.parseFloat(this.specVersion);
                }
                catch (NumberFormatException nfe) {
                    Print.dprintln((String)("SpecVersion could not be parsed as 'float': >" + this.specVersion + "<"));
                }
                try {
                    int p = this.specVersion.indexOf(".");
                    if (p < 0) {
                        p = this.specVersion.length();
                    }
                    this.specMajor = Integer.parseInt(this.specVersion.substring(0, p));
                    if (p + 1 < this.specVersion.length()) {
                        this.specMinor = Integer.parseInt(this.specVersion.substring(p + 1));
                    }
                }
                catch (NumberFormatException nfe) {
                    Print.dprintln((String)("SpecVersion could not be separated into major.minor: >" + this.specVersion + "<"));
                }
            } else {
                this.specVersion = "";
                this.specVersionFloat = 0.0f;
                this.specMajor = 0;
                this.specMinor = 0;
            }
        }

        public ModuleType getModuleType() {
            return this.moduleType;
        }

        public float getFloat() {
            return this.specVersionFloat;
        }

        public int getMajor() {
            return this.specMajor;
        }

        public int getMinor() {
            return this.specMinor;
        }

        public boolean compare(float vers) {
            return this.getFloat() >= vers;
        }

        public boolean compare(int major, int minor) {
            return this.getMajor() > major || this.getMajor() == major && this.getMinor() >= minor;
        }

        public String toString() {
            ModuleType mt = this.getModuleType();
            String mts = mt != null ? mt.toString().toUpperCase() : "???";
            return mts + " " + this.specVersion;
        }
    }
}

