/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.shared;

import com.sun.enterprise.deployment.Group;
import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DTRoleMapper
implements SecurityRoleMapper {
    private String _rolemapper = "DTRoleMapper";
    private Hashtable _rolesMap = new Hashtable();

    private List _getRolePrincipals(String roleName) {
        if (roleName != null) {
            Vector list = (Vector)this._rolesMap.get(roleName);
            if (list == null) {
                list = new Vector();
                this._rolesMap.put(roleName, list);
            }
            return list;
        }
        return null;
    }

    public String getName() {
        return this._rolemapper;
    }

    public String toString() {
        return this._rolemapper;
    }

    public Map getRoleToSubjectMapping() {
        return this._rolesMap;
    }

    public Iterator getRoles() {
        return this._rolesMap.keySet().iterator();
    }

    public boolean hasRole(Principal princ, String roleName) {
        if (roleName != null) {
            List list = this._getRolePrincipals(roleName);
            return list.contains(princ);
        }
        return false;
    }

    public void assignRole(Principal princ, Role role) {
        List list;
        if (princ != null && role != null && !(list = this._getRolePrincipals(role.getName())).contains(princ)) {
            list.add(princ);
        }
    }

    public void unassignRole(Principal princ, Role role) {
        List list;
        if (princ != null && role != null && (list = this._getRolePrincipals(role.getName())).contains(princ)) {
            list.remove(princ);
        }
    }

    public void unassignRole(Role role) {
        if (role != null) {
            this._rolesMap.remove(role.getName());
        }
    }

    public void unassignPrincipalFromRole(Role role, Principal principal) {
        List list;
        if (role != null && principal != null && (list = this._getRolePrincipals(role.getName())).contains(principal)) {
            list.remove(principal);
        }
    }

    public Enumeration getGroupsAssignedTo(Role role) {
        Vector v = new Vector();
        if (role != null) {
            List list = this._getRolePrincipals(role.getName());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object p = i.next();
                if (!(p instanceof Group)) continue;
                v.add(p);
            }
        }
        return v.elements();
    }

    public Enumeration getUsersAssignedTo(Role role) {
        Vector v = new Vector();
        if (role != null) {
            List list = this._getRolePrincipals(role.getName());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object p = i.next();
                if (p instanceof Group) continue;
                v.add(p);
            }
        }
        return v.elements();
    }

    public void setName(String name) {
        this._rolemapper = name;
    }
}

