/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentConnectionException;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManagerSettings;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentModule;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.server.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;

public class ServerGeneralInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ServerGeneralInspector.class);
    private static String TABNAME = localStrings.getLocalString("ui.servergeneralinspector.tabname", "Applications");
    private static String DEPLOYED_OBJECT_TITLE = localStrings.getLocalString("ui.servergeneralinspector.deployedobject", "Deployed Applications");
    private static String MODULE_UNDEPLOY = localStrings.getLocalString("ui.servergeneralinspector.module.undeploy", "Undeploy");
    private static String MODULE_START = localStrings.getLocalString("ui.servergeneralinspector.module.start", "Start");
    private static String MODULE_STOP = localStrings.getLocalString("ui.servergeneralinspector.module.stop", "Stop");
    private static String MODULE_CLIENTJAR = localStrings.getLocalString("ui.servergeneralinspector.module.client_jar", "Client Jar...");
    private static String CHOOSE_STUB_DIR = localStrings.getLocalString("ui.servergeneralinspector.module.client_jar.choose_stub_dir", "Please choose the client stub destination directory");
    private static String PLEASE_CHOOSE_A_DIRECTORY = localStrings.getLocalString("ui.servergeneralinspector.module.client_jar.must_be_a_dir", "Client stub destination must be a directory");
    private static String TABLE_DEPLOYED_OBJECT = localStrings.getLocalString("ui.servergeneralinspector.deployed_object.name", "Name");
    private static String TABLE_RUNNING_STATUS = localStrings.getLocalString("ui.servergeneralinspector.deployed_object.status", "Status");
    private static String STATUS_RUNNING = localStrings.getLocalString("ui.servergeneralinspector.deployed_object.running", "Running");
    private static String STATUS_STOPPED = localStrings.getLocalString("ui.servergeneralinspector.deployed_object.stopped", "Stopped");
    private static String STATUS_UNKNOWN = localStrings.getLocalString("ui.servergeneralinspector.deployed_object.unknown", "Unknown");
    private static String PLEASE_SELECT_SINGLE_MODULE = localStrings.getLocalString("ui.servergeneralinspector.error.please_select_a_single_module", "Please select a single deployed object module");
    private static String ERROR_WRITING_STUB_JAR_RAR = localStrings.getLocalString("ui.servergeneralinspector.error.writing_stub_jar_rar", "Unable to create client stub jar file for the selected connector.\nThis feature is available only for applications and stand-alone EJBs.");
    private static String ERROR_WRITING_STUB_JAR_WAR = localStrings.getLocalString("ui.servergeneralinspector.error.writing_stub_jar_war", "Unable to create client stub jar file for the selected WAR.\nThis feature is available only for applications and stand-alone EJBs.");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    private ServerDescriptor descriptor = null;
    private UITitledTable depObjPanel = null;
    private DeployedObjectTable depObjTable = null;

    private static String ERROR_WRITING_STUB_JAR(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.error.writing_stub_jar", "Unable to create client stub jar file\n {0}", new Object[]{v0});
    }

    private static String CREATED_STUB_JAR(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.created_stub_jar", "Successfully created client stub jarfile\n {0}", new Object[]{v0});
    }

    private static String USING_DISCONNECTED_DM_ERROR_MSG(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.cannot_contacted_server", "The deployment manager could not be contacted.\nPlease confirm that the server is running.\n{0}", new Object[]{v0});
    }

    private static String UNABLE_TO_CONNECT(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.unable_to_connect_to_server", "The server could not be contacted.\nPlease confirm that the server is running,\nand that a valid user/password has been entered.\n{0}", new Object[]{v0});
    }

    private static String SERVER_NOT_RUNNING_ERROR_MSG(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.please_start_the_server", "You must start the target server to view deployed modules:\n{0}", new Object[]{v0});
    }

    private static String ACTION_NOT_FOR_APPCLIENT(Object v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.error.action_not_for_appclient", "Start action does not apply to Application Client module(s)\n {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode) {
        return new ServerGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ServerDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ServerDescriptor) {
            this.descriptor = (ServerDescriptor)obj;
            if (this.descriptor != null) {
                this.descriptor.getServer().setCurrent();
            }
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ServerGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.depObjPanel = new UITitledTable(DEPLOYED_OBJECT_TITLE, true);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.depObjPanel, c);
        this.depObjTable = new DeployedObjectTable(new DeployedObjectTableModel());
        this.depObjPanel.setTableView(this.depObjTable);
        this.depObjPanel.addSelectionEnabledButton(new UIButton(MODULE_START, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerGeneralInspector.this.moduleStartAction();
            }
        }));
        this.depObjPanel.addSelectionEnabledButton(new UIButton(MODULE_STOP, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerGeneralInspector.this.moduleStopAction();
            }
        }));
        this.depObjPanel.addSelectionEnabledButton(new UIButton(MODULE_UNDEPLOY, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerGeneralInspector.this.moduleUndeployAction();
            }
        }));
        this.depObjPanel.addSelectionEnabledButton(new UIButton(MODULE_CLIENTJAR, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServerGeneralInspector.this.clientJarAction();
            }
        }));
    }

    public void refresh() {
        block9: {
            if (this.descriptor != null) {
                try {
                    DeploymentPlatform dp = this.descriptor.getDeploymentPlatform();
                    DeploymentPlatform.ManagerURI mu = this.descriptor.getServer();
                    if (!(dp.hasCurrentUserPassword() && dp.isConnected() && dp.isServerRunning() || DeploymentManagerSettings.showDialog(dp, mu, true))) {
                        this._refreshTable(null);
                        return;
                    }
                    Target target = mu.getTarget();
                    if (target == null) {
                        target = dp.getTarget(dp.getDeploymentManagerWithException(true), "server");
                        mu.setTarget(target);
                    }
                    if (target != null && ((SunTarget)target).isDAS()) {
                        ((DeployToolWindow)DT.getApplicationFrame()).getDescriptorTreeView().getRootTree().refresh();
                    }
                    dp.clearCachedDeploymentManagers();
                    if (!dp.isConnected() || !dp.isServerRunning()) {
                        this._refreshTable(null);
                        UIOptionPane.showErrorDialog(this, ServerGeneralInspector.UNABLE_TO_CONNECT(this.descriptor.getName()));
                        break block9;
                    }
                    this._refreshTable(this.descriptor.getDeploymentModules());
                }
                catch (DeploymentConnectionException dce) {
                    UIOptionPane.showErrorDialog(this, ServerGeneralInspector.UNABLE_TO_CONNECT(this.descriptor.getName()));
                    Print.dprintStackTrace((String)"Can't get deployed modules. (server not running?)", (Throwable)dce);
                    this._refreshTable(null);
                }
                catch (Throwable t) {
                    Print.dprintStackTrace((String)"Unexpected Exception", (Throwable)t);
                    this._refreshTable(null);
                }
            } else {
                this._refreshTable(null);
            }
        }
    }

    private void _refreshTable(Collection c) {
        if (c != null) {
            Vector v = new Vector(c);
            Iterator i = v.iterator();
            while (i.hasNext()) {
                DeploymentModule ref = (DeploymentModule)i.next();
                String n = ref.getName();
                if (!n.equalsIgnoreCase("adminapp") && !n.equalsIgnoreCase("MEjbApp") && !n.equalsIgnoreCase("admingui") && !n.equalsIgnoreCase("com_sun_web_ui") && !n.equalsIgnoreCase("__ejb_container_timer_app")) continue;
                i.remove();
            }
            this.depObjTable.updateTableData(v);
            this.depObjTable.setEnabled(true);
        } else {
            this.depObjTable.clearTableData();
            this.depObjTable.setEnabled(false);
        }
    }

    public void notification(NotificationEvent ne) {
        this.invokeRefresh();
    }

    public void moduleStartAction() {
        Object[] und = this.depObjTable.getSelectedRowObjects();
        Vector<DeploymentModule> mods = new Vector<DeploymentModule>();
        String errors = "";
        for (int i = 0; i < und.length; ++i) {
            DeploymentModule dm = (DeploymentModule)und[i];
            if (dm.isRunning()) continue;
            if (dm.getModuleType() == ModuleType.CAR) {
                errors = dm.getName() + "\n" + errors;
                continue;
            }
            mods.add(dm);
        }
        if (errors.length() > 0) {
            UIOptionPane.showErrorDialog(this, ServerGeneralInspector.ACTION_NOT_FOR_APPCLIENT(errors));
        }
        if (mods.size() <= 0) {
            return;
        }
        DeploymentModule[] m = mods.toArray(new DeploymentModule[mods.size()]);
        if (m != null && m.length > 0) {
            DT.getDeploymentManager().startObject(m);
            this.invokeRefresh();
        }
    }

    public void moduleStopAction() {
        Object[] und = this.depObjTable.getSelectedRowObjects();
        Vector<DeploymentModule> mods = new Vector<DeploymentModule>();
        for (int i = 0; i < und.length; ++i) {
            DeploymentModule dm = (DeploymentModule)und[i];
            if (!dm.isRunning()) continue;
            mods.add(dm);
        }
        DeploymentModule[] m = mods.toArray(new DeploymentModule[mods.size()]);
        if (m != null && m.length > 0) {
            DT.getDeploymentManager().stopObject(m);
            this.invokeRefresh();
        }
    }

    public void moduleUndeployAction() {
        Object[] und = this.depObjTable.getSelectedRowObjects();
        DeploymentModule[] m = (DeploymentModule[])ListTools.arrayCopy(und, DeploymentModule.class);
        DT.getDeploymentManager().undeployObject(m);
        this.invokeRefresh();
    }

    public void clientJarAction() {
        Object[] und = this.depObjTable.getSelectedRowObjects();
        DeploymentModule[] m = (DeploymentModule[])ListTools.arrayCopy(und, DeploymentModule.class);
        if (m.length != 1) {
            UIOptionPane.showErrorDialog(this, PLEASE_SELECT_SINGLE_MODULE);
            return;
        }
        ModuleType mtype = m[0].getModuleType();
        if (mtype == ModuleType.RAR) {
            UIOptionPane.showErrorDialog(this, ERROR_WRITING_STUB_JAR_RAR);
            return;
        }
        if (mtype == ModuleType.WAR) {
            UIOptionPane.showErrorDialog(this, ERROR_WRITING_STUB_JAR_WAR);
            return;
        }
        File stubDir = null;
        while (true) {
            if ((stubDir = UIOptionPane.showDirInputDialog(this, CHOOSE_STUB_DIR, null)) == null) {
                return;
            }
            if (stubDir.isDirectory()) break;
            UIOptionPane.showErrorDialog(this, PLEASE_CHOOSE_A_DIRECTORY);
        }
        try {
            if (!m[0].writeAppClientStubs(stubDir)) {
                UIOptionPane.showErrorDialog(this, ServerGeneralInspector.ERROR_WRITING_STUB_JAR(""));
            } else {
                UIOptionPane.showInfoDialog(this, ServerGeneralInspector.CREATED_STUB_JAR(stubDir));
            }
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"Unable to create AppClient stub jarfile", (Throwable)t);
            UIOptionPane.showErrorDialog(this, ServerGeneralInspector.ERROR_WRITING_STUB_JAR(t));
        }
    }

    private class DeployedObjectTableModel
    extends InspectorTableModel {
        public DeployedObjectTableModel() {
            super(new String[]{TABLE_DEPLOYED_OBJECT, TABLE_RUNNING_STATUS});
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            DeploymentModule ref = (DeploymentModule)obj;
            String value = null;
            block0 : switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    switch (ref._isRunning()) {
                        case 1: {
                            value = STATUS_RUNNING;
                            break block0;
                        }
                        case 0: {
                            value = STATUS_STOPPED;
                            break block0;
                        }
                    }
                    value = STATUS_UNKNOWN;
                    break;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            DeploymentModule ref = (DeploymentModule)obj;
        }
    }

    private class DeployedObjectTable
    extends InspectorTable {
        public DeployedObjectTable(DeployedObjectTableModel model) {
            super(model);
        }
    }
}

