/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.server;

import com.sun.enterprise.tools.deployment.ui.server.ServerInfoRetriever;
import com.sun.enterprise.util.Print;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;

public class JNDINamesRetriever
extends ServerInfoRetriever {
    private static final String RESOURCES_JMX_OBJECTNAME = "com.sun.appserv:type=resources,category=config";

    public JNDINamesRetriever(String adminHost, int adminPort, String user, String password) {
        super(adminHost, adminPort, user, password);
    }

    /*
     * WARNING - void declaration
     */
    public Collection getJndiNames(String type) {
        void var2_2;
        String command;
        if (type.equals("javax.sql.DataSource")) {
            command = "getJdbcResource";
        } else if (type.equals("javax.mail.Session")) {
            command = "getMailResource";
        } else if (type.equals("javax.jms.QueueConnectionFactory") || type.equals("javax.jms.TopicConnectionFactory") || type.equals("javax.jms.ConnectionFactory")) {
            command = "getJmsResource";
        } else {
            return null;
        }
        String[] paramTypes = new String[]{"java.lang.String"};
        Object[] params = new Object[]{null};
        Object[] ret = (Object[])this.callServer(RESOURCES_JMX_OBJECTNAME, (String)var2_2, params, paramTypes);
        Vector<String> v = new Vector<String>();
        if (ret != null) {
            for (int i = 0; i < ret.length; ++i) {
                v.add(this.getJndiName(ret[i].toString()));
            }
        }
        return v;
    }

    private String getJndiName(String resourceConfig) {
        StringTokenizer tok = new StringTokenizer(resourceConfig, "=", false);
        int i = 0;
        String jndiName = null;
        while (tok.hasMoreElements()) {
            jndiName = tok.nextToken();
            if (++i != 3) continue;
        }
        tok = new StringTokenizer(jndiName, ",", false);
        jndiName = tok.nextToken();
        return jndiName;
    }

    public static void main(String[] args) {
        JNDINamesRetriever nsr = new JNDINamesRetriever("localhost", 4848, "admin", "adminadmin");
        Collection ret = nsr.getJndiNames("javax.sql.DataSource");
        Print.dprintln((String)("JDBCs in server at localhost:4848 are: " + ret));
        ret = nsr.getJndiNames("javax.mail.Session");
        Print.dprintln((String)("JavaMails in server at localhost:4848 are: " + ret));
        ret = nsr.getJndiNames("javax.jms.ConnectionFactory");
        Print.dprintln((String)("JMSs in server at localhost:4848 are: " + ret));
    }
}

