/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.script;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.script.Deploytool;
import com.sun.enterprise.tools.deployment.ui.script.RunScript;
import com.sun.enterprise.tools.deployment.ui.script.ScriptException;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfigProperties;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.util.Print;
import java.io.File;
import java.util.Vector;

public abstract class Script {
    public static final String CONFIG_PREFIX = "ui.script.";
    private static final String DOTJAVA = ".java";
    private String scriptSource = null;
    private String scriptName = null;
    private UIConfigProperties scriptConfig = null;
    private RunScript runScriptThread = null;
    private boolean interactive = true;
    private Deploytool deploytoolScript = null;

    public Script() {
        String src = Print.getStackFrame((int)1).getFileName();
        if (src != null) {
            int p = src.lastIndexOf(File.separator);
            this.scriptSource = src.endsWith(DOTJAVA) ? src.substring(p + 1, src.length() - DOTJAVA.length()) : src.substring(p + 1);
        } else {
            this.scriptSource = "unknown";
        }
        Print.dprintln((String)("Script source: " + this.scriptSource));
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public String getScriptName() {
        return this.scriptName != null ? this.scriptName : this.getScriptSource();
    }

    public void setScriptName(String name) {
        this.scriptName = name;
    }

    void setRunScriptThread(RunScript runScriptThread) {
        this.runScriptThread = runScriptThread;
    }

    public boolean preCheck() {
        return true;
    }

    protected boolean isServerRunning(String serverName) {
        return false;
    }

    protected boolean requireServerRunning(String serverName, boolean confirm) {
        if (!this.isServerRunning(serverName)) {
            String msg = "Required server not found: ";
            if (confirm) {
                if (!this.showConfirmMessage(msg + serverName + "\n" + "Continue anyway?", false)) {
                    return false;
                }
            } else {
                this.showErrorMessage(msg + serverName + "\n" + "Cannot continue.");
                return false;
            }
        }
        return true;
    }

    protected boolean isApplicationOpen(String appName) {
        Vector apps = DT.getModuleManager().getApplicationNames();
        return appName != null ? apps.contains(appName) : apps.size() > 0;
    }

    protected boolean requireApplicationOpen(String appName, boolean confirm) {
        if (!this.isApplicationOpen(appName)) {
            String msg = "Required application not open: ";
            if (confirm) {
                if (!this.showConfirmMessage(msg + appName + "\n" + "Continue anyway?", false)) {
                    return false;
                }
            } else {
                this.showErrorMessage(msg + appName + "\n" + "Cannot continue.");
                return false;
            }
        }
        return true;
    }

    protected boolean requireApplicationClosed(String appName, boolean confirm) {
        if (this.isApplicationOpen(appName)) {
            String msg = "Application is already open: ";
            if (confirm) {
                if (!this.showConfirmMessage(msg + appName + "\n" + "Continue anyway?", false)) {
                    return false;
                }
            } else {
                this.showErrorMessage(msg + appName + "\n" + "Cannot continue.");
                return false;
            }
        }
        return true;
    }

    protected boolean fileExists(String file) {
        return new File(file).exists();
    }

    protected boolean requireFileExists(String file, boolean confirm) {
        if (!this.fileExists(file)) {
            String msg = "File/Directory does not exist:";
            if (confirm) {
                if (!this.showConfirmMessage(msg + "\n    " + file + "\n" + "Continue anyway?", false)) {
                    return false;
                }
            } else {
                this.showErrorMessage(msg + "\n    " + file + "\n" + "Cannot continue.");
                return false;
            }
        }
        return true;
    }

    protected static String makeFilename(String root, String file) {
        String r = Script.platformFilename(root);
        if (file != null) {
            if (!r.endsWith(File.separator)) {
                r = r + File.separator;
            }
            return r + Script.platformFilename(file);
        }
        return r;
    }

    protected static String makeTemporaryFilename(String file) {
        return Script.makeFilename(Script.getTemporaryDirectory(), file);
    }

    protected static String platformFilename(String file) {
        return file.replace('/', File.separatorChar);
    }

    protected static String getTemporaryDirectory() {
        return UIConfig.getTempDirectory().toString();
    }

    protected boolean showConfirmMessage(String msg, boolean dftVal) {
        if (this.runScriptThread != null) {
            return this.runScriptThread.showConfirmMessage(msg, dftVal);
        }
        if (this.isInteractive()) {
            boolean rtn = UIOptionPane.showConfirmDialog(DT.getApplicationFrame(), msg);
            this.logMessage(msg + " [" + rtn + "]");
            return rtn;
        }
        this.logMessage(msg + " [" + dftVal + "]");
        return dftVal;
    }

    protected void showErrorMessage(String msg) {
        if (this.runScriptThread != null) {
            this.runScriptThread.showErrorMessage(msg);
        } else if (this.isInteractive()) {
            this.logMessage(msg);
            UIOptionPane.showErrorDialog(DT.getApplicationFrame(), msg);
        } else {
            this.logMessage(msg);
        }
    }

    public void logMessage(String msg) {
        if (this.runScriptThread != null) {
            this.runScriptThread.logMessage(msg);
        } else {
            Print.println((String)msg);
        }
    }

    protected void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void runScript() throws ScriptException;

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean f) {
        this.interactive = f;
    }

    private UIConfigProperties _getProps() {
        if (this.scriptConfig == null) {
            this.scriptConfig = RunScript.getConfigProperties(this.getScriptName());
        }
        return this.scriptConfig;
    }

    public boolean saveConfig(String header) {
        return RunScript.saveConfigProperties(this.scriptConfig, header);
    }

    public boolean saveConfig() {
        return RunScript.saveConfigProperties(this.scriptConfig);
    }

    protected boolean _saveConfig() {
        return false;
    }

    public String getConfigValue(String key) {
        return this._getProps().getProperty(key);
    }

    public String getConfigValue(String key, String dftVal) {
        return this._getProps().getProperty(key, dftVal);
    }

    public void setConfigValue(String key, String val) {
        this._getProps().setProperty(key, val);
        this._saveConfig();
    }

    public boolean getConfigBoolean(String key) {
        return this._getProps().getPropertyBoolean(key);
    }

    public boolean getConfigBoolean(String key, boolean dftVal) {
        return this._getProps().getPropertyBoolean(key, dftVal);
    }

    public void setConfigBoolean(String key, boolean val) {
        this._getProps().setPropertyBoolean(key, val);
        this._saveConfig();
    }

    public int getConfigInteger(String key) {
        return this._getProps().getPropertyInteger(key);
    }

    public int getConfigInteger(String key, int dftVal) {
        return this._getProps().getPropertyInteger(key, dftVal);
    }

    public void setConfigInteger(String key, int val) {
        this._getProps().setPropertyInteger(key, val);
        this._saveConfig();
    }

    public String[] getConfigArray(String key) {
        return this._getProps().getStringArray(key);
    }

    public String[] getConfigArray(String key, String[] dftVal) {
        return this._getProps().getStringArray(key, dftVal);
    }

    public void setConfigArray(String key, String[] val) {
        this._getProps().setPropertyArray(key, val);
        this._saveConfig();
    }

    public Deploytool getDeploytoolWindow() {
        if (this.deploytoolScript == null) {
            this.deploytoolScript = new Deploytool(this);
        }
        return this.deploytoolScript;
    }
}

