/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.deployment.ui.rar.ConfigPropsDialog;
import com.sun.enterprise.tools.deployment.ui.rar.ConnDefInspector;
import com.sun.enterprise.tools.deployment.ui.rar.NewResAdaptWizard;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.help.CSH;
import javax.resource.spi.ResourceAdapter;
import javax.swing.ImageIcon;

public class ResAdaptGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResAdaptGeneralInspector.class);
    private static String TOOLTIP = localStrings.getLocalString("ui.resadaptgeneralinspector.tooltip", "Resource Adapter Archive information");
    private static String TRANS_NONE = localStrings.getLocalString("ui.resadaptgeneralinspector.transactionsupport_none", "None");
    private static String TRANS_LOCAL = localStrings.getLocalString("ui.resadaptgeneralinspector.transactionsupport_local", "Local");
    private static String TRANS_XA = localStrings.getLocalString("ui.resadaptgeneralinspector.transactionsupport_xa", "XA");
    private static String RES_ADAPT_CLASS = localStrings.getLocalString("ui.resadaptgeneralinspector.resourceadapterclass", "Resource Adapter Class:");
    private static String CONNECTION_DEFINITION_TABLE_TITLE = localStrings.getLocalString("ui.resadaptgeneralinspector.conndefs", "Connection Definitions");
    private static String TITLE_ADD_CONNECTION_DEF = localStrings.getLocalString("ui.resadaptgeneralinspector.conndef_title.add", "Add Connection Definition");
    private static String TITLE_EDIT_CONNECTION_DEF = localStrings.getLocalString("ui.resadaptgeneralinspector.conndef_title.edit", "Edit Connection Definition");
    private static String MAN_CONN_FACT_COL = localStrings.getLocalString("ui.resadaptgeneralinspector.managedconnfactcolumn", "Managed Conn. Factory:");
    private static String CONN_FACT_IFACE_COL = localStrings.getLocalString("ui.resadaptgeneralinspector.connfactoryinterfacecolumn", "Connection Factory Interface");
    private static String CONN_IFACE_COL = localStrings.getLocalString("ui.resadaptgeneralinspector.conninterfacecolumn", "Conn. Interface:");
    private static String TRANS_SUPPORT = localStrings.getLocalString("ui.resadaptgeneralinspector.transupport", "Transaction Support:");
    private static String VERSION_INFO = localStrings.getLocalString("ui.resadaptgeneralinspector.versioninfo", "Version Information...*");
    private static String NO_ADAPT_CLASS_ERR = localStrings.getLocalString("ui.resadaptgeneralinspector.no_adaptor_classes", "No Class implements interface 'javax.resource.spi.ResourceAdapter'.\nPlease return to the RAR file screen and add a ResourceAdapter class");
    private static String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.resadaptgeneralinspector.description.acc_dsc", "Enter Description for the Resource Adapter");
    private static String ICONS_ACC_DSC = localStrings.getLocalString("at.resadaptgeneralinspector.icons_acc_dsc", "Add Icons for the Resource Adapter");
    private static String TABNAME = localStrings.getLocalString("ui.resadaptgeneralinspector.tabname", "General");
    private static char VERSION_INFO_MNEMONIC = localStrings.getLocalString("ui.resadaptgeneralinspector.versioninfo_mnemonic", "V").charAt(0);
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    private static String EMPTY_STRING = " ";
    private ConnectorDescriptor descriptor;
    private UITitledComboBox cbResAdaptClass = null;
    private UIButton cfgProps = null;
    private ConnDefsTable connDefsTab = null;
    private UITitledComboBox cbTransSupport = null;
    private VersionInfoDialog versionInfoDialog = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private ImageIcon filledCfgPropsIcon = null;
    private ImageIcon emptyCfgPropsIcon = null;
    private ConfigPropsDialog cfgPropsDiag = null;
    private ConnDefInspector.ConnDefDialog connDefsDiag = null;
    private static String DIALOG_HELP_ID = "VersionInfo";
    private static final String VERSION_HELP_ID = "Version";

    public static InspectorPane newInspectorPane(String mode) {
        return new ResAdaptGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectorDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectorDescriptor) {
            this.descriptor = (ConnectorDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ResAdaptGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
        this.filledCfgPropsIcon = UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_ICON);
        this.emptyCfgPropsIcon = UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_ICON);
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setToolTipText(TOOLTIP);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.cbResAdaptClass = new UITitledComboBox(RES_ADAPT_CLASS, false);
        this.cbResAdaptClass.setReadOnly(this.isDeploymentMode());
        this.cbResAdaptClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.updateResAdaptClass();
            }
        });
        this.add((Component)this.cbResAdaptClass, gbc);
        this.cfgProps = new UIButton(UIIcons.getDefaultIcon());
        this.cfgProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.getConfigProps();
            }
        });
        this.cbResAdaptClass.setBrowserButton(this.cfgProps);
        UITitledTable connDefsUITab = new UITitledTable(CONNECTION_DEFINITION_TABLE_TITLE, true);
        gbc.weighty = 0.5;
        gbc.fill = 1;
        this.add((Component)connDefsUITab, gbc);
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.connDefsTab = new ConnDefsTable(new ConnDefsTableModel());
        connDefsUITab.setTableView(this.connDefsTab);
        connDefsUITab.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ResAdaptGeneralInspector.this.addConnDefsAction(null);
            }
        }, true));
        connDefsUITab.addSelectionEnabledButton(UIButton.createEditButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.addConnDefsAction((ConnectionDefDescriptor)ResAdaptGeneralInspector.this.connDefsTab.getSelectedRowObject());
            }
        }, true));
        connDefsUITab.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.deleteConnDefsAction();
            }
        }, true));
        UITitledBox buttonPanel = new UITitledBox(null, false);
        this.add((Component)buttonPanel, gbc);
        buttonPanel.getGBConstraints().insets = new Insets(5, 3, 0, 3);
        this.cbTransSupport = new UITitledComboBox(TRANS_SUPPORT, false);
        this.cbTransSupport.setModel(new Object[]{TRANS_NONE, TRANS_LOCAL, TRANS_XA});
        this.cbTransSupport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.updateTransactionSupport();
            }
        });
        buttonPanel.getGBConstraints().gridx = 0;
        buttonPanel.getGBConstraints().gridy = 0;
        buttonPanel.addWithGBConstraints(this.cbTransSupport);
        buttonPanel.getGBConstraints().gridx = 0;
        buttonPanel.getGBConstraints().gridy = 1;
        buttonPanel.addWithGBConstraints(new UIButton(VERSION_INFO, VERSION_INFO_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ResAdaptGeneralInspector.this.updateVersionInformation();
            }
        }));
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        this.iconInspector.getAccessibleContext().setAccessibleDescription(ICONS_ACC_DSC);
        UITitledBox iconButtonBox = new UITitledBox(" ", false);
        iconButtonBox.addWithGBConstraints(this.iconInspector);
        buttonPanel.getGBConstraints().gridx = 1;
        buttonPanel.getGBConstraints().gridy = 0;
        buttonPanel.addWithGBConstraints(iconButtonBox);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
        buttonPanel.getGBConstraints().gridx = 1;
        buttonPanel.getGBConstraints().gridy = 1;
        buttonPanel.addWithGBConstraints(this.descInspector);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        this.cfgProps.setIcon(this.descriptor.getConfigProperties().size() > 0 ? this.filledCfgPropsIcon : this.emptyCfgPropsIcon);
        OutboundResourceAdapter outResAdapter = this._getOutboundResourceAdapter(false);
        if (outResAdapter != null) {
            this.connDefsTab.updateTableData(outResAdapter.getConnectionDefs());
        } else {
            this.connDefsTab.clear();
        }
        if (this.isWizardMode()) {
            Vector clz = this.getArchiveClassNames(new Class[]{ResourceAdapter.class});
            clz.add(EMPTY_STRING);
            this.cbResAdaptClass.setModel((Collection)clz);
            String resAdapterClass = this.descriptor.getResourceAdapterClass();
            if (resAdapterClass == null || "".equals(resAdapterClass)) {
                resAdapterClass = EMPTY_STRING;
            }
            this.cbResAdaptClass.setSelectedItem(resAdapterClass);
        } else {
            this.cbResAdaptClass.setModel(new Object[]{this.descriptor.getResourceAdapterClass()});
        }
        this.cbTransSupport.setReadOnly(this.isDeploymentMode());
        if (outResAdapter == null) {
            this.cbTransSupport.setSelectedItem("");
        } else {
            switch (outResAdapter.getTransactionSupport()) {
                case 0: {
                    this.cbTransSupport.setSelectedItem(TRANS_NONE);
                    break;
                }
                case 1: {
                    this.cbTransSupport.setSelectedItem(TRANS_LOCAL);
                    break;
                }
                case 2: {
                    this.cbTransSupport.setSelectedItem(TRANS_XA);
                    break;
                }
                default: {
                    this.cbTransSupport.setSelectedItem("");
                }
            }
        }
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getDisplayName(), this, this.descriptor);
    }

    public OutboundResourceAdapter _getOutboundResourceAdapter(boolean create) {
        OutboundResourceAdapter obra = this.descriptor.getOutboundResourceAdapter();
        if (obra == null && create) {
            obra = new OutboundResourceAdapter();
            this.descriptor.setOutboundResourceAdapter(obra);
        }
        return obra;
    }

    private void getConfigProps() {
        if (this.cfgPropsDiag == null) {
            this.cfgPropsDiag = ConfigPropsDialog.newDialog(this);
        }
        this.cfgPropsDiag.showDialog((Descriptor)this.descriptor);
        this.invokeRefresh();
    }

    private void addConnDefsAction(ConnectionDefDescriptor connDefDesc) {
        if (this.connDefsDiag == null) {
            this.connDefsDiag = (ConnDefInspector.ConnDefDialog)ConnDefInspector.createInspectorDialog(this.getOwner(), this, true);
            this.connDefsDiag.setConnDefsTable(this.connDefsTab);
        }
        ConnectionDefDescriptor newConnDef = connDefDesc != null ? new ConnectionDefDescriptor(connDefDesc) : new ConnectionDefDescriptor();
        this.connDefsDiag.setDescriptor((Descriptor)newConnDef);
        this.connDefsDiag.setTitle(connDefDesc != null ? TITLE_EDIT_CONNECTION_DEF : TITLE_ADD_CONNECTION_DEF);
        if (this.connDefsDiag.showDialog()) {
            OutboundResourceAdapter outResAdapter = this._getOutboundResourceAdapter(true);
            if (connDefDesc != null) {
                outResAdapter.removeConnectionDefDescriptor(connDefDesc);
            }
            outResAdapter.addConnectionDefDescriptor(newConnDef);
        }
        this.invokeRefresh();
    }

    private void deleteConnDefsAction() {
        Object[] list = this.connDefsTab.confirmDeleteSelection(null, null);
        if (list != null) {
            OutboundResourceAdapter outResAdapter = this._getOutboundResourceAdapter(true);
            for (int i = 0; i < list.length; ++i) {
                outResAdapter.removeConnectionDefDescriptor((ConnectionDefDescriptor)list[i]);
            }
            this.connDefsTab.clearSelection();
        }
        this.invokeRefresh();
    }

    protected void updateResAdaptClass() {
        String selected = (String)this.cbResAdaptClass.getSelectedItem();
        if (EMPTY_STRING.equals(selected)) {
            selected = null;
        }
        this.descriptor.setResourceAdapterClass(selected);
    }

    protected void updateTransactionSupport() {
        int trans = 0;
        String sel = (String)this.cbTransSupport.getSelectedItem();
        trans = sel == null || sel.equals(TRANS_NONE) ? 0 : (sel.equals(TRANS_LOCAL) ? 1 : (sel.equals(TRANS_XA) ? 2 : 0));
        this._getOutboundResourceAdapter(true).setTransactionSupport(trans);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            NewResAdaptWizard raw = (NewResAdaptWizard)this.getOwner();
            this._addWizardIcon("large", iconFile, raw.getModuleContent(), (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            NewResAdaptWizard raw = (NewResAdaptWizard)this.getOwner();
            this._addWizardIcon("small", iconFile, raw.getModuleContent(), (Descriptor)this.descriptor);
        }
    }

    private void versionInfoOKAction(boolean update) {
        if (this.versionInfoDialog == null) {
            return;
        }
        if (update) {
            this.descriptor.setVendorName(this.versionInfoDialog.getVendorNameField().getText());
            this.descriptor.setEisType(this.versionInfoDialog.getEisTypeField().getText());
            this.descriptor.setResourceAdapterVersion(this.versionInfoDialog.getConnVersionField().getText());
        }
        this.versionInfoDialog.dispose();
        this.versionInfoDialog = null;
    }

    private void updateVersionInformation() {
        Window win = this.getMyParentWindow();
        if (win instanceof Dialog) {
            this.versionInfoDialog = new VersionInfoDialog((Dialog)win);
        } else if (win instanceof Frame) {
            this.versionInfoDialog = new VersionInfoDialog((Frame)win);
        }
        this.versionInfoDialog.getVendorNameField().setText(this.descriptor.getVendorName());
        this.versionInfoDialog.getEisTypeField().setText(this.descriptor.getEisType());
        String version = this.descriptor.getResourceAdapterVersion();
        if (version == null || version.equals("")) {
            version = NewResAdaptWizard.RESOURCE_VERSION_NUMBER;
        }
        this.versionInfoDialog.getConnVersionField().setText(version);
        this.versionInfoDialog.show();
    }

    static /* synthetic */ void access$1100(ResAdaptGeneralInspector x0, boolean x1) {
        x0.versionInfoOKAction(x1);
    }

    private class VersionInfoDialog
    extends UIDialog {
        private UITitledTextField vendorNameField;
        private UITitledTextField eisTypeField;
        private UITitledTextField connectorVersionField;

        public VersionInfoDialog(Frame p) {
            super(p, true);
            this.vendorNameField = null;
            this.eisTypeField = null;
            this.connectorVersionField = null;
            this.initUI(p);
        }

        public VersionInfoDialog(Dialog p) {
            super(p, true);
            this.vendorNameField = null;
            this.eisTypeField = null;
            this.connectorVersionField = null;
            this.initUI(p);
        }

        public Dimension getPreferredSize() {
            return new Dimension(375, 200);
        }

        public void initUI(Window p) {
            CSH.setHelpIDString((Component)this, (String)DIALOG_HELP_ID);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.getContentPane().setLayout(gridbag);
            UIControlButtonBox buttonsPanel = new UIControlButtonBox(null, false);
            c.weightx = 0.8;
            c.weighty = 0.8;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            c.fill = 1;
            this.getContentPane().add((Component)buttonsPanel, c);
            UIPanel textFieldPanel = new UIPanel();
            textFieldPanel.setLayout(new GridLayout(4, 1));
            this.vendorNameField = new UITitledTextField(localStrings.getLocalString("ui.resadaptgeneralinspector.vendor_name", "Vendor Name:"), false);
            this.vendorNameField.setRequired(true);
            textFieldPanel.add(this.vendorNameField);
            this.eisTypeField = new UITitledTextField(localStrings.getLocalString("ui.resadaptgeneralinspector.eis_type", "EIS Type:"), false);
            this.eisTypeField.setRequired(true);
            textFieldPanel.add(this.eisTypeField);
            this.connectorVersionField = new UITitledTextField(localStrings.getLocalString("ui.resadaptgeneralinspector.connector_version", "Connector Specification Version:"), false);
            this.connectorVersionField.setReadOnly(true);
            this.connectorVersionField.setRequired(true);
            textFieldPanel.add(this.connectorVersionField);
            buttonsPanel.setView(textFieldPanel);
            buttonsPanel.addControlButton(UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ VersionInfoDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    ResAdaptGeneralInspector.access$1100(VersionInfoDialog.access$1000(this.this$1), true);
                }
            }));
            buttonsPanel.addControlButton(UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ VersionInfoDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    ResAdaptGeneralInspector.access$1100(VersionInfoDialog.access$1000(this.this$1), false);
                }
            }));
            buttonsPanel.addControlButton(new UIHelpButton(ResAdaptGeneralInspector.VERSION_HELP_ID));
            this.setTitle(localStrings.getLocalString("ui.resadaptgeneralinspector.title", "Version Information"));
            this.setBounds(p.getBounds().x + 20, p.getBounds().y + 20, 375, 200);
            this.setResizable(false);
        }

        public UITitledTextField getVendorNameField() {
            return this.vendorNameField;
        }

        public UITitledTextField getEisTypeField() {
            return this.eisTypeField;
        }

        public UITitledTextField getConnVersionField() {
            return this.connectorVersionField;
        }

        static /* synthetic */ ResAdaptGeneralInspector access$1000(VersionInfoDialog x0) {
            return x0.ResAdaptGeneralInspector.this;
        }
    }

    private class ConnDefsTableModel
    extends InspectorTableModel {
        public ConnDefsTableModel() {
            super(new String[]{MAN_CONN_FACT_COL, CONN_FACT_IFACE_COL, CONN_IFACE_COL});
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getObjectValue(Object obj, int col) {
            ConnectionDefDescriptor ref = (ConnectionDefDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getManagedConnectionFactoryImpl();
                    break;
                }
                case 1: {
                    value = ref.getConnectionFactoryIntf();
                    break;
                }
                case 2: {
                    value = ref.getConnectionIntf();
                }
            }
            return value != null ? value : "";
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ConnectionDefDescriptor ref = (ConnectionDefDescriptor)obj;
        }
    }

    public class ConnDefsTable
    extends InspectorTable {
        public ConnDefsTable(ConnDefsTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }
    }
}

