/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.rar.ConfigPropsDialog;
import com.sun.enterprise.tools.deployment.ui.rar.ResAdaptGeneralInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIIcons;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.Wizard;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ConnDefInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnDefInspector.class);
    private static String TOOLTIP = localStrings.getLocalString("ui.conndefinspector.tooltip", "Resource Adapter Archive information");
    private static String CONN_DEF_TITLE = localStrings.getLocalString("ui.conndefinspector.condef.title", "None");
    private static String MAN_CONN_FACT = localStrings.getLocalString("ui.conndefinspector.managedconnfact", "Managed Connection Factory:");
    private static String CONN_FACT = localStrings.getLocalString("ui.conndefinspector.connfactory", "Connection Factory");
    private static String INTERFACE = localStrings.getLocalString("ui.conndefinspector.interface", "Interface:");
    private static String IMPLEMENTATION = localStrings.getLocalString("ui.conndefinspector.implementation", "Implementation:");
    private static String CONNECTION = localStrings.getLocalString("ui.conndefinspector.connection", "Connection");
    private static String DISPLAY_NAME = localStrings.getLocalString("ui.conndefinspector.adapterdisplayname", "Resource Adapter Display Name:");
    private static String TRANS_SUPPORT = localStrings.getLocalString("ui.conndefinspector.transupport", "Transaction Support:");
    private static String VERSION_INFO = localStrings.getLocalString("ui.conndefinspector.versioninfo", "Version Information...");
    private static String TABNAME = localStrings.getLocalString("ui.conndefinspector.tabname", "General");
    private static String MAN_CONN_FACT_COL = localStrings.getLocalString("ui.conndefinspector.managedconnfactcolumn", "Managed Conn. Factory:");
    private static String CONN_FACT_IFACE_COL = localStrings.getLocalString("ui.conndefinspector.connfactoryinterfacecolumn", "Connection Factory Interface");
    private static String CONN_IFACE_COL = localStrings.getLocalString("ui.conndefinspector.conninterfacecolumn", "Conn. Interface:");
    private static String CONFIG_PROPERTIES = localStrings.getLocalString("ui.conndefinspector.config_properties_button", "Configuration Properties...");
    private static char CONFIG_PROPERTIES_MNEMONIC = localStrings.getLocalString("ui.conndefinspector.config_properties_button_mnemonic", "P").charAt(0);
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    private ConnectionDefDescriptor descriptor = null;
    private UITitledComboBox cbMngConnFact = null;
    private UITitledComboBox cbConnFactInterface = null;
    private UITitledComboBox cbConnFactImplement = null;
    private UITitledComboBox cbConnInterface = null;
    private UITitledComboBox cbConnImplement = null;
    private UIButton configPropsButton = null;
    private ConfigPropsDialog cfgPropsDiag = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new ConnDefInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ConnectionDefDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectionDefDescriptor) {
            this.descriptor = (ConnectionDefDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ConnDefInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setToolTipText(TOOLTIP);
        c.weighty = 0.5;
        c.gridx = -1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 0, 5);
        c.fill = 1;
        c.anchor = 10;
        UIPanel leftPanel = new UIPanel(new GridBagLayout());
        c.weightx = 0.75;
        this.add((Component)leftPanel, c);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 2;
        gbc.anchor = 10;
        this.cbMngConnFact = new UITitledComboBox(MAN_CONN_FACT, false);
        this.cbMngConnFact.setRequired(true);
        this.cbMngConnFact.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.descriptor.setManagedConnectionFactoryImpl(ConnDefInspector.this.cbMngConnFact.getText());
            }
        });
        leftPanel.add((Component)this.cbMngConnFact, gbc);
        UITitledBox boxConnFact = new UITitledBox(CONN_FACT, true);
        boxConnFact.setRequired(true);
        this.cbConnFactInterface = new UITitledComboBox(INTERFACE, false);
        this.cbConnFactInterface.setRequired(true);
        this.cbConnFactInterface.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.descriptor.setConnectionFactoryIntf(ConnDefInspector.this.cbConnFactInterface.getText());
                ConnDefInspector.this._updateImplementingClasses(ConnDefInspector.this.cbConnFactInterface, ConnDefInspector.this.cbConnFactImplement);
            }
        });
        this.cbConnFactInterface.setEditable(true);
        boxConnFact.setGBConstraints(this.cbConnFactInterface);
        boxConnFact.add(this.cbConnFactInterface);
        this.cbConnFactImplement = new UITitledComboBox(IMPLEMENTATION, false);
        this.cbConnFactImplement.setRequired(true);
        this.cbConnFactImplement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.descriptor.setConnectionFactoryImpl(ConnDefInspector.this.cbConnFactImplement.getText());
            }
        });
        boxConnFact.addWithGBConstraints(this.cbConnFactImplement);
        leftPanel.add((Component)boxConnFact, gbc);
        UITitledBox boxConn = new UITitledBox(CONNECTION, true);
        boxConn.setRequired(true);
        leftPanel.add((Component)boxConn, gbc);
        this.cbConnInterface = new UITitledComboBox(INTERFACE, false);
        this.cbConnInterface.setRequired(true);
        this.cbConnInterface.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.descriptor.setConnectionIntf(ConnDefInspector.this.cbConnInterface.getText());
                ConnDefInspector.this._updateImplementingClasses(ConnDefInspector.this.cbConnInterface, ConnDefInspector.this.cbConnImplement);
            }
        });
        this.cbConnInterface.setEditable(true);
        boxConn.addWithGBConstraints(this.cbConnInterface);
        this.cbConnImplement = new UITitledComboBox(IMPLEMENTATION, false);
        this.cbConnImplement.setRequired(true);
        this.cbConnImplement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.descriptor.setConnectionImpl(ConnDefInspector.this.cbConnImplement.getText());
            }
        });
        boxConn.addWithGBConstraints(this.cbConnImplement);
        this.configPropsButton = new UIButton(CONFIG_PROPERTIES, CONFIG_PROPERTIES_MNEMONIC, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConnDefInspector.this.getConfigProps();
            }
        });
        leftPanel.add((Component)this.configPropsButton, gbc);
    }

    public void refresh() {
        List ifaceList;
        if (this.descriptor == null) {
            return;
        }
        Vector classList = this.getArchiveClasses();
        if (classList == null || classList.size() == 0) {
            Print.dprintln((String)"No classes!");
        }
        if ((ifaceList = this.getArchiveInterfaces()) == null || ifaceList.size() == 0) {
            Print.dprintln((String)"No interfaces!");
        }
        String mngConnFactSel = this.descriptor.getManagedConnectionFactoryImpl();
        this.cbMngConnFact.setModel(this._getClassNames(classList, mngConnFactSel));
        this.cbMngConnFact.setSelectedItem(mngConnFactSel);
        String connFactSel = this.descriptor.getConnectionFactoryIntf();
        this.cbConnFactInterface.setModel(this._getClassNames(ifaceList, connFactSel));
        if (!this.cbConnFactInterface.containsItem("javax.resource.cci.ConnectionFactory")) {
            this.cbConnFactInterface.addItem("javax.resource.cci.ConnectionFactory");
        }
        this.cbConnFactInterface.setSelectedItem(connFactSel);
        String connFactSelImpl = this.descriptor.getConnectionFactoryImpl();
        this.cbConnFactImplement.setModel(this._getImplementingClassNames(this._getClass(connFactSel), connFactSelImpl));
        this.cbConnFactImplement.setSelectedItem(connFactSelImpl);
        String connSel = this.descriptor.getConnectionIntf();
        this.cbConnInterface.setModel(this._getClassNames(ifaceList, connSel));
        if (!this.cbConnInterface.containsItem("javax.resource.cci.Connection")) {
            this.cbConnInterface.addItem("javax.resource.cci.Connection");
        }
        this.cbConnInterface.setSelectedItem(connSel);
        String connSelImpl = this.descriptor.getConnectionImpl();
        this.cbConnImplement.setModel(this._getImplementingClassNames(this._getClass(connSel), connSelImpl));
        this.cbConnImplement.setSelectedItem(connSelImpl);
        this.configPropsButton.setIcon(this.descriptor.getConfigProperties().size() > 0 ? UIIcons.getImageIconFor(UIIcons.CONF_PROPS_FILLED_ICON) : UIIcons.getImageIconFor(UIIcons.CONF_PROPS_EMPTY_ICON));
    }

    private void getConfigProps() {
        if (this.cfgPropsDiag == null) {
            this.cfgPropsDiag = ConfigPropsDialog.newDialog(this);
        }
        this.cfgPropsDiag.showDialog((Descriptor)this.descriptor);
        this.invokeRefresh();
    }

    protected Class _getClass(String cn) {
        try {
            return Class.forName(cn);
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected Class _getSelectedClass(UITitledComboBox cb) {
        Object sel = cb.getSelectedItem();
        if (sel == null || sel instanceof Class) {
            return (Class)sel;
        }
        return this._getClass(sel.toString());
    }

    protected List _getImplementingClassNames(Class intrf, String selName) {
        if (intrf == null && selName == null) {
            return null;
        }
        Vector classList = this.getArchiveClasses();
        Vector<String> implClz = new Vector<String>();
        if (intrf != null) {
            Iterator i = classList.iterator();
            while (i.hasNext()) {
                Class clz = (Class)i.next();
                if (clz.isInterface() || !intrf.isAssignableFrom(clz)) continue;
                implClz.add(clz.getName());
            }
        }
        if (selName != null && !implClz.contains(selName)) {
            implClz.add(selName);
        }
        return implClz;
    }

    protected List _getClassNames(List clzList, String selName) {
        if (clzList == null && selName == null) {
            return null;
        }
        Vector<String> clzNames = new Vector<String>();
        if (clzList != null) {
            Iterator i = clzList.iterator();
            while (i.hasNext()) {
                Object clz = i.next();
                clzNames.add(clz instanceof Class ? ((Class)clz).getName() : clz.toString());
            }
        }
        if (selName != null && !clzNames.contains(selName)) {
            clzNames.add(selName);
        }
        return clzNames;
    }

    protected void _updateImplementingClasses(UITitledComboBox cbIntf, UITitledComboBox cbImpl) {
        cbImpl.setModel(this._getImplementingClassNames(this._getSelectedClass(cbIntf), null));
        cbImpl.setSelectedIndex(-1);
        cbImpl.fireUpdate();
    }

    public static InspectorPane.InspectorPaneDialog createInspectorDialog(InspectorPane.InspectorPaneOwner inspOwner, Component winOwner, boolean modal) {
        String mode = inspOwner instanceof Wizard ? "WizardMode" : "DeploymentMode";
        InspectorPane connDef = ConnDefInspector.newInspectorPane(mode);
        InspectorPane.InspectorPaneDialog connDefDialog = connDef.createInspectorPaneDialog(inspOwner, winOwner, true);
        connDefDialog.setLocationRelativeTo(winOwner);
        return connDefDialog;
    }

    protected InspectorPane.InspectorPaneDialog _createInspectorPaneDialog(Window win, InspectorPane.InspectorPaneOwner inspOwner, boolean modal) {
        if (win instanceof Frame) {
            return new ConnDefDialog((Frame)win, inspOwner, modal);
        }
        if (win instanceof Dialog) {
            return new ConnDefDialog((Dialog)win, inspOwner, modal);
        }
        return null;
    }

    public class ConnDefDialog
    extends InspectorPane.InspectorPaneDialog {
        private int MIN_WIDTH;
        private int MIN_HEIGHT;
        private boolean isOk;
        private ResAdaptGeneralInspector.ConnDefsTable connDefsTable;

        public ConnDefDialog(Frame f, InspectorPane.InspectorPaneOwner o, boolean m) {
            super((InspectorPane)ConnDefInspector.this, f, o, m);
            this.MIN_WIDTH = 450;
            this.MIN_HEIGHT = 300;
            this.isOk = false;
            this.init();
        }

        public ConnDefDialog(Dialog d, InspectorPane.InspectorPaneOwner o, boolean m) {
            super((InspectorPane)ConnDefInspector.this, d, o, m);
            this.MIN_WIDTH = 450;
            this.MIN_HEIGHT = 300;
            this.isOk = false;
            this.init();
        }

        private void init() {
            super.setTitle(CONN_DEF_TITLE);
            super.setCancelEnabled(true);
        }

        public void setDescriptor(Descriptor obj) {
            if (obj instanceof ConnectionDefDescriptor) {
                ConnDefInspector.this.descriptor = (ConnectionDefDescriptor)obj;
                ConnDefInspector.this.invokeRefresh();
            } else {
                ConnDefInspector.this.descriptor = null;
            }
        }

        public void setConnDefsTable(ResAdaptGeneralInspector.ConnDefsTable table) {
            this.connDefsTable = table;
        }

        public void okAction() {
            this.isOk = true;
            this.connDefsTable.addRowObject(ConnDefInspector.this.descriptor);
            this.hide();
        }

        public void cancelAction() {
            Print.dprintln((String)"In cancelAction");
            this.isOk = false;
            this.hide();
        }

        public boolean showDialog() {
            this.show();
            return this.isOk;
        }

        public void setLocationRelativeTo(Component comp) {
            if (!(comp instanceof InspectorPane)) {
                Dimension d = this.getSize();
                if (d.width < this.MIN_WIDTH || d.height < this.MIN_HEIGHT) {
                    int w = d.width < this.MIN_WIDTH ? this.MIN_WIDTH : d.width;
                    int h = d.height < this.MIN_HEIGHT ? this.MIN_HEIGHT : d.height;
                    this.setSize(w, h);
                }
            }
            super.setLocationRelativeTo(comp);
        }
    }
}

