/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rar;

import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import javax.swing.table.TableCellEditor;

public class ConfigPropsDialog
extends UIDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigPropsDialog.class);
    protected static final String CFG_PROPS_TITLE = localStrings.getLocalString("ui.configpropsdialog.table.config_value", "Configuration Properties");
    protected static final String CFG_PROPERTY = localStrings.getLocalString("ui.configpropsdialog.table.config_property", "Property");
    protected static final String CFG_TYPE = localStrings.getLocalString("ui.configpropsdialog.table.config_type", "Type");
    protected static final String CFG_VALUE = localStrings.getLocalString("ui.configpropsdialog.table.config_value", "Default Value");
    private static final String CFG_PROPS_TABLE = localStrings.getLocalString("ui.configpropsdialog.connfactconfigprops", "Configuration Properties for Connection Factories");
    private static String CFG_PROPS_TABLE_ACC_DSC = localStrings.getLocalString("at.configpropsdialog.connfactconfigprops.acc_dsc", "Table for editing Resource Adapter Configuration Properties");
    private ConfigPropertyHolder descriptor = null;
    private boolean isOk = false;
    private ConnFactPropertiesTable connFactPropsTable = null;
    private static final String JAVA_LANG = "java.lang.";

    protected static String ILLEGAL_VALUE(String v0) {
        return localStrings.getLocalString("ui.configpropsdialog.table.illegal_type", "{0} is not a legal value for this environment entry type", new Object[]{v0});
    }

    public Descriptor getDescriptor() {
        return this.descriptor != null ? this.descriptor.getDescriptor() : null;
    }

    public void setDescriptor(Descriptor d) {
        if (this.getDescriptor() != d) {
            this.descriptor = d != null ? new ConfigPropertyHolder(d, true) : null;
            this.connFactPropsTable.clearTableData();
            this.connFactPropsTable.setColumnHidden(1, d instanceof MessageListener);
            this.connFactPropsTable.setColumnHidden(2, d instanceof MessageListener);
        }
    }

    private Set getConfigProperties() {
        return this.descriptor.getConfigProperties();
    }

    private void addConfigProperty(EnvironmentProperty ep) {
        this.descriptor.addConfigProperty(ep);
    }

    private void removeConfigProperty(EnvironmentProperty ep) {
        this.descriptor.removeConfigProperty(ep);
    }

    public static ConfigPropsDialog newDialog(Component ownerComp) {
        Window win = WinTools.getAncestorWindow(ownerComp);
        if (win instanceof Frame) {
            return new ConfigPropsDialog((Frame)win);
        }
        if (win instanceof Dialog) {
            return new ConfigPropsDialog((Dialog)win);
        }
        return null;
    }

    public boolean showDialog(Descriptor d) {
        this.isOk = false;
        this.setDescriptor(d);
        this.setTitle(CFG_PROPS_TITLE);
        this.refreshDialog();
        this.setSize(520, 425);
        this.setLocationRelativeToOwner();
        this.show();
        this.setDescriptor(null);
        return this.isOk;
    }

    public void refreshDialog() {
        this.connFactPropsTable.updateTableData(this.getConfigProperties());
    }

    protected ConfigPropsDialog(Dialog d) {
        super(d, true);
        this.initDialogLayout();
    }

    protected ConfigPropsDialog(Frame f) {
        super(f, true);
        this.initDialogLayout();
    }

    private void initDialogLayout() {
        UIControlButtonBox container = new UIControlButtonBox(null, false);
        container.setControlButtonLocation(101);
        this.getContentBox().addWithGBConstraints(container);
        container.setView(this.initDialogViewLayout());
        container.addControlButton(UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConfigPropsDialog.this.okAction();
            }
        }));
        container.addControlButton(UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ConfigPropsDialog.this.cancelAction();
            }
        }));
        container.addControlButton(new UIHelpButton("RIConfigProp"));
    }

    protected UITitledBox initDialogViewLayout() {
        UITitledBox viewBox = new UITitledBox(null, false);
        UITitledTable configTbl = new UITitledTable(CFG_PROPS_TABLE, true);
        configTbl.getAccessibleContext().setAccessibleDescription(CFG_PROPS_TABLE_ACC_DSC);
        viewBox.addWithGBConstraints(configTbl);
        this.connFactPropsTable = new ConnFactPropertiesTable(new ConnFactPropertiesModel());
        configTbl.setTableView(this.connFactPropsTable);
        configTbl.addControlButton(UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPropsDialog.this.addConfigPropertyAction();
            }
        }));
        configTbl.addSelectionEnabledButton(UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigPropsDialog.this.removeConfigPropertyAction();
            }
        }, true));
        return viewBox;
    }

    private void okAction() {
        this.descriptor.commit();
        this.hide();
    }

    protected void cancelAction() {
        this.hide();
    }

    protected void addConfigPropertyAction() {
        if (this.connFactPropsTable.getRowWithValue(0, "") == null) {
            this.addConfigProperty(new EnvironmentProperty("", "", "", String.class.getName()));
        }
        this.connFactPropsTable.selectRowWithValueOnUpdate(0, "");
        this.refreshDialog();
    }

    protected void removeConfigPropertyAction() {
        Object[] list = this.connFactPropsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                this.removeConfigProperty((EnvironmentProperty)list[i]);
            }
        }
        this.refreshDialog();
    }

    protected class ConnFactPropertiesModel
    extends InspectorTableModel {
        public ConnFactPropertiesModel() {
            super(new String[]{CFG_PROPERTY, CFG_TYPE, CFG_VALUE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public Object getObjectValue(Object obj, int col) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    String type = ref.getType();
                    if (type == null) {
                        type = "String";
                    }
                    value = type.startsWith(ConfigPropsDialog.JAVA_LANG) ? type.substring(ConfigPropsDialog.JAVA_LANG.length()) : type;
                    break;
                }
                case 2: {
                    value = ref.getValue();
                    break;
                }
                case 3: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            EnvironmentProperty ref = (EnvironmentProperty)obj;
            String valStr = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(valStr);
                    break;
                }
                case 1: {
                    if (!valStr.startsWith(ConfigPropsDialog.JAVA_LANG)) {
                        valStr = ConfigPropsDialog.JAVA_LANG + valStr;
                    }
                    if (valStr.equals(ref.getType())) break;
                    ref.setType(valStr);
                    this.setObjectValue(obj, 2, "");
                    break;
                }
                case 2: {
                    try {
                        ref.setValue(super.validatePrimitiveValue(ref.getType(), valStr));
                    }
                    catch (IllegalArgumentException iae) {
                        UIOptionPane.showErrorDialog(null, ConfigPropsDialog.ILLEGAL_VALUE(valStr));
                    }
                    break;
                }
                case 3: {
                    ref.setDescription(valStr);
                }
            }
        }
    }

    protected class ConnFactPropertiesTable
    extends InspectorTable {
        public ConnFactPropertiesTable(ConnFactPropertiesModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 1: {
                    rtn = super.getPrimitiveTypesEditor();
                    break;
                }
                case 2: {
                    EnvironmentProperty ref = (EnvironmentProperty)this.getRowObject(row);
                    rtn = super.getPrimitiveValueEditor(ref.getType());
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }

    private class ConfigPropertyHolder {
        private Descriptor descriptor = null;
        private Set configProperties = null;

        public ConfigPropertyHolder(Descriptor d, boolean copy) {
            Set origSet;
            this.descriptor = d;
            if (copy && (origSet = this.getConfigProperties(d)) != null) {
                this.configProperties = new ListTools.OrderedSet();
                Iterator i = origSet.iterator();
                while (i.hasNext()) {
                    EnvironmentProperty ep = (EnvironmentProperty)i.next();
                    this.configProperties.add(new EnvironmentProperty(ep));
                }
            }
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        private Set getConfigProperties(Descriptor d) {
            if (d instanceof ConnectorDescriptor) {
                return ((ConnectorDescriptor)d).getConfigProperties();
            }
            if (d instanceof MessageListener) {
                return ((MessageListener)d).getConfigProperties();
            }
            if (d instanceof AdminObject) {
                return ((AdminObject)d).getConfigProperties();
            }
            if (d instanceof ConnectionDefDescriptor) {
                return ((ConnectionDefDescriptor)d).getConfigProperties();
            }
            return null;
        }

        public Set getConfigProperties() {
            return this.configProperties != null ? this.configProperties : this.getConfigProperties(this.descriptor);
        }

        public void addConfigProperty(EnvironmentProperty ep) {
            if (this.configProperties != null) {
                if (!this.configProperties.contains(ep)) {
                    this.configProperties.add(ep);
                }
            } else if (this.descriptor instanceof ConnectorDescriptor) {
                ((ConnectorDescriptor)this.descriptor).addConfigProperty(ep);
            } else if (this.descriptor instanceof MessageListener) {
                ((MessageListener)this.descriptor).addConfigProperty(ep);
            } else if (this.descriptor instanceof AdminObject) {
                ((AdminObject)this.descriptor).addConfigProperty(ep);
            } else if (this.descriptor instanceof ConnectionDefDescriptor) {
                ((ConnectionDefDescriptor)this.descriptor).addConfigProperty(ep);
            }
        }

        public void removeConfigProperty(EnvironmentProperty ep) {
            if (this.configProperties != null) {
                this.configProperties.remove(ep);
            } else if (this.descriptor instanceof ConnectorDescriptor) {
                ((ConnectorDescriptor)this.descriptor).removeConfigProperty(ep);
            } else if (this.descriptor instanceof MessageListener) {
                ((MessageListener)this.descriptor).removeConfigProperty(ep);
            } else if (this.descriptor instanceof AdminObject) {
                ((AdminObject)this.descriptor).removeConfigProperty(ep);
            } else if (this.descriptor instanceof ConnectionDefDescriptor) {
                ((ConnectionDefDescriptor)this.descriptor).removeConfigProperty(ep);
            }
        }

        public void commit() {
            if (this.configProperties != null) {
                Set origSet = this.getConfigProperties(this.descriptor);
                origSet.clear();
                origSet.addAll(this.configProperties);
                this.descriptor.changed();
            }
        }
    }
}

