/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.pref;

import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.pref.PreferencePanel;
import com.sun.enterprise.tools.deployment.ui.pref.PreferenceTable;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class DeployManagerPreferences
extends UITitledBox
implements PreferencePanel {
    private static final boolean USE_COMBO_BOX = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployManagerPreferences.class);
    protected static String DEP_PLATFORM = localStrings.getLocalString("ui.deploymanagerpreferences.platform.combo_title", "Deployment Platform:");
    protected static String DEP_PLATFORM_COLUMN_TITLE = localStrings.getLocalString("ui.deploymanagerpreferences.platform.column_title", "Deployment Platform");
    protected static String DEP_URIS_BOX_TITLE = localStrings.getLocalString("ui.deploymanagerpreferences.uri.box_title", "Deployment Manager URIs");
    protected static String DEP_URIS_COL_URI = localStrings.getLocalString("ui.deploymanagerpreferences.uri.column0_title", "Deployment Manager URI");
    protected static String DEP_URIS_SET_DEFAULT = localStrings.getLocalString("ui.deploymanagerpreferences.uri.set_default", "Set Default");
    private Vector depMgrs = null;
    private UITitledComboBox platformName = new UITitledComboBox(DEP_PLATFORM, false);
    private PreferenceTable platformTable = null;
    private PreferenceTable uriTable = null;

    public DeployManagerPreferences(String nodeTitle) {
        super(nodeTitle, true);
        this.platformName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentPlatform dp = DeployManagerPreferences.this.getSelectedPlatform();
                DeployManagerPreferences.this.showDeploymentManagerURIs(dp);
            }
        });
        GridBagConstraints gbc = this.getGBConstraintsCopy();
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)this.platformName, gbc);
        this.uriTable = new PreferenceTable(DEP_URIS_BOX_TITLE, true, null, new String[]{DEP_URIS_COL_URI});
        this.uriTable.setRecordHandler(new PreferenceTable.PrefRecordHandler(){

            public boolean isColumnEditable(Object ref, int col) {
                return true;
            }

            public Object getColumnValue(Object ref, int col) {
                if (ref instanceof DeploymentPlatform.ManagerURI && col == 0) {
                    return ((DeploymentPlatform.ManagerURI)ref).getURI();
                }
                return "";
            }

            public void setColumnValue(Object ref, int col, Object value) {
                if (ref instanceof DeploymentPlatform.ManagerURI && col == 0) {
                    String v = DeploymentPlatform.NormalizeDefaultURI(value.toString());
                    ((DeploymentPlatform.ManagerURI)ref).setURI(v);
                }
            }
        });
        this.uriTable.setNewRecordTemplate(new PreferenceTable.PrefNewRecord(){

            public Object newRecord() {
                DeploymentPlatform p = DeployManagerPreferences.this.getSelectedPlatform();
                return p != null ? p.newManagerURI("") : null;
            }
        });
        this.uriTable.setRestartRequired(false);
        this.uriTable.addEditButtons(13);
        this.uriTable.addSelectionEnabledButton(new UIButton(DEP_URIS_SET_DEFAULT, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeployManagerPreferences.this.setDefaultManagerURI();
            }
        }));
        this.uriTable.setClearWhenDisabled(true);
        this.getGBConstraints().insets.top = 5;
        this.addWithGBConstraints(this.uriTable);
    }

    private DeploymentPlatform getSelectedPlatform() {
        return (DeploymentPlatform)this.platformName.getSelectedItem();
    }

    private void showDeploymentManagerURIs(DeploymentPlatform dp) {
        this.uriTable.clearSelection();
        this.uriTable.setConfigData(dp != null ? dp.getManagerURIList() : null);
    }

    private void setDefaultManagerURI() {
        DeploymentPlatform dp = this.getSelectedPlatform();
        DeploymentPlatform.ManagerURI mu = (DeploymentPlatform.ManagerURI)this.uriTable.getSelectedRowObject();
        if (dp != null && mu != null) {
            dp.setDefaultURI(mu.getURI());
            this.showDeploymentManagerURIs(dp);
            this.uriTable.selectRowWithValue(0, mu.getURI());
        }
    }

    public void refreshConfig() {
        this.platformName.setModel(DeploymentPlatform.getPlatforms());
        this.uriTable.setEnabled(this.getSelectedPlatform() != null);
        this.showDeploymentManagerURIs(this.getSelectedPlatform());
    }

    public boolean commitConfig() {
        DeploymentPlatform.setPlatforms(ListTools.toList(this.platformName.getModel()));
        DT.getServerManager().fireServerChangedNotification(null);
        return false;
    }
}

