/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.common.dd.ejb.Cmp;
import com.sun.enterprise.tools.common.dd.ejb.Ejb;
import com.sun.enterprise.tools.common.dd.ejb.MethodParams;
import com.sun.enterprise.tools.common.dd.ejb.PrefetchDisabled;
import com.sun.enterprise.tools.common.dd.ejb.QueryMethod;
import com.sun.enterprise.tools.deployment.ui.ejb.MethodUtil;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FinderSelectDialog {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(FinderSelectDialog.class);
    private static final String FIND_SELECT_METHODS = localStrings.getLocalString("ui.finderselectdialog.dialog_title", "Finder/Select Methods");
    private static final String IMPL_QUERIES = localStrings.getLocalString("ui.finderselectdialog.ejb_ql_queries_title", "EJB-QL Queries for Finder/Select Methods");
    private static final String SHOW_LABEL = localStrings.getLocalString("ui.finderselectdialog.show_label", "Show:");
    private static final String SHOW_FINDERS_ACC_DSC = localStrings.getLocalString("at.finderselectdialog.show_finders.acc_dsc", "Choose Local or Remote Finder methods or Select methods");
    private static final String SHOW_FINDERS = localStrings.getLocalString("ui.finderselectdialog.show_finders", "Finders");
    private static final String SHOW_SELECT_METHODS = localStrings.getLocalString("ui.finderselectdialog.show_select_methods", "Select Methods");
    private static final String FINDER_QUERY = localStrings.getLocalString("ui.finderselectdialog.ejbql_query", "EJB-QL Query");
    private static final String FINDER_QUERY_TOOLTIP = localStrings.getLocalString("at.finderselectdialog.ejbql_query.tooltip", "Specify EJB-QL Query for selected method");
    private static final String RETURN_TYPE = localStrings.getLocalString("ui.finderselectdialog.return.type", "Return EJBs Of Type:");
    private static final String RETURN_TYPE_TOOLTIP = localStrings.getLocalString("at.finderselectdialog.return.type.tooltip", "Choose return type of EJB's.");
    private static final String RETURN_LOCAL = localStrings.getLocalString("ui.finderselectdialog.return.local", "Local");
    private static final String RETURN_REMOTE = localStrings.getLocalString("ui.finderselectdialog.return.remote", "Remote");
    private static final String RETURN_NONE = localStrings.getLocalString("ui.finderselectdialog.return.none", "None");
    private static final String FINDER_TABLE_METHOD = localStrings.getLocalString("ui.finderselectdialog.findertablemethod", "<HTML><br>Method</HTML>");
    private static final String FINDER_TABLE_PREFETCH = localStrings.getLocalString("ui.finderselectdialog.findertableprefetch", "<HTML>&nbsp;Prefetch Disabled<br>&nbsp;(Sun-specific)</HTML>");
    private static final String METHOD_FIND = "find";
    private static final String METHOD_EJB_SELECT = "ejbSelect";
    private static final String METHOD_FindBPK = "findByPrimaryKey";
    private static final String helpID = "FinderSelectMethods";
    private static Object[] FINDER_OPTIONS = new Object[]{SHOW_FINDERS, SHOW_SELECT_METHODS};
    private UITitledComboBox showFinders = null;
    private DescriptionInspector.DescriptionManagerDialog finderSelectDialog = null;
    private FinderSelectTable finderTable = null;
    private UITitledTextArea finderQueryText = null;
    private UITitledComboBox rtnTypeCB = null;
    private EjbCMPEntityDescriptor descriptor = null;
    private PersistenceDescriptor persDescriptor = null;
    private Map mdOrigMap = null;
    private Map qdOrigMap = null;
    private Ejb ejb = null;
    private Cmp cmp = null;
    private PrefetchDisabled prefetch = null;
    private Set mdSet = null;
    private boolean descriptorChanged = false;
    private HashMap mdMap = null;
    private QueryMethod[] methodArray = null;
    private MethodParams params = null;

    private static String FIND_SELECT_METHODS_FOR(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.dialog_title_for", "Finder/Select Methods for {0}", new Object[]{v0});
    }

    private static final String FINDER_QUERY_FOR(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.ejbql_query_for", "EJB-QL Query for {0}", new Object[]{v0});
    }

    private static String ERROR_GETTING_QUERY_METHODS(String v0) {
        return localStrings.getLocalString("ui.finderselectdialog.error_getting_query_methods", "Error encountered while trying to obtain query methods\n {0}", new Object[]{v0});
    }

    public FinderSelectDialog(Component owner) {
        this.finderSelectDialog = DescriptionInspector.DescriptionManagerDialog.newDialog(owner);
        this.finderSelectDialog.setModal(true);
        this.finderSelectDialog.doNothingOnClose();
        this.finderSelectDialog.setContentPane(this.getFinderSelectPane());
        this.finderSelectDialog.setSize(800, 430);
        this.finderSelectDialog.setLocationRelativeToOwner(20, 20);
    }

    private JPanel getFinderSelectPane() {
        UIControlButtonBox panel = new UIControlButtonBox(null, false);
        panel.setControlButtonLocation(101);
        UITitledBox viewBox = new UITitledBox(IMPL_QUERIES, true);
        panel.setView(viewBox);
        GridBagConstraints c = viewBox.getGBConstraintsCopy();
        this.showFinders = new UITitledComboBox(SHOW_LABEL, false);
        this.showFinders.getAccessibleContext().setAccessibleDescription(SHOW_FINDERS_ACC_DSC);
        this.showFinders.setModel(FINDER_OPTIONS);
        this.showFinders.setClearWhenDisabled(true);
        this.showFinders.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FinderSelectDialog.this.refreshDialog();
            }
        });
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 0;
        c.anchor = 17;
        viewBox.add((Component)this.showFinders, c);
        UITitledTable tablePanel = new UITitledTable(null, false);
        this.finderTable = new FinderSelectTable(new FinderSelectTableModel());
        this.finderTable.setMinimumSize(new Dimension(150, 150));
        this.finderTable.getSelectionModel().addListSelectionListener(new FinderSelectionListener());
        tablePanel.setTableView(this.finderTable);
        c.weightx = 0.7;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 0);
        c.fill = 1;
        c.anchor = 10;
        viewBox.add((Component)tablePanel, c);
        UITitledBox queryBox = new UITitledBox(null, false);
        c.weightx = 0.3;
        c.weighty = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        viewBox.add((Component)queryBox, c);
        this.finderQueryText = new UITitledTextArea(FINDER_QUERY, false);
        this.finderQueryText.setToolTipText(FINDER_QUERY_TOOLTIP);
        this.finderQueryText.setClearWhenDisabled(true);
        this.finderQueryText.setEnabled(false);
        this.finderQueryText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                MethodDescriptor md = (MethodDescriptor)FinderSelectDialog.this.finderTable.getSelectedRowObject();
                QueryDescriptor qd = FinderSelectDialog.this.persDescriptor.getQueryFor(md);
                if (qd == null) {
                    qd = new QueryDescriptor();
                    qd.setQueryMethodDescriptor(md);
                    FinderSelectDialog.this.persDescriptor.setQueryFor(md, qd);
                }
                qd.setQuery(FinderSelectDialog.this.finderQueryText.getText());
                FinderSelectDialog.this.descriptorChanged = true;
            }
        });
        queryBox.addWithGBConstraints(this.finderQueryText);
        this.rtnTypeCB = new UITitledComboBox(RETURN_TYPE, false);
        this.rtnTypeCB.setToolTipText(RETURN_TYPE_TOOLTIP);
        this.rtnTypeCB.setClearWhenDisabled(true);
        this.rtnTypeCB.setEnabled(false);
        this.rtnTypeCB.setModel(new String[]{RETURN_LOCAL, RETURN_REMOTE, RETURN_NONE});
        this.rtnTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MethodDescriptor md = (MethodDescriptor)FinderSelectDialog.this.finderTable.getSelectedRowObject();
                QueryDescriptor qd = FinderSelectDialog.this.persDescriptor.getQueryFor(md);
                if (qd == null) {
                    qd = new QueryDescriptor();
                    qd.setQueryMethodDescriptor(md);
                    FinderSelectDialog.this.persDescriptor.setQueryFor(md, qd);
                }
                if (FinderSelectDialog.this.showFinders.getSelectedItem().equals(SHOW_FINDERS)) {
                    qd.setHasNoReturnTypeMapping();
                } else if (FinderSelectDialog.this.rtnTypeCB.getText().equals(RETURN_LOCAL)) {
                    qd.setHasLocalReturnTypeMapping();
                } else if (FinderSelectDialog.this.rtnTypeCB.getText().equals(RETURN_REMOTE)) {
                    qd.setHasRemoteReturnTypeMapping();
                } else {
                    qd.setHasNoReturnTypeMapping();
                }
                FinderSelectDialog.this.descriptorChanged = true;
            }
        });
        GridBagConstraints gbc = queryBox.getGBConstraintsCopy();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.fill = 2;
        queryBox.add((Component)this.rtnTypeCB, gbc);
        UIButton okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FinderSelectDialog.this.okAction();
            }
        });
        panel.addControlButton(okBtn);
        UIButton cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FinderSelectDialog.this.cancelAction();
            }
        });
        panel.addControlButton(cancelBtn);
        panel.addControlButton(new UIHelpButton(helpID));
        return panel;
    }

    private void refreshDialog() {
        Object o;
        this.finderTable.clearTableData();
        this.finderTable.updateTableData(this.getMethodsForSelType());
        this.finderTable.clearSelection();
        this.finderQueryText.setEnabled(false);
        this.rtnTypeCB.setEnabled(false);
        if (this.finderTable.getRowCount() > 0 && (o = this.finderTable.getSelectedRowObject()) == null) {
            this.finderTable.setSelectedIndex(0);
        }
    }

    private Set getMethodsForSelType() {
        String selIntf = (String)this.showFinders.getSelectedItem();
        Set set = null;
        if (selIntf == null) {
            if (!this.getFinders().isEmpty()) {
                this.showFinders.setSelectedItem(SHOW_FINDERS);
            } else if (!this.getSelectMethods().isEmpty()) {
                this.showFinders.setSelectedItem(SHOW_SELECT_METHODS);
            }
            selIntf = (String)this.showFinders.getSelectedItem();
        }
        if (selIntf.equals(SHOW_FINDERS)) {
            set = this.getFinders();
        } else if (selIntf.equals(SHOW_SELECT_METHODS)) {
            set = this.getSelectMethods();
        }
        return set;
    }

    private Set getFinders() {
        HashSet<MethodDescriptor> finderSet = new HashSet<MethodDescriptor>();
        Iterator iter = this.mdSet.iterator();
        while (iter.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)iter.next();
            if (!md.getName().startsWith(METHOD_FIND)) continue;
            finderSet.add(md);
        }
        return finderSet;
    }

    private Set getSelectMethods() {
        HashSet<MethodDescriptor> selectSet = new HashSet<MethodDescriptor>();
        Iterator iter = this.mdSet.iterator();
        while (iter.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)iter.next();
            if (!md.getName().startsWith(METHOD_EJB_SELECT)) continue;
            selectSet.add(md);
        }
        return selectSet;
    }

    public void setDescriptor(Object d) {
        this.descriptor = (EjbCMPEntityDescriptor)d;
        this.setSunDescriptor(this.descriptor);
        this.persDescriptor = this.descriptor.getPersistenceDescriptor();
        this.mdSet = this.filterDuplicateFinders(this.persDescriptor.getAllPossibleQueriedMethods());
        this.initMethods(this.mdSet, this.methodArray);
        this.copyOriginalDescriptor(this.mdSet);
        this.descriptorChanged = false;
        this.finderSelectDialog.setTitle(FinderSelectDialog.FIND_SELECT_METHODS_FOR(this.descriptor.getDisplayName()));
    }

    private void setSunDescriptor(EjbCMPEntityDescriptor d) {
        this.ejb = (Ejb)SunOneUtils.getSunDescriptor((Descriptor)d);
        this.cmp = this.ejb.getCmp();
        this.prefetch = this.cmp != null ? this.cmp.getPrefetchDisabled() : null;
        this.methodArray = this.prefetch != null ? this.prefetch.getQueryMethod() : null;
    }

    private void copyOriginalDescriptor(Set mdSet) {
        this.mdOrigMap = new HashMap();
        this.qdOrigMap = new HashMap();
        Iterator iter = mdSet.iterator();
        while (iter.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)iter.next();
            MethodDescriptor mdOrig = new MethodDescriptor();
            mdOrig.setEjbName(md.getEjbName());
            mdOrig.setEjbClassSymbol(md.getEjbClassSymbol());
            mdOrig.setName(md.getName());
            mdOrig.setDescription(md.getDescription());
            String[] params = md.getParameterClassNames();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    mdOrig.addParameterClass(params[i]);
                }
            }
            this.mdOrigMap.put(mdOrig, this.getBooleanValue(md));
            QueryDescriptor qd = this.persDescriptor.getQueryFor(md);
            if (qd == null) continue;
            QueryDescriptor qdOrig = new QueryDescriptor();
            qdOrig.setQueryMethodDescriptor(md);
            qdOrig.setQuery(qd.getQuery());
            if (qd.getHasLocalReturnTypeMapping()) {
                qdOrig.setHasLocalReturnTypeMapping();
            } else if (qd.getHasNoReturnTypeMapping()) {
                qdOrig.setHasNoReturnTypeMapping();
            } else if (qd.getHasRemoteReturnTypeMapping()) {
                qdOrig.setHasRemoteReturnTypeMapping();
            }
            qdOrig.setDescription(qd.getDescription());
            this.qdOrigMap.put(md, qdOrig);
        }
    }

    public void show() {
        this.refreshDialog();
        this.finderSelectDialog.show();
    }

    private void okAction() {
        if (this.descriptorChanged) {
            this.descriptor.changed();
        }
        this.finderSelectDialog.hide();
    }

    private void cancelAction() {
        this.revertToOriginalQueryDescriptors();
        this.revertToOriginalPrefetchDisabledMethods();
        this.finderSelectDialog.hide();
    }

    private void revertToOriginalQueryDescriptors() {
        Iterator mdIter = this.mdSet.iterator();
        while (mdIter.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)mdIter.next();
            QueryDescriptor qd = this.persDescriptor.getQueryFor(md);
            QueryDescriptor qdOrig = (QueryDescriptor)this.qdOrigMap.get(md);
            if (qdOrig == null) {
                this.persDescriptor.removeQueryFor(md);
                continue;
            }
            if (qd == null) {
                qd = new QueryDescriptor();
                qd.setQueryMethodDescriptor(md);
                this.persDescriptor.setQueryFor(md, qd);
            }
            qd.setQuery(qdOrig.getQuery());
            if (qdOrig.getHasLocalReturnTypeMapping()) {
                qd.setHasLocalReturnTypeMapping();
            } else if (qdOrig.getHasNoReturnTypeMapping()) {
                qd.setHasNoReturnTypeMapping();
            } else if (qdOrig.getHasRemoteReturnTypeMapping()) {
                qd.setHasRemoteReturnTypeMapping();
            }
            qd.setDescription(qdOrig.getDescription());
        }
    }

    private void revertToOriginalPrefetchDisabledMethods() {
        this.writeMethods(this.mdOrigMap);
    }

    private Set filterDuplicateFinders(Set mdSet) {
        HashMap<String, MethodDescriptor> filteredMap = new HashMap<String, MethodDescriptor>();
        Iterator iter = mdSet.iterator();
        while (iter.hasNext()) {
            MethodDescriptor md = (MethodDescriptor)iter.next();
            String formattedName = md.getFormattedString();
            filteredMap.put(formattedName, md);
        }
        return new HashSet(filteredMap.values());
    }

    private void initMethods(Set mdSet, QueryMethod[] methodArray) {
        this.buildMaps(mdSet);
        if (methodArray != null && methodArray.length > 0 && mdSet != null) {
            Iterator iter = mdSet.iterator();
            while (iter.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)iter.next();
                String mdName = md.getName();
                String[] mdParam = md.getJavaParameterClassNames();
                for (int i = 0; i < methodArray.length; ++i) {
                    String name = methodArray[i].getMethodName();
                    MethodParams params = methodArray[i].getMethodParams();
                    String[] param = null;
                    if (params != null) {
                        param = params.getMethodParam();
                    }
                    if (!name.equals(mdName)) continue;
                    if (!(mdParam != null && mdParam.length != 0 || param != null && param.length != 0)) {
                        this.mdMap.put(md, Boolean.TRUE);
                        continue;
                    }
                    if (param == null || mdParam == null || param.length != mdParam.length) continue;
                    boolean match = true;
                    for (int j = 0; j < param.length; ++j) {
                        if (param[j].equals(mdParam[j])) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    this.mdMap.put(md, Boolean.TRUE);
                }
            }
        }
    }

    private void buildMaps(Set mdSet) {
        this.mdMap = new HashMap();
        if (mdSet != null) {
            Iterator iter = mdSet.iterator();
            while (iter.hasNext()) {
                MethodDescriptor md = (MethodDescriptor)iter.next();
                this.mdMap.put(md, Boolean.FALSE);
            }
        }
    }

    private Boolean getBooleanValue(MethodDescriptor md) {
        Boolean b = null;
        if (md != null) {
            b = (Boolean)this.mdMap.get(md);
        }
        return b;
    }

    private void updateMethods(MethodDescriptor md, Boolean val) {
        if (md != null && val != null) {
            this.mdMap.put(md, val);
            this.writeMethods(this.mdMap);
        }
    }

    private void writeMethods(Map mdMap) {
        this.clearMethod();
        Set set = mdMap.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            MethodDescriptor k = (MethodDescriptor)me.getKey();
            String mdName = k.getName();
            String[] mdParam = k.getJavaParameterClassNames();
            Boolean v = (Boolean)me.getValue();
            if (v != Boolean.TRUE) continue;
            QueryMethod qm = null;
            qm = MethodUtil.createQueryMethod(mdName, mdParam);
            this.addMethod(qm);
        }
    }

    private void addMethod(QueryMethod m) {
        if (this.prefetch == null) {
            this.prefetch = new PrefetchDisabled();
            if (this.cmp == null) {
                this.cmp = new Cmp();
                this.ejb.setCmp(this.cmp);
            }
            this.cmp.setPrefetchDisabled(this.prefetch);
        }
        this.prefetch.addQueryMethod(m);
    }

    private void clearMethod() {
        this.prefetch = null;
        if (this.cmp != null) {
            this.cmp.setPrefetchDisabled(this.prefetch);
            if (this.cmp.getIsOneOneCmp() == null && this.cmp.getMappingProperties() == null && this.cmp.getOneOneFinders() == null) {
                this.cmp = null;
                this.ejb.setCmp(this.cmp);
            }
        } else {
            this.ejb.setCmp(this.cmp);
        }
    }

    private class FinderSelectTableModel
    extends InspectorTableModel {
        public FinderSelectTableModel() {
            super(new String[]{FINDER_TABLE_METHOD, FINDER_TABLE_PREFETCH, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
            this.setDataOrdering(1);
        }

        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            QueryDescriptor qd = FinderSelectDialog.this.persDescriptor.getQueryFor(md);
            Object value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    value = FinderSelectDialog.this.getBooleanValue(md);
                    break;
                }
                case 2: {
                    if (qd == null) break;
                    value = qd.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            QueryDescriptor qd = FinderSelectDialog.this.persDescriptor.getQueryFor(md);
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    FinderSelectDialog.this.updateMethods(md, (Boolean)value);
                    FinderSelectDialog.this.descriptorChanged = true;
                    break;
                }
                case 2: {
                    String desc = (String)value;
                    if (qd == null) {
                        qd = new QueryDescriptor();
                        qd.setQueryMethodDescriptor(md);
                        FinderSelectDialog.this.persDescriptor.setQueryFor(md, qd);
                    }
                    qd.setDescription(desc);
                    FinderSelectDialog.this.descriptorChanged = true;
                }
            }
        }
    }

    private class FinderSelectTable
    extends InspectorTable {
        public FinderSelectTable(FinderSelectTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            this.adjustColumnWidth(1, false);
        }
    }

    private class FinderSelectionListener
    implements ListSelectionListener {
        private FinderSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MethodDescriptor md = (MethodDescriptor)FinderSelectDialog.this.finderTable.getSelectedRowObject();
            QueryDescriptor qd = null;
            MethodDescriptor qmd = null;
            if (md != null) {
                qd = FinderSelectDialog.this.persDescriptor.getQueryFor(md);
            }
            if (qd != null) {
                qmd = qd.getQueryMethodDescriptor();
            }
            if (qd == null || qmd == null) {
                if (md != null) {
                    FinderSelectDialog.this.finderQueryText.setTitle(FinderSelectDialog.FINDER_QUERY_FOR(md.getName()));
                } else {
                    FinderSelectDialog.this.finderQueryText.setTitle(FINDER_QUERY);
                }
                FinderSelectDialog.this.finderQueryText.setText("");
                FinderSelectDialog.this.finderQueryText.setEnabled(true);
                if (FinderSelectDialog.this.showFinders.getSelectedItem().equals(SHOW_SELECT_METHODS)) {
                    FinderSelectDialog.this.rtnTypeCB.setSelectedItem(RETURN_LOCAL);
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(true);
                } else {
                    FinderSelectDialog.this.rtnTypeCB.setSelectedItem(null);
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(false);
                }
            } else {
                String qmn = qmd.getName();
                FinderSelectDialog.this.finderQueryText.setTitle(FinderSelectDialog.FINDER_QUERY_FOR(qmn));
                FinderSelectDialog.this.finderQueryText.setText(qd.getQuery());
                FinderSelectDialog.this.finderQueryText.setEnabled(true);
                if (FinderSelectDialog.this.showFinders.getSelectedItem().equals(SHOW_SELECT_METHODS)) {
                    if (qd.getHasLocalReturnTypeMapping()) {
                        FinderSelectDialog.this.rtnTypeCB.setSelectedItem(RETURN_LOCAL);
                    } else if (qd.getHasRemoteReturnTypeMapping()) {
                        FinderSelectDialog.this.rtnTypeCB.setSelectedItem(RETURN_REMOTE);
                    } else {
                        FinderSelectDialog.this.rtnTypeCB.setSelectedItem(RETURN_NONE);
                    }
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(true);
                } else {
                    FinderSelectDialog.this.rtnTypeCB.setSelectedItem(null);
                    FinderSelectDialog.this.rtnTypeCB.setEnabled(false);
                }
            }
        }
    }
}

