/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.table.TableCellEditor;

public class EjbTransactionInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EjbTransactionInspector.class);
    private static final String XACTION_MGMT = localStrings.getLocalString("ui.ejbtransactioninspector.box_title", "Transaction Management Settings");
    private static final String XACTION_MGMT_ACC_DSC = localStrings.getLocalString("at.ejbtransactioninspector.box_title.acc_dsc", "Choose type of Transaction Management");
    private static final String BEAN_MGT_XACTIONS = localStrings.getLocalString("ui.ejbtransactioninspector.bean_managed", "Bean-Managed");
    private static final String CONT_MGT_XACTIONS = localStrings.getLocalString("ui.ejbtransactioninspector.container_managed", "Container-Managed");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.ejbtransactioninspector.show_interface", "Show:");
    private static final String SHOW_INTERFACES_ACC_DSC = localStrings.getLocalString("at.ejbtransactioninspector.show_interface.acc_dsc", "Choose interfaces to expose");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.ejbtransactioninspector.local", "Local");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.ejbtransactioninspector.local_home", "Local Home");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.ejbtransactioninspector.remote", "Remote");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.ejbtransactioninspector.remote_home", "Remote Home");
    private static final String SHOW_BEAN_IMPL = localStrings.getLocalString("ui.ejbtransactioninspector.bean_impl", "Bean");
    private static final String SHOW_SERVICE_ENDPOINT = localStrings.getLocalString("ui.ejbtransactioninspector.service_endpoint", "Service Endpoint");
    private static final String TRANS_NOT_SUPPORTED = localStrings.getLocalString("ui.ejbtransactioninspector.trans.not_supported", "Not Supported");
    private static final String TRANS_SUPPORTS = localStrings.getLocalString("ui.ejbtransactioninspector.trans.supports", "Supports");
    private static final String TRANS_REQUIRED = localStrings.getLocalString("ui.ejbtransactioninspector.trans.required", "Required");
    private static final String TRANS_REQUIRES_NEW = localStrings.getLocalString("ui.ejbtransactioninspector.trans.requires_new", "Requires New");
    private static final String TRANS_MANDATORY = localStrings.getLocalString("ui.ejbtransactioninspector.trans.mandatory", "Mandatory");
    private static final String TRANS_NEVER = localStrings.getLocalString("ui.ejbtransactioninspector.trans.never", "Never");
    private static String[] COLUMN_LABELS = new String[]{localStrings.getLocalString("ui.ejbtransactioninspector.cmt_table.method", "Method"), localStrings.getLocalString("ui.ejbtransactioninspector.cmt_table.attribute", "Transaction Attribute"), DescriptionInspector.DESCRIPTION_COLUMN_INIT};
    private static String TABNAME = localStrings.getLocalString("ui.ejbtransactioninspector.tabname", "Transactions");
    private static String wizardHelpID = "Transaction";
    private static String deployHelpID = "Transaction";
    private boolean isSessionBean = false;
    private boolean isMessageBean = false;
    private EjbDescriptor descriptor = null;
    private static String[] EJB_METH_TYPE = new String[]{MethodDescriptor.EJB_LOCAL, MethodDescriptor.EJB_LOCALHOME, MethodDescriptor.EJB_REMOTE, MethodDescriptor.EJB_HOME, MethodDescriptor.EJB_BEAN, MethodDescriptor.EJB_WEB_SERVICE};
    private static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME, SHOW_BEAN_IMPL, SHOW_SERVICE_ENDPOINT};
    private UIRadioButtonBox showInterfaces = null;
    private static String[] ContainerTransaction_TYPES = new String[]{ContainerTransaction.NOT_SUPPORTED, ContainerTransaction.SUPPORTS, ContainerTransaction.REQUIRED, ContainerTransaction.REQUIRES_NEW, ContainerTransaction.MANDATORY, ContainerTransaction.NEVER};
    private static String[] TRANS_ATTR_OPTIONS = new String[]{TRANS_NOT_SUPPORTED, TRANS_SUPPORTS, TRANS_REQUIRED, TRANS_REQUIRES_NEW, TRANS_MANDATORY, TRANS_NEVER};
    private Vector transAttrs = null;
    private UIRadioButtonBox xactionMgmtBox = null;
    private UITitledTable transTableBox = null;
    private TransactionTable transactionTable = null;
    private boolean refresh_disable = false;
    private HashMap containerTrans = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new EjbTransactionInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return EjbDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof EjbDescriptor ? (EjbDescriptor)desc : null;
            this.transactionTable.clearTableData();
            this.containerTrans = null;
            this.isSessionBean = this.descriptor instanceof EjbSessionDescriptor;
            this.isMessageBean = this.descriptor instanceof EjbMessageBeanDescriptor;
        }
    }

    private EjbTransactionInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeWidgets();
    }

    private void initializeWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        CSH.setHelpIDString((Component)this, (String)"EJB_Transactions_Inspector_Tab");
        this.xactionMgmtBox = new UIRadioButtonBox(XACTION_MGMT, true);
        this.xactionMgmtBox.getAccessibleContext().setAccessibleDescription(XACTION_MGMT_ACC_DSC);
        this.xactionMgmtBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbTransactionInspector.this._xactionMgmtChangedAction();
            }
        });
        this.xactionMgmtBox.addItem(BEAN_MGT_XACTIONS);
        this.xactionMgmtBox.addItem(CONT_MGT_XACTIONS);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)this.xactionMgmtBox, c);
        UITitledBox CMTBox = new UITitledBox(null, true);
        GridBagConstraints gbc = this.xactionMgmtBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        this.xactionMgmtBox.add((Component)CMTBox, gbc);
        this.xactionMgmtBox.addSelectionEnabledComponent(CMTBox, CONT_MGT_XACTIONS);
        this.showInterfaces = new UIRadioButtonBox(SHOW_INTERFACES, false);
        this.showInterfaces.getAccessibleContext().setAccessibleDescription(SHOW_INTERFACES_ACC_DSC);
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EjbTransactionInspector.this.invokeRefresh();
            }
        });
        gbc = CMTBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        CMTBox.add((Component)this.showInterfaces, gbc);
        this.transTableBox = new UITitledTable(null, false);
        this.transactionTable = new TransactionTable(new TransactionTableModel());
        this.transactionTable.setContainTransactionsEditable(true);
        this.transTableBox.setTableView(this.transactionTable);
        gbc = CMTBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        CMTBox.add((Component)this.transTableBox, gbc);
    }

    public void refresh() {
        if (this.refresh_disable) {
            return;
        }
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
            this.xactionMgmtBox.setSelectedItem(CONT_MGT_XACTIONS);
        } else {
            this.xactionMgmtBox.setSelectedItem(BEAN_MGT_XACTIONS);
        }
        this.xactionMgmtBox.setReadOnly(this.isReadOnly() || !this.isMessageBean && !this.isSessionBean);
        this.showInterfaces.setVisible(!this.isMessageBean);
        if (this.descriptor.getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE)) {
            this.transactionTable.clearTableData();
        } else {
            String methType = null;
            if (this.isMessageBean) {
                this.showInterfaces.setItemEnabled(SHOW_LOCAL, false);
                this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, false);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE, false);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, false);
                this.showInterfaces.setItemEnabled(SHOW_SERVICE_ENDPOINT, false);
                methType = MethodDescriptor.EJB_BEAN;
            } else {
                this.showInterfaces.setItemEnabled(SHOW_LOCAL, this.descriptor.getLocalClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, this.descriptor.getLocalHomeClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE, this.descriptor.getRemoteClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, this.descriptor.getHomeClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_SERVICE_ENDPOINT, this.descriptor.hasWebServiceEndpointInterface());
                int mtNdx = this.showInterfaces.getSelectedIndex();
                String string = methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : null;
                if (methType == null) {
                    if (this.descriptor.getLocalClassName() != null) {
                        this.showInterfaces.setSelectedItem(SHOW_LOCAL);
                    } else if (this.descriptor.getRemoteClassName() != null) {
                        this.showInterfaces.setSelectedItem(SHOW_REMOTE);
                    }
                    mtNdx = this.showInterfaces.getSelectedIndex();
                    methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : "";
                }
            }
            Vector methods = new Vector();
            try {
                BundleDescriptor bd = DescriptorTools.getBundleDescriptor((Descriptor)this.descriptor);
                ModuleArchive modArch = ModuleArchive.getModuleArchive((Descriptor)bd);
                bd.setClassLoader(modArch.getClassLoader());
                methods.addAll(this.descriptor.getTransactionMethodDescriptors());
            }
            catch (Throwable e) {
                this.refresh_disable = true;
                Print.dprintStackTrace((String)"==> getTransactionMethodDescriptors()", (Throwable)e);
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.ejbtransactioninspector.problemgettingmethods", "Error obtaining the list of methods on {0}\n{1}\n", new Object[]{this.descriptor.getDisplayName(), e.getMessage()}));
                this.refresh_disable = false;
                return;
            }
            this.transAttrs = this.descriptor.getPossibleTransactionAttributes();
            Vector<MethodDescriptor> vdata = new Vector<MethodDescriptor>();
            Enumeration e = methods.elements();
            while (e.hasMoreElements()) {
                ContainerTransaction ct;
                MethodDescriptor md = (MethodDescriptor)e.nextElement();
                if (md.getEjbClassSymbol().equals(methType)) {
                    vdata.add(md);
                }
                if (!this.isDevelopmentMode() || !this.descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE) || (ct = (ContainerTransaction)this.descriptor.getMethodContainerTransactions().get(md)) != null) continue;
                ct = new ContainerTransaction(ContainerTransaction.REQUIRED, "");
                this.descriptor.getMethodContainerTransactions().put(md, ct);
            }
            this.transactionTable.clearTableData();
            this.transactionTable.updateTableData(vdata);
        }
    }

    public void setReadOnly(boolean state) {
        super.setReadOnly(state);
        this.xactionMgmtBox.setReadOnly(state || !this.isMessageBean && !this.isSessionBean);
        if (this.showInterfaces.isVisible()) {
            this.showInterfaces.setReadOnly(state);
        }
        this.transTableBox.setReadOnly(state);
    }

    public void _xactionMgmtChangedAction() {
        String item = (String)this.xactionMgmtBox.getSelectedItem();
        if (item.equals(BEAN_MGT_XACTIONS)) {
            this.descriptor.setTransactionType(EjbDescriptor.BEAN_TRANSACTION_TYPE);
        } else {
            this.descriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
        }
        this.invokeRefresh();
    }

    private ContainerTransaction _getContainerTransactionFor(MethodDescriptor md) {
        if (this.containerTrans == null) {
            this.containerTrans = new HashMap();
        }
        if (this.containerTrans.containsKey(md)) {
            return (ContainerTransaction)this.containerTrans.get(md);
        }
        ContainerTransaction ct = this.descriptor.getContainerTransactionFor(md);
        this.containerTrans.put(md, ct);
        return ct;
    }

    private void _setContainerTransactionFor(MethodDescriptor md, ContainerTransaction ct) {
        if (this.containerTrans == null) {
            this.containerTrans = new HashMap();
        }
        try {
            this.descriptor.setContainerTransactionFor(md, ct);
            this.containerTrans.put(md, ct);
        }
        catch (Throwable t) {
            Print.printStackTrace((String)"ContainerTransaction not allowed", (Throwable)t);
        }
    }

    private class TransactionTableModel
    extends InspectorTableModel {
        private boolean editable;

        public TransactionTableModel() {
            super(COLUMN_LABELS);
            this.editable = true;
            this.setDataOrdering(1);
        }

        public void setContainTransactionsEditable(boolean state) {
            this.editable = state;
        }

        public boolean isCellEditable(int row, int col) {
            if (this.isReadOnly()) {
                return false;
            }
            return col <= 0 ? false : this.editable;
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            ContainerTransaction ct = null;
            String value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    ct = EjbTransactionInspector.this._getContainerTransactionFor(md);
                    value = ct != null ? this._Type2Display(ct.getTransactionAttribute()) : this._Type2Display(ContainerTransaction.REQUIRED);
                    break;
                }
                case 2: {
                    ct = EjbTransactionInspector.this._getContainerTransactionFor(md);
                    value = ct != null ? ct.getDescription() : "";
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            ContainerTransaction ct = null;
            ContainerTransaction newCt = null;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    ct = EjbTransactionInspector.this._getContainerTransactionFor(md);
                    newCt = new ContainerTransaction(this._Display2Type((String)value), ct != null ? ct.getDescription() : "");
                    EjbTransactionInspector.this._setContainerTransactionFor(md, newCt);
                    break;
                }
                case 2: {
                    ct = EjbTransactionInspector.this._getContainerTransactionFor(md);
                    if (ct == null) {
                        newCt = new ContainerTransaction(ContainerTransaction.REQUIRED, (String)value);
                        EjbTransactionInspector.this._setContainerTransactionFor(md, newCt);
                        break;
                    }
                    ct.setDescription((String)value);
                }
            }
        }

        public String _Display2Type(String s) {
            for (int i = 0; i < TRANS_ATTR_OPTIONS.length; ++i) {
                if (!TRANS_ATTR_OPTIONS[i].equals(s)) continue;
                return ContainerTransaction_TYPES[i];
            }
            Print.dprintStackTrace((String)("Display type not found: " + s));
            return s;
        }

        public String _Type2Display(String s) {
            for (int i = 0; i < ContainerTransaction_TYPES.length; ++i) {
                if (!ContainerTransaction_TYPES[i].equals(s)) continue;
                return TRANS_ATTR_OPTIONS[i];
            }
            Print.dprintStackTrace((String)("Trans type not found: " + s));
            return s;
        }
    }

    private class TransactionTable
    extends InspectorTable {
        public TransactionTable(TransactionTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 1) {
                Vector<String> cbModel = new Vector<String>();
                Vector allAttr = EjbTransactionInspector.this.descriptor.getPossibleTransactionAttributes();
                TransactionTableModel m = (TransactionTableModel)this.getModel();
                if (EjbTransactionInspector.this.isMessageBean) {
                    boolean isEjbTimeout = ((String)this.getValueAt(row, 0)).startsWith("ejbTimeout(");
                    Iterator i = allAttr.iterator();
                    while (i.hasNext()) {
                        ContainerTransaction ct = (ContainerTransaction)i.next();
                        String ta = ct.getTransactionAttribute();
                        if (isEjbTimeout && ta.equals(ContainerTransaction.REQUIRED) || !isEjbTimeout && ta.equals(ContainerTransaction.REQUIRES_NEW)) continue;
                        cbModel.add(m._Type2Display(ta));
                    }
                } else {
                    Iterator i = allAttr.iterator();
                    while (i.hasNext()) {
                        cbModel.add(m._Type2Display(((ContainerTransaction)i.next()).getTransactionAttribute()));
                    }
                }
                return super.getComboBoxEditor(cbModel);
            }
            return super.getCellEditor(row, col);
        }

        public void setContainTransactionsEditable(boolean state) {
            ((TransactionTableModel)this.getModel()).setContainTransactionsEditable(state);
        }
    }
}

