/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.ejb;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIEventQueue;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.tools.deployment.ui.utils.WinTools;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;

public class DeploymentSettingsInspector {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentSettingsInspector.class);
    private static final String INSPECTOR_BUTTON = localStrings.getLocalString("ui.deploymentsettingsinspector.inspector_button", "Sun-specific Settings...");
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsinspector.deployment_settings", "Sun-specific Settings");
    private static final String DB_SETTINGS = localStrings.getLocalString("ui.deploymentsettingsinspector.db_settings", "Database settings");
    private static final String DB_JNDI_NAME = localStrings.getLocalString("ui.deploymentsettingsinspector.db_jndi_name", "Database JNDI Name:");
    private static final String DB_JNDI_NAME_TOOLTIP = localStrings.getLocalString("at.deploymentsettingsinspector.db_jndi_name.tooltip", "Enter value for Database JNDI Name");
    private static final String USER_NAME = localStrings.getLocalString("ui.deploymentsettingsinspector.user_name", "User name:");
    private static final String USER_NAME_TOOLTIP = localStrings.getLocalString("at.deploymentsettingsinspector.user_name.tooltip", "Enter value for User name");
    private static final String PASSWORD = localStrings.getLocalString("ui.deploymentsettingsinspector.password", "Password:");
    private static final String PASSWORD_TOOLTIP = localStrings.getLocalString("at.deploymentsettingsinspector.password.tooltip", "Enter value for Password");
    private static final String GENERATE_SQL = localStrings.getLocalString("ui.deploymentsettingsinspector.generate_sql", "Generate SQL Now");
    private static String helpSetMapID = "DeploymentSettings";

    private DeploymentSettingsInspector() {
    }

    public static class DialogDisplayButton
    extends UIButton
    implements ActionListener {
        private UpdateListener target = null;
        private DeploymentSettingsDialog dialog = null;

        public DialogDisplayButton(UpdateListener target) {
            super(INSPECTOR_BUTTON);
            this.target = target;
            super.setActionCommand("show");
            super.addActionListener(this);
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
            this._getDialog().setUpdateListener(this.target);
        }

        public void setDeploymentSettingsInspector(String dbName, String userName, String passwd) {
            this._getDialog().setModel(dbName, userName, passwd);
        }

        public void actionPerformed(ActionEvent ae) {
            this._getDialog().show();
        }

        private DeploymentSettingsDialog _getDialog() {
            if (this.dialog == null) {
                Window window = WinTools.getAncestorWindow(this);
                this.dialog = window instanceof Dialog ? new DeploymentSettingsDialog((Dialog)window) : new DeploymentSettingsDialog((Frame)window);
                this.dialog.setUpdateListener(this.target);
            }
            return this.dialog;
        }
    }

    private static class DeploymentSettingsDialog
    extends UIDialog {
        private static final String helpSetMapID = "DatabaseSettings";
        private EjbBundleDescriptor descriptor = null;
        private String dbName_cache = null;
        private String userName_cache = null;
        private String userPasswd_cache = null;
        private UITitledTextField dbNameText = null;
        private UITitledTextField userNameText = null;
        private UITitledPasswordField passwdText = null;
        private JButton sqlgenPB = null;
        private boolean sqlGenerated = false;
        private Runnable enableAction = null;
        private boolean buttonEnable_pending = false;
        private JButton okButton = null;
        private final DeploymentSettingsDialog thisDialog = this;
        private UpdateListener target = null;

        public DeploymentSettingsDialog(Frame owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        public DeploymentSettingsDialog(Dialog owner) {
            super(owner, true);
            this.initDialog(owner);
        }

        private void initDialog(Window window) {
            this.setTitle(DEPLOYMENT_SETTINGS);
            this.doNothingOnClose();
            this.setEnableBusyCursor(true);
            UIPanel contentPane = new UIPanel();
            contentPane.setToolTipText(DEPLOYMENT_SETTINGS);
            contentPane.setPreferredSize(new Dimension(580, 400));
            GridBagLayout gridbag = new GridBagLayout();
            contentPane.setLayout(gridbag);
            this.setContentPane(contentPane);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 0.5;
            c.gridx = 0;
            c.gridy = -1;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.insets = new Insets(5, 5, 5, 5);
            UIControlButtonBox upperHalf = new UIControlButtonBox(null, false);
            c.weighty = 0.0;
            c.fill = 2;
            c.anchor = 11;
            contentPane.add((Component)upperHalf, c);
            UITitledBox dbSettingsPane = new UITitledBox(DB_SETTINGS, true);
            GridBagConstraints gbc = dbSettingsPane.getGBConstraints();
            upperHalf.setView(dbSettingsPane);
            gbc.weighty = 0.0;
            gbc.gridx = -1;
            gbc.gridy = 0;
            UITitledBox dbSettingsLeft = new UITitledBox(null, false);
            gbc.weightx = 0.5;
            gbc.fill = 2;
            dbSettingsPane.addWithGBConstraints(dbSettingsLeft);
            UITitledBox dbSettingsRight = new UITitledBox(null, false);
            gbc.weightx = 0.0;
            gbc.fill = 0;
            gbc.anchor = 14;
            gbc.insets.left = 5;
            dbSettingsPane.add((Component)dbSettingsRight, gbc);
            this.enableAction = new Runnable(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    DeploymentSettingsDialog.access$200(this.this$0);
                }
            };
            this.dbNameText = new UITitledTextField(DB_JNDI_NAME, false);
            this.dbNameText.setToolTipText(DB_JNDI_NAME_TOOLTIP);
            this.dbNameText.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void keyTyped(KeyEvent ke) {
                    if (!DeploymentSettingsDialog.access$500(this.this$0)) {
                        DeploymentSettingsDialog.access$502(this.this$0, true);
                        UIEventQueue.invokeLater(DeploymentSettingsDialog.access$600(this.this$0));
                    }
                }
            });
            this.dbNameText.addActionListener(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    if (!DeploymentSettingsDialog.access$500(this.this$0)) {
                        DeploymentSettingsDialog.access$502(this.this$0, true);
                        UIEventQueue.invokeLater(DeploymentSettingsDialog.access$600(this.this$0));
                    }
                }
            });
            dbSettingsLeft.addWithGBConstraints(this.dbNameText);
            this.userNameText = new UITitledTextField(USER_NAME, false);
            this.userNameText.setToolTipText(USER_NAME_TOOLTIP);
            dbSettingsLeft.addWithGBConstraints(this.userNameText);
            this.passwdText = new UITitledPasswordField(PASSWORD, false);
            this.passwdText.setToolTipText(PASSWORD_TOOLTIP);
            dbSettingsLeft.addWithGBConstraints(this.passwdText);
            this.okButton = UIButton.createOkButton(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    DeploymentSettingsDialog.access$1100(this.this$0);
                }
            });
            upperHalf.addControlButton(this.okButton);
            UIButton canPB = UIButton.createCancelButton(new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$0.cancelAction();
                }
            });
            upperHalf.addControlButton(canPB);
            UIHelpButton helpPB = new UIHelpButton(helpSetMapID);
            upperHalf.addControlButton(helpPB);
            this.sqlgenPB = new UIButton(GENERATE_SQL, null, new ActionListener(this){
                private final /* synthetic */ DeploymentSettingsDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    DeploymentSettingsDialog.access$1300(this.this$0);
                }
            });
            upperHalf.addControlButton(this.sqlgenPB);
            Rectangle b = this.getOwner().getBounds();
            b.x += 20;
            b.y += 20;
            b.width = 380;
            b.height = 180;
            this.setBounds(b);
        }

        public void setUpdateListener(UpdateListener target) {
            this.target = target;
        }

        public void show() {
            this.dbNameText.setText(this.dbName_cache);
            this.userNameText.setText(this.userName_cache);
            this.passwdText.setText(this.userPasswd_cache);
            this.enableButtons();
            super.show();
        }

        private void okAction() {
            this.setModel(this.dbNameText.getText(), this.userNameText.getText(), this.passwdText.getText());
            this.target.resourceReferenceUpdated(this.dbName_cache, this.userName_cache, this.userPasswd_cache);
            this.hide();
        }

        protected void cancelAction() {
            this.hide();
        }

        void setModel(String dbName, String user, String passwd) {
            this.dbName_cache = dbName;
            this.userName_cache = user;
            this.userPasswd_cache = passwd;
        }

        private void generateSQL() {
            String dbName = this.dbNameText.getText();
            if (dbName.equals("")) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.no_dbname_specified", "ERROR: No database name specified"));
                return;
            }
            String currentServer = DT.getServerManager().getTargetServer();
            if (currentServer == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.please_connect_to_server", "You must connect to a target server to generate SQL"));
                return;
            }
            try {
                this.sqlGenerated = true;
                this.target.generateSQL(dbName, this.userNameText.getText(), this.passwdText.getText(), this);
                UIOptionPane.showInfoDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.sql_complete", "SQL Generation complete"));
                this.enableButtons();
            }
            catch (Throwable t) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.deploymentsettingsinspector.error_generating_sql", "ERROR: while generating SQL.\n{0}\nPlease make sure the database name/user/password is valid\nand the J2EE server and database are running.", new Object[]{t}));
            }
        }

        private void enableButtons() {
            boolean ok;
            boolean bl = ok = !this.dbNameText.getText().equals("");
            if (ok != this.sqlgenPB.isEnabled()) {
                this.sqlgenPB.setEnabled(ok);
            }
            this.buttonEnable_pending = false;
        }

        static /* synthetic */ void access$200(DeploymentSettingsDialog x0) {
            x0.enableButtons();
        }

        static /* synthetic */ boolean access$500(DeploymentSettingsDialog x0) {
            return x0.buttonEnable_pending;
        }

        static /* synthetic */ boolean access$502(DeploymentSettingsDialog x0, boolean x1) {
            x0.buttonEnable_pending = x1;
            return x0.buttonEnable_pending;
        }

        static /* synthetic */ Runnable access$600(DeploymentSettingsDialog x0) {
            return x0.enableAction;
        }

        static /* synthetic */ void access$1100(DeploymentSettingsDialog x0) {
            x0.okAction();
        }

        static /* synthetic */ void access$1300(DeploymentSettingsDialog x0) {
            x0.generateSQL();
        }
    }

    public static interface UpdateListener {
        public void resourceReferenceUpdated(String var1, String var2, String var3);

        public void generateSQL(String var1, String var2, String var3, JDialog var4) throws Exception;
    }
}

