/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.dtv;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeModel;
import com.sun.enterprise.tools.deployment.ui.dtv.DescriptorTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.FileSystemTreeNode;
import com.sun.enterprise.tools.deployment.ui.dtv.NodeDescriptors;
import com.sun.enterprise.tools.deployment.ui.dtv.UIDescriptorTree;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Print;

public class StandAloneRootTreeNode
extends FileSystemTreeNode {
    public StandAloneRootTreeNode(NodeDescriptors.TreeRootDescriptor desc) {
        super(desc, true);
    }

    public StandAloneRootTreeNode() {
        this(new NodeDescriptors.StandAloneRootDescriptor());
    }

    public void update(DescriptorTreeModel treeModel) {
        this.updateChildDescriptorNodes(treeModel, DT.getModuleManager().getStandAlones());
    }

    protected boolean isValidDescriptor(Descriptor d) {
        return true;
    }

    protected DescriptorTreeNode createChildDescriptorNode(Descriptor d) {
        Print.dprintStackTrace((String)"Nobody should be calling this!");
        return super.createChildDescriptorNode(d);
    }

    public boolean notification(UIDescriptorTree uiTree, NotificationEvent ne) {
        Descriptor desc;
        String type = ne.getType();
        if (type == null) {
            return false;
        }
        Object obj = ne.getValue("ModuleProperty");
        Descriptor descriptor = desc = obj instanceof Descriptor ? (Descriptor)obj : null;
        if (this.isValidDescriptor(desc) && DescriptorTools.isStandAlone(desc)) {
            if (type.equals("ModuleAdded")) {
                DescriptorTreeNode node = this.createChildDescriptorNode(desc);
                if (node != null) {
                    super.addNode((DescriptorTreeModel)uiTree.getModel(), node);
                    node.update((DescriptorTreeModel)uiTree.getModel());
                    uiTree.setSelectedDescriptor(desc, true);
                }
                return true;
            }
            if (type.equals("ModuleRemoved")) {
                DescriptorTreeNode node = this.getNodeFor(desc);
                if (node != null) {
                    this.removeNode((DescriptorTreeModel)uiTree.getModel(), node);
                    uiTree.setSelectedDescriptor(null, false);
                }
                return true;
            }
            if (type.equals("ModuleSaved")) {
                return true;
            }
        }
        return false;
    }
}

