/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentURISelector;
import com.sun.enterprise.tools.deployment.ui.utils.FileTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class NewDeploymentSettingsFile
extends UIDialog {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NewDeploymentSettingsFile.class);
    protected static String NEW_WINDOW_TITLE = localStrings.getLocalString("ui.newdeploymentsettingsfile.window_title.new", "New Deployment Settings File");
    protected static String EDIT_WINDOW_TITLE = localStrings.getLocalString("ui.newdeploymentsettingsfile.window_title.edit", "Edit Deployment Settings File");
    protected static String SAVE_WINDOW_TITLE = localStrings.getLocalString("ui.newdeploymentsettingsfile.window_title.save", "Save Deployment Settings File");
    protected static String CLOSE_WITHOUT_SAVING = localStrings.getLocalString("ui.newdeploymentsettingsfile.close_without_saving", "Close Without Saving");
    protected static String FILE_LOCATION = localStrings.getLocalString("ui.newdeploymentsettingsfile.file_location", "File Location:");
    public static String NEW = "newConfigMode";
    public static String EDIT = "editConfigMode";
    public static String SAVE = "saveConfigMode";
    private static NewDeploymentSettingsFile dialog = null;
    private String editMode = "";
    private boolean isOk = false;
    private boolean isCancel = false;
    private UITitledTextField fileLocation = null;
    private DeploymentURISelector uriSelector = null;
    private UIButton okBtn = null;
    private UIButton saveBtn = null;
    private UIButton cancelBtn = null;
    private UIButton closeBtn = null;

    protected NewDeploymentSettingsFile(Frame parentFrame) {
        super(parentFrame, true);
        this.setTitle(NEW_WINDOW_TITLE);
        this._initLayout();
    }

    protected void _initLayout() {
        UITitledBox content = (UITitledBox)this.getContentPane();
        UIControlButtonBox control = new UIControlButtonBox(null, false);
        control.setControlButtonLocation(101);
        content.addWithGBConstraints(control);
        UITitledBox box = new UITitledBox(null, false);
        box.getGBConstraints().weighty = 0.0;
        box.getGBConstraints().fill = 2;
        box.getGBConstraints().anchor = 11;
        box.getGBConstraints().insets.top = 5;
        control.setView(box);
        this.okBtn = UIButton.createOkButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewDeploymentSettingsFile.this.okAction();
            }
        });
        control.addControlButton(this.okBtn);
        this.saveBtn = UIButton.createSaveButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewDeploymentSettingsFile.this.okAction();
            }
        });
        control.addControlButton(this.saveBtn);
        this.cancelBtn = UIButton.createCancelButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewDeploymentSettingsFile.this.cancelAction();
            }
        });
        control.addControlButton(this.cancelBtn);
        this.closeBtn = new UIButton(CLOSE_WITHOUT_SAVING, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewDeploymentSettingsFile.this.closeAction();
            }
        });
        control.addControlButton(this.closeBtn);
        control.addControlButton(new UIHelpButton("DepMgrSettings"));
        this.fileLocation = new UITitledTextField(FILE_LOCATION, false);
        this.fileLocation.setBrowserActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NewDeploymentSettingsFile.this.browseFileLocation();
            }
        });
        box.addWithGBConstraints(this.fileLocation);
        this.uriSelector = new DeploymentURISelector(false);
        box.addWithGBConstraints(this.uriSelector);
    }

    public File getFileLocation() {
        String fn = this.fileLocation.getText();
        if (fn.equals("")) {
            return null;
        }
        File f = new File(fn).getAbsoluteFile();
        if (!fn.equals(f.toString())) {
            this.fileLocation.setText(f.toString());
        }
        return f;
    }

    public DeploymentPlatform getDeploymentPlatform() {
        return this.uriSelector.getSelectedPlatform();
    }

    public boolean isOk() {
        return this.isOk;
    }

    public boolean isCancelled() {
        return this.isCancel;
    }

    private void browseFileLocation() {
        UIFileChooser fc = UIFileChooser.getFileChooser(this.getFileLocation());
        int rtn = fc.showDialog(this, null);
        if (rtn == 0) {
            File file = fc.getSelectedFile();
            this.fileLocation.setText(file.toString());
        }
    }

    private void okAction() {
        File f = this.getFileLocation();
        if (this.editMode.equals(NEW) || this.editMode.equals(SAVE)) {
            if (f == null) {
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newdeploymentsettingsfile.please_select_valid_filename", "Please select a valid filename."));
                return;
            }
            if (f.exists()) {
                if (!FileTools.checkFileOverwrite((Component)this, f)) {
                    return;
                }
                if (!FileTools.deleteFile(this, f)) {
                    return;
                }
            }
        } else if (this.editMode.equals(EDIT) && (f == null || !f.isFile())) {
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.newdeploymentsettingsfile.please_select_existing_file", "Please select an existing file."));
            return;
        }
        if (!this.uriSelector.isValidURI()) {
            this.getDeploymentPlatform().showInvalidURI(this, this.uriSelector.getAlwaysConnect());
            return;
        }
        this.uriSelector.applySelections();
        this.isOk = true;
        this.hide();
    }

    protected void cancelAction() {
        this.isCancel = true;
        this.hide();
    }

    private void closeAction() {
        this.hide();
    }
}

