/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.deploy;

import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentManagerSettings;
import com.sun.enterprise.tools.deployment.ui.deploy.DeploymentPlatform;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICheckBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Print;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class DeploymentURISelector
extends UIControlButtonBox {
    protected static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeploymentURISelector.class);
    protected static String DEPLOYMENT_MANAGER = localStrings.getLocalString("ui.deploymenturiselector.title", "Deployment Manager");
    protected static String DM_PLATFORM = localStrings.getLocalString("ui.deploymenturiselector.platform", "Platform:");
    protected static String DM_URI = localStrings.getLocalString("ui.deploymenturiselector.server", "Server:");
    protected static String DM_SETTINGS = localStrings.getLocalString("ui.deploymenturiselector.settings", "Settings...");
    protected static String ALWAYS_CONNECT = localStrings.getLocalString("ui.deploymenturiselector.alway_use_connected", "Always use connected DeploymentManager");
    protected static String CONNECTION_SETTINGS = localStrings.getLocalString("ui.deploymenturiselector.connection_settings", "Connection Settings");
    protected static String USERNAME = localStrings.getLocalString("ui.deploymenturiselector.connection_settings.user_name", "User Name:");
    protected static String PASSWORD = localStrings.getLocalString("ui.deploymenturiselector.connection_settings.password", "Password:");
    private static final String SAVED_USERPASS_FILE = ".asadminprefs";
    private static final String AS_ADMIN_USER = "AS_ADMIN_USER";
    private static final String AS_ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private UITitledComboBox depPlatform = null;
    private UITitledComboBox depMgrUri = null;
    private UITitledBox connectionSettingsBox = null;
    private UICheckBox useConnected = null;
    private UIButton settings = null;
    private UITitledTextField userName = null;
    private UITitledPasswordField userPass = null;

    public DeploymentURISelector(boolean showSettings) {
        this(showSettings, false);
    }

    public DeploymentURISelector(boolean showSettings, boolean showAlwaysConnect) {
        this(showSettings, showAlwaysConnect, false);
    }

    public DeploymentURISelector(boolean showSettings, boolean showAlwaysConnect, boolean showFrame) {
        super(showFrame ? DEPLOYMENT_MANAGER : null, showFrame);
        this.initLayout(showSettings, showAlwaysConnect);
    }

    private void initLayout(boolean showSettings, boolean showAlwaysConnect) {
        this.setControlButtonLocation(202);
        UITitledBox container = new UITitledBox(null, false);
        this.setView(container);
        container.getGBConstraints().insets.bottom = 5;
        this.depPlatform = new UITitledComboBox(DM_PLATFORM, false);
        this.depPlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentURISelector.this.refreshUriModel();
                DeploymentURISelector.this.updateComponent(DeploymentURISelector.this);
            }
        });
        container.addWithGBConstraints(this.depPlatform);
        this.depMgrUri = new UITitledComboBox(DM_URI, false);
        this.depMgrUri.getComboBox().setRenderer(new URICellRenderer());
        this.depMgrUri.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DeploymentURISelector.this.refreshUriModel();
                DeploymentURISelector.this.updateComponent(DeploymentURISelector.this);
            }
        });
        container.addWithGBConstraints(this.depMgrUri);
        if (showSettings) {
            if (showAlwaysConnect) {
                this.useConnected = new UICheckBox(ALWAYS_CONNECT);
                this.useConnected.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                    }
                });
                container.addWithGBConstraints(this.useConnected);
            }
            this.connectionSettingsBox = new UITitledBox(CONNECTION_SETTINGS, true);
            ActionListener userPassAction = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                }
            };
            container.addWithGBConstraints(this.connectionSettingsBox);
            this.userName = new UITitledTextField(USERNAME, false);
            this.userName.addActionListener(userPassAction);
            this.connectionSettingsBox.addWithGBConstraints(this.userName);
            this.userPass = new UITitledPasswordField(PASSWORD, false);
            this.userPass.addActionListener(userPassAction);
            this.connectionSettingsBox.addWithGBConstraints(this.userPass);
        } else {
            this.settings = new UIButton(DM_SETTINGS, new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DeploymentManagerSettings.showDialog();
                    DeploymentURISelector.this.refreshPlatforms();
                }
            });
            this.addControlButton(this.settings);
        }
    }

    public void setConnectionSettingsVisible(boolean visible) {
        if (this.connectionSettingsBox != null && this.connectionSettingsBox.isVisible() != visible) {
            this.connectionSettingsBox.setVisible(visible);
            this.userName.setText("");
            this.userPass.setText("");
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.depPlatform.setReadOnly(readOnly || this.depPlatform.getItemCount() <= 1);
        this.depPlatform.setVisible(this.depPlatform.getItemCount() > 1);
        if (this.depMgrUri != null) {
            this.depMgrUri.setReadOnly(readOnly);
        }
        if (this.useConnected != null) {
            this.useConnected.setReadOnly(readOnly);
        }
        if (this.userName != null) {
            this.userName.setReadOnly(readOnly);
        }
        if (this.userPass != null) {
            this.userPass.setReadOnly(readOnly);
        }
        if (this.settings != null) {
            this.settings.setReadOnly(readOnly);
        }
    }

    public boolean getAlwaysConnect() {
        if (this.userName != null) {
            return this.useConnected != null ? this.useConnected.isSelected() : true;
        }
        DeploymentPlatform dp = this.getSelectedPlatform();
        return dp != null ? dp.getAlwaysConnect() : false;
    }

    public boolean isValidURI() {
        DeploymentPlatform dp = this.getSelectedPlatform();
        if (dp != null) {
            String pwd;
            String uri = this.depMgrUri.getText();
            String usr = this.userName != null ? this.userName.getText() : dp.getCurrentUser();
            String string = pwd = this.userPass != null ? this.userPass.getText() : dp.getCurrentPassword();
            if (this.getAlwaysConnect()) {
                return dp.isValidConnectedURI(uri, usr, pwd);
            }
            return dp.isValidDisconnectedURI(uri);
        }
        return false;
    }

    public boolean isValidUsernamePassword() {
        int pswdLength;
        boolean flag = true;
        DeploymentPlatform dp = this.getSelectedPlatform();
        int usrLength = this.userName != null ? this.userName.getText().length() : dp.getCurrentUser().length();
        int n = pswdLength = this.userPass != null ? this.userPass.getText().length() : dp.getCurrentPassword().length();
        if (usrLength == 0 || pswdLength == 0) {
            flag = false;
        }
        return flag;
    }

    public DeploymentPlatform applySelections() {
        DeploymentPlatform dp = this.getSelectedPlatform();
        if (dp != null) {
            dp.setSelectedURI(this.depMgrUri.getText());
            DeploymentPlatform.setSelectedManagerURI(dp.getManagerURI(this.depMgrUri.getText()));
            if (this.useConnected != null) {
                dp.setAlwaysConnect(this.useConnected.isSelected());
            }
            if (this.userName != null && this.userPass != null) {
                dp.setCurrentUser(this.userName.getText(), this.userPass.getText());
            }
        }
        return dp;
    }

    public void refreshPlatforms() {
        List p = DeploymentPlatform.getPlatforms();
        this.depPlatform.setModel(p);
        this.depPlatform.setReadOnly(this.isReadOnly() || p == null || p.size() <= 1);
        this.depPlatform.setVisible(p != null && p.size() > 1);
        this.refreshUriModel();
    }

    private void refreshUriModel() {
        DeploymentPlatform dp = this.getSelectedPlatform();
        if (dp != null) {
            this.depMgrUri.setModel(dp.getURIList());
            if (this.useConnected != null) {
                this.useConnected.setEnabled(true);
                this.useConnected.setSelected(dp.getAlwaysConnect());
            }
            if (this.userName != null) {
                this.userName.setEnabled(true);
                if (dp.getCurrentUser().equals("")) {
                    this.userName.setText(this.getDefaultUserPassword(AS_ADMIN_USER));
                } else {
                    this.userName.setText(dp.getCurrentUser());
                }
            }
            if (this.userPass != null) {
                this.userPass.setEnabled(true);
                if (dp.getCurrentPassword().equals("")) {
                    this.userPass.setText(this.getDefaultUserPassword(AS_ADMIN_PASSWORD));
                } else {
                    this.userPass.setText(dp.getCurrentPassword());
                }
            }
        } else {
            this.depMgrUri.setModel((Collection)null);
            if (this.useConnected != null) {
                this.useConnected.setSelected(false);
                this.useConnected.setEnabled(false);
            }
            if (this.userName != null) {
                this.userName.setText("");
                this.userName.setEnabled(false);
            }
            if (this.userPass != null) {
                this.userPass.setText("");
                this.userPass.setEnabled(false);
            }
        }
    }

    private String getDefaultUserPassword(String input) {
        if (input.equals(AS_ADMIN_USER) && !UIConfig.getDefaultUserName().equals("")) {
            return UIConfig.getDefaultUserName();
        }
        if (input.equals(AS_ADMIN_PASSWORD) && !UIConfig.getDefaultPassword().equals("")) {
            return UIConfig.getDefaultPassword();
        }
        String configFile = System.getProperty("user.home") + File.separator + SAVED_USERPASS_FILE;
        if (!new File(configFile).exists()) {
            return "";
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            String lineRead = reader.readLine();
            while (lineRead != null) {
                StringTokenizer tokens = new StringTokenizer(lineRead, "=");
                while (tokens.hasMoreTokens()) {
                    String name = tokens.nextToken();
                    if (!name.equals(input)) continue;
                    return tokens.nextToken();
                }
                lineRead = reader.readLine();
            }
            reader = null;
        }
        catch (FileNotFoundException fe) {
            return "";
        }
        catch (IOException ioe) {
            return "";
        }
        return "";
    }

    public DeploymentPlatform getSelectedPlatform() {
        return (DeploymentPlatform)this.depPlatform.getSelectedItem();
    }

    public void setSelectedPlatform(DeploymentPlatform dp) {
        this.depPlatform.setSelectedItem(dp);
        this.refreshUriModel();
    }

    public void setSelectedURI(DeploymentPlatform.ManagerURI mu) {
        if (mu != null) {
            Print.dprintln((String)("Selecting " + mu));
            this.depMgrUri.setText(mu.toString());
        }
    }

    public void setEnabled(boolean state) {
        this.depPlatform.setEnabled(state);
        this.depMgrUri.setEnabled(state);
    }

    public void setEditable(boolean state) {
    }

    public class URICellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object v, int ndx, boolean sel, boolean foc) {
            int p = v.toString().indexOf("::");
            String uri = p >= 0 ? v.toString().substring(p + 2) : v.toString();
            return super.getListCellRendererComponent((JList<?>)list, uri, ndx, sel, foc);
        }
    }
}

