/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.cmp;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.tools.common.cmp.ui.MappingEvaluator;
import com.sun.enterprise.tools.common.cmp.ui.SunOneUtilsCMP;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.cmp.CmpPanel;
import com.sun.enterprise.tools.deployment.ui.cmp.CmpSettingsPanel;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptorTools;
import com.sun.enterprise.tools.deployment.ui.sunone.SunOneUtils;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JOptionPane;

public class CmpInspectorPane
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CmpInspectorPane.class);
    public static final String DEFAULT_TABNAME = localStrings.getLocalString("ui.cmpinspectorpane.default_tabname", "[CMP Database]");
    private String tabName = null;
    private Descriptor descriptor = null;
    private Component cmpPanel = null;
    private UITitledBox cmpBox = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new CmpInspectorPane();
    }

    public String getHelpID() {
        return "Cmp";
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTabName() {
        if (this.cmpPanel instanceof CmpPanel) {
            return ((CmpPanel)((Object)this.cmpPanel)).getTabName();
        }
        return this.tabName != null ? this.tabName : DEFAULT_TABNAME;
    }

    public Class getDescriptorClass() {
        return Descriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor d) {
        if (this.descriptor != d) {
            this.descriptor = d;
            if (this.cmpPanel instanceof CmpPanel) {
                ((CmpPanel)((Object)this.cmpPanel)).setDescriptor(d);
            }
        }
    }

    private CmpInspectorPane() {
        this.initializeLayout();
        this.setCmpPanel(new CmpSettingsPanel(this));
    }

    private void initializeLayout() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.cmpBox = new UITitledBox(null, false);
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.fill = 1;
        this.add((Component)this.cmpBox, c);
    }

    public void refresh() {
        if (this.cmpPanel instanceof CmpPanel) {
            EjbBundleDescriptor d = (EjbBundleDescriptor)DescriptorTools.getBundleDescriptor(this.getDescriptor());
            ClassLoader cl = d.getClassLoader();
            List errors = MappingEvaluator.evaluate(cl, SunOneUtils.getSunCmpMappings((Descriptor)d));
            if (!SunOneUtilsCMP.isSchemaSpecified()) {
                errors.add(localStrings.getLocalString("ui.cmpinspectorpane.warning_cant_display_mappings", "Warning - Cannot Display Mappings\nYou have existing mappings that were created without capturing database meta data,\nand therefore, could not be displayed in the Field Mappings table.\nThe existing mappings are still deployable and may continue to be used."));
            }
            boolean optionVal = false;
            if (errors.size() > 0) {
                JOptionPane.showMessageDialog(this, UIUtils.constructMessage(errors), "Packaging Warning", 2);
            }
            ((CmpPanel)((Object)this.cmpPanel)).refresh();
        }
    }

    public boolean validateEntries(boolean showErrors) {
        if (this.cmpPanel instanceof CmpPanel) {
            boolean ret = ((CmpPanel)((Object)this.cmpPanel)).validateEntries(showErrors);
            return ret;
        }
        return true;
    }

    public void setCmpPanel(Component c) {
        if (this.cmpPanel != null) {
            this.cmpBox.remove(this.cmpPanel);
        }
        this.cmpPanel = c;
        this.cmpBox.addWithGBConstraints(this.cmpPanel);
    }
}

