/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.appc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.shared.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.shared.IconInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ManifestClasspathInspector;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleArchive;
import com.sun.enterprise.tools.deployment.ui.shared.ModuleContent;
import com.sun.enterprise.tools.deployment.ui.utils.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.ListTools;
import com.sun.enterprise.tools.deployment.ui.utils.UIControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIProject;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

public class AppClientGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
ManifestClasspathInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AppClientGeneralInspector.class);
    private static final String DISPLAY_NAME = localStrings.getLocalString("ui.appclientgeneralinspector.displayname", "Display name:");
    private static String DISPLAY_NAME_TOOLTIP = localStrings.getLocalString("at.appclientgeneralinspector.displayname.tooltip", "Enter Display name of the Application Client");
    private static final String MAIN_CLASS = localStrings.getLocalString("ui.appclientgeneralinspector.main_class", "Main Class:");
    private static final String MAIN_CLASS_TOOLTIP = localStrings.getLocalString("at.appclientgeneralinspector.main_class.tooltip", "Choose the Main Class for the Application Client");
    private static final String APP_CLIENT_BOX = localStrings.getLocalString("ui.appclientgeneralinspector.applicationclient_box", "Application Client");
    private static final String APP_CLIENT_BOX_ACC_DESC = localStrings.getLocalString("at.appclientgeneralinspector.applicationclient_box.acc_desc", "Enter values for Application Client");
    private static final String CALLBACK_HANDLER_CLASS = localStrings.getLocalString("ui.appclientgeneralinspector.callbackhandler_class", "Callback Handler Class:");
    private static final String CALLBACK_HANDLER_CLASS_TOOLTIP = localStrings.getLocalString("at.appclientgeneralinspector.callbackhandler_class.tooltip", "Choose the Callback Handler Class for the Application Client");
    private static final String CONTAINER_CALLBACK = localStrings.getLocalString("ui.appclientgeneralinspector.container_callback_class", "(Use container-managed authentication)");
    private static String DESCRIPTION_ACC_DSC = localStrings.getLocalString("at.appclientgeneralinspector.description.acc_dsc", "Enter Description for the Application Client");
    private static String MANIFEST_CLASSPATH_ACC_DSC = localStrings.getLocalString("at.appclientgeneralinspector.manifest_classpath.acc_dsc", "Enter Manifest Classpath for the Application Client");
    private static String ICON_ACC_DSC = localStrings.getLocalString("at.appclientgeneralinspector.icon.acc_dsc", "Add Icons for the Application Clent");
    private static final String TABNAME = localStrings.getLocalString("ui.appclientgeneralinspector.tabname", "General");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    ApplicationClientDescriptor descriptor;
    private UITitledComboBox mainClassCombo = null;
    private UITitledComboBox callbackCombo = null;
    private ManifestClasspathInspector.DialogDisplayButton classpathButton = null;
    private DescriptionInspector.DialogDisplayButton descInspector = null;
    private IconInspector.DialogDisplayButton iconInspector = null;
    private ModuleContent contentsMap = null;
    private Application appDescriptor = null;

    public static InspectorPane newInspectorPane(String mode) {
        return new AppClientGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return ApplicationClientDescriptor.class;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ApplicationClientDescriptor) {
            this.descriptor = (ApplicationClientDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private AppClientGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        CSH.setHelpIDString((Component)this, (String)this.getHelpID());
        UITitledBox appClientBox = new UITitledBox(APP_CLIENT_BOX, true);
        appClientBox.getAccessibleContext().setAccessibleDescription(APP_CLIENT_BOX_ACC_DESC);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 25);
        c.fill = 2;
        c.anchor = 10;
        gridbag.setConstraints(appClientBox, c);
        this.add((Component)appClientBox, c);
        this.mainClassCombo = new UITitledComboBox(MAIN_CLASS, false);
        this.mainClassCombo.setToolTipText(MAIN_CLASS_TOOLTIP);
        this.mainClassCombo.setRequired(true);
        this.mainClassCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selClass = (String)AppClientGeneralInspector.this.mainClassCombo.getSelectedItem();
                if (AppClientGeneralInspector.this.isWizardMode() && selClass != null) {
                    int p = selClass.lastIndexOf(".");
                    String sn = p < 0 ? selClass : selClass.substring(p + 1);
                    String dn = AppClientGeneralInspector.this.descriptor.getDisplayName();
                    if (dn == null || dn.equals("")) {
                        AppClientGeneralInspector.this.descriptor.setDisplayName(sn);
                    }
                }
                AppClientGeneralInspector.this.descriptor.setMainClassName(selClass);
            }
        });
        GridBagConstraints gbc = appClientBox.getGBConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(5, 5, 0, 35);
        gbc.fill = 2;
        appClientBox.addWithGBConstraints(this.mainClassCombo);
        this.callbackCombo = new UITitledComboBox(CALLBACK_HANDLER_CLASS, false);
        this.callbackCombo.setToolTipText(CALLBACK_HANDLER_CLASS_TOOLTIP);
        this.callbackCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selItem = (String)AppClientGeneralInspector.this.callbackCombo.getSelectedItem();
                if (selItem == null || selItem.equals("") || selItem.equals(CONTAINER_CALLBACK)) {
                    AppClientGeneralInspector.this.descriptor.setCallbackHandler(null);
                } else {
                    AppClientGeneralInspector.this.descriptor.setCallbackHandler(selItem);
                }
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 5, 5, 35);
        appClientBox.addWithGBConstraints(this.callbackCombo);
        UIControlButtonBox buttonBox = new UIControlButtonBox(null, false);
        buttonBox.setView(null);
        buttonBox.setControlButtonLocation(103);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 55);
        c.fill = 2;
        c.anchor = 10;
        this.add((Component)buttonBox, c);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        this.descInspector.getAccessibleContext().setAccessibleDescription(DESCRIPTION_ACC_DSC);
        buttonBox.addControlButton(this.descInspector);
        this.classpathButton = new ManifestClasspathInspector.DialogDisplayButton(this);
        this.classpathButton.getAccessibleContext().setAccessibleDescription(MANIFEST_CLASSPATH_ACC_DSC);
        buttonBox.addControlButton(this.classpathButton);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        this.iconInspector.getAccessibleContext().setAccessibleDescription(ICON_ACC_DSC);
        buttonBox.addControlButton(this.iconInspector);
        UIPanel dummyPanel = new UIPanel();
        c.weightx = 0.5;
        c.weighty = 0.5;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 5, 5, 55);
        c.fill = 1;
        c.anchor = 10;
        this.add((Component)dummyPanel, c);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            this._addWizardIcon("large", iconFile, this.contentsMap, (Descriptor)this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, (Descriptor)this.descriptor, (Descriptor)this.descriptor);
        } else {
            this._addWizardIcon("small", iconFile, this.contentsMap, (Descriptor)this.descriptor);
        }
    }

    public void manifestClasspathUpdated(ListModel listModel) {
        Vector cpList = ListTools.toList(listModel);
        ModuleArchive.getModuleArchive((Descriptor)this.descriptor).setManifestClasspaths(cpList);
    }

    public void setTargetApplication(Application app) {
        this.appDescriptor = app;
    }

    private Application getTargetApplication() {
        return this.isWizardMode() ? this.appDescriptor : null;
    }

    public void setModuleContent(ModuleContent fcd) {
        this.contentsMap = fcd;
    }

    public ModuleContent getModuleContent() {
        if (!this.isWizardMode()) {
            return null;
        }
        this.contentsMap.addEntries(UIProject.getProjectFileEntry((Descriptor)this.descriptor));
        return this.contentsMap;
    }

    public String getMainClass() {
        return (String)this.mainClassCombo.getSelectedItem();
    }

    public void refresh() {
        String dispName;
        if (this.descriptor == null) {
            return;
        }
        Vector mainClassComboModel = new Vector();
        Vector<String> callbackComboModel = new Vector<String>();
        callbackComboModel.add(CONTAINER_CALLBACK);
        Iterator i = this.getArchiveClassNames().iterator();
        while (i.hasNext()) {
            Object cn = i.next();
            mainClassComboModel.add(cn);
            callbackComboModel.add((String)cn);
        }
        this.mainClassCombo.setModel(mainClassComboModel);
        String mainClass = this.descriptor.getMainClassName();
        this.mainClassCombo.setSelectedItem(mainClass, true);
        this.callbackCombo.setModel(callbackComboModel);
        String callbackClass = this.descriptor.getCallbackHandler();
        if (callbackClass == null) {
            this.callbackCombo.setSelectedItem(CONTAINER_CALLBACK);
        } else {
            this.callbackCombo.setSelectedItem(callbackClass, true);
        }
        if (this.isWizardMode() && ((dispName = this.descriptor.getDisplayName()) == null || dispName.equals("")) && mainClass != null) {
            int p = mainClass.lastIndexOf(".");
            String name = p < 0 ? mainClass : mainClass.substring(p + 1);
            this.descriptor.setDisplayName(name);
        }
        DefaultListModel dlm = new DefaultListModel();
        ListTools.toListModel(ModuleArchive.getModuleArchive((Descriptor)this.descriptor).getManifestClasspaths(), dlm);
        if (this.isDeploymentMode()) {
            this.classpathButton.setManifestClasspathInspector(dlm, null, (Descriptor)this.descriptor);
        } else {
            Application app = this.getTargetApplication();
            this.classpathButton.setManifestClasspathInspector(dlm, null, (Descriptor)this.descriptor, (Descriptor)app);
        }
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getDisplayName(), this, this.descriptor);
        this.invalidate();
        this.validate();
    }
}

