/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.cmp.ui;

import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.util.NbBundle;

public class MappingEvaluator {
    private static final ResourceBundle bundle = NbBundle.getBundle(MappingEvaluator.class);

    private MappingEvaluator() {
    }

    public static List evaluate(List schemas, SunCmpMappings mappingFileContent) {
        ArrayList<String> retVal = new ArrayList<String>();
        SunCmpMapping[] maps = null;
        if (null != mappingFileContent) {
            maps = mappingFileContent.getSunCmpMapping();
        }
        if (null != maps) {
            for (int i = 0; i < maps.length; ++i) {
                String aSchemaRef = maps[i].getSchema();
                if (null == aSchemaRef || aSchemaRef.trim().length() <= 0) continue;
                String aRef = aSchemaRef.trim();
                String lowRef = aRef + ".dbschema";
                String upRef = aRef + ".DBSCHEMA";
                if (schemas.contains(lowRef) || schemas.contains(upRef)) continue;
                String message = MessageFormat.format(bundle.getString("ERROR_SCHEMA_NOT_FOUND"), aRef);
                retVal.add(message);
            }
        }
        return retVal;
    }

    public static List evaluate(ClassLoader cl, SunCmpMappings mappingFileContent) {
        ArrayList<String> retVal = new ArrayList<String>();
        SunCmpMapping[] maps = null;
        if (null != mappingFileContent) {
            maps = mappingFileContent.getSunCmpMapping();
        }
        if (null != maps) {
            for (int i = 0; i < maps.length; ++i) {
                String aSchemaRef = maps[i].getSchema();
                if (null == aSchemaRef || aSchemaRef.trim().length() <= 0) continue;
                String aRef = aSchemaRef.trim();
                SchemaElement schema = null;
                schema = null == cl ? SchemaElement.forName((String)aSchemaRef) : SchemaElement.forName((String)aSchemaRef, (ClassLoader)cl);
                if (null != schema) continue;
                String message = MessageFormat.format(bundle.getString("ERROR_SCHEMA_NOT_FOUND"), aRef);
                retVal.add(message);
            }
        }
        return retVal;
    }

    public static List evaluate(SunCmpMappings mappingFileContent) {
        return MappingEvaluator.evaluate((ClassLoader)null, mappingFileContent);
    }
}

