/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.DestinationName;
import com.sun.messaging.jms.ra.ResourceAdapter;
import java.io.Serializable;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapterAssociation;

public class ActivationSpec
implements javax.resource.spi.ActivationSpec,
ResourceAdapterAssociation,
Serializable {
    private static final String AUTOACKNOWLEDGE = "Auto-acknowledge";
    private static final String DUPSOKACKNOWLEDGE = "Dups-ok-acknowledge";
    public static final String NOACKNOWLEDGE = "No-acknowledge";
    protected static final String DURABLE = "Durable";
    protected static final String NONDURABLE = "NonDurable";
    protected static final String QUEUE = "javax.jms.Queue";
    protected static final String TOPIC = "javax.jms.Topic";
    private ResourceAdapter ra = null;
    private String destinationType = null;
    private String destination = null;
    private String messageSelector = null;
    private String acknowledgeMode = "Auto-acknowledge";
    private String subscriptionDurability = "NonDurable";
    private String clientId = null;
    private String subscriptionName = null;
    private String connectionFactoryJNDIName;
    private int endpointPoolMaxSize = 15;
    private int endpointPoolSteadySize = 10;
    private int endpointPoolResizeCount = 1;
    private int endpointPoolResizeTimeout = 5;
    private int endpointExceptionRedeliveryAttempts = 6;
    private int endpointExceptionRedeliveryInterval = 100;
    private boolean sendUndeliverableMsgsToDMQ = true;
    private boolean enableSharedClientID = false;
    private String addressList = null;
    private String customAcknowledgeMode = null;
    private String mdbName = null;
    private String userName = null;
    private String password = null;
    private transient ClassLoader contextClassLoader = null;
    private transient String groupName = null;
    private transient String raUID = null;
    private transient boolean inClusteredContainer = false;
    private transient boolean deliverySerial = false;

    public void validate() throws InvalidPropertyException {
        if (!DestinationName.isSyntaxValid(this.destination)) {
            throw new InvalidPropertyException("MQRA:AS:validate-Invalid value:destination=" + this.destination);
        }
        if (this.destinationType.equals(TOPIC) && this.subscriptionDurability.equals(DURABLE) && (this.subscriptionName == null || "".equals(this.subscriptionName) || this.clientId == null || "".equals(this.clientId))) {
            throw new InvalidPropertyException("MQRA:AS:validate-Both subscriptionName and clientId must be non-null\n\tsubscriptionName=" + this.subscriptionName + "\n\tclientId=" + this.clientId);
        }
        if (this.endpointExceptionRedeliveryInterval < 1) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointExceptionRedeliveryInterval must be greater than 0\nInvalid value=" + this.endpointExceptionRedeliveryInterval);
        }
        if (this.endpointExceptionRedeliveryAttempts < 0) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointExceptionRedeliveryAttempts must be greater than or equal to 0\nInvalid value=" + this.endpointExceptionRedeliveryAttempts);
        }
        if (this.endpointPoolResizeTimeout < 1) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointPoolResizeTimeout must be greater than 0\nInvalid value=" + this.endpointPoolResizeTimeout);
        }
        if (this.endpointPoolResizeCount < 1) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointPoolResizeCount must be greater than 0\nInvalid value=" + this.endpointPoolResizeCount);
        }
        if (this.endpointPoolMaxSize < 1) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointPoolMaxSize must be greater than 0\nInvalid value=" + this.endpointPoolMaxSize);
        }
        if (this.endpointPoolSteadySize < 0) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointPoolSteadySize must be greater than or equal to 0\nInvalid value=" + this.endpointPoolSteadySize);
        }
        if (this.endpointPoolSteadySize > this.endpointPoolMaxSize) {
            throw new InvalidPropertyException("MQRA:AS:validate-\nendpointPoolSteadySize must be less than or equal to endpointPoolMaxSize\nendpointPoolSteadySize value=" + this.endpointPoolSteadySize + "\nendpointPoolMaxSize value=" + this.endpointPoolSteadySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter) throws ResourceException {
        ActivationSpec activationSpec = this;
        synchronized (activationSpec) {
            if (this.ra == null) {
                if (!(resourceAdapter instanceof ResourceAdapter)) {
                    throw new ResourceException("MQRA:AS:incompatible to associate resource adapter of class:" + resourceAdapter.getClass());
                }
            } else {
                throw new ResourceException("MQRA:AS:illegal to change resource adapter association");
            }
            this.ra = (ResourceAdapter)resourceAdapter;
            this.groupName = this.ra.getGroupName();
            this.inClusteredContainer = this.ra.getInClusteredContainer();
            this.raUID = this.ra._getRAUID();
        }
    }

    public javax.resource.spi.ResourceAdapter getResourceAdapter() {
        return this.ra;
    }

    public void setDestinationType(String string) {
        if (!QUEUE.equals(string) && !TOPIC.equals(string)) {
            throw new IllegalArgumentException("MQRA:AS:Invalid destinationType - " + string);
        }
        this.destinationType = string;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestination(String string) {
        if (!DestinationName.isSyntaxValid(string)) {
            throw new IllegalArgumentException("MQRA:AS:Invalid destination name - " + string);
        }
        this.destination = string;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setMessageSelector(String string) {
        this.messageSelector = string;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setAcknowledgeMode(String string) {
        if (!AUTOACKNOWLEDGE.equals(string) && !DUPSOKACKNOWLEDGE.equals(string)) {
            throw new IllegalArgumentException("MQRA:AS:Invalid acknowledgeMode - " + string);
        }
        this.acknowledgeMode = string;
    }

    public String getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setCustomAcknowledgeMode(String string) {
        if (!NOACKNOWLEDGE.equals(string)) {
            throw new IllegalArgumentException("MQRA:AS:Invalid CustomAcknowledgeMode - " + string);
        }
        this.customAcknowledgeMode = string;
    }

    public String getCustomAcknowledgeMode() {
        return this.customAcknowledgeMode;
    }

    public void setSubscriptionDurability(String string) {
        if (!DURABLE.equals(string) && !NONDURABLE.equals(string)) {
            throw new IllegalArgumentException("MQRA:AS:Invalid subscriptionDurability - " + string);
        }
        this.subscriptionDurability = string;
    }

    public String getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setClientId(String string) {
        this.clientId = string;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setSubscriptionName(String string) {
        this.subscriptionName = string;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void _setConnectionFactoryJNDIName(String string) {
        this.connectionFactoryJNDIName = string;
    }

    public String _getConnectionFactoryJNDIName() {
        return this.connectionFactoryJNDIName;
    }

    public void setEndpointPoolMaxSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointPoolMaxSize-Value must be greater than 0Invalid value=" + n);
        }
        this.endpointPoolMaxSize = n;
    }

    public int getEndpointPoolMaxSize() {
        return this.endpointPoolMaxSize;
    }

    public void setEndpointPoolSteadySize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointPoolSteadySize-Value must be greater than or equal to 0Invalid value=" + n);
        }
        this.endpointPoolSteadySize = n;
    }

    public int getEndpointPoolSteadySize() {
        return this.endpointPoolSteadySize;
    }

    public void setEndpointPoolResizeCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointPoolResizeCount-Value must be greater than 0:Invalid value=" + n);
        }
        this.endpointPoolResizeCount = n;
    }

    public int getEndpointPoolResizeCount() {
        return this.endpointPoolResizeCount;
    }

    public void setEndpointPoolResizeTimeout(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointPoolResizeTimeout-Value must be greater than 0:Invalid value=" + n);
        }
        this.endpointPoolResizeTimeout = n;
    }

    public int getEndpointPoolResizeTimeout() {
        return this.endpointPoolResizeTimeout;
    }

    public void setEndpointExceptionRedeliveryAttempts(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointExceptionRedeliveryAttempts-Value must be greater than or equal to 0:Invalid value=" + n);
        }
        this.endpointExceptionRedeliveryAttempts = n;
    }

    public int getEndpointExceptionRedeliveryAttempts() {
        return this.endpointExceptionRedeliveryAttempts;
    }

    public void setEndpointExceptionRedeliveryInterval(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("MQRA:AS:setEndpointExceptionRedeliveryInterval-Value must be greater than 0:Invalid value=" + n);
        }
        this.endpointExceptionRedeliveryInterval = n;
    }

    public int getEndpointExceptionRedeliveryInterval() {
        return this.endpointExceptionRedeliveryInterval;
    }

    public void setSendUndeliverableMsgsToDMQ(boolean bl) {
        this.sendUndeliverableMsgsToDMQ = bl;
    }

    public boolean getSendUndeliverableMsgsToDMQ() {
        return this.sendUndeliverableMsgsToDMQ;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        this.contextClassLoader = classLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public void setAddressList(String string) {
        this.addressList = string;
    }

    public String getAddressList() {
        return this.addressList;
    }

    public void setMdbName(String string) {
        this.mdbName = string;
    }

    public String getMdbName() {
        return this.mdbName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getUserName() {
        if (this.userName == null && this.ra != null) {
            return this.ra.getUserName();
        }
        return this.userName;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        if (this.password == null && this.ra != null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    protected String _AddressList() {
        if (this.addressList != null) {
            return this.addressList;
        }
        if (this.ra != null) {
            return this.ra.getConnectionURL();
        }
        return "localhost";
    }

    public void _setDeliverySerial(boolean bl) {
        this.deliverySerial = bl;
    }

    protected boolean _getDeliverySerial() {
        return this.deliverySerial;
    }

    protected boolean _deliverySerial() {
        return this.deliverySerial;
    }

    protected String _getGroupName() {
        return this.groupName;
    }

    protected void _setGroupName(String string) {
        this.groupName = string;
    }

    protected String _getRAUID() {
        return this.raUID;
    }

    protected void _setRAUID(String string) {
        this.raUID = string;
    }

    protected boolean _isInClusteredContainer() {
        return this.inClusteredContainer;
    }

    protected void _setInClusteredContainer(boolean bl) {
        this.inClusteredContainer = bl;
    }

    public String toString() {
        return "ActvationSpec configuration=\n\tDestinationType                     =" + this.destinationType + "\n" + "\tDestination                         =" + this.destination + "\n" + "\tMessageSelector                     =" + this.messageSelector + "\n" + "\tAcknowledgeMode                     =" + this.acknowledgeMode + "\n" + "\tSubscriptionDurability              =" + this.subscriptionDurability + "\n" + "\tClientId                            =" + this.clientId + "\n" + "\tSubscriptionName                    =" + this.subscriptionName + "\n" + "\tConnectionFactoryJNDIName           =" + this.connectionFactoryJNDIName + "\n" + "\tEndpointPoolMaxSize                 =" + this.endpointPoolMaxSize + "\n" + "\tEndpointPoolSteadySize              =" + this.endpointPoolSteadySize + "\n" + "\tEndpointPoolResizeCount             =" + this.endpointPoolResizeCount + "\n" + "\tEndpointPoolResizeTimeout           =" + this.endpointPoolResizeTimeout + "\n" + "\tEndpointExceptionRedeliveryAttempts =" + this.endpointExceptionRedeliveryAttempts + "\n" + "\tEndpointExceptionRedeliveryInterval =" + this.endpointExceptionRedeliveryInterval + "\n" + "\tSendUndeliverableMsgsToDMQ          =" + this.sendUndeliverableMsgsToDMQ + "\n" + "\tGroupName                           =" + this.groupName + "\n" + "\tRAUID                               =" + this.raUID + "\n" + "\tInClusteredContainer                =" + this.inClusteredContainer + "\n" + "\tMdbName                             =" + this.mdbName + "\n" + "\tUserName                            =" + this.userName + "\n" + "\tPassword                            =" + this.password + "\n" + "\tAddressList                         =" + this.addressList + "\n";
    }
}

