/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.util.JMQXid;
import javax.jms.JMSException;
import javax.jms.Message;

public class Transaction {
    protected SessionImpl session = null;
    protected ProtocolHandler protocolHandler = null;
    protected WriteChannel writeChannel = null;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    private boolean setJMSXProducerTXID = false;

    protected Transaction(SessionImpl sessionImpl, boolean bl) throws JMSException {
        this.session = sessionImpl;
        this.writeChannel = sessionImpl.connection.getWriteChannel();
        this.protocolHandler = sessionImpl.protocolHandler;
        this.setJMSXProducerTXID = sessionImpl.connection.connectionMetaData.setJMSXProducerTXID;
        if (bl) {
            this.startNewLocalTransaction();
        }
    }

    protected void setProtocolHandler(ProtocolHandler protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    protected void init() throws JMSException {
        this.startNewLocalTransaction();
        this.setJMSXProducerTXID = this.session.connection.connectionMetaData.setJMSXProducerTXID;
    }

    protected synchronized void commit() throws JMSException {
        this.protocolHandler.commit(this.transactionID, -1, null);
        this.startNewLocalTransaction();
    }

    protected synchronized void rollback() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
        this.startNewLocalTransaction();
    }

    protected void rollbackToXA() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
        this.transactionID = -1L;
    }

    protected void send(Message message) throws JMSException {
        MessageImpl messageImpl = (MessageImpl)message;
        if (this.setJMSXProducerTXID) {
            messageImpl.setStringProperty("JMSXProducerTXID", String.valueOf(this.transactionID));
        }
        ReadWritePacket readWritePacket = messageImpl.getPacket();
        readWritePacket.setTransactionID(this.transactionID);
        this.writeChannel.writeJMSMessage(message);
    }

    protected JMQXid[] recoverXATransactions(int n) throws JMSException {
        return this.protocolHandler.recover(n);
    }

    protected void prepareXATransaction(JMQXid jMQXid) throws JMSException {
        this.protocolHandler.prepare(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, jMQXid);
    }

    protected void commitXATransaction(JMQXid jMQXid, boolean bl) throws JMSException {
        int n = bl ? 0x40000000 : 0;
        this.protocolHandler.commit(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
    }

    protected void rollbackXATransaction(JMQXid jMQXid) throws JMSException {
        this.protocolHandler.rollback(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, jMQXid);
    }

    protected void startXATransaction(int n, JMQXid jMQXid) throws JMSException {
        this.startTransaction(n, jMQXid);
    }

    protected void endXATransaction(int n, JMQXid jMQXid) throws JMSException {
        this.protocolHandler.endTransaction(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
    }

    protected void startNewLocalTransaction() throws JMSException {
        this.transactionID = -1L;
        this.jmqXid = null;
        this.startTransaction(-1, null);
    }

    protected synchronized void startTransaction(int n, JMQXid jMQXid) throws JMSException {
        if (this.transactionID == -1L) {
            boolean bl = false;
            while (!bl) {
                try {
                    this.transactionID = jMQXid == null ? this.protocolHandler.startTransaction(this.getNextTransactionID(), n, jMQXid, this.session.getBrokerSessionID()) : this.protocolHandler.startTransaction(this.getNextTransactionID(), n, jMQXid);
                    bl = true;
                }
                catch (JMSException jMSException) {
                    String string = jMSException.getErrorCode();
                    if (string == "C4028") continue;
                    throw jMSException;
                }
            }
            if (jMQXid != null) {
                this.jmqXid = jMQXid;
            }
        } else {
            this.transactionID = this.protocolHandler.startTransaction(this.jmqXid != null && this.jmqXid.equals(jMQXid) ? this.transactionID : 0L, n, jMQXid);
            if (jMQXid != null) {
                this.jmqXid = jMQXid;
            }
        }
    }

    protected void releaseBrokerResource() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
    }

    private int getNextTransactionID() throws JMSException {
        return this.session.connection.getNextTransactionID();
    }

    protected synchronized long getTransactionID() {
        return this.transactionID;
    }

    public synchronized void setTransactionID(long l) {
        this.transactionID = l;
    }
}

