/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionRecover;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.QueueReceiverImpl;
import com.sun.messaging.jmq.jmsclient.ReadQTable;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.TopicSubscriberImpl;
import com.sun.messaging.jmq.util.DebugPrinter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;

public class ReadChannel
implements Runnable {
    private ConnectionImpl connection = null;
    private ProtocolHandler protocolHandler = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected InterestTable interestTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isClosed = false;
    protected boolean receivedGoodByeReply = false;
    protected FlowControl flowControl = null;
    protected boolean protectMode = false;
    protected static final String iMQReadChannel = "iMQReadChannel-";
    private boolean reconnect = false;
    private boolean isFatalErrorSet = false;
    private Throwable savedError = null;
    private boolean fatalErrorIsProcessed = false;
    private boolean debug = Debug.debug;

    ReadChannel(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        this.protocolHandler = connectionImpl.getProtocolHandler();
        this.interestTable = connectionImpl.interestTable;
        this.readQTable = connectionImpl.readQTable;
        this.ackQTable = connectionImpl.ackQTable;
        this.requestMetaData = connectionImpl.requestMetaData;
        this.init();
    }

    private void init() {
        String string = this.connection.getProperty("imqReconnectEnabled");
        if (Boolean.valueOf(string).booleanValue()) {
            this.reconnect = true;
        }
        this.protectMode = this.connection.getProtectMode();
        this.connection.flowControl = this.flowControl = new FlowControl(this.connection);
        this.flowControl.start();
        Thread thread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            thread.setDaemon(true);
        }
        thread.setName(iMQReadChannel + this.connection.getLocalID());
        thread.start();
    }

    private void dispatch(ReadWritePacket readWritePacket) throws JMSException {
        switch (readWritePacket.getPacketType()) {
            case 54: {
                this.protocolHandler.pingReply(readWritePacket);
                break;
            }
            case 15: 
            case 27: {
                this.replaceConsumerID(readWritePacket);
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 11: {
                this.replaceConnectionID(readWritePacket);
                this.updateBrokerVersionInfo(readWritePacket);
                this.processAcknowledge(readWritePacket);
                this.connection.writeChannel.updateFlowControl(readWritePacket);
                break;
            }
            case 19: {
                this.replaceProducerID(readWritePacket);
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 9: 
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 67: 
            case 69: 
            case 71: 
            case 77: {
                this.processAcknowledge(readWritePacket);
                break;
            }
            case 29: {
                this.processAcknowledge(readWritePacket);
                this.receivedGoodByeReply = true;
                this.close();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.processJMSMessage(readWritePacket);
                break;
            }
            case 52: {
                this.processResumeFlow(readWritePacket);
                break;
            }
            case 28: {
                this.processBrokerGoodbye(readWritePacket);
                break;
            }
            case 74: {
                this.processDebug(readWritePacket);
                break;
            }
            default: {
                if (this.isClosed) break;
                String string = AdministeredObject.cr.getKString("W2000");
                Debug.getPrintStream().println(string);
                readWritePacket.dump(Debug.getPrintStream());
            }
        }
    }

    protected void processDebug(ReadWritePacket readWritePacket) {
        try {
            InputStream inputStream = readWritePacket.getMessageBodyStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Hashtable hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            inputStream.close();
            DebugPrinter debugPrinter = new DebugPrinter(2);
            String string = (String)hashtable.get("file");
            debugPrinter.setFile(string);
            String string2 = (String)hashtable.get("verbose");
            boolean bl = Boolean.valueOf(string2);
            Hashtable hashtable2 = this.connection.getDebugState(bl);
            hashtable2.put("DebugCmd", hashtable);
            debugPrinter.setHashtable(hashtable2);
            debugPrinter.println();
            debugPrinter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processBrokerGoodbye(ReadWritePacket readWritePacket) throws JMSException {
        Object object;
        Boolean bl = null;
        try {
            object = readWritePacket.getProperties();
            if (object != null) {
                bl = (Boolean)((Hashtable)object).get("JMQExit");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.connection.imqReconnect || bl != null && bl.booleanValue()) {
            object = AdministeredObject.cr.getKString("C4056");
            JMSException jMSException = new JMSException((String)object, "C4056");
            this.exitConnection(jMSException);
        }
    }

    private void updateBrokerVersionInfo(ReadWritePacket readWritePacket) throws JMSException {
        try {
            int n;
            Integer n2;
            Hashtable hashtable = readWritePacket.getProperties();
            String string = (String)hashtable.get("JMQVersion");
            if (string != null) {
                this.connection.setBrokerVersion(string);
            }
            if ((n2 = (Integer)hashtable.get("JMQProtocolLevel")) != null) {
                this.connection.setBrokerProtocolLevel(n2);
            }
            if ((n = ((Integer)hashtable.get("JMQStatus")).intValue()) == 505 && this.connection.checkBrokerProtocolLevel()) {
                this.connection.setNegotiateProtocolLevel(true);
                this.close();
            }
        }
        catch (Exception exception) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(exception, "C4000", true);
        }
    }

    protected void replaceConnectionID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Hashtable hashtable = readWritePacket.getProperties();
            Long l = (Long)hashtable.get("JMQConnectionID");
            if (l != null) {
                this.connection.setConnectionID(l);
            }
        }
        catch (Exception exception) {
            ExceptionHandler cfr_ignored_0 = this.connection.exceptionHandler;
            ExceptionHandler.handleException(exception, "C4000", true);
        }
    }

    protected void replaceProducerID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Long l;
            Hashtable hashtable = readWritePacket.getProperties();
            Long l2 = new Long(readWritePacket.getConsumerID());
            Long l3 = (Long)hashtable.get("JMQProducerID");
            MessageProducerImpl messageProducerImpl = (MessageProducerImpl)this.requestMetaData.get(l2);
            this.requestMetaData.remove(l2);
            if (l3 == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No producer for packet: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                return;
            }
            int n = -1;
            long l4 = -1L;
            Integer n2 = (Integer)hashtable.get("JMQSize");
            if (n2 != null) {
                n = n2;
            }
            if ((l = (Long)hashtable.get("JMQBytes")) != null) {
                l4 = l;
            }
            long l5 = l3;
            Destination destination = messageProducerImpl.addProducerDest;
            messageProducerImpl.setProducerID(destination, l5);
            messageProducerImpl.setFlowLimit(l5, n);
            messageProducerImpl.setFlowBytesLimit(l5, l4);
        }
        catch (Exception exception) {
            exception.printStackTrace(Debug.getPrintStream());
        }
    }

    protected void replaceConsumerID(ReadWritePacket readWritePacket) throws JMSException {
        try {
            int n;
            Hashtable hashtable = readWritePacket.getProperties();
            Long l = new Long(readWritePacket.getConsumerID());
            Long l2 = (Long)hashtable.get("JMQConsumerID");
            Consumer consumer = (Consumer)this.requestMetaData.get(l);
            this.requestMetaData.remove(l);
            if (l2 == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No consumer for packet: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                return;
            }
            this.interestTable.removeInterest(consumer);
            consumer.setInterestId(l2);
            Integer n2 = (Integer)hashtable.get("JMQDestType");
            consumer.setDestType(n2);
            this.interestTable.addInterest(consumer);
            Integer n3 = (Integer)hashtable.get("JMQSize");
            if (n3 != null && (n = n3.intValue()) > 0) {
                consumer.setPrefetchMaxMsgCount(n);
            }
            this.connection.flowControl.addConsumerFlowControl(consumer);
            SessionImpl sessionImpl = null;
            if (readWritePacket.getPacketType() == 15) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl topicSubscriberImpl = (TopicSubscriberImpl)consumer;
                    sessionImpl = topicSubscriberImpl.getSession();
                    sessionImpl.addMessageConsumer((MessageConsumerImpl)consumer);
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl queueReceiverImpl = (QueueReceiverImpl)consumer;
                    sessionImpl = queueReceiverImpl.getSession();
                    sessionImpl.addMessageConsumer((MessageConsumerImpl)consumer);
                }
            } else {
                BrowserConsumer browserConsumer = (BrowserConsumer)consumer;
                sessionImpl = browserConsumer.getSession();
                sessionImpl.addBrowserConsumer(browserConsumer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void processResumeFlow(ReadWritePacket readWritePacket) throws JMSException {
        try {
            Hashtable hashtable = readWritePacket.getProperties();
            Integer n = (Integer)hashtable.get("JMQSize");
            Long l = (Long)hashtable.get("JMQBytes");
            Long l2 = (Long)hashtable.get("JMQProducerID");
            if (this.debug) {
                Debug.println("processResumeFlow() : JMQSize = " + n + ", JMQBytes = " + l + ", ProducerID = " + l2);
            }
            if (l2 != null) {
                MessageProducerImpl messageProducerImpl = this.connection.findMessageProducer(l2);
                if (messageProducerImpl != null) {
                    if (n != null) {
                        messageProducerImpl.setFlowLimit(l2, n);
                    }
                    if (l != null) {
                        messageProducerImpl.setFlowBytesLimit(l2, l);
                    }
                } else if (this.debug) {
                    Debug.info("*** warning: Cannot find producer for the resume pkt: ");
                    readWritePacket.dump(Debug.getPrintStream());
                    this.connection.printDebugState();
                }
            } else {
                if (this.debug) {
                    Debug.info("Connection Resume Flow pkt dump: ");
                    readWritePacket.dump(Debug.getPrintStream());
                }
                this.connection.writeChannel.updateFlowControl(readWritePacket);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    protected void processJMSMessage(ReadWritePacket readWritePacket) throws JMSException {
        long l;
        SessionQueue sessionQueue = null;
        Consumer consumer = null;
        Long l2 = null;
        this.flowControl.messageReceived();
        if (readWritePacket.getFlowPaused()) {
            this.flowControl.requestConnectionFlowResume();
        }
        if ((consumer = this.interestTable.getConsumer(new Long(l = readWritePacket.getConsumerID()))) != null) {
            l2 = consumer.getReadQueueId();
            if (l2 != null) {
                sessionQueue = this.readQTable.get(l2);
                if (sessionQueue != null) {
                    this.flowControl.messageReceived(consumer);
                    if (readWritePacket.getConsumerFlow()) {
                        this.flowControl.requestResume(consumer);
                    }
                    if (consumer instanceof BrowserConsumer) {
                        this.deliverToBrowserConsumer((BrowserConsumer)consumer, readWritePacket);
                    } else {
                        sessionQueue.enqueueNotify(readWritePacket);
                    }
                } else {
                    String string = AdministeredObject.cr.getKString("W2001");
                    Debug.println(string);
                    readWritePacket.dump(Debug.getPrintStream());
                }
            } else {
                Debug.getPrintStream().println("ERROR: NO session (null) for packet: ");
                readWritePacket.dump(Debug.getPrintStream());
            }
        } else if (this.debug) {
            Debug.getPrintStream().println("ERROR: NO consumer for packet: ");
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    protected void deliverToBrowserConsumer(BrowserConsumer browserConsumer, ReadOnlyPacket readOnlyPacket) throws JMSException {
        MessageImpl messageImpl = this.protocolHandler.getJMSMessage(readOnlyPacket);
        SessionImpl sessionImpl = browserConsumer.session;
        messageImpl.setSession(sessionImpl);
        browserConsumer.onMessage(messageImpl);
    }

    protected void processAcknowledge(ReadWritePacket readWritePacket) throws JMSException {
        long l = readWritePacket.getConsumerID();
        SessionQueue sessionQueue = this.ackQTable.get(new Long(l));
        if (sessionQueue != null) {
            sessionQueue.enqueueNotify(readWritePacket);
        } else {
            String string = AdministeredObject.cr.getKString("W2001");
            Debug.println(string);
            readWritePacket.dump(Debug.getPrintStream());
        }
    }

    protected synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flowControl.close();
    }

    protected void abort() {
        this.reconnect = false;
    }

    public void run() {
        ReadWritePacket readWritePacket = null;
        while (!this.isClosed) {
            try {
                readWritePacket = this.protocolHandler.readPacket();
                if (this.isFatalErrorSet) {
                    this.fatalError(this.savedError);
                    return;
                }
                this.dispatch(readWritePacket);
            }
            catch (JMSException jMSException) {
                if (this.connection.isClosed || this.receivedGoodByeReply) {
                    this.connection.connectionIsBroken = true;
                    if (this.debug) {
                        Debug.println("ReadChannel[connection closed=" + this.connection.isClosed + ", received goodbye-reply=" + this.receivedGoodByeReply + "] : " + jMSException.getMessage());
                        Debug.printStackTrace((Exception)((Object)jMSException));
                    }
                    this.closeIOAndNotify();
                    return;
                }
                this.connection.setRecoverInProcess(true);
                boolean bl = false;
                if (this.reconnect) {
                    bl = this.recover();
                }
                this.connection.setRecoverInProcess(false);
                if (bl) continue;
                this.exitConnection(jMSException);
            }
            catch (Throwable throwable) {
                this.fatalError(throwable);
            }
        }
        if (this.debug) {
            Debug.println("ReadChannel exit ...");
        }
    }

    protected synchronized void setFatalError(Throwable throwable) {
        try {
            if (this.isFatalErrorSet) {
                return;
            }
            this.isFatalErrorSet = true;
            this.savedError = throwable;
            this.protocolHandler.close();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fatalError(Throwable throwable) {
        try {
            Object object = this;
            synchronized (object) {
                block11: {
                    if (!this.fatalErrorIsProcessed) break block11;
                    return;
                }
                this.fatalErrorIsProcessed = true;
            }
            this.connection.connectionIsBroken = true;
            this.readQTable.closeAll();
            object = AdministeredObject.cr.getKString("C4089", throwable.toString());
            JMSException jMSException = new JMSException((String)object, "C4089");
            this.exitConnection(jMSException);
        }
        catch (Throwable throwable2) {
            if (Debug.debug) {
                throwable2.printStackTrace();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    protected boolean recover() {
        boolean bl = false;
        ConnectionRecover connectionRecover = null;
        try {
            this.connection.checkAndSetReconnecting();
            this.closeIOAndNotify();
            connectionRecover = new ConnectionRecover(this.connection);
            this.protocolHandler.init(true);
            bl = true;
        }
        catch (Exception exception) {
            this.connection.setReconnecting(false);
        }
        if (bl) {
            connectionRecover.start();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exitConnection(JMSException jMSException) {
        block9: {
            block8: {
                this.connection.connectionIsBroken = true;
                try {
                    this.closeIOAndNotify();
                    this.connection.exitConnection();
                    this.flowControl.close();
                    Object var3_2 = null;
                    this.isClosed = true;
                    if (this.connection.exceptionListener == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.isClosed = true;
                    if (this.connection.exceptionListener != null) {
                        this.connection.exceptionListener.onException(jMSException);
                    } else {
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null && this.protocolHandler.authenticated) {
                            Debug.printStackTrace(exception);
                        }
                        if (this.protocolHandler.authenticated) {
                            Debug.printStackTrace((Exception)((Object)jMSException));
                        }
                    }
                    throw throwable;
                }
                this.connection.exceptionListener.onException(jMSException);
                break block9;
            }
            Exception exception = jMSException.getLinkedException();
            if (exception != null && this.protocolHandler.authenticated) {
                Debug.printStackTrace(exception);
            }
            if (this.protocolHandler.authenticated) {
                Debug.printStackTrace((Exception)((Object)jMSException));
            }
        }
    }

    protected void closeIOAndNotify() {
        block2: {
            try {
                this.protocolHandler.close();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                Debug.printStackTrace(exception);
            }
        }
        this.readQTable.notifyAllQueues();
        this.ackQTable.notifyAllQueues();
    }
}

