/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ConsoleHelp;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.util.Globals;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.DefaultHelpBroker;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class AdminDialog
extends JDialog
implements ActionListener {
    public static final int OK = 1;
    public static final int APPLY = 2;
    public static final int CLEAR = 4;
    public static final int RESET = 8;
    public static final int CANCEL = 16;
    public static final int CLOSE = 32;
    public static final int HELP = 64;
    private EventListenerList aListeners = new EventListenerList();
    private int whichButtons = 0;
    protected JPanel buttonPanel = null;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JButton closeButton = null;
    protected JButton clearButton = null;
    protected JButton resetButton = null;
    protected JButton applyButton = null;
    protected JButton helpButton = null;
    private static boolean helpDisplayed = false;
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    static /* synthetic */ Class class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener;

    public AdminDialog(Frame frame, String string) {
        this(frame, string, 81);
    }

    public AdminDialog(Frame frame, String string, int n) {
        super(frame, string, true);
        this.whichButtons = n;
        this.initContentPane(true);
        this.pack();
    }

    public AdminDialog(Frame frame, String string, int n, boolean bl) {
        super(frame, string, true);
        this.whichButtons = n;
        this.initContentPane(bl);
        this.pack();
    }

    public void addAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.add(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = AdminDialog.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    public void removeAdminEventListener(AdminEventListener adminEventListener) {
        this.aListeners.remove(class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener = AdminDialog.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener")) : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener, adminEventListener);
    }

    public void fireAdminEventDispatched(AdminEvent adminEvent) {
        Object[] objectArray = this.aListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener == null ? AdminDialog.class$("com.sun.messaging.jmq.admin.apps.console.event.AdminEventListener") : class$com$sun$messaging$jmq$admin$apps$console$event$AdminEventListener)) continue;
            ((AdminEventListener)objectArray[i + 1]).adminEventDispatched(adminEvent);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.doOK();
        } else if (object == this.applyButton) {
            this.doApply();
        } else if (object == this.cancelButton) {
            this.doCancel();
        } else if (object == this.closeButton) {
            this.doClose();
        } else if (object == this.clearButton) {
            this.doClear();
        } else if (object == this.resetButton) {
            this.doReset();
        } else if (object == this.helpButton) {
            this.doHelp();
        }
    }

    private void initContentPane(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bl) {
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        JPanel jPanel2 = this.createWorkPanel();
        this.buttonPanel = this.createButtonPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(jPanel);
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        if (this.useButton(1)) {
            this.okButton = new JButton(acr.getString("A1076"));
            this.okButton.addActionListener(this);
            jPanel.add(this.okButton);
        }
        if (this.useButton(2)) {
            this.applyButton = new JButton(acr.getString("A1077"));
            this.applyButton.addActionListener(this);
            jPanel.add(this.applyButton);
        }
        if (this.useButton(4)) {
            this.clearButton = new JButton(acr.getString("A1078"));
            this.clearButton.addActionListener(this);
            jPanel.add(this.clearButton);
        }
        if (this.useButton(8)) {
            this.resetButton = new JButton(acr.getString("A1079"));
            this.resetButton.addActionListener(this);
            jPanel.add(this.resetButton);
        }
        if (this.useButton(16)) {
            this.cancelButton = new JButton(acr.getString("A1080"));
            this.cancelButton.addActionListener(this);
            jPanel.add(this.cancelButton);
        }
        if (this.useButton(32)) {
            this.closeButton = new JButton(acr.getString("A1081"));
            this.closeButton.addActionListener(this);
            jPanel.add(this.closeButton);
        }
        if (this.useButton(64)) {
            this.helpButton = new JButton(acr.getString("A1082"));
            this.helpButton.setEnabled(false);
            this.helpButton.addActionListener(this);
            jPanel.add(this.helpButton);
        }
        return jPanel;
    }

    public void setHelpId(String string) {
        if (this.helpButton == null) {
            return;
        }
        if (ConsoleHelp.helpLoaded()) {
            HelpBroker helpBroker = ConsoleHelp.hb[0];
            HelpSet helpSet = ConsoleHelp.hs[0];
            this.helpButton.addActionListener((ActionListener)ConsoleHelp.hl[0]);
            helpBroker.enableHelp((Component)this.helpButton, string, helpSet);
            this.helpButton.setEnabled(true);
        }
    }

    public void setDefaultButton(int n) {
        JButton jButton = null;
        if (this.useButton(1)) {
            jButton = this.okButton;
        } else if (this.useButton(2)) {
            jButton = this.applyButton;
        } else if (this.useButton(4)) {
            jButton = this.clearButton;
        } else if (this.useButton(8)) {
            jButton = this.resetButton;
        } else if (this.useButton(16)) {
            jButton = this.cancelButton;
        } else if (this.useButton(32)) {
            jButton = this.closeButton;
        } else if (this.useButton(64)) {
            jButton = this.helpButton;
        }
        if (jButton != null) {
            this.getRootPane().setDefaultButton(jButton);
        }
    }

    public void hide() {
        if (helpDisplayed) {
            HelpBroker helpBroker = ConsoleHelp.hb[0];
            ((DefaultHelpBroker)helpBroker).setActivationWindow(null);
            helpBroker.setDisplayed(false);
        }
        super.hide();
    }

    private boolean useButton(int n) {
        return (this.whichButtons & n) == n;
    }

    public abstract JPanel createWorkPanel();

    public abstract void doOK();

    public abstract void doApply();

    public abstract void doCancel();

    public abstract void doClose();

    public abstract void doClear();

    public abstract void doReset();

    public void doHelp() {
        HelpBroker helpBroker = ConsoleHelp.hb[0];
        ((DefaultHelpBroker)helpBroker).setActivationWindow((Window)this);
        helpBroker.setDisplayed(true);
        helpDisplayed = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

