/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.ejb.Container;
import com.sun.ejb.ee.sfsb.store.BaseSFSBStoreManager;
import com.sun.ejb.ee.sfsb.store.EJBModuleStatistics;
import com.sun.ejb.ee.sfsb.store.EJBStoreBase;
import com.sun.ejb.ee.sfsb.store.HASFSBStoreManager;
import com.sun.ejb.ee.sfsb.store.SFSBStoreConnectionUtil;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.hadb.jdbc.LOBDescr;
import com.sun.logging.LogDomains;
import java.io.DataInputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HAEjbStore
extends EJBStoreBase {
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    public static String blobSfsbTable = "statefulsessionbean";
    private static int CHUNK_SIZE = 100;
    private PreparedStatement preparedInsertSqlNoCommit = null;
    private PreparedStatement preparedUpdateSqlNoCommit = null;
    private PreparedStatement preparedExpiredKeysSql = null;
    protected SFSBStoreManager manager;
    private Container container = null;
    private String clusterID = null;
    private String containerID = null;
    private ConnectionUtil connectionUtilEjb = null;
    protected Connection conn = null;
    protected HAErrorManager haErr = null;
    protected HAErrorManager haErrAggregateSave = null;
    protected HAErrorManager haErrLoad = null;
    protected HAErrorManager haErrRemove = null;
    protected HAErrorManager haErrRemoveExpired = null;
    protected HAErrorManager haErrExpiredKeys = null;
    protected HAErrorManager haErrGetBeanIds = null;
    protected HAErrorManager haErrRemoveAllBeans = null;
    protected HAErrorManager haErrUpdateAccessTime = null;
    protected int _debug = 1;
    private LOBDescr insertLob = new LOBDescr();
    private LOBDescr loadLob = new LOBDescr();
    private LOBDescr updateLob = new LOBDescr();

    public HAEjbStore() {
        info = "HAEjbStore/1.0";
        this.threadName = "HAEjbStore";
        storeName = "HAEjbStore";
        this.insertLob.setTableName(blobSfsbTable);
        this.insertLob.addKey("id", 1);
        this.insertLob.setLOBColumn("beandata", 4);
        this.loadLob.setTableName(blobSfsbTable);
        this.loadLob.addKey("id", 1);
        this.loadLob.setLOBColumn("beandata", 2);
        this.updateLob.setTableName(blobSfsbTable);
        this.updateLob.addKey("id", 5);
        this.updateLob.setLOBColumn("beandata", 3);
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        this.haErrAggregateSave = new HAErrorManager(timeout, this.threadName);
        this.haErrLoad = new HAErrorManager(timeout, this.threadName);
        this.haErrRemove = new HAErrorManager(timeout, this.threadName);
        this.haErrRemoveAllBeans = new HAErrorManager(timeout, this.threadName);
        this.haErrRemoveExpired = new HAErrorManager(timeout, this.threadName);
        this.haErrExpiredKeys = new HAErrorManager(timeout, this.threadName);
        this.haErrGetBeanIds = new HAErrorManager(timeout, this.threadName);
        this.haErrUpdateAccessTime = new HAErrorManager(timeout, this.threadName);
    }

    protected boolean isMonitoringEnabled() {
        BaseSFSBStoreManager mgr = (BaseSFSBStoreManager)this.getSFSBStoreManager();
        return mgr.isMonitoringEnabled();
    }

    protected EJBModuleStatistics getEJBModuleStatistics() {
        BaseSFSBStoreManager mgr = (BaseSFSBStoreManager)this.getSFSBStoreManager();
        return mgr.getEJBModuleStatistics();
    }

    protected ConnectionUtil getConnectionUtil() {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "getConnectionUtil");
        }
        if (this.connectionUtilEjb == null) {
            this.connectionUtilEjb = new SFSBStoreConnectionUtil(this.container, this.manager);
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "getConnectionUtil", this.connectionUtilEjb);
        }
        return this.connectionUtilEjb;
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HAEjb store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HAEjb store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected void debug(String message) {
        System.out.println(message);
    }

    public Container getContainer() {
        return this.container;
    }

    protected String getContainerId() {
        return this.containerID;
    }

    protected void setContainerId(String containerId) {
        this.containerID = containerId;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void save(SFSBBeanState sfsBean, SFSBStoreManager mgr, boolean isNew) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "save", new Object[]{sfsBean, mgr});
        }
        this.manager = mgr;
        this.save(sfsBean, isNew);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "save");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(SFSBBeanState sfsBean, boolean isNew) throws IOException {
        block23: {
            block24: {
                block21: {
                    block20: {
                        if (HAEjbStore._logger.isLoggable(Level.FINER)) {
                            HAEjbStore._logger.entering("HAEjbStore", "save", sfsBean);
                        }
                        connGroup = null;
                        internalConn = null;
                        externalConn = null;
                        stats = this.getEJBModuleStatistics();
                        try {
                            try {
                                if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                                    HAEjbStore._logger.log(Level.FINEST, "HAEjbStore.  save  " + sfsBean + "  bean isNew=" + isNew);
                                }
                                getConnStartTime = 0L;
                                if (this.isMonitoringEnabled()) {
                                    getConnStartTime = System.currentTimeMillis();
                                }
                                util = this.getConnectionUtil();
                                connGroup = util.getConnectionsFromPool(true);
                                if (this.isMonitoringEnabled()) {
                                    getConnEndTime = System.currentTimeMillis();
                                    stats.processGetConnectionFromPool(getConnEndTime - getConnStartTime);
                                }
                                if (connGroup == null) {
                                    if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                                        HAEjbStore._logger.log(Level.FINEST, "HAEjbStore:  connGroup is null");
                                    }
                                    var13_12 = null;
                                    if (externalConn == null) {
                                        return;
                                    }
                                    break block20;
                                }
                                internalConn = connGroup._internalConn;
                                externalConn = connGroup._externalConn;
                                if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                                    HAEjbStore._logger.log(Level.FINEST, "HAEjbStore.  save  : is .isnew =" + isNew);
                                }
                                if (isNew) {
                                    this.insertSFSBean(sfsBean, internalConn);
                                } else {
                                    this.updateSFSBean(sfsBean, internalConn);
                                }
                                try {
                                    externalConn.close();
                                }
                                catch (SQLException ex) {
                                    ex.printStackTrace();
                                }
                                externalConn = null;
                                break block21;
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                throw ex;
                            }
                        }
                        catch (Throwable var12_18) {
                            var13_14 = null;
                            if (externalConn == null) throw var12_18;
                            try {
                                externalConn.close();
                            }
                            catch (SQLException ex) {
                                ex.printStackTrace();
                            }
                            externalConn = null;
                            throw var12_18;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [6 : 291->301)] { 
lbl59:
                    // 1 sources

                    externalConn.close();
                    return;
lbl61:
                    // 1 sources

                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                var13_13 = null;
                if (externalConn == null) break block23;
                ** try [egrp 3[TRYBLOCK] [6 : 291->301)] { 
lbl68:
                // 1 sources

                externalConn.close();
                break block24;
lbl70:
                // 1 sources

                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            externalConn = null;
        }
        if (HAEjbStore._logger.isLoggable(Level.FINER) == false) return;
        HAEjbStore._logger.exiting("HAEjbStore", "save");
    }

    public void save(SFSBBeanState[] beanStates, long startTime) throws IOException {
        HADBConnectionGroup connGroup;
        long getConnDuration = 0L;
        long getConnStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            getConnStartTime = System.currentTimeMillis();
        }
        if ((connGroup = this.getConnectionGroup()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore:  connGroup is null");
            }
            return;
        }
        if (this.isMonitoringEnabled()) {
            getConnDuration = System.currentTimeMillis() - getConnStartTime;
            getConnDuration = beanStates.length != 0 ? (getConnDuration /= (long)beanStates.length) : 0L;
        }
        this.save(beanStates, connGroup, startTime, getConnDuration);
    }

    /*
     * Loose catch block
     */
    public void save(SFSBBeanState[] beanStates, HADBConnectionGroup connGroup, long startTime, long getConnDuration) throws IOException {
        block34: {
            SQLException ex222;
            Connection externalConn;
            Connection internalConn;
            block30: {
                internalConn = null;
                externalConn = null;
                long eachStartTime = startTime;
                long eachEndTime = 0L;
                this.haErrAggregateSave.txStart();
                while (!this.haErrAggregateSave.isTxCompleted()) {
                    try {
                        internalConn = connGroup._internalConn;
                        externalConn = connGroup._externalConn;
                        for (int i = 0; i < beanStates.length; ++i) {
                            SFSBBeanState sfsBean = beanStates[i];
                            boolean isNew = sfsBean.isNew();
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINEST, "HAEjbStore.  aggregate save  : is .isnew =" + isNew);
                            }
                            if (isNew) {
                                this.insertSFSBeanNoCommit(sfsBean, internalConn);
                            } else {
                                this.updateSFSBeanNoCommit(sfsBean, internalConn);
                            }
                            if (!this.isMonitoringEnabled()) continue;
                            eachEndTime = System.currentTimeMillis();
                            long storeDuration = eachEndTime - eachStartTime;
                            sfsBean.setTxCheckpointDuration(sfsBean.getTxCheckpointDuration() + storeDuration + getConnDuration);
                            eachStartTime = eachEndTime;
                        }
                        internalConn.commit();
                        if (this.preparedInsertSqlNoCommit != null) {
                            this.preparedInsertSqlNoCommit.close();
                            this.preparedInsertSqlNoCommit = null;
                        }
                        if (this.preparedUpdateSqlNoCommit != null) {
                            this.preparedUpdateSqlNoCommit.close();
                            this.preparedUpdateSqlNoCommit = null;
                        }
                        externalConn.close();
                        externalConn = null;
                        this.haErrAggregateSave.txEnd();
                    }
                    catch (SQLException e) {
                        this.haErrAggregateSave.checkError(e, internalConn);
                    }
                }
                Object var19_19 = null;
                if (this.preparedInsertSqlNoCommit == null) break block30;
                try {
                    this.preparedInsertSqlNoCommit.close();
                }
                catch (SQLException ex222) {
                    ex222.printStackTrace();
                }
                this.preparedInsertSqlNoCommit = null;
            }
            if (this.preparedUpdateSqlNoCommit != null) {
                try {
                    this.preparedUpdateSqlNoCommit.close();
                }
                catch (SQLException ex222) {
                    ex222.printStackTrace();
                }
                this.preparedUpdateSqlNoCommit = null;
            }
            if (externalConn == null) break block34;
            try {
                externalConn.close();
            }
            catch (SQLException ex222) {
                ex222.printStackTrace();
            }
            externalConn = null;
            {
                break block34;
                catch (SQLException ex3) {
                    ex3.printStackTrace();
                    try {
                        internalConn.rollback();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    IOException ex1 = (IOException)new IOException("SQL Error from HAEjbStore-aggregate save: " + ex3.getMessage()).initCause(ex3);
                    throw ex1;
                }
                catch (HATimeoutException tex) {
                    IOException ex23 = (IOException)new IOException("Timeout from HAEjbStore-aggregate save: " + tex.getMessage()).initCause(tex);
                    throw ex23;
                }
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (this.preparedInsertSqlNoCommit != null) {
                    try {
                        this.preparedInsertSqlNoCommit.close();
                    }
                    catch (SQLException ex222) {
                        ex222.printStackTrace();
                    }
                    this.preparedInsertSqlNoCommit = null;
                }
                if (this.preparedUpdateSqlNoCommit != null) {
                    try {
                        this.preparedUpdateSqlNoCommit.close();
                    }
                    catch (SQLException ex222) {
                        ex222.printStackTrace();
                    }
                    this.preparedUpdateSqlNoCommit = null;
                }
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex222) {
                        ex222.printStackTrace();
                    }
                    externalConn = null;
                }
                throw throwable;
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "save");
        }
    }

    public HADBConnectionGroup getConnectionGroup() throws IOException {
        HADBConnectionGroup connGroup = null;
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long getConnStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            getConnStartTime = System.currentTimeMillis();
        }
        try {
            ConnectionUtil util = this.getConnectionUtil();
            connGroup = util.getConnectionsFromPool();
            if (connGroup == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "HAEjbStore:  connGroup is null");
                }
                return connGroup;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        if (this.isMonitoringEnabled()) {
            long getConnEndTime = System.currentTimeMillis();
            stats.processGetConnectionFromPool(getConnEndTime - getConnStartTime);
        }
        return connGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SFSBBeanState loadBean(Object id) throws IOException {
        SFSBBeanState bean;
        block23: {
            SFSBBeanState sFSBBeanState;
            Connection externalConn;
            block21: {
                Connection internalConn;
                HADBConnectionGroup connGroup;
                block18: {
                    SFSBBeanState getConnEndTime22;
                    block19: {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.entering("HAEjbStore", "loadBean", id);
                        }
                        if (id == null) {
                            return null;
                        }
                        bean = null;
                        connGroup = null;
                        internalConn = null;
                        externalConn = null;
                        EJBModuleStatistics stats = this.getEJBModuleStatistics();
                        long getConnStartTime = 0L;
                        if (this.isMonitoringEnabled()) {
                            getConnStartTime = System.currentTimeMillis();
                        }
                        ConnectionUtil util = this.getConnectionUtil();
                        connGroup = util.getConnectionsFromPool(true);
                        if (this.isMonitoringEnabled()) {
                            long getConnEndTime22 = System.currentTimeMillis();
                            stats.processGetConnectionFromPool(getConnEndTime22 - getConnStartTime);
                        }
                        if (connGroup != null) break block18;
                        _logger.log(Level.INFO, "HAEjbStore:  connGroup is null");
                        getConnEndTime22 = null;
                        Object var13_14 = null;
                        if (externalConn == null) break block19;
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex2) {
                            ex2.printStackTrace();
                        }
                        externalConn = null;
                    }
                    return getConnEndTime22;
                }
                internalConn = connGroup._internalConn;
                externalConn = connGroup._externalConn;
                bean = this.loadSFSBean(id, internalConn);
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                externalConn = null;
                sFSBBeanState = bean;
                Object var13_15 = null;
                if (externalConn == null) break block21;
                try {
                    externalConn.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                externalConn = null;
            }
            return sFSBBeanState;
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                    Object var13_16 = null;
                    if (externalConn == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (externalConn != null) {
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex2) {
                            ex2.printStackTrace();
                        }
                        externalConn = null;
                    }
                    throw throwable;
                }
                try {
                    externalConn.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                externalConn = null;
                {
                }
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "loadBean", bean);
        }
        return bean;
    }

    protected SFSBBeanState getSFSBean(ResultSet rst) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "getSFSBean", rst);
        }
        SFSBBeanState bean = null;
        String id = null;
        byte[] beandata = null;
        String clusterid = "";
        long lastaccess = 0L;
        String containerId = null;
        Object bis = null;
        long longContId = 0L;
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: getSFSBean ResultSet =" + rst);
            }
            id = rst.getString(1);
            Blob blob = rst.getBlob(2);
            clusterid = rst.getString(3);
            lastaccess = rst.getLong(4);
            containerId = rst.getString(5);
            longContId = Long.valueOf(containerId);
            int blobLen = (int)blob.length();
            beandata = new byte[blobLen];
            DataInputStream dis = new DataInputStream(blob.getBinaryStream());
            try {
                dis.readFully(beandata, 0, blobLen);
            }
            catch (IOException ex) {
                _logger.log(Level.FINE, "HAEjbStore: getSFSBean error getting blob data");
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id =" + id + " clusterid=" + clusterid + " lastaccess=" + lastaccess + " blob.length=" + blob.length() + " beandata.length=" + beandata.length + "   containerId=" + containerId);
            }
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
        SFSBStoreManager mgr = this.manager;
        bean = new SFSBBeanState(clusterid, longContId, (Object)id, lastaccess, false, beandata, mgr);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "getSFSBean", bean);
        }
        return bean;
    }

    protected SFSBBeanState getSFSBean(ResultSet rst, Object beanId) {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "getSFSBean", rst);
        }
        SFSBBeanState bean = null;
        String id = null;
        byte[] beandata = null;
        String clusterid = "";
        long lastaccess = 0L;
        String containerId = null;
        Object bis = null;
        long longContId = 0L;
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: getSFSBean ResultSet =" + rst);
            }
            id = rst.getString(1);
            Blob blob = rst.getBlob(2);
            clusterid = rst.getString(3);
            lastaccess = rst.getLong(4);
            containerId = rst.getString(5);
            longContId = Long.valueOf(containerId);
            int blobLen = (int)blob.length();
            beandata = new byte[blobLen];
            DataInputStream dis = new DataInputStream(blob.getBinaryStream());
            try {
                dis.readFully(beandata, 0, blobLen);
            }
            catch (IOException ex) {
                _logger.log(Level.FINE, "HAEjbStore: getSFSBean error getting blob data");
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id =" + id + " clusterid=" + clusterid + " lastaccess=" + lastaccess + " blob.length=" + blob.length() + " beandata.length=" + beandata.length + "   containerId=" + containerId);
            }
        }
        catch (SQLException sqe) {
            sqe.printStackTrace();
        }
        SFSBStoreManager mgr = this.manager;
        bean = new SFSBBeanState(clusterid, longContId, beanId, lastaccess, false, beandata, mgr);
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "getSFSBean", bean);
        }
        return bean;
    }

    private SFSBBeanState loadSFSBean(Object id, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "loadSFSBean", new Object[]{id, connection});
        }
        PreparedStatement preparedLoadSql = null;
        String loadSql = "SELECT  id, beandata, clusterid, lastaccess, containerid FROM " + blobSfsbTable + " WHERE id = ?";
        ResultSet rst = null;
        SFSBBeanState sfsBean = null;
        try {
            this.haErrLoad.txStart();
            while (!this.haErrLoad.isTxCompleted()) {
                try {
                    preparedLoadSql = connection.prepareStatement(loadSql);
                    preparedLoadSql.setString(1, id.toString());
                    rst = preparedLoadSql.executeQuery();
                    if (rst == null || !rst.next()) {
                        this.debug("No persisted data found for session " + id);
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.exiting("HAEjbStore", "loadSFSBean", null);
                        }
                        this.closePreparedStatement(preparedLoadSql);
                        return null;
                    }
                    sfsBean = this.getSFSBean(rst, id);
                    this.closePreparedStatement(preparedLoadSql);
                    this.haErrLoad.txEnd();
                }
                catch (SQLException e) {
                    this.haErrLoad.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
                this.closePreparedStatement(preparedLoadSql);
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-loadSFSBean: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        catch (Exception e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            e.printStackTrace();
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "loadSFSBean", sfsBean);
        }
        return sfsBean;
    }

    private void updateSFSBean(SFSBBeanState sfsb, Connection conn) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "updateSFSBean", new Object[]{sfsb, conn});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        Statement preparedUpdateSql = null;
        Object rst = null;
        String updateSFSBSql = "UPDATE " + blobSfsbTable + " SET clusterid = ?, lastaccess = ?, beandata = ?, containerid = ? where id=?";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HAEjbStore: updateSFSBSql is " + updateSFSBSql);
            _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id " + sfsb.getId() + "  class=  " + sfsb.getId().getClass());
        }
        long startPrepTime = 0L;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (this.isMonitoringEnabled()) {
                        startPrepTime = System.currentTimeMillis();
                    }
                    preparedUpdateSql = conn.prepareStatement(updateSFSBSql);
                    String id = sfsb.getId().toString();
                    int length = sfsb.getState().length;
                    preparedUpdateSql.setString(5, id);
                    preparedUpdateSql.setBytes(3, sfsb.getState());
                    preparedUpdateSql.setString(1, this.getClusterID());
                    preparedUpdateSql.setLong(2, sfsb.getLastAccess());
                    preparedUpdateSql.setString(4, this.getContainerId());
                    if (this.isMonitoringEnabled()) {
                        long endPrepTime = System.currentTimeMillis();
                        stats.processStatementPrepBlock(endPrepTime - startPrepTime);
                    }
                    long execStartTime = 0L;
                    if (this.isMonitoringEnabled()) {
                        execStartTime = System.currentTimeMillis();
                    }
                    preparedUpdateSql.executeUpdate();
                    if (this.isMonitoringEnabled()) {
                        long execEndTime = System.currentTimeMillis();
                        stats.processExecuteStatement(execEndTime - execStartTime);
                    }
                    preparedUpdateSql.close();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore:updateSFSBean========================Committed");
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, conn);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore-updateSFSBean: EXCEPTION HERE  " + preparedUpdateSql);
            }
            e.printStackTrace();
            try {
                conn.rollback();
                preparedUpdateSql.close();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore-updateSFSBean: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-updateSFSBean: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "updateSFSBean");
        }
    }

    private void updateSFSBeanNoCommit(SFSBBeanState sfsb, Connection conn) throws SQLException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "updateSFSBeanNoCommit", new Object[]{sfsb, conn});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        Object rst = null;
        String updateSFSBSql = "UPDATE " + blobSfsbTable + " SET clusterid = ?, lastaccess = ?, beandata = ?, containerid = ? where id=?";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HAEjbStore: updateSFSBSql is " + updateSFSBSql);
            _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id " + sfsb.getId() + "  class=  " + sfsb.getId().getClass());
        }
        long startPrepTime = 0L;
        try {
            if (this.isMonitoringEnabled()) {
                startPrepTime = System.currentTimeMillis();
            }
            if (this.preparedUpdateSqlNoCommit == null) {
                this.preparedUpdateSqlNoCommit = conn.prepareStatement(updateSFSBSql);
            }
            String id = sfsb.getId().toString();
            this.preparedUpdateSqlNoCommit.setString(5, id);
            this.preparedUpdateSqlNoCommit.setBytes(3, sfsb.getState());
            this.preparedUpdateSqlNoCommit.setString(1, this.getClusterID());
            this.preparedUpdateSqlNoCommit.setLong(2, sfsb.getLastAccess());
            this.preparedUpdateSqlNoCommit.setString(4, this.getContainerId());
            if (this.isMonitoringEnabled()) {
                long endPrepTime = System.currentTimeMillis();
                stats.processStatementPrepBlock(endPrepTime - startPrepTime);
            }
            long execStartTime = 0L;
            if (this.isMonitoringEnabled()) {
                execStartTime = System.currentTimeMillis();
            }
            this.preparedUpdateSqlNoCommit.executeUpdate();
            if (this.isMonitoringEnabled()) {
                long execEndTime = System.currentTimeMillis();
                stats.processExecuteStatement(execEndTime - execStartTime);
                stats.processCheckpointSave(execEndTime - saveStartTime);
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore-updateSFSBeanNoCommit:  " + this.preparedUpdateSqlNoCommit);
            }
            throw e;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "updateSFSBeanNoCommit");
        }
    }

    private void insertSFSBean(SFSBBeanState sfsb, Connection conn) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "insertSFSBean", new Object[]{sfsb, conn});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        Statement preparedInsertSql = null;
        Object rst = null;
        String insertSFSBSql = "INSERT INTO " + blobSfsbTable + " (id, clusterid, lastaccess, beandata, containerid) " + " VALUES (?, ?, ?, ?, ?) ";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HAEjbStore: insertSFSBSQL is " + insertSFSBSql);
            _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id " + sfsb.getId() + "  class=  " + sfsb.getId().getClass());
        }
        long startPrepTime = 0L;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (this.isMonitoringEnabled()) {
                        startPrepTime = System.currentTimeMillis();
                    }
                    preparedInsertSql = conn.prepareStatement(insertSFSBSql);
                    String id = sfsb.getId().toString();
                    int length = sfsb.getState().length;
                    preparedInsertSql.setString(1, id);
                    preparedInsertSql.setBytes(4, sfsb.getState());
                    preparedInsertSql.setString(2, this.getClusterID());
                    preparedInsertSql.setLong(3, sfsb.getLastAccess());
                    preparedInsertSql.setString(5, this.getContainerId());
                    if (this.isMonitoringEnabled()) {
                        long endPrepTime = System.currentTimeMillis();
                        stats.processStatementPrepBlock(endPrepTime - startPrepTime);
                    }
                    long execStartTime = 0L;
                    if (this.isMonitoringEnabled()) {
                        execStartTime = System.currentTimeMillis();
                    }
                    preparedInsertSql.executeUpdate();
                    if (this.isMonitoringEnabled()) {
                        long execEndTime = System.currentTimeMillis();
                        stats.processExecuteStatement(execEndTime - execStartTime);
                    }
                    preparedInsertSql.close();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore:::::::::::::::::::::::: Committed");
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, conn);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: EXCEPTION HERE  " + preparedInsertSql);
            }
            e.printStackTrace();
            try {
                conn.rollback();
                preparedInsertSql.close();
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjb store-insertSFSBean: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "insertSFSBean");
        }
    }

    private void insertSFSBeanNoCommit(SFSBBeanState sfsb, Connection conn) throws SQLException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "insertSFSBeanNoCommit", new Object[]{sfsb, conn});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        Object rst = null;
        String insertSFSBSql = "INSERT INTO " + blobSfsbTable + " (id, clusterid, lastaccess, beandata, containerid) " + " VALUES (?, ?, ?, ?, ?) ";
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HAEjbStore: insertSFSBSQL is " + insertSFSBSql);
            _logger.log(Level.FINEST, "HAEjbStore: SFSBBeanState id " + sfsb.getId() + "  class=  " + sfsb.getId().getClass());
        }
        long startPrepTime = 0L;
        try {
            if (this.isMonitoringEnabled()) {
                startPrepTime = System.currentTimeMillis();
            }
            if (this.preparedInsertSqlNoCommit == null) {
                this.preparedInsertSqlNoCommit = conn.prepareStatement(insertSFSBSql);
            }
            String id = sfsb.getId().toString();
            this.preparedInsertSqlNoCommit.setString(1, id);
            this.preparedInsertSqlNoCommit.setBytes(4, sfsb.getState());
            this.preparedInsertSqlNoCommit.setString(2, this.getClusterID());
            this.preparedInsertSqlNoCommit.setLong(3, sfsb.getLastAccess());
            this.preparedInsertSqlNoCommit.setString(5, this.getContainerId());
            if (this.isMonitoringEnabled()) {
                long endPrepTime = System.currentTimeMillis();
                stats.processStatementPrepBlock(endPrepTime - startPrepTime);
            }
            long execStartTime = 0L;
            if (this.isMonitoringEnabled()) {
                execStartTime = System.currentTimeMillis();
            }
            this.preparedInsertSqlNoCommit.executeUpdate();
            if (this.isMonitoringEnabled()) {
                long execEndTime = System.currentTimeMillis();
                stats.processExecuteStatement(execEndTime - execStartTime);
                stats.processCheckpointSave(execEndTime - saveStartTime);
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore: insertSFSBeanNoCommit: " + this.preparedInsertSqlNoCommit);
            }
            throw e;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "insertSFSBeanNoCommit");
        }
    }

    /*
     * Loose catch block
     */
    public void updateLastAccessTime(Object sessionKey, long time) throws IOException {
        block14: {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore.updateLastAccessTime id = " + sessionKey);
            }
            HADBConnectionGroup connGroup = null;
            Connection internalConn = null;
            Connection externalConn = null;
            ConnectionUtil util = this.getConnectionUtil();
            connGroup = util.getConnectionsFromPool(true);
            if (connGroup == null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "HAEjbStore>>updateLastAccessTime:  connGroup is null");
                }
                throw new IOException("failed to obtain connection in updateLastAccessTime: failed to update last access time for bean id: " + sessionKey.toString());
            }
            internalConn = connGroup._internalConn;
            externalConn = connGroup._externalConn;
            this.updateLastAccessTimeForBean(sessionKey, time, internalConn);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            externalConn = null;
            Object var11_9 = null;
            if (externalConn == null) break block14;
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            externalConn = null;
            {
                break block14;
                catch (IOException ex) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "updateLastAccessTime: failed to update last access time for bean id: " + sessionKey.toString());
                    }
                    ex.printStackTrace();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                    externalConn = null;
                }
                throw throwable;
            }
        }
    }

    private void updateLastAccessTimeForBean(Object sessionKey, long time, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "updateLastAccessTimeForBean", new Object[]{sessionKey, connection});
        }
        Object rst = null;
        String updateSFSBSql = "UPDATE " + blobSfsbTable + " SET lastaccess = ? where id=?";
        PreparedStatement preparedUpdateTSSql = null;
        try {
            this.haErrUpdateAccessTime.txStart();
            while (!this.haErrUpdateAccessTime.isTxCompleted()) {
                try {
                    preparedUpdateTSSql = connection.prepareStatement(updateSFSBSql);
                    preparedUpdateTSSql.setLong(1, time);
                    preparedUpdateTSSql.setString(2, sessionKey.toString());
                    preparedUpdateTSSql.executeUpdate();
                    preparedUpdateTSSql.close();
                    preparedUpdateTSSql = null;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore:updateLastAccessTimeForBean========================Committed");
                    }
                    this.haErrUpdateAccessTime.txEnd();
                }
                catch (SQLException e) {
                    this.haErrUpdateAccessTime.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore-updateLastAccessTimeForBean: EXCEPTION HERE  " + preparedUpdateTSSql);
            }
            e.printStackTrace();
            try {
                connection.rollback();
                preparedUpdateTSSql.close();
                preparedUpdateTSSql = null;
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore-updateLastAccessTimeForBean: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-updateLastAccessTimeForBean: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "updateLastAccessTimeForBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean remove(Object id) throws IOException {
        boolean result;
        block24: {
            boolean bl;
            Connection externalConn;
            block22: {
                Connection internalConn;
                HADBConnectionGroup connGroup;
                block19: {
                    boolean getConnEndTime22;
                    block20: {
                        if (_logger.isLoggable(Level.FINER)) {
                            _logger.entering("HAEjbStore", "remove", id);
                        }
                        connGroup = null;
                        internalConn = null;
                        externalConn = null;
                        result = false;
                        EJBModuleStatistics stats = this.getEJBModuleStatistics();
                        long getConnStartTime = 0L;
                        if (this.isMonitoringEnabled()) {
                            getConnStartTime = System.currentTimeMillis();
                        }
                        ConnectionUtil util = this.getConnectionUtil();
                        connGroup = this.getConnectionsFromPool();
                        if (this.isMonitoringEnabled()) {
                            long getConnEndTime22 = System.currentTimeMillis();
                            stats.processGetConnectionFromPool(getConnEndTime22 - getConnStartTime);
                        }
                        if (connGroup != null) break block19;
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, "HAEjbStore:  connGroup is null");
                        }
                        getConnEndTime22 = false;
                        Object var13_14 = null;
                        if (externalConn == null) break block20;
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex2) {
                            ex2.printStackTrace();
                        }
                        externalConn = null;
                    }
                    return getConnEndTime22;
                }
                internalConn = connGroup._internalConn;
                externalConn = connGroup._externalConn;
                result = this.removeSFSBean(id, internalConn);
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                externalConn = null;
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.exiting("HAEjbStore", "remove", new Boolean(result));
                }
                bl = result;
                Object var13_15 = null;
                if (externalConn == null) break block22;
                try {
                    externalConn.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                externalConn = null;
            }
            return bl;
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                    Object var13_16 = null;
                    if (externalConn == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (externalConn != null) {
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex2) {
                            ex2.printStackTrace();
                        }
                        externalConn = null;
                    }
                    throw throwable;
                }
                try {
                    externalConn.close();
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                }
                externalConn = null;
                {
                }
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.exiting("HAEjbStore", "remove", new Boolean(result));
        }
        return result;
    }

    private boolean removeSFSBean(Object id, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "removeSFSBean", new Object[]{id, connection});
        }
        int result = 0;
        String removeSql = "DELETE FROM " + blobSfsbTable + " WHERE id = ?";
        PreparedStatement preparedRemoveSql = null;
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    preparedRemoveSql = connection.prepareStatement(removeSql);
                    preparedRemoveSql.setString(1, id.toString());
                    result = preparedRemoveSql.executeUpdate();
                    connection.commit();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore:removeSFSBean------------------------Committed");
                    }
                    preparedRemoveSql.close();
                    this.haErrRemove.txEnd();
                    if (!_logger.isLoggable(Level.FINER)) continue;
                    _logger.exiting("HAEjbStore", "removeSFSBean", new Integer(result));
                }
                catch (SQLException e) {
                    this.haErrRemove.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore-removeSFSBean: EXCEPTION HERE  " + preparedRemoveSql);
            }
            e.printStackTrace();
            try {
                connection.rollback();
                preparedRemoveSql.close();
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore-removeSFSBean: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-removeSFSBean: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        return result > 0;
    }

    public void removeExpired() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "HAEjbStore.removeExpired containerId = " + this.containerID);
        }
        Object[] ids = new Object[]{};
        Connection connection = null;
        try {
            connection = this.getConnection(false);
            ids = this.expiredKeys(blobSfsbTable, connection);
            for (int i = 0; i < ids.length; ++i) {
                this.removeSFSBean(ids[i], connection);
            }
        }
        catch (IOException ex) {
            _logger.log(Level.WARNING, "removeExpired: failed to remove all the beans for this container " + this.getContainerId());
        }
        System.out.println("number of expired beans = " + ids.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int removeExpiredSessions() {
        int result;
        block19: {
            Connection externalConn;
            Connection internalConn;
            HADBConnectionGroup connGroup;
            block16: {
                int n;
                block17: {
                    _logger.finest("IN HAEjbStore>>removeExpiredSessions");
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore.removeExpiredSessions containerId = " + this.containerID);
                    }
                    Object[] ids = new Object[]{};
                    connGroup = null;
                    internalConn = null;
                    externalConn = null;
                    result = 0;
                    ConnectionUtil util = this.getConnectionUtil();
                    connGroup = util.getConnectionsFromPool();
                    if (connGroup != null) break block16;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore>>removeExpiredSessions:  connGroup is null");
                    }
                    n = result;
                    Object var9_10 = null;
                    if (externalConn == null) break block17;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
                return n;
            }
            internalConn = connGroup._internalConn;
            externalConn = connGroup._externalConn;
            result = this.removeExpiredSFSBeans(blobSfsbTable, internalConn, CHUNK_SIZE);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            externalConn = null;
            Object var9_11 = null;
            if (externalConn == null) break block19;
            try {
                externalConn.close();
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
            }
            externalConn = null;
            {
                break block19;
                catch (IOException ex) {
                    _logger.log(Level.WARNING, "removeExpiredSessions: failed to remove all the expired beans for this container " + this.getContainerId());
                    ex.printStackTrace();
                    Object var9_12 = null;
                    if (externalConn == null) break block19;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
                throw throwable;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HAEjbStore>>removeExpiredSessions():number of expired beans = " + result);
        }
        return result;
    }

    private int removeExpiredSFSBeansPrevious(String sessionTable, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINER)) {
            _logger.entering("HAEjbStore", "removeExpiredSFSBeans", new Object[]{connection});
        }
        PreparedStatement preparedRemoveSql = null;
        int result = 0;
        long timeNow = System.currentTimeMillis();
        HASFSBStoreManager mgr = (HASFSBStoreManager)this.getSFSBStoreManager();
        long idleTimeoutInMillis = mgr.getIdleTimeoutInSeconds() * 1000;
        long relevantTime = timeNow - idleTimeoutInMillis;
        String removeExpiredSql = "DELETE FROM " + sessionTable + " WHERE containerId = '" + this.getContainerId() + "'" + " AND lastaccess < ?";
        try {
            this.haErrRemoveExpired.txStart();
            while (!this.haErrRemoveExpired.isTxCompleted()) {
                try {
                    preparedRemoveSql = connection.prepareStatement(removeExpiredSql);
                    preparedRemoveSql.setLong(1, relevantTime);
                    result = preparedRemoveSql.executeUpdate();
                    connection.commit();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore:removeExpiredSFSBeans------------------------Committed");
                    }
                    preparedRemoveSql.close();
                    this.haErrRemoveExpired.txEnd();
                }
                catch (SQLException e) {
                    this.haErrRemoveExpired.checkError(e, connection);
                }
                if (!_logger.isLoggable(Level.FINER)) continue;
                _logger.exiting("HAEjbStore", "removeExpiredSFSBean", new Integer(result));
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAEjbStore-removeExpiredSFSBeans: EXCEPTION HERE  " + preparedRemoveSql);
            }
            e.printStackTrace();
            try {
                connection.rollback();
                preparedRemoveSql.close();
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
            IOException ex1 = (IOException)new IOException("Error from HAEjbStore-removeExpiredSFSBeans: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-removeExpiredSFSBeans: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        return result;
    }

    private int removeExpiredSFSBeans(String sessionTable, Connection connection, int chunk) throws IOException {
        int result = 0;
        if (connection == null) {
            return result;
        }
        ResultSet rst = null;
        PreparedStatement preparedKeysSql = null;
        long timeNow = System.currentTimeMillis();
        HASFSBStoreManager mgr = (HASFSBStoreManager)this.getSFSBStoreManager();
        long idleTimeoutInMillis = mgr.getIdleTimeoutInSeconds() * 1000;
        long relevantTime = timeNow - idleTimeoutInMillis;
        String keysSql = "SELECT id FROM " + sessionTable + " WHERE containerId = ?" + " AND lastaccess < ? ORDER BY id";
        PreparedStatement preparedDeleteSql = null;
        String deleteSql = "DELETE FROM " + sessionTable + " WHERE id BETWEEN ? AND ? AND containerId = ?" + " AND lastaccess < ?";
        try {
            this.haErrRemoveExpired.txStart();
            while (!this.haErrRemoveExpired.isTxCompleted()) {
                try {
                    boolean moreLeft = true;
                    while (moreLeft) {
                        preparedKeysSql = connection.prepareStatement(keysSql);
                        preparedKeysSql.setString(1, this.getContainerId());
                        preparedKeysSql.setLong(2, relevantTime);
                        rst = preparedKeysSql.executeQuery();
                        if (!rst.isBeforeFirst()) {
                            rst.close();
                            moreLeft = false;
                            break;
                        }
                        int rowno = 0;
                        String keyLow = null;
                        String keyHigh = null;
                        boolean chunkSizeReached = false;
                        while (rst.next()) {
                            if (rowno == 0) {
                                keyLow = rst.getString(1);
                            }
                            keyHigh = rst.getString(1);
                            if (++rowno < chunk) continue;
                            chunkSizeReached = true;
                            break;
                        }
                        if (!chunkSizeReached) {
                            moreLeft = false;
                        }
                        rst.close();
                        preparedDeleteSql = connection.prepareStatement(deleteSql);
                        preparedDeleteSql.setString(1, keyLow);
                        preparedDeleteSql.setString(2, keyHigh);
                        preparedDeleteSql.setString(3, this.getContainerId());
                        preparedDeleteSql.setLong(4, relevantTime);
                        int cnt = preparedDeleteSql.executeUpdate();
                        result += cnt;
                        connection.commit();
                    }
                    connection.commit();
                    this.closePreparedStatement(preparedKeysSql);
                    this.closePreparedStatement(preparedDeleteSql);
                    this.haErrRemoveExpired.txEnd();
                    return result;
                }
                catch (SQLException e) {
                    this.haErrRemoveExpired.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
                this.closePreparedStatement(preparedKeysSql);
                this.closePreparedStatement(preparedDeleteSql);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-removeExpiredSFSBeans: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undeployContainerPrevious() {
        block16: {
            block15: {
                if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                    HAEjbStore._logger.log(Level.FINEST, "HAEjbStore.undeployContainer containerId = " + this.containerID);
                }
                connGroup = null;
                internalConn = null;
                externalConn = null;
                try {
                    try {
                        util = this.getConnectionUtil();
                        connGroup = util.getConnectionsFromPool();
                        if (connGroup == null) {
                            if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                                HAEjbStore._logger.log(Level.FINEST, "HAEjbStore>>undeployContainer:  connGroup is null");
                            }
                            var8_6 = null;
                            if (externalConn == null) return;
                            break block15;
                        }
                        internalConn = connGroup._internalConn;
                        externalConn = connGroup._externalConn;
                        id = this.getBeanIDsForContainer(internalConn);
                        for (i = 0; i < id.length; ++i) {
                            this.removeSFSBean(id[i], internalConn);
                        }
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        externalConn = null;
                        break block16;
                    }
                    catch (IOException ex) {
                        HAEjbStore._logger.log(Level.WARNING, "undeployContainer: failed to remove all the beans for this container " + this.getContainerId());
                        ex.printStackTrace();
                        var8_8 = null;
                        if (externalConn == null) return;
                        try {
                            externalConn.close();
                            return;
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable var7_17) {
                    block17: {
                        var8_9 = null;
                        if (externalConn == null) throw var7_17;
                        ** try [egrp 3[TRYBLOCK] [7 : 221->231)] { 
lbl48:
                        // 1 sources

                        externalConn.close();
                        break block17;
lbl50:
                        // 1 sources

                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                    }
                    externalConn = null;
                    throw var7_17;
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 221->231)] { 
lbl57:
            // 1 sources

            externalConn.close();
            return;
lbl59:
            // 1 sources

            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return;
        }
        var8_7 = null;
        if (externalConn == null) return;
        ** try [egrp 3[TRYBLOCK] [7 : 221->231)] { 
lbl66:
        // 1 sources

        externalConn.close();
        return;
lbl68:
        // 1 sources

        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void undeployContainer() {
        block15: {
            block14: {
                HAEjbStore._logger.finest("IN HAEjbStore>>undeployContainer");
                if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                    HAEjbStore._logger.log(Level.FINEST, "HAEjbStore.undeployContainer containerId = " + this.containerID);
                }
                connGroup = null;
                internalConn = null;
                externalConn = null;
                try {
                    try {
                        util = this.getConnectionUtil();
                        connGroup = util.getConnectionsFromPool();
                        if (connGroup == null) {
                            if (HAEjbStore._logger.isLoggable(Level.FINEST)) {
                                HAEjbStore._logger.log(Level.FINEST, "HAEjbStore>>undeployContainer:  connGroup is null");
                            }
                            var7_6 = null;
                            if (externalConn == null) return;
                            break block14;
                        }
                        internalConn = connGroup._internalConn;
                        externalConn = connGroup._externalConn;
                        this.removeAllBeansForContainer(internalConn, HAEjbStore.CHUNK_SIZE);
                        try {
                            externalConn.close();
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        externalConn = null;
                        break block15;
                    }
                    catch (IOException ex) {
                        HAEjbStore._logger.log(Level.WARNING, "undeployContainer: failed to remove all the expired beans for this container " + this.getContainerId());
                        ex.printStackTrace();
                        var7_8 = null;
                        if (externalConn == null) return;
                        try {
                            externalConn.close();
                            return;
                        }
                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable var6_15) {
                    block16: {
                        var7_9 = null;
                        if (externalConn == null) throw var6_15;
                        ** try [egrp 3[TRYBLOCK] [7 : 200->209)] { 
lbl45:
                        // 1 sources

                        externalConn.close();
                        break block16;
lbl47:
                        // 1 sources

                        catch (SQLException ex) {
                            ex.printStackTrace();
                        }
                    }
                    externalConn = null;
                    throw var6_15;
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 200->209)] { 
lbl54:
            // 1 sources

            externalConn.close();
            return;
lbl56:
            // 1 sources

            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return;
        }
        var7_7 = null;
        if (externalConn == null) return;
        ** try [egrp 3[TRYBLOCK] [7 : 200->209)] { 
lbl63:
        // 1 sources

        externalConn.close();
        return;
lbl65:
        // 1 sources

        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void removeAllBeansForContainer(Connection connection, int chunk) throws IOException {
        if (connection == null) {
            return;
        }
        ResultSet rst = null;
        PreparedStatement preparedKeysSql = null;
        String keysSql = "SELECT id FROM " + blobSfsbTable + "  WHERE containerid = ? ORDER BY id";
        PreparedStatement preparedDeleteSql = null;
        String deleteSql = "DELETE FROM " + blobSfsbTable + " WHERE id BETWEEN ? AND ? AND containerid = ?";
        try {
            this.haErrRemoveAllBeans.txStart();
            while (!this.haErrRemoveAllBeans.isTxCompleted()) {
                try {
                    boolean moreLeft = true;
                    while (moreLeft) {
                        preparedKeysSql = connection.prepareStatement(keysSql);
                        preparedKeysSql.setString(1, this.getContainerId());
                        rst = preparedKeysSql.executeQuery();
                        if (!rst.isBeforeFirst()) {
                            rst.close();
                            moreLeft = false;
                            break;
                        }
                        int rowno = 0;
                        String keyLow = null;
                        String keyHigh = null;
                        boolean chunkSizeReached = false;
                        while (rst.next()) {
                            if (rowno == 0) {
                                keyLow = rst.getString(1);
                            }
                            keyHigh = rst.getString(1);
                            if (++rowno < chunk) continue;
                            chunkSizeReached = true;
                            break;
                        }
                        if (!chunkSizeReached) {
                            moreLeft = false;
                        }
                        rst.close();
                        preparedDeleteSql = connection.prepareStatement(deleteSql);
                        preparedDeleteSql.setString(1, keyLow);
                        preparedDeleteSql.setString(2, keyHigh);
                        preparedDeleteSql.setString(3, this.getContainerId());
                        int cnt = preparedDeleteSql.executeUpdate();
                        connection.commit();
                    }
                    connection.commit();
                    this.closePreparedStatement(preparedKeysSql);
                    this.closePreparedStatement(preparedDeleteSql);
                    this.haErrRemoveAllBeans.txEnd();
                    return;
                }
                catch (SQLException e) {
                    this.haErrRemoveAllBeans.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
                this.closePreparedStatement(preparedKeysSql);
                this.closePreparedStatement(preparedDeleteSql);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-removeAllBeansForContainer: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int getContainerSize() {
        int result;
        block19: {
            Connection externalConn;
            Connection internalConn;
            HADBConnectionGroup connGroup;
            block16: {
                int n;
                block17: {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore.getContainerSize containerId = " + this.containerID);
                    }
                    connGroup = null;
                    internalConn = null;
                    externalConn = null;
                    result = 0;
                    ConnectionUtil util = this.getConnectionUtil();
                    connGroup = util.getConnectionsFromPool();
                    if (connGroup != null) break block16;
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "HAEjbStore>>undeployContainer:  connGroup is null");
                    }
                    n = result;
                    Object var9_9 = null;
                    if (externalConn == null) break block17;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
                return n;
            }
            internalConn = connGroup._internalConn;
            externalConn = connGroup._externalConn;
            Object[] id = this.getBeanIDsForContainer(internalConn);
            if (id == null) {
                result = id.length;
            }
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            externalConn = null;
            Object var9_10 = null;
            if (externalConn == null) break block19;
            try {
                externalConn.close();
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
            }
            externalConn = null;
            {
                break block19;
                catch (IOException ex) {
                    _logger.log(Level.WARNING, "getContainerSize: failed to get number of all the beans for this container " + this.getContainerId());
                    ex.printStackTrace();
                    Object var9_11 = null;
                    if (externalConn == null) break block19;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (externalConn != null) {
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                    }
                    externalConn = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] expiredKeys(String sessionTable, Connection connection) throws IOException {
        String[] result = new String[]{};
        long timeNow = System.currentTimeMillis();
        HASFSBStoreManager mgr = (HASFSBStoreManager)this.getSFSBStoreManager();
        long idleTimeoutInMillis = mgr.getIdleTimeoutInSeconds() * 1000;
        long relevantTime = timeNow - idleTimeoutInMillis;
        String expiredKeysSql = "SELECT id FROM " + sessionTable + " WHERE containerId = '" + this.getContainerId() + "'" + " AND lastaccess < ?";
        if (connection == null) {
            return result;
        }
        ResultSet rst = null;
        String[] keys = null;
        try {
            this.haErrExpiredKeys.txStart();
            while (!this.haErrExpiredKeys.isTxCompleted()) {
                try {
                    if (this.preparedExpiredKeysSql == null) {
                        this.preparedExpiredKeysSql = connection.prepareStatement(expiredKeysSql);
                    }
                    this.preparedExpiredKeysSql.setLong(1, relevantTime);
                    rst = this.preparedExpiredKeysSql.executeQuery();
                    if (rst == null) {
                        if (this._debug > 0) {
                            this.debug("expiredKeys(): No rows returned, returning an empty array");
                        }
                        String[] stringArray = new String[]{};
                        this.closeResultSet(rst);
                        return stringArray;
                    }
                    ArrayList<String> keysArray = new ArrayList<String>();
                    int i = 0;
                    while (rst.next()) {
                        if (this._debug > 0) {
                            this.debug("in expiredKeys, id is " + rst.getString(1));
                        }
                        keysArray.add(rst.getString(1));
                        ++i;
                    }
                    keys = keysArray.toArray(new String[0]);
                    connection.commit();
                    this.haErrExpiredKeys.txEnd();
                }
                catch (SQLException e) {
                    this.haErrExpiredKeys.checkError(e, connection);
                }
            }
            this.closeResultSet(rst);
            return keys;
        }
        catch (SQLException e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HAEjbStore-expiredKeys: " + e.getMessage()).initCause(e);
                throw ex1;
                catch (HATimeoutException tex) {
                    IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-expiredKeys: " + tex.getMessage()).initCause(tex);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object[] getBeanIDsForContainer(Connection connection) throws IOException {
        Object[] result;
        block15: {
            result = new String[]{};
            ResultSet rst = null;
            Object[] keys = null;
            String keysSql = "SELECT id FROM " + blobSfsbTable + " WHERE containerid = ?";
            PreparedStatement preparedKeysSql = null;
            if (connection == null) {
                return result;
            }
            try {
                this.haErrGetBeanIds.txStart();
                while (!this.haErrGetBeanIds.isTxCompleted()) {
                    try {
                        preparedKeysSql = connection.prepareStatement(keysSql);
                        preparedKeysSql.setString(1, this.getContainerId());
                        rst = preparedKeysSql.executeQuery();
                        if (rst == null) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINEST, "getBeanIDsForContainer: no beans found for this container " + this.getContainerId());
                            }
                            this.closePreparedStatement(preparedKeysSql);
                            return new String[0];
                        }
                        ArrayList<String> keysArray = new ArrayList<String>();
                        int i = 0;
                        while (rst.next()) {
                            if (this._debug > 0) {
                                this.debug("in keys, id is " + rst.getString(1));
                            }
                            keysArray.add(rst.getString(1));
                            ++i;
                        }
                        keys = keysArray.toArray(new String[0]);
                        connection.commit();
                        this.closePreparedStatement(preparedKeysSql);
                        this.haErrGetBeanIds.txEnd();
                        return keys;
                    }
                    catch (SQLException e) {
                        try {
                            this.haErrGetBeanIds.checkError(e, connection);
                        }
                        catch (SQLException e2) {
                            e2.printStackTrace();
                            try {
                                connection.rollback();
                                this.closePreparedStatement(preparedKeysSql);
                                break block15;
                            }
                            catch (SQLException ee) {
                                ee.printStackTrace();
                            }
                        }
                    }
                }
                break block15;
                {
                    break;
                }
            }
            catch (HATimeoutException tex) {
                IOException ex2 = (IOException)new IOException("Timeout from HAEjbStore-getBeanIDsForContainer: " + tex.getMessage()).initCause(tex);
                throw ex2;
            }
        }
        return result;
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.conn = null;
        ConnectionUtil util = this.getConnectionUtil();
        if (util != null) {
            util.clearCachedConnection();
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedExpiredKeysSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
        this.clearStatementReferences();
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void clearStatementReferences() {
        this.preparedExpiredKeysSql = null;
    }

    private void closePreparedStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

