/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.initialization;

import com.sun.ejb.base.container.util.CacheProperties;
import com.sun.ejb.base.sfsb.initialization.AbstractPersistenceStrategyBuilder;
import com.sun.ejb.base.sfsb.util.EJBServerConfigLookup;
import com.sun.ejb.ee.sfsb.store.HASFSBStoreManager;
import com.sun.ejb.spi.sfsb.initialization.PersistenceStrategyBuilder;
import com.sun.ejb.spi.sfsb.initialization.SFSBContainerInitialization;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HaStrategyBuilder
extends AbstractPersistenceStrategyBuilder
implements PersistenceStrategyBuilder {
    public void initializePersistenceStrategy(SFSBContainerInitialization container, EjbDescriptor descriptor) {
        try {
            super.initializePersistenceStrategy(container, descriptor);
            HASFSBStoreManager storeManager = new HASFSBStoreManager();
            this.initStoreManager(storeManager, descriptor);
            container.setSFSBStoreManager((SFSBStoreManager)storeManager);
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Could not initialize container using HaStrategyBuilder", th);
        }
    }

    private void initStoreManager(SFSBStoreManager storeManager, EjbDescriptor ejbDescriptor) {
        CacheProperties desc = new CacheProperties(ejbDescriptor);
        int idleTimeoutInSeconds = desc.getRemovalTimeoutInSeconds();
        long containerId = ejbDescriptor.getUniqueId();
        EJBServerConfigLookup configLookup = new EJBServerConfigLookup(ejbDescriptor);
        String clusterId = configLookup.getClusterName();
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put("idleTimeoutInSeconds", new Integer(idleTimeoutInSeconds));
        initMap.put("containerId", new Long(containerId));
        initMap.put("clusterId", clusterId);
        try {
            storeManager.initSessionStore(initMap);
        }
        catch (SFSBStoreManagerException ex) {
            // empty catch block
        }
    }

    private void initStoreManagerPrevious(HASFSBStoreManager storeManager, EjbDescriptor ejbDescriptor) {
        CacheProperties desc = new CacheProperties(ejbDescriptor);
        int idleTimeoutInSeconds = desc.getRemovalTimeoutInSeconds();
        long containerId = ejbDescriptor.getUniqueId();
        EJBServerConfigLookup configLookup = new EJBServerConfigLookup(ejbDescriptor);
        String clusterId = configLookup.getClusterName();
        storeManager.initSessionStore(clusterId, containerId, idleTimeoutInSeconds);
    }

    public void setLogger(Logger logger) {
    }
}

