/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.servlet;

import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.compiler.JspUtil;

public class HandlePrecompiledJsp
extends HttpServlet {
    private static final String PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    private static final String SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    private static final String JSP_CLASS_PREFIX = "org.apache.jsp.";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pathInfo = (String)req.getAttribute(PATH_INFO_ATTRIBUTE);
        String servletPath = (String)req.getAttribute(SERVLET_PATH_ATTRIBUTE);
        if (servletPath == null) {
            servletPath = req.getServletPath();
            pathInfo = req.getPathInfo();
        }
        String className = this.getClassName(servletPath, pathInfo);
        try {
            Class<?> cls = Class.forName(className);
            Object obj = cls.newInstance();
            ((HttpServlet)obj).init(this.getServletConfig());
            ((HttpServlet)obj).service((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception ex) {
            throw new FrameworkException("Unabled to handle pre-compiled JSP '" + servletPath + pathInfo + "'.  Expected pre-compiled classname: '" + className + "'.", (Throwable)ex);
        }
    }

    protected String getClassName(String servletPath, String jspName) {
        return this.getClassName(servletPath + jspName);
    }

    protected String getClassName(String fullPath) {
        int lastSlash = (fullPath = fullPath.trim()).lastIndexOf(47);
        if (lastSlash == -1) {
            return JSP_CLASS_PREFIX + JspUtil.makeJavaIdentifier((String)fullPath);
        }
        String packageName = fullPath.substring(0, ++lastSlash);
        String jspName = fullPath.substring(lastSlash);
        int loc = packageName.indexOf("//");
        while (loc != -1) {
            packageName = packageName.replaceAll("//", "/");
            loc = packageName.indexOf("//");
        }
        if (packageName.startsWith("/")) {
            packageName = packageName.substring(1);
        }
        StringTokenizer tok = new StringTokenizer(packageName, "/");
        StringBuffer className = new StringBuffer(JSP_CLASS_PREFIX);
        while (tok.hasMoreTokens()) {
            className.append(JspUtil.makeJavaIdentifier((String)tok.nextToken()));
            className.append('.');
        }
        className.append(JspUtil.makeJavaIdentifier((String)jspName));
        if (Util.isLoggableFINER()) {
            Util.logFINER("CLASSNAME = " + className);
        }
        return className.toString();
    }
}

