/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.View;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCPageTitle;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.view.html.CCCheckBox;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class SSLHandlers {
    public void displayCiphersValues(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        ArrayList cipherNames = (ArrayList)handlerCtx.getInputValue("cipherNames");
        if (cipherNames == null) {
            throw new FrameworkException("cipherNames not specified", descView.getViewDescriptor(), view);
        }
        String objectName = (String)handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("objectName not specified", descView.getViewDescriptor(), view);
        }
        AttributeList values = null;
        try {
            values = MBeanUtil.getMBeanServer().getAttributes(new ObjectName(objectName), cipherNames.toArray(new String[cipherNames.size()]));
        }
        catch (Exception ex) {
            throw new FrameworkException("displayCiphersValues: failed to get MBean values", (Throwable)ex, descView.getViewDescriptor(), view);
        }
        AttributeList attrList = values;
        boolean allNull = true;
        for (int i = 0; i < attrList.size(); ++i) {
            Attribute attr = (Attribute)attrList.get(i);
            Object attrValue = attr.getValue();
            if (attrValue != null) {
                allNull = false;
            }
            this.parseAndSet(descView, attrValue);
        }
        if (allNull) {
            descView.setDisplayFieldValue("allSupported", (Object)"true");
        }
    }

    public void createSSL(RequestContext ctx, HandlerContext handlerCtx) {
        String ciphers;
        Attribute attr;
        View view = handlerCtx.getView();
        if (!(view instanceof DescriptorContainerView)) {
            View parent = view.getParent();
            if (!(parent instanceof DescriptorContainerView)) {
                throw new FrameworkException("View is not a DescriptorContainerView!", null, view);
            }
            view = parent;
        }
        if (view instanceof DescriptorCCPageTitle) {
            view = view.getParent();
        }
        DescriptorContainerView descView = (DescriptorContainerView)view;
        String objectName = (String)handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("objectName not specified", descView.getViewDescriptor(), view);
        }
        String certNickName = (String)descView.getDisplayFieldValue("certificateNickName");
        if (Util.isEmpty(certNickName)) {
            this.deleteSSL(objectName);
            return;
        }
        ArrayList displayNames = (ArrayList)handlerCtx.getInputValue("sslDisplayNames");
        if (displayNames == null) {
            throw new FrameworkException("sslDisplayNames not specified", descView.getViewDescriptor(), view);
        }
        ArrayList modelNames = (ArrayList)handlerCtx.getInputValue("sslAttributeNames");
        if (modelNames == null) {
            throw new FrameworkException("sslModelNames not specified", descView.getViewDescriptor(), view);
        }
        ArrayList ssl3CiphersNames = (ArrayList)handlerCtx.getInputValue("ssl3CipherNames");
        if (ssl3CiphersNames == null) {
            throw new FrameworkException("ssl3CipherNames not specified", descView.getViewDescriptor(), view);
        }
        String methodName = (String)handlerCtx.getInputValue("methodName");
        if (methodName == null) {
            throw new FrameworkException("methodName not specified", descView.getViewDescriptor(), view);
        }
        AttributeList attrList = new AttributeList();
        for (int i = 0; i < displayNames.size(); ++i) {
            attr = new Attribute((String)modelNames.get(i), (String)descView.getDisplayFieldValue((String)displayNames.get(i)));
            attrList.add(attr);
            if (!Util.isLoggableFINEST()) continue;
            Util.logFINEST(":::" + modelNames.get(i) + "=" + descView.getDisplayFieldValue((String)displayNames.get(i)));
        }
        String allSupported = (String)((CCCheckBox)descView.getChild("allSupported")).getValue();
        if (allSupported.equals("false") && !(ciphers = this.makeCipherList(descView, ssl3CiphersNames)).equals("")) {
            attr = new Attribute("ssl3-tls-ciphers", ciphers);
            attrList.add(attr);
        }
        this.deleteSSL(objectName);
        Object returnValue = this.createSSL(objectName, methodName, attrList);
        if (Util.isLoggableFINER()) {
            Util.logFINER("createSSLReturnValue: " + returnValue);
        }
    }

    private void parseAndSet(DescriptorContainerView view, Object attrValue) {
        if (attrValue == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(attrValue.toString(), ",", false);
        while (st.hasMoreTokens()) {
            String cipher = st.nextToken();
            if (cipher.charAt(0) == '+') {
                view.setDisplayFieldValue(cipher.substring(1), (Object)"true");
                continue;
            }
            if (cipher.charAt(0) != '-') continue;
            view.setDisplayFieldValue(cipher.substring(1), (Object)"false");
        }
    }

    private String makeCipherList(DescriptorContainerView descView, ArrayList names) {
        String ciphers = "";
        for (int i = 0; i < names.size(); ++i) {
            String value = (String)descView.getDisplayFieldValue((String)names.get(i));
            if (value.equalsIgnoreCase("true")) {
                if (i != 0) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "+" + names.get(i);
                continue;
            }
            if (i != 0) {
                ciphers = ciphers + ",";
            }
            ciphers = ciphers + "-" + names.get(i);
        }
        return ciphers;
    }

    private Object deleteSSL(String objectName) {
        Object returnValue = null;
        try {
            returnValue = MBeanUtil.invoke(objectName, "getSsl", null, null);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (returnValue == null) {
            return null;
        }
        try {
            returnValue = MBeanUtil.invoke(objectName, "removeSsl", null, null);
        }
        catch (Exception ex) {
            throw new FrameworkException("Exception while attempting to peform deleteSsl.", (Throwable)ex, null, null);
        }
        return returnValue;
    }

    private Object createSSL(String objectName, String methodName, AttributeList attrList) {
        Object[] params = new Object[]{attrList};
        String[] types = new String[]{"javax.management.AttributeList"};
        Object returnValue = null;
        try {
            returnValue = MBeanUtil.invoke(objectName, methodName, params, types);
        }
        catch (Exception ex) {
            throw new FrameworkException("Exception while attempting to peform create.", (Throwable)ex, null, null);
        }
        return returnValue;
    }
}

