/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildContentDisplayEvent;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import java.util.Iterator;
import java.util.StringTokenizer;

public class HtmlHeaderHandler {
    private static CCI18N peHelpIds = null;
    private static CCI18N eeHelpIds = null;

    private boolean refreshForOpenNodes(RequestContext ctx) {
        IndexTreeNode node = Util.getSelectedNode();
        if (node == null) {
            return false;
        }
        if ((node = node.getParent()) == null) {
            return false;
        }
        return node.openNode(ctx);
    }

    private void setHeaderDisplayValues(CCHtmlHeaderTag tag, HandlerContext handlerCtx) {
        String title;
        String copyRight;
        String onUnload = (String)handlerCtx.getInputValue("onUnload");
        if (onUnload != null) {
            tag.setOnUnload(onUnload);
        }
        if ((copyRight = (String)handlerCtx.getInputValue("copyRight")) != null) {
            tag.setCopyrightYear(copyRight);
        }
        if ((title = (String)handlerCtx.getInputValue("pageTitle")) != null) {
            tag.setPageTitle(title);
        }
    }

    public void beginHtmlHeaderDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd = handlerCtx.getViewDescriptor();
        if (vd.getParent() != null) {
            vd = vd.getParent();
        }
        Iterator it = vd.getChildDescriptors().iterator();
        String tableButtonInitScript = "";
        while (it.hasNext()) {
            ViewDescriptor child = (ViewDescriptor)it.next();
            if (!(child instanceof CCActionTableDescriptor)) continue;
            tableButtonInitScript = (String)handlerCtx.getInputValue("tableButtonInitScript");
            break;
        }
        if (tableButtonInitScript == null) {
            tableButtonInitScript = "";
        }
        CCHtmlHeaderTag tag = (CCHtmlHeaderTag)handlerCtx.getEvent().getSource();
        boolean refresh = ctx.getRequest().getAttribute("refreshTree") != null;
        String onLoad = null;
        onLoad = this.refreshForOpenNodes(ctx) || refresh ? (String)handlerCtx.getInputValue("onLoadRefreshTree") : (String)handlerCtx.getInputValue("onLoad");
        if (onLoad != null) {
            tag.setOnLoad(tableButtonInitScript + onLoad);
        }
        this.setHeaderDisplayValues(tag, handlerCtx);
    }

    public void beginTreeHtmlHeaderDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        boolean refresh;
        CCHtmlHeaderTag tag = (CCHtmlHeaderTag)handlerCtx.getEvent().getSource();
        boolean bl = refresh = ctx.getRequest().getAttribute("refreshRightSide") != null;
        if (refresh) {
            String onLoad = (String)handlerCtx.getInputValue("onLoadRefreshRight");
            if (onLoad != null) {
                tag.setOnLoad(onLoad);
            }
        } else {
            String onLoad = (String)handlerCtx.getInputValue("onLoad");
            if (onLoad != null) {
                tag.setOnLoad(onLoad);
            }
        }
        ctx.getRequest().removeAttribute("refreshRightSide");
        this.setHeaderDisplayValues(tag, handlerCtx);
    }

    private static String getHelpHTMLName(String key) {
        Boolean isEE = ConfigProperties.getInstance().getTargetSupported();
        if (isEE.booleanValue() && eeHelpIds == null) {
            eeHelpIds = new CCI18N(RequestManager.getRequestContext(), "com.sun.enterprise.ee.tools.admingui.resources.Helplinks");
        }
        if (peHelpIds == null) {
            peHelpIds = new CCI18N(RequestManager.getRequestContext(), "com.sun.enterprise.tools.admingui.resources.Helplinks");
        }
        String htmlFileName = null;
        if (eeHelpIds != null && (htmlFileName = eeHelpIds.getMessage(key)).equals(key)) {
            htmlFileName = null;
        }
        if (htmlFileName == null) {
            htmlFileName = peHelpIds.getMessage(key);
        }
        if (htmlFileName != null) {
            htmlFileName = htmlFileName.trim();
        }
        if (htmlFileName == null || htmlFileName.length() == 0 || htmlFileName.equals(key)) {
            htmlFileName = peHelpIds.getMessage("default");
        }
        if (htmlFileName != null) {
            htmlFileName = htmlFileName.trim();
        }
        if (htmlFileName == null || htmlFileName.equals("")) {
            htmlFileName = key;
        }
        if (!htmlFileName.endsWith(".html")) {
            htmlFileName = htmlFileName + ".html";
        }
        return htmlFileName;
    }

    private void addHiddenAttrValue(NonSyncStringBuffer buff, RequestContext ctx, IndexTreeNode node, String attrName, boolean lookUpInTreeHierarchy) {
        String attr = null;
        Object obj = node.getAttribute(attrName, lookUpInTreeHierarchy);
        if (obj == null) {
            obj = ctx.getRequest().getAttribute(attrName);
        }
        if (obj != null) {
            attr = obj.toString();
        }
        if (attr != null && attr.length() > 0) {
            buff.append("\n<input name=\"").append(attrName).append("\" type=\"hidden\" value=\"").append(attr).append("\">");
        }
    }

    private void setCurrentView(RequestContext ctx, View view) {
        String currentView = view.getName();
        String editKeyValue = (String)ctx.getRequest().getAttribute("editKeyValue");
        if (editKeyValue != null) {
            currentView = currentView + "?editKeyValue=" + Util.URLencode(ctx, editKeyValue);
        }
        Util.setCurrentViewURL(currentView);
    }

    public String endExtraDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String helpID;
        IndexTreeNode selectedNode;
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        View bean = handlerCtx.getView();
        while (!(bean instanceof DescriptorContainerView)) {
            bean = bean.getParent();
        }
        this.setCurrentView(ctx, bean);
        NonSyncStringBuffer buff = new NonSyncStringBuffer(ev.getContent(), 512);
        String script = (String)handlerCtx.getInputValue("script");
        if (script != null) {
            buff.append("\n").append(script);
        }
        if ((selectedNode = Util.getSelectedNode()) != null) {
            String id = selectedNode.getHighlightIDPath();
            buff.append("\n<input name=\"highlightid\" type=\"hidden\" value=\"").append(id).append("\">");
            this.addHiddenAttrValue(buff, ctx, selectedNode, "instanceName", true);
            this.addHiddenAttrValue(buff, ctx, selectedNode, "configName", true);
            this.addHiddenAttrValue(buff, ctx, selectedNode, "clusterName", true);
            this.addHiddenAttrValue(buff, ctx, selectedNode, "nodeAgentName", true);
            this.addHiddenAttrValue(buff, ctx, selectedNode, "ApplicationType", true);
            this.addHiddenAttrValue(buff, ctx, selectedNode, "objectName", false);
        }
        if ((helpID = (String)handlerCtx.getInputValue("helpID")) == null) {
            helpID = bean.getName();
        }
        String helpHTMLName = HtmlHeaderHandler.getHelpHTMLName(helpID);
        buff.append("\n<input name=\"helplink\" type=\"hidden\" value=\"").append(helpHTMLName).append("\">");
        return buff.toString();
    }

    public String endResourceStringsDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String keys = ev.getContent();
        if (keys == null | keys.length() == 0) {
            return "";
        }
        String result = "";
        StringTokenizer st = new StringTokenizer(keys);
        while (st.hasMoreTokens()) {
            String key = st.nextToken().trim();
            if (key.length() == 0) continue;
            result = result + "<input name=\"" + key + "\" type=\"hidden\" value=\"" + Util.getMessage(key) + "\">\n";
        }
        return result;
    }

    public void beginLinksPageTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        IndexTreeNode selectedNode = Util.getSelectedNode();
        tag.setPageTitleText(selectedNode.getName());
    }

    public String endChildPageLinkDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        String hrefExtras = "title=\"@@@@\" onmouseover=\"window.status='@@@@'; return true\" onmouseout=\"window.status=''; return true\" onblur=\"window.status=''; return true\" onfocus=\"window.status='@@@@'; return true\" ";
        ChildContentDisplayEvent ev = (ChildContentDisplayEvent)handlerCtx.getEvent();
        String html = ev.getContent();
        IndexTreeNode selectedNode = Util.getSelectedNode();
        if (selectedNode != null) {
            html = Util.removeHtmlProp(html, "name");
            html = html.replaceAll("links", "Index");
            html = html.replaceAll("childPageLink", "TreeView1.showContainer");
            int i = html.indexOf("__");
            int j = html.indexOf("__", i + 2);
            if (i < 0 || j < 0) {
                return "";
            }
            int index = new Integer(html.substring(i + 2, j));
            IndexTreeNode kid = (IndexTreeNode)selectedNode.getChildren().get(index);
            if (kid == null) {
                return "";
            }
            html = html.replaceAll(html.substring(i, j + 2), kid.getName());
            html = html.replaceAll("_VALUE_", kid.getPath());
            html = Util.addHtmlProp(html, "title=\"@@@@\" onmouseover=\"window.status='@@@@'; return true\" onmouseout=\"window.status=''; return true\" onblur=\"window.status=''; return true\" onfocus=\"window.status='@@@@'; return true\" ".replaceAll("@@@@", kid.getName()));
            return html;
        }
        return "";
    }
}

