/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.miscconfig;

import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.miscconfig.DefaultWebXMLTransfer;
import com.sun.enterprise.tools.upgrade.miscconfig.InitConfTransfer;
import com.sun.enterprise.tools.upgrade.miscconfig.PolicyParser;
import com.sun.enterprise.tools.upgrade.miscconfig.SunACCTransfer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.provider.PolicyParser;

public class ConfigTransfers
implements BaseModule {
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private Vector recoveryList = new Vector();

    public boolean upgrade(CommonInfoModel commonInfo) {
        this.transferServerPolicy(commonInfo.getSourceServerPolicyFileName(), commonInfo.getTargetServerPolicyFileName());
        new DefaultWebXMLTransfer().transform(commonInfo.getSourceDefaultWebXMLFileName(), commonInfo.getTargetDefaultWebXMLFileName());
        new SunACCTransfer().transform(commonInfo.getSourceSunACCFileName(), commonInfo.getTargetSunACCFileName());
        if (commonInfo.getSourceVersion().equals("7x")) {
            new InitConfTransfer(commonInfo).transform();
        }
        return true;
    }

    public void recovery(CommonInfoModel commonInfo) {
        Enumeration e = this.recoveryList.elements();
        while (e.hasMoreElements()) {
            String recoverPath = (String)e.nextElement();
            String backupPath = recoverPath + ".bak";
            try {
                UpgradeUtils.getUpgradeUtils(commonInfo).copyFile(backupPath, recoverPath);
                new File(backupPath).delete();
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.realm.recoveryFailureMessage", (Object)ioe.getMessage()), new Object[]{recoverPath, ioe});
            }
        }
    }

    private void transferServerPolicy(String sourcePolicyFileName, String destPolicyFileName) {
        if (!this.backup(destPolicyFileName)) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.backupFailureMessage"));
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startFailureMessage"));
            return;
        }
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startMessage"));
        PolicyParser sourcePolicy = new PolicyParser();
        PolicyParser targetPolicy = new PolicyParser();
        try {
            sourcePolicy.read(new FileReader(sourcePolicyFileName));
            targetPolicy.read(new FileReader(destPolicyFileName));
        }
        catch (PolicyParser.ParsingException pe) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startFailureMessage") + pe.getLocalizedMessage());
            return;
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startFailureMessage"), ioe.getMessage());
            return;
        }
        Enumeration<PolicyParser.GrantEntry> sourceElements = sourcePolicy.grantElements();
        Enumeration<PolicyParser.GrantEntry> targetElements = targetPolicy.grantElements();
        while (sourceElements.hasMoreElements()) {
            PolicyParser.GrantEntry sourceGrantEntry = sourceElements.nextElement();
            boolean matchedGrantEntry = false;
            while (targetElements.hasMoreElements()) {
                PolicyParser.GrantEntry targetGrantEntry = targetElements.nextElement();
                if (targetGrantEntry.codeBase == null && sourceGrantEntry.codeBase == null) {
                    matchedGrantEntry = true;
                } else if (targetGrantEntry.codeBase != null && sourceGrantEntry.codeBase != null && targetGrantEntry.codeBase.equals(sourceGrantEntry.codeBase)) {
                    matchedGrantEntry = true;
                }
                if (!matchedGrantEntry) continue;
                Enumeration<PolicyParser.PermissionEntry> sourcePermissions = sourceGrantEntry.permissionElements();
                while (sourcePermissions.hasMoreElements()) {
                    boolean matchedPermission = false;
                    PolicyParser.PermissionEntry sourcePermission = sourcePermissions.nextElement();
                    Enumeration<PolicyParser.PermissionEntry> targetPermissions = targetGrantEntry.permissionElements();
                    while (targetPermissions.hasMoreElements()) {
                        PolicyParser.PermissionEntry targetPermission = targetPermissions.nextElement();
                        if (!targetPermission.equals(sourcePermission)) continue;
                        matchedPermission = true;
                        break;
                    }
                    if (matchedPermission) continue;
                    targetGrantEntry.add(sourcePermission);
                }
                Iterator sourcePrincipalIterator = sourceGrantEntry.principals.iterator();
                while (sourcePrincipalIterator.hasNext()) {
                    boolean matchedPrincipal = false;
                    PolicyParser.PrincipalEntry sourcePrincipalEntry = (PolicyParser.PrincipalEntry)sourcePrincipalIterator.next();
                    Iterator targetPrincipalIterator = targetGrantEntry.principals.iterator();
                    while (targetPrincipalIterator.hasNext()) {
                        PolicyParser.PrincipalEntry targetPrincipalEntry = (PolicyParser.PrincipalEntry)targetPrincipalIterator.next();
                        if (!targetPrincipalEntry.equals(sourcePrincipalEntry)) continue;
                        matchedPrincipal = true;
                        break;
                    }
                    if (matchedPrincipal) continue;
                    targetGrantEntry.principals.add(sourcePrincipalEntry);
                }
                break block6;
            }
            if (matchedGrantEntry) continue;
            targetPolicy.add(sourceGrantEntry);
        }
        try {
            targetPolicy.write(new FileWriter(destPolicyFileName));
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startFailureMessage"), ioe.getMessage());
            return;
        }
    }

    private boolean backup(String filename) {
        try {
            File targetFile = new File(filename);
            boolean renamed = targetFile.renameTo(new File(filename + ".bak"));
            if (!renamed) {
                renamed = targetFile.delete();
            }
            if (renamed) {
                targetFile = new File(filename);
                targetFile.createNewFile();
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename + ".bak")));
                PrintWriter writer = new PrintWriter(new FileOutputStream(targetFile));
                String readLine = null;
                while ((readLine = reader.readLine()) != null) {
                    writer.println(readLine);
                }
                writer.flush();
                writer.close();
                reader.close();
                return true;
            }
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.renameFailureMessage"));
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.configTransfers.serverPolicy.startFailureMessage"), ex);
        }
        return false;
    }

    public String getName() {
        return this.stringManager.getString("upgrade.configTransfers.moduleName");
    }
}

