/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.cli;

import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CLIParser {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private static final String LONG_OPTION = "--";
    private StringManager sm;
    private static final String HELP = "--help";
    private static final String HELP_SHORT = "-h";
    private static final String HELP_QUESTION = "-?";
    private static final String VERSION_LONG = "--version";
    private static final String VERSION_SHORT = "-V";
    private static final String CONSOLE_LONG = "--console";
    private static final String CONSOLE_SHORT = "-c";
    private static final String SOURCE_INSTALL_DIR_EQUAL_OPTION = "--source=";
    private static final String SOURCE_INSTALL_DIR = "--source";
    private static final String SOURCE_INSTALL_DIR_SHORT = "-s";
    private boolean source = false;
    private static final String TARGET_INSTALL_DIR_EQUAL_OPTION = "--target=";
    private static final String TARGET_INSTALL_DIR = "--target";
    private static final String TARGET_INSTALL_DIR_SHORT = "-t";
    private static final String ADMIN_USER = "--adminuser";
    private static final String ADMIN_USER_SHORT = "-a";
    private static final String ADMIN_USER_EQUAL_OPTION = "--adminuser=";
    private static final String ADMIN_PASSWORD = "--adminpassword";
    private static final String ADMIN_PASSWORD_SHORT = "-w";
    private static final String ADMIN_PASSWORD_EQUAL_OPTION = "--adminpassword=";
    private static final String PWFILE_LONG = "--passwordfile";
    private static final String PWFILE_SHORT = "-f";
    private static final String MASTER_PASSWORD_LONG = "--masterpassword";
    private static final String MASTER_PASSWORD_SHORT = "-m";
    private static final String NOPROMPT = "-noprompt";
    private static final String CLINSTANCE = "--clinstancefiles";
    private static final String CLINSTANCE_SHORT = "-i";
    private static final String CONFIG = "config";
    private boolean interactiveInput = false;
    private boolean target = false;
    private static final String NSS_PWD_FILE_EQUAL_OPTION = "--nsspwdfile=";
    private static final String NSS_PWD_FILE = "--nsspwdfile";
    private static final String NSS_PWD_FILE_SHORT = "-n";
    private static final String TARGET_NSS_PWD_FILE_EQUAL_OPTION = "--targetnsspwdfile=";
    private static final String TARGET_NSS_PWD_FILE = "--targetnsspwdfile";
    private static final String TARGET_NSS_PWD_FILE_SHORT = "-e";
    private boolean nsskeystorePwd = false;
    private boolean nsstargetkeystorePwd = false;
    private static final String JKS_PWD_FILE_EQUAL_OPTION = "--jkspwdfile=";
    private static final String JKS_PWD_FILE = "--jkspwdfile";
    private static final String JKS_PWD_FILE_SHORT = "-j";
    private static final String JKS_CA_PWD_FILE_EQUAL_OPTION = "--capwdfile=";
    private static final String JKS_CA_PWD_FILE = "--capwdfile";
    private static final String JKS_CA_PWD_FILE_SHORT = "-p";
    private boolean jkskeystorePwd = false;
    private boolean jkscakeystorePwd = false;
    private boolean adminuser = false;
    private boolean adminpassword = false;
    private boolean noprompt = false;
    private boolean clinstance = false;
    private static final String DOMAIN_NAME_EQUAL_OPTION = "--domain=";
    private static final String DOMAIN_NAME = "--domain";
    private static final String DOMAIN_NAME_SHORT = "-d";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private static final String DOMAIN = "domain";
    private static final String NSSPWD = "nsspwd";
    private static final String TARGETNSSPWD = "targetnsspwd";
    private static final String JKSPWD = "jkspwd";
    private static final String CAPWD = "capwd";
    private static final String ADMINUSER = "adminuser";
    private static final String ADMINPASSWORD = "adminpassword";
    private static final String MASTERPASSWORD = "masterpassword";
    private static final String CLINSTANCEINFO = "clinstancefiles";
    private Map interactiveInputMap = new HashMap();
    private String currentDomain;
    private int index = 0;
    private CommonInfoModel commonInfo;

    public CLIParser() {
    }

    public CLIParser(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public void setCommonInfoModel(CommonInfoModel commonInfo) {
        this.commonInfo = commonInfo;
    }

    public CommonInfoModel getCommonInfoModel(CommonInfoModel commonInfo) {
        return commonInfo;
    }

    public void printInfo() {
        this.commonInfo.printInfo();
    }

    public void parseComandLineArguments(String[] args) {
        this.parseOptions(args);
        this.verifyValidInteractiveConsoleInput();
        if (!this.interactiveInput) {
            this.verifyCommonInfo(args);
        }
        if (!this.commonInfo.isUpgradeSupported()) {
            this.helpUsage(this.sm.getString("enterprise.tools.upgrade.cli.upgrade_not_supported"));
            System.exit(1);
        }
        this.commonInfo.enlistDomainsFromSource();
    }

    public void parseOptions(String[] args) {
        StringBuffer argsStringBuff = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            argsStringBuff.append(args[i]);
            argsStringBuff.append(" ");
        }
        _logger.info("asupgrade " + argsStringBuff.toString());
        this.sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.cli");
        if (args[0].equals(HELP) || args[0].equals(HELP_SHORT) || args[0].equals(HELP_QUESTION)) {
            this.helpUsage();
            System.exit(1);
        }
        String nssPwdFile = "";
        String targetnssPwdFile = "";
        String jksPwdFile = "";
        String jkscaPwdFile = "";
        this.currentDomain = null;
        while (this.index < args.length) {
            boolean validpwd;
            if (args[this.index].equals(SOURCE_INSTALL_DIR) || args[this.index].equals(SOURCE_INSTALL_DIR_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--source/-s");
                this.argumentCheck(args, this.index + 2, msg);
                this.checkValidSourceDir(args[this.index + 1]);
                this.commonInfo.setSourceInstallDir(args[this.index + 1]);
                this.interactiveInputMap.put(SOURCE, args[this.index + 1]);
                this.index += 2;
                this.source = true;
                continue;
            }
            if (args[this.index].startsWith(SOURCE_INSTALL_DIR_EQUAL_OPTION)) {
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                String sourceDirectory = args[this.index].substring(ind + 1, len);
                this.checkValidSourceDir(sourceDirectory);
                this.commonInfo.setSourceInstallDir(sourceDirectory);
                this.interactiveInputMap.put(SOURCE, sourceDirectory);
                ++this.index;
                this.source = true;
                continue;
            }
            if (args[this.index].equals(TARGET_INSTALL_DIR) || args[this.index].equals(TARGET_INSTALL_DIR_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--target/-t");
                this.argumentCheck(args, this.index + 2, msg);
                this.checkValidTargetDir(args[this.index + 1]);
                this.commonInfo.setTargetInstallDir(args[this.index + 1]);
                this.interactiveInputMap.put(TARGET, args[this.index + 1]);
                this.commonInfo.enlistDomainsFromSource();
                this.index += 2;
                this.target = true;
                continue;
            }
            if (args[this.index].startsWith(TARGET_INSTALL_DIR_EQUAL_OPTION)) {
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                String targetDirectory = args[this.index].substring(ind + 1, len);
                this.checkValidTargetDir(targetDirectory);
                this.commonInfo.setTargetInstallDir(targetDirectory);
                this.interactiveInputMap.put(TARGET, targetDirectory);
                this.commonInfo.enlistDomainsFromSource();
                ++this.index;
                this.target = true;
                continue;
            }
            if (args[this.index].startsWith(NOPROMPT)) {
                ++this.index;
                this.noprompt = true;
                if (this.commonInfo.getAdminUserName() == null) {
                    this.commonInfo.setAdminUserName(ADMINUSER);
                    this.interactiveInputMap.put(ADMINUSER, ADMINUSER);
                    this.adminuser = true;
                }
                if (this.commonInfo.getAdminPassword() == null) {
                    this.commonInfo.setAdminPassword(ADMINPASSWORD);
                    this.interactiveInputMap.put(ADMINPASSWORD, ADMINPASSWORD);
                    this.adminpassword = true;
                }
                this.commonInfo.setCertificateConversionFlag(true);
                List domainList = this.commonInfo.getDomainList();
                Iterator it = domainList.iterator();
                while (it.hasNext()) {
                    String trustJksPath;
                    String domainName = (String)it.next();
                    this.commonInfo.setCurrentDomain(domainName);
                    String password = UpgradeUtils.getUpgradeUtils(this.commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.keyStorePassword");
                    if (password == null) {
                        password = "changeit";
                    }
                    this.commonInfo.setJksKeystorePassword(password);
                    String trustPassword = UpgradeUtils.getUpgradeUtils(this.commonInfo).getJvmOptionValueFromSourceConfig("javax.net.ssl.trustStorePassword");
                    if (trustPassword == null) {
                        trustPassword = "changeit";
                    }
                    this.commonInfo.setJksCAKeystorePassword(trustPassword);
                    this.commonInfo.addDomainOptionName(domainName);
                    this.interactiveInputMap.put("domain-" + this.commonInfo.getCurrentDomain(), domainName);
                    this.interactiveInputMap.put("jkspwd-" + domainName, password);
                    this.interactiveInputMap.put("capwd-" + domainName, password);
                    String jksPath = this.commonInfo.getSourceJKSKeyStorePath();
                    if (!PasswordVerifier.verifyKeystorePassword(jksPath, password)) {
                        this.commonInfo.recover();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                        System.exit(1);
                    }
                    if (PasswordVerifier.verifyKeystorePassword(trustJksPath = this.commonInfo.getSourceTrustedJKSKeyStorePath(), trustPassword)) continue;
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                    System.exit(1);
                }
                this.jkskeystorePwd = true;
                this.jkscakeystorePwd = true;
                continue;
            }
            if (args[this.index].equals(CLINSTANCE) || args[this.index].equals(CLINSTANCE_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"-i/--clinstancefiles");
                this.argumentCheck(args, this.index + 2, msg);
                StringTokenizer st = new StringTokenizer(args[this.index + 1], ",");
                Vector<String> clinstanceList = new Vector<String>();
                while (st.hasMoreTokens()) {
                    clinstanceList.add((String)st.nextElement());
                }
                this.commonInfo.processClinstnceConfFiles(clinstanceList);
                this.interactiveInputMap.put(CLINSTANCEINFO, args[this.index + 1]);
                this.index += 2;
                this.clinstance = true;
                continue;
            }
            if (args[this.index].equals(ADMIN_USER) || args[this.index].equals(ADMIN_USER_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--adminuser/-a");
                this.argumentCheck(args, this.index + 2, msg);
                this.commonInfo.setAdminUserName(args[this.index + 1]);
                this.interactiveInputMap.put(ADMINUSER, args[this.index + 1]);
                this.index += 2;
                this.adminuser = true;
                continue;
            }
            if (args[this.index].startsWith(ADMIN_USER_EQUAL_OPTION)) {
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                String adminUser = args[this.index].substring(ind + 1, len);
                this.commonInfo.setAdminUserName(adminUser);
                this.interactiveInputMap.put(ADMINUSER, adminUser);
                ++this.index;
                this.adminuser = true;
                continue;
            }
            if (args[this.index].equals(ADMIN_PASSWORD) || args[this.index].equals(ADMIN_PASSWORD_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--adminpassword/-w");
                this.argumentCheck(args, this.index + 2, msg);
                this.commonInfo.setAdminPassword(args[this.index + 1]);
                this.interactiveInputMap.put(ADMINPASSWORD, args[this.index + 1]);
                this.index += 2;
                this.adminpassword = true;
                if (!this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) continue;
                this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), null);
                continue;
            }
            if (args[this.index].startsWith(ADMIN_PASSWORD_EQUAL_OPTION)) {
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                String adminPassword = args[this.index].substring(ind + 1, len);
                this.commonInfo.setAdminPassword(adminPassword);
                this.interactiveInputMap.put(ADMINPASSWORD, adminPassword);
                ++this.index;
                this.adminpassword = true;
                if (!this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) continue;
                this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), null);
                continue;
            }
            if (args[this.index].equals(NSS_PWD_FILE) || args[this.index].equals(NSS_PWD_FILE_SHORT)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--nsspwdfile/-n");
                this.argumentCheck(args, this.index + 2, msg);
                nssPwdFile = args[this.index + 1];
                String password = "";
                if (this.commonInfo.getSourceVersion().equals("7x") || this.commonInfo.getTargetVersionAndEdition().equals("as81se") || this.commonInfo.getTargetVersionAndEdition().equals("as81ee")) {
                    password = this.readPassword(nssPwdFile);
                    if (password == null) {
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                        System.exit(1);
                    }
                    this.commonInfo.setCertDbPassword(password);
                    this.commonInfo.setNSSPwdFile(nssPwdFile);
                    boolean validpwd2 = PasswordVerifier.verifySourceNSSPassword(this.commonInfo);
                    if (!validpwd2) {
                        this.commonInfo.recover();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
                        System.exit(1);
                    }
                }
                this.index += 2;
                this.interactiveInputMap.put("nsspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.nsskeystorePwd = true;
                continue;
            }
            if (args[this.index].startsWith(NSS_PWD_FILE_EQUAL_OPTION)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                nssPwdFile = args[this.index].substring(ind + 1, len);
                String password = "";
                if (this.commonInfo.getSourceVersion().equals("7x") || this.commonInfo.getTargetVersionAndEdition().equals("as81se") || this.commonInfo.getTargetVersionAndEdition().equals("as81ee")) {
                    password = this.readPassword(nssPwdFile);
                    if (password == null) {
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                        System.exit(1);
                    }
                    this.commonInfo.setCertDbPassword(password);
                    this.commonInfo.setNSSPwdFile(nssPwdFile);
                    boolean validpwd3 = PasswordVerifier.verifySourceNSSPassword(this.commonInfo);
                    if (!validpwd3) {
                        this.commonInfo.recover();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
                        System.exit(1);
                    }
                }
                ++this.index;
                this.interactiveInputMap.put("nsspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.nsskeystorePwd = true;
                continue;
            }
            if (args[this.index].equals(TARGET_NSS_PWD_FILE) || args[this.index].equals(TARGET_NSS_PWD_FILE_SHORT)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--targetnsspwdfile/-n");
                this.argumentCheck(args, this.index + 2, msg);
                nssPwdFile = args[this.index + 1];
                String password = "";
                if (this.commonInfo.getSourceVersion().equals("7x") || this.commonInfo.getTargetVersionAndEdition().equals("as81se") || this.commonInfo.getTargetVersionAndEdition().equals("as81ee")) {
                    password = this.readPassword(nssPwdFile);
                    if (password == null) {
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                        System.exit(1);
                    }
                    this.commonInfo.setTargetCertDbPassword(password);
                    this.commonInfo.setTargetNSSPwdFile(nssPwdFile);
                    boolean validpwd4 = PasswordVerifier.verifyTargetNSSPassword(this.commonInfo, this.commonInfo.getTargetConfig());
                    if (!validpwd4) {
                        this.commonInfo.recover();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_target_nss_password"));
                        System.exit(1);
                    }
                }
                this.index += 2;
                this.interactiveInputMap.put("targetnsspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.nsstargetkeystorePwd = true;
                continue;
            }
            if (args[this.index].startsWith(TARGET_NSS_PWD_FILE_EQUAL_OPTION)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                nssPwdFile = args[this.index].substring(ind + 1, len);
                String password = "";
                if (this.commonInfo.getSourceVersion().equals("7x") || this.commonInfo.getTargetVersionAndEdition().equals("as81se") || this.commonInfo.getTargetVersionAndEdition().equals("as81ee")) {
                    password = this.readPassword(nssPwdFile);
                    if (password == null) {
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                        System.exit(1);
                    }
                    this.commonInfo.setTargetCertDbPassword(password);
                    this.commonInfo.setTargetNSSPwdFile(nssPwdFile);
                    boolean validpwd5 = PasswordVerifier.verifyTargetNSSPassword(this.commonInfo, this.commonInfo.getTargetConfig());
                    if (!validpwd5) {
                        this.commonInfo.recover();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_target_nss_password"));
                        System.exit(1);
                    }
                }
                ++this.index;
                this.interactiveInputMap.put("targetnsspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.nsstargetkeystorePwd = true;
                continue;
            }
            if (args[this.index].equals(JKS_PWD_FILE) || args[this.index].equals(JKS_PWD_FILE_SHORT)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--jkspwdfile/-j");
                this.argumentCheck(args, this.index + 2, msg);
                jksPwdFile = args[this.index + 1];
                String password = this.readPassword(jksPwdFile);
                if (password == null) {
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                    System.exit(1);
                }
                this.commonInfo.setJksKeystorePassword(password);
                String jksPath = "";
                jksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetJKSKeyStorePath() : this.commonInfo.getSourceJKSKeyStorePath();
                boolean validpwd6 = PasswordVerifier.verifyKeystorePassword(jksPath, password);
                if (!validpwd6) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                    System.exit(1);
                }
                this.index += 2;
                this.interactiveInputMap.put("jkspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.jkskeystorePwd = true;
                continue;
            }
            if (args[this.index].startsWith(JKS_PWD_FILE_EQUAL_OPTION)) {
                int len;
                int ind;
                String password;
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                if ((password = this.readPassword(jksPwdFile = args[this.index].substring((ind = args[this.index].indexOf("=")) + 1, len = args[this.index].length()))) == null) {
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                    System.exit(1);
                }
                this.commonInfo.setJksKeystorePassword(password);
                String jksPath = "";
                jksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetJKSKeyStorePath() : this.commonInfo.getSourceJKSKeyStorePath();
                validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, password);
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                    System.exit(1);
                }
                ++this.index;
                this.interactiveInputMap.put("jkspwd-" + this.commonInfo.getCurrentDomain(), password);
                this.jkskeystorePwd = true;
                continue;
            }
            if (args[this.index].equals(JKS_CA_PWD_FILE) || args[this.index].equals(JKS_CA_PWD_FILE_SHORT)) {
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--capwdfile/-p");
                this.argumentCheck(args, this.index + 2, msg);
                jkscaPwdFile = args[this.index + 1];
                String password = this.readPassword(jkscaPwdFile);
                if (password == null) {
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                    System.exit(1);
                }
                this.commonInfo.setJksCAKeystorePassword(password);
                String trustJksPath = "";
                trustJksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetTrustedJKSKeyStorePath() : this.commonInfo.getSourceTrustedJKSKeyStorePath();
                boolean validpwd7 = PasswordVerifier.verifyKeystorePassword(trustJksPath, password);
                if (!validpwd7) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                    System.exit(1);
                }
                this.index += 2;
                this.interactiveInputMap.put("capwd-" + this.commonInfo.getCurrentDomain(), password);
                this.jkscakeystorePwd = true;
                continue;
            }
            if (args[this.index].startsWith(JKS_CA_PWD_FILE_EQUAL_OPTION)) {
                int len;
                int ind;
                String password;
                String commonInfoCurrentDomain = this.commonInfo.getCurrentDomain();
                if (commonInfoCurrentDomain == null || this.currentDomain == null || !commonInfoCurrentDomain.equals(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_option_missing"));
                    System.exit(1);
                }
                if ((password = this.readPassword(jkscaPwdFile = args[this.index].substring((ind = args[this.index].indexOf("=")) + 1, len = args[this.index].length()))) == null) {
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)args[this.index + 1]));
                    System.exit(1);
                }
                this.commonInfo.setJksCAKeystorePassword(password);
                String trustJksPath = "";
                trustJksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetTrustedJKSKeyStorePath() : this.commonInfo.getSourceTrustedJKSKeyStorePath();
                validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, password);
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                    System.exit(1);
                }
                ++this.index;
                this.interactiveInputMap.put("capwd-" + this.commonInfo.getCurrentDomain(), password);
                this.jkscakeystorePwd = true;
                continue;
            }
            if (args[this.index].equals(DOMAIN_NAME) || args[this.index].equals(DOMAIN_NAME_SHORT)) {
                String domainName;
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--domain/-d");
                this.argumentCheck(args, this.index + 2, msg);
                this.currentDomain = domainName = args[this.index + 1];
                if (!this.commonInfo.getDomainList().contains(domainName)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist", (Object)domainName));
                    System.exit(1);
                }
                this.commonInfo.setCurrentDomain(domainName);
                this.commonInfo.addDomainOptionName(domainName);
                this.index += 2;
                this.interactiveInputMap.put("domain-" + this.commonInfo.getCurrentDomain(), domainName);
                continue;
            }
            if (args[this.index].startsWith(DOMAIN_NAME_EQUAL_OPTION)) {
                int ind = args[this.index].indexOf("=");
                int len = args[this.index].length();
                this.currentDomain = args[this.index].substring(ind + 1, len);
                if (!this.commonInfo.getDomainList().contains(this.currentDomain)) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist", (Object)this.currentDomain));
                    System.exit(1);
                }
                this.commonInfo.setCurrentDomain(this.currentDomain);
                this.commonInfo.addDomainOptionName(this.currentDomain);
                ++this.index;
                this.interactiveInputMap.put("domain-" + this.commonInfo.getCurrentDomain(), this.currentDomain);
                continue;
            }
            if (args[this.index].equals(PWFILE_LONG) || args[this.index].equals(PWFILE_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--passwordfile/-f");
                this.argumentCheck(args, this.index + 2, msg);
                this.commonInfo.setPasswordsFromFile(args[this.index + 1]);
                this.interactiveInputMap.put(MASTERPASSWORD, this.commonInfo.getMasterPassword());
                this.interactiveInputMap.put(ADMINPASSWORD, this.commonInfo.getAdminPassword());
                if (!this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) {
                    this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), this.commonInfo.getMasterPassword());
                } else {
                    this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), null);
                }
                this.index += 2;
                continue;
            }
            if (args[this.index].equals(MASTER_PASSWORD_LONG) || args[this.index].equals(MASTER_PASSWORD_SHORT)) {
                String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--masterpassword/-m");
                this.argumentCheck(args, this.index + 2, msg);
                this.commonInfo.setMasterPassword(args[this.index + 1]);
                this.interactiveInputMap.put(MASTERPASSWORD, this.commonInfo.getMasterPassword());
                if (!this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) {
                    this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), this.commonInfo.getMasterPassword());
                }
                this.index += 2;
                continue;
            }
            if (args[this.index].equals(VERSION_LONG)) {
                _logger.info("asupgrade v1.1");
                System.exit(0);
                continue;
            }
            if (args[this.index].equals(VERSION_SHORT)) {
                _logger.info("asupgrade v1.1");
                System.exit(0);
                continue;
            }
            if (args[this.index].equals(HELP) || args[this.index].equals(HELP_SHORT) || args[this.index].equals(HELP_QUESTION)) {
                this.helpUsage();
                System.exit(0);
                continue;
            }
            if (args[this.index].equals(CONSOLE_LONG) || args[this.index].equals(CONSOLE_SHORT)) {
                ++this.index;
                continue;
            }
            String msg = this.sm.getString("enterprise.tools.upgrade.cli.invalid_option", (Object)args[this.index]);
            this.helpUsage(msg);
            System.exit(1);
        }
    }

    private void checkValidSourceDir(String sourceDir) {
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).isValidSourcePath(sourceDir)) {
            this.helpUsage();
            _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
            System.exit(1);
        }
    }

    private void checkValidTargetDir(String targetDir) {
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).isValidTargetPath(targetDir)) {
            File biDir = new File(targetDir + File.separator + "bin");
            String certUtilPath = "";
            certUtilPath = this.commonInfo.getOSName().indexOf("Windows") == -1 ? targetDir + File.separator + "lib" + File.separator + "certutil" : targetDir + File.separator + "lib" + File.separator + "certutil.exe";
            File certutil = new File(certUtilPath);
            if (!biDir.isDirectory() || !certutil.isFile()) {
                this.helpUsage();
                _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
                System.exit(1);
            }
        }
    }

    private void checkCertificateArguments(String[] args, int index) {
        int length = args.length;
        if (index + 7 > length) {
            String msg = this.sm.getString("enterprise.tools.upgrade.cli.all_password_required", (Object)this.currentDomain);
            this.helpUsage(msg);
            System.exit(1);
        }
        int dummy = index + 1;
        int check = 1;
        while (dummy < length && !args[dummy].startsWith(DOMAIN_NAME) && !args[dummy].equals(DOMAIN_NAME_SHORT)) {
            ++dummy;
            ++check;
        }
        if (check != 8) {
            this.helpUsage();
            System.exit(1);
        }
    }

    private void checkCertificateArgumentsWithEqualOption(String[] args, int index) {
        int length = args.length;
        if (index + 3 > length) {
            String msg = this.sm.getString("enterprise.tools.upgrade.cli.all_password_required", (Object)this.currentDomain);
            this.helpUsage(msg);
            System.exit(1);
        }
        int dummy = index + 1;
        int check = 1;
        while (dummy < length && !args[dummy].startsWith(DOMAIN_NAME) && !args[dummy].equals(DOMAIN_NAME_SHORT)) {
            ++dummy;
            ++check;
        }
        if (check != 4) {
            this.helpUsage();
            System.exit(1);
        }
    }

    private void argumentCheck(String[] args, int index, String help) {
        int argIndex = index - 1;
        if (index > args.length || args[argIndex].startsWith(LONG_OPTION)) {
            this.helpUsage(help);
            System.exit(1);
        }
    }

    public void verifyValidInteractiveConsoleInput() {
        File biDir;
        byte[] b;
        String domainName;
        if (this.noprompt) {
            return;
        }
        List domainList = this.commonInfo.getDomainList();
        Iterator itr = domainList.iterator();
        while (itr.hasNext()) {
            domainName = (String)itr.next();
            String suffix = "-" + domainName;
            if ((this.interactiveInputMap.get(SOURCE) == null || this.interactiveInputMap.get(TARGET) == null) && this.interactiveInputMap.get(DOMAIN + suffix) != null) {
                this.helpUsage();
                System.exit(1);
            }
            if (this.interactiveInputMap.get(NSSPWD + suffix) == null && this.interactiveInputMap.get(JKSPWD + suffix) == null && this.interactiveInputMap.get(CAPWD + suffix) == null || this.interactiveInputMap.get(DOMAIN + suffix) != null) continue;
            this.helpUsage();
            System.exit(1);
        }
        if (this.interactiveInputMap.get(SOURCE) == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Source_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String sourceDir = new String(b, 0, c);
                String source = sourceDir.trim();
                biDir = new File(source + File.separator + "bin");
                if (!(!source.equals("") && biDir.isDirectory() || this.commonInfo.checkSourceInputAsDomainRoot(source))) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_source_install"));
                    System.exit(1);
                }
                if (this.commonInfo.checkSourceInputAsDomainRoot(source)) {
                    this.commonInfo.setSourceDomainRoot(source);
                }
                this.commonInfo.setSourceInstallDir(source);
                this.interactiveInputMap.put(SOURCE, source);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (this.interactiveInputMap.get(TARGET) == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String targetDir = new String(b, 0, c);
                String target = targetDir.trim();
                biDir = new File(target + File.separator + "bin");
                String certUtilPath = "";
                certUtilPath = this.commonInfo.getOSName().indexOf("Windows") == -1 ? target + File.separator + "lib" + File.separator + "certutil" : target + File.separator + "lib" + File.separator + "certutil.exe";
                File certutil = new File(certUtilPath);
                if (!biDir.isDirectory() || !certutil.isFile()) {
                    this.helpUsage();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.not_valid_target_install"));
                    System.exit(1);
                }
                this.commonInfo.setTargetInstallDir(target);
                this.commonInfo.enlistDomainsFromSource();
                this.interactiveInputMap.put(TARGET, target);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (this.interactiveInputMap.get(ADMINUSER) == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminuser_input"));
            b = new byte[1024];
            try {
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                String adminUser = new String(b, 0, c);
                String admiuser = adminUser.trim();
                this.commonInfo.setAdminUserName(admiuser);
                this.interactiveInputMap.put(ADMINUSER, admiuser);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (this.interactiveInputMap.get(ADMINPASSWORD) == null) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.adminpassword_input"));
            b = new byte[1024];
            try {
                String adminPassword = new CliUtil().getPassword();
                this.commonInfo.setAdminPassword(adminPassword);
                this.interactiveInputMap.put(ADMINPASSWORD, adminPassword);
                this.interactiveInput = true;
                if (this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) {
                    this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), null);
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        if (this.interactiveInputMap.get(CLINSTANCEINFO) == null && this.commonInfo.checkUpgradefrom7xeeto8xee()) {
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.clinstance_input"));
            b = new byte[1024];
            try {
                String clinstance;
                String clinstancetrim;
                int c = System.in.read(b);
                if (c == -1) {
                    System.exit(1);
                }
                if ((clinstancetrim = (clinstance = new String(b, 0, c)).trim()).length() > 2) {
                    StringTokenizer st = new StringTokenizer(clinstancetrim, ",");
                    Vector<Object> clinstanceList = new Vector<Object>();
                    while (st.hasMoreTokens()) {
                        clinstanceList.add(st.nextElement());
                    }
                    this.commonInfo.processClinstnceConfFiles(clinstanceList);
                }
                this.interactiveInputMap.put(CLINSTANCEINFO, clinstancetrim);
                this.interactiveInput = true;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
            }
        }
        domainList = this.commonInfo.getDomainList();
        itr = domainList.iterator();
        while (itr.hasNext()) {
            String password;
            domainName = (String)itr.next();
            String suffix = "-" + domainName;
            boolean certmigration = false;
            if (this.interactiveInputMap.get(DOMAIN + suffix) == null) {
                String answer = "no";
                while (true) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Ask_domain_cert_migration", (Object)domainName));
                    byte[] b2 = new byte[1024];
                    try {
                        String ans;
                        int c = System.in.read(b2);
                        if (c == -1) {
                            System.exit(1);
                        }
                        if (!(answer = (ans = new String(b2, 0, c)).trim()).equalsIgnoreCase("yes") && !answer.equalsIgnoreCase("y") && !answer.equalsIgnoreCase("no") && !answer.equalsIgnoreCase("n") && !answer.equalsIgnoreCase("")) continue;
                    }
                    catch (Exception e) {
                        _logger.log(Level.SEVERE, this.sm.getString("enterprise.tools.upgrade.cli.unexpectedException"), e);
                        continue;
                    }
                    break;
                }
                if (answer.equalsIgnoreCase("yes") || answer.equalsIgnoreCase("y")) {
                    if (!this.commonInfo.getDomainList().contains(domainName)) {
                        this.helpUsage();
                        _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.domain_does_not_exist", (Object)domainName));
                        System.exit(1);
                    }
                    this.commonInfo.setCurrentDomain(domainName);
                    this.commonInfo.addDomainOptionName(domainName);
                    this.interactiveInputMap.put("domain-" + this.commonInfo.getCurrentDomain(), domainName);
                    this.interactiveInput = true;
                    this.commonInfo.setCertificateConversionFlag(true);
                    certmigration = true;
                }
            } else {
                this.commonInfo.setCertificateConversionFlag(true);
                certmigration = true;
            }
            if (this.interactiveInputMap.get(NSSPWD + suffix) == null && certmigration && (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse() || this.commonInfo.checkUpgradefrom7xpeseto8xse())) {
                if (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.NSS_pwd_input"));
                }
                if (this.commonInfo.checkUpgradefrom8xpeto8xse()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                }
                password = new CliUtil().getPassword();
                this.commonInfo.setCertDbPassword(password);
                boolean validpwd = PasswordVerifier.verifySourceNSSPassword(this.commonInfo);
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
                    System.exit(1);
                }
                this.interactiveInputMap.put("nsspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (this.interactiveInputMap.get(TARGETNSSPWD + suffix) == null && certmigration && this.commonInfo.checkUpgradefrom7xpeseto8xse()) {
                System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_NSS_pwd_input"));
                password = new CliUtil().getPassword();
                this.commonInfo.setTargetCertDbPassword(password);
                boolean validpwd = PasswordVerifier.verifyTargetNSSPassword(this.commonInfo, this.commonInfo.getTargetConfig());
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_target_nss_password"));
                    System.exit(1);
                }
                this.interactiveInputMap.put("targetnsspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (this.interactiveInputMap.get(JKSPWD + suffix) == null && certmigration && (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse() || this.commonInfo.checkUpgradefrom80peto81pe())) {
                if (this.commonInfo.checkUpgradefrom7xpeseto8xpe()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_JKS_input"));
                }
                if (this.commonInfo.checkUpgradefrom8xpeto8xse()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.JKS_input"));
                }
                if (this.commonInfo.checkUpgradefrom80peto81pe()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.JKS_password"));
                }
                password = new CliUtil().getPassword();
                this.commonInfo.setJksKeystorePassword(password);
                String jksPath = "";
                jksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetJKSKeyStorePath() : this.commonInfo.getSourceJKSKeyStorePath();
                boolean validpwd = PasswordVerifier.verifyKeystorePassword(jksPath, password);
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_keypair_password"));
                    System.exit(1);
                }
                this.interactiveInputMap.put("jkspwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (this.interactiveInputMap.get(CAPWD + suffix) == null && certmigration && (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse() || this.commonInfo.checkUpgradefrom80peto81pe())) {
                if (this.commonInfo.checkUpgradefrom7xpeseto8xpe()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.Target_CA_input"));
                }
                if (this.commonInfo.checkUpgradefrom8xpeto8xse()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.CA_input"));
                }
                if (this.commonInfo.checkUpgradefrom80peto81pe()) {
                    System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.CA_password"));
                }
                password = new CliUtil().getPassword();
                this.commonInfo.setJksCAKeystorePassword(password);
                String trustJksPath = "";
                trustJksPath = this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom7xpeseto8xse() ? this.commonInfo.getTargetTrustedJKSKeyStorePath() : this.commonInfo.getSourceTrustedJKSKeyStorePath();
                boolean validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, password);
                if (!validpwd) {
                    this.commonInfo.recover();
                    _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
                    System.exit(1);
                }
                this.interactiveInputMap.put("capwd-" + domainName, password);
                this.interactiveInput = true;
            }
            if (this.commonInfo.getTargetVersionAndEdition().equals("as81pe") || this.interactiveInputMap.get(MASTERPASSWORD) != null) continue;
            System.out.print(this.sm.getString("enterprise.tools.upgrade.cli.MasterPW_input"));
            password = new CliUtil().getPassword();
            this.commonInfo.setMasterPassword(password);
            this.interactiveInputMap.put(MASTERPASSWORD, password);
            this.verifyUserAndPasswords(this.commonInfo.getAdminUserName(), this.commonInfo.getAdminPassword(), password);
            this.interactiveInput = true;
        }
    }

    private void verifyUserAndPasswords(String adminUser, String adminPassword, String masterPassword) {
        if (!this.commonInfo.getTargetVersionAndEdition().equals("as81pe")) {
            if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).validateUserDetails(adminUser, adminPassword, masterPassword)) {
                _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
                System.exit(1);
            }
        } else if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).validateUserDetails(adminUser, adminPassword, masterPassword)) {
            _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword"));
            System.exit(1);
        }
    }

    public void verifyCommonInfo(String[] args) {
        String msg;
        if (this.commonInfo.getSourceInstallDir().equals(this.commonInfo.getTargetInstallDir())) {
            msg = this.sm.getString("enterprise.tools.upgrade.cli.Invalid_input_directory");
            this.helpUsage(msg);
            System.exit(1);
        }
        if (args.length < 3) {
            this.helpUsage();
            System.exit(1);
        }
        if (!(this.source && this.target && this.adminuser && this.adminpassword)) {
            this.helpUsage();
            System.exit(1);
        }
        if (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse()) {
            if (!(this.jkskeystorePwd && this.nsskeystorePwd && this.jkscakeystorePwd || !this.jkskeystorePwd && !this.nsskeystorePwd && !this.jkscakeystorePwd)) {
                msg = this.sm.getString("enterprise.tools.upgrade.cli.all_password_required", (Object)this.currentDomain);
                this.helpUsage(msg);
                System.exit(1);
            }
            if (this.jkskeystorePwd && this.nsskeystorePwd && this.jkscakeystorePwd) {
                this.commonInfo.setCertificateConversionFlag(true);
            }
        }
        if (this.commonInfo.checkUpgradefrom7xpeseto8xse()) {
            if (!(this.nsskeystorePwd && this.nsstargetkeystorePwd || !this.nsskeystorePwd && !this.nsstargetkeystorePwd)) {
                msg = this.sm.getString("enterprise.tools.upgrade.cli.both_nss_passwords_required", (Object)this.currentDomain);
                this.helpUsage(msg);
                System.exit(0);
            }
            if (this.nsskeystorePwd && this.nsstargetkeystorePwd) {
                this.commonInfo.setCertificateConversionFlag(true);
            }
        }
        if (!(!this.commonInfo.checkUpgradefrom80peto81pe() || this.jkskeystorePwd && this.jkscakeystorePwd || !this.jkskeystorePwd && !this.jkscakeystorePwd)) {
            msg = this.sm.getString("enterprise.tools.upgrade.cli.keypair_ca_password_required", (Object)this.currentDomain);
            this.helpUsage(msg);
            System.exit(1);
        }
        if (this.commonInfo.checkUpgradefrom80peto81pe() && this.jkskeystorePwd && this.jkscakeystorePwd) {
            this.commonInfo.setCertificateConversionFlag(true);
        }
        if (this.jkskeystorePwd && this.nsskeystorePwd && this.jkscakeystorePwd) {
            this.commonInfo.setCertificateConversionFlag(true);
        }
    }

    private void helpUsage(String str) {
        this.helpUsage();
        System.out.println(str);
    }

    private void helpUsage() {
        System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.usage"));
        this.commonInfo.recover();
        if (this.commonInfo.checkUpgradefrom7xpeseto8xpe() || this.commonInfo.checkUpgradefrom8xpeto8xse()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.command_string"));
            System.out.println();
            return;
        }
        if (this.commonInfo.checkUpgradefrom7xpeseto8xse()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.commandfrom7xseto8xse_string"));
            System.out.println();
            return;
        }
        if (this.commonInfo.checkUpgradefrom80peto81pe()) {
            System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.commandfrom80peto81pe_string"));
            System.out.println();
            return;
        }
        System.out.println(this.sm.getString("enterprise.tools.upgrade.cli.command_string"));
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CLIParser parser = new CLIParser();
        parser.setCommonInfoModel(new CommonInfoModel());
        parser.parseComandLineArguments(args);
        parser.printInfo();
    }

    public static Logger getDefaultLogger() {
        if (_logger == null) {
            _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
        }
        return _logger;
    }

    private String readPassword(String pwdfile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pwdfile)));
            String password = reader.readLine();
            if (password != null) {
                password = password.trim();
            } else {
                _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile));
                System.exit(1);
            }
            return password;
        }
        catch (FileNotFoundException fe) {
            this.helpUsage();
            _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_file_missing", (Object)pwdfile));
            System.exit(1);
        }
        catch (Exception io) {
            _logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_missing", (Object)pwdfile));
            System.exit(1);
        }
        return null;
    }
}

