/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.connectors.ConnectionManagerImpl;
import com.sun.gjc.spi.ConnectionHolder;
import com.sun.gjc.spi.ConnectionManager;
import com.sun.gjc.spi.ConnectionRequestInfo;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;

public class DataSource
implements javax.sql.DataSource,
Serializable,
com.sun.appserv.jdbc.DataSource,
Referenceable {
    private ManagedConnectionFactory mcf;
    private javax.resource.spi.ConnectionManager cm;
    private int loginTimeout;
    private PrintWriter logWriter;
    private String description;
    private Reference reference;
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = false;

    public DataSource(ManagedConnectionFactory mcf, javax.resource.spi.ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm == null ? new ConnectionManager() : cm;
    }

    public Connection getConnection() throws SQLException {
        try {
            return (Connection)this.cm.allocateConnection(this.mcf, null);
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getConnection(String user, String pwd) throws SQLException {
        try {
            ConnectionRequestInfo info = new ConnectionRequestInfo(user, pwd);
            return (Connection)this.cm.allocateConnection(this.mcf, (javax.resource.spi.ConnectionRequestInfo)info);
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getConnection(Connection con) throws SQLException {
        Connection driverCon = con;
        if (con instanceof ConnectionHolder) {
            driverCon = ((ConnectionHolder)con).getConnection();
        }
        return driverCon;
    }

    public Connection getNonTxConnection() throws SQLException {
        try {
            return (Connection)((ConnectionManagerImpl)this.cm).allocateNonTxConnection(this.mcf, null);
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public Connection getNonTxConnection(String user, String password) throws SQLException {
        try {
            ConnectionRequestInfo cxReqInfo = new ConnectionRequestInfo(user, password);
            return (Connection)((ConnectionManagerImpl)this.cm).allocateNonTxConnection(this.mcf, (javax.resource.spi.ConnectionRequestInfo)cxReqInfo);
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "jdbc.exc_get_conn", re.getMessage());
            throw new SQLException(re.getMessage());
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = loginTimeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.logWriter = logWriter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }
}

