/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.common.DataSourceSpec;
import com.sun.gjc.spi.DataSource;
import com.sun.gjc.spi.ManagedConnection;
import com.sun.gjc.util.SecurityUtils;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;

public abstract class ManagedConnectionFactory
implements javax.resource.spi.ManagedConnectionFactory,
ValidatingManagedConnectionFactory,
Serializable {
    protected DataSourceSpec spec = new DataSourceSpec();
    protected transient DataSourceObjectBuilder dsObjBuilder;
    protected PrintWriter logWriter = null;
    protected ResourceAdapter ra = null;
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = false;

    public Object createConnectionFactory() {
        if (this.logWriter != null) {
            this.logWriter.println("In createConnectionFactory()");
        }
        DataSource cf = new DataSource(this, null);
        return cf;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) {
        if (this.logWriter != null) {
            this.logWriter.println("In createConnectionFactory(javax.resource.spi.ConnectionManager cxManager)");
        }
        DataSource cf = new DataSource(this, cxManager);
        return cf;
    }

    public abstract javax.resource.spi.ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract boolean equals(Object var1);

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public ResourceAdapter getResourceAdapter() {
        if (this.logWriter != null) {
            this.logWriter.println("In getResourceAdapter");
        }
        return this.ra;
    }

    public int hashCode() {
        if (this.logWriter != null) {
            this.logWriter.println("In hashCode");
        }
        return this.spec.hashCode();
    }

    public javax.resource.spi.ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In matchManagedConnections");
        }
        if (connectionSet == null) {
            return null;
        }
        PasswordCredential pc = SecurityUtils.getPasswordCredential(this, subject, cxRequestInfo);
        Iterator iter = connectionSet.iterator();
        ManagedConnection mc = null;
        while (iter.hasNext()) {
            try {
                mc = (ManagedConnection)iter.next();
            }
            catch (NoSuchElementException nsee) {
                _logger.log(Level.SEVERE, "jdbc.exc_iter");
                throw new ResourceException(nsee.getMessage());
            }
            if (pc == null && this.equals(mc.getManagedConnectionFactory())) {
                try {
                    this.isValid(mc);
                    return mc;
                }
                catch (ResourceException re) {
                    _logger.log(Level.SEVERE, "jdbc.exc_re", re);
                    mc.connectionErrorOccurred((Exception)((Object)re), null);
                    continue;
                }
            }
            if (!SecurityUtils.isPasswordCredentialEqual(pc, mc.getPasswordCredential())) continue;
            try {
                this.isValid(mc);
                return mc;
            }
            catch (ResourceException re) {
                _logger.log(Level.SEVERE, "jdbc.re");
                mc.connectionErrorOccurred((Exception)((Object)re), null);
            }
        }
        return null;
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        Iterator iter = connectionSet.iterator();
        HashSet<ManagedConnection> invalid = new HashSet<ManagedConnection>();
        while (iter.hasNext()) {
            ManagedConnection mc = (ManagedConnection)iter.next();
            try {
                this.isValid(mc);
            }
            catch (ResourceException re) {
                invalid.add(mc);
                mc.connectionErrorOccurred((Exception)((Object)re), null);
            }
        }
        return invalid;
    }

    void isValid(ManagedConnection mc) throws ResourceException {
        boolean connectionValidationRequired;
        if (mc.isTransactionInProgress()) {
            return;
        }
        String conVal = this.spec.getDetail(25);
        boolean bl = connectionValidationRequired = conVal == null ? false : new Boolean(conVal.toLowerCase());
        if (!connectionValidationRequired || mc == null) {
            return;
        }
        String validationMethod = this.spec.getDetail(26).toLowerCase();
        mc.checkIfValid();
        Connection con = mc.getActualConnection();
        if (validationMethod.equals("auto-commit")) {
            this.isValidByAutoCommit(con);
        } else if (validationMethod.equalsIgnoreCase("meta-data")) {
            this.isValidByMetaData(con);
        } else if (validationMethod.equalsIgnoreCase("table")) {
            this.isValidByTableQuery(con, this.spec.getDetail(27));
        } else {
            throw new ResourceException("The validation method is not proper");
        }
    }

    protected void isValidByAutoCommit(Connection con) throws ResourceException {
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        try {
            boolean ac = con.getAutoCommit();
            if (ac) {
                con.setAutoCommit(false);
            } else {
                con.rollback();
                con.setAutoCommit(true);
            }
            con.setAutoCommit(ac);
        }
        catch (Exception sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_autocommit");
            throw new ResourceException(sqle.getMessage());
        }
    }

    protected void isValidByMetaData(Connection con) throws ResourceException {
        if (con == null) {
            throw new ResourceException("The connection is not valid as the connection is null");
        }
        try {
            DatabaseMetaData dmd = con.getMetaData();
        }
        catch (Exception sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_md");
            throw new ResourceException("The connection is not valid as getting the meta data failed: " + sqle.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    protected void isValidByTableQuery(Connection con, String tableName) throws ResourceException {
        block16: {
            if (con == null) {
                throw new ResourceException("The connection is not valid as the connection is null");
            }
            Statement stmt = null;
            ResultSet rs = null;
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
            Object var7_5 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
                break block16;
            }
            catch (Exception e2) {}
            break block16;
            {
                catch (Exception sqle) {
                    _logger.log(Level.SEVERE, "jdbc.exc_execute");
                    throw new ResourceException("The connection is not valid as querying the table " + tableName + " failed: " + sqle.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e1) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected void setIsolation(ManagedConnection mc) throws ResourceException {
        Connection con = mc.getActualConnection();
        if (con == null) {
            return;
        }
        String tranIsolation = this.spec.getDetail(28);
        if (tranIsolation != null && !tranIsolation.equals("")) {
            int tranIsolationInt = this.getTransactionIsolationInt(tranIsolation);
            try {
                con.setTransactionIsolation(tranIsolationInt);
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "jdbc.exc_tx_level");
                throw new ResourceException("The transaction isolation could not be set: " + sqle.getMessage());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resetIsolation(ManagedConnection mc, int tranIsol) throws ResourceException {
        String guaranteeIsolationLevel;
        Connection con = mc.getActualConnection();
        if (con == null) {
            return;
        }
        String tranIsolation = this.spec.getDetail(28);
        if (tranIsolation == null || tranIsolation.equals("") || (guaranteeIsolationLevel = this.spec.getDetail(29)) == null || guaranteeIsolationLevel.equals("")) return;
        boolean guarantee = new Boolean(guaranteeIsolationLevel.toLowerCase());
        if (guarantee) {
            int tranIsolationInt = this.getTransactionIsolationInt(tranIsolation);
            try {
                if (tranIsolationInt == con.getTransactionIsolation()) return;
                con.setTransactionIsolation(tranIsolationInt);
                return;
            }
            catch (SQLException sqle) {
                _logger.log(Level.SEVERE, "jdbc.exc_tx_level");
                throw new ResourceException("The isolation level could not be set: " + sqle.getMessage());
            }
        }
        try {
            if (tranIsol == con.getTransactionIsolation()) return;
            con.setTransactionIsolation(tranIsol);
            return;
        }
        catch (SQLException sqle) {
            _logger.log(Level.SEVERE, "jdbc.exc_tx_level");
            throw new ResourceException("The isolation level could not be set: " + sqle.getMessage());
        }
    }

    private int getTransactionIsolationInt(String tranIsolation) throws ResourceException {
        if (tranIsolation.equalsIgnoreCase("read-uncommitted")) {
            return 1;
        }
        if (tranIsolation.equalsIgnoreCase("read-committed")) {
            return 2;
        }
        if (tranIsolation.equalsIgnoreCase("repeatable-read")) {
            return 4;
        }
        if (tranIsolation.equalsIgnoreCase("serializable")) {
            return 8;
        }
        throw new ResourceException("Invalid transaction isolation; the transaction isolation level can be empty or any of the following: read-uncommitted, read-committed, repeatable-read, serializable");
    }

    protected void validateAndSetIsolation(ManagedConnection mc) throws ResourceException {
        this.isValid(mc);
        this.setIsolation(mc);
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this.ra = ra;
    }

    public void setUser(String user) {
        this.spec.setDetail(1, user);
    }

    public String getUser() {
        return this.spec.getDetail(1);
    }

    public void setuser(String user) {
        this.spec.setDetail(1, user);
    }

    public String getuser() {
        return this.spec.getDetail(1);
    }

    public void setPassword(String passwd) {
        this.spec.setDetail(2, passwd);
    }

    public String getPassword() {
        return this.spec.getDetail(2);
    }

    public void setpassword(String passwd) {
        this.spec.setDetail(2, passwd);
    }

    public String getpassword() {
        return this.spec.getDetail(2);
    }

    public void setClassName(String className) {
        this.spec.setDetail(20, className);
    }

    public String getClassName() {
        return this.spec.getDetail(20);
    }

    public void setclassName(String className) {
        this.spec.setDetail(20, className);
    }

    public String getclassName() {
        return this.spec.getDetail(20);
    }

    public void setConnectionValidationRequired(String conVldReq) {
        this.spec.setDetail(25, conVldReq);
    }

    public String getConnectionValidationRequired() {
        return this.spec.getDetail(25);
    }

    public void setconnectionValidationRequired(String conVldReq) {
        this.spec.setDetail(25, conVldReq);
    }

    public String getconnectionValidationRequired() {
        return this.spec.getDetail(25);
    }

    public void setValidationMethod(String validationMethod) {
        this.spec.setDetail(26, validationMethod);
    }

    public String getValidationMethod() {
        return this.spec.getDetail(26);
    }

    public void setvalidationMethod(String validationMethod) {
        this.spec.setDetail(26, validationMethod);
    }

    public String getvalidationMethod() {
        return this.spec.getDetail(26);
    }

    public void setValidationTableName(String table) {
        this.spec.setDetail(27, table);
    }

    public String getValidationTableName() {
        return this.spec.getDetail(27);
    }

    public void setvalidationTableName(String table) {
        this.spec.setDetail(27, table);
    }

    public String getvalidationTableName() {
        return this.spec.getDetail(27);
    }

    public void setTransactionIsolation(String trnIsolation) {
        this.spec.setDetail(28, trnIsolation);
    }

    public String getTransactionIsolation() {
        return this.spec.getDetail(28);
    }

    public void settransactionIsolation(String trnIsolation) {
        this.spec.setDetail(28, trnIsolation);
    }

    public String gettransactionIsolation() {
        return this.spec.getDetail(28);
    }

    public void setGuaranteeIsolationLevel(String guaranteeIsolation) {
        this.spec.setDetail(29, guaranteeIsolation);
    }

    public String getGuaranteeIsolationLevel() {
        return this.spec.getDetail(29);
    }

    public void setguaranteeIsolationLevel(String guaranteeIsolation) {
        this.spec.setDetail(29, guaranteeIsolation);
    }

    public String getguaranteeIsolationLevel() {
        return this.spec.getDetail(29);
    }

    protected boolean isEqual(PasswordCredential pc, String user, String password) {
        String thisUser = pc == null ? null : pc.getUserName();
        char[] passwordArray = pc == null ? null : pc.getPassword();
        String thisPassword = passwordArray == null ? null : new String(passwordArray);
        return this.isStringEqual(thisUser, user) && this.isStringEqual(thisPassword, password);
    }

    private boolean isStringEqual(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public void setserverName(String serverName) {
        this.spec.setDetail(12, serverName);
    }

    public String getserverName() {
        return this.spec.getDetail(12);
    }

    public void setServerName(String serverName) {
        this.spec.setDetail(12, serverName);
    }

    public String getServerName() {
        return this.spec.getDetail(12);
    }

    public void setportNumber(String portNumber) {
        this.spec.setDetail(10, portNumber);
    }

    public String getportNumber() {
        return this.spec.getDetail(10);
    }

    public void setPortNumber(String portNumber) {
        this.spec.setDetail(10, portNumber);
    }

    public String getPortNumber() {
        return this.spec.getDetail(10);
    }

    public void setdatabaseName(String databaseName) {
        this.spec.setDetail(6, databaseName);
    }

    public String getdatabaseName() {
        return this.spec.getDetail(6);
    }

    public void setDatabaseName(String databaseName) {
        this.spec.setDetail(6, databaseName);
    }

    public String getDatabaseName() {
        return this.spec.getDetail(6);
    }

    public void setdataSourceName(String dsn) {
        this.spec.setDetail(7, dsn);
    }

    public String getdataSourceName() {
        return this.spec.getDetail(7);
    }

    public void setDataSourceName(String dsn) {
        this.spec.setDetail(7, dsn);
    }

    public String getDataSourceName() {
        return this.spec.getDetail(7);
    }

    public void setdescription(String desc) {
        this.spec.setDetail(8, desc);
    }

    public String getdescription() {
        return this.spec.getDetail(8);
    }

    public void setDescription(String desc) {
        this.spec.setDetail(8, desc);
    }

    public String getDescription() {
        return this.spec.getDetail(8);
    }

    public void setnetworkProtocol(String nwProtocol) {
        this.spec.setDetail(9, nwProtocol);
    }

    public String getnetworkProtocol() {
        return this.spec.getDetail(9);
    }

    public void setNetworkProtocol(String nwProtocol) {
        this.spec.setDetail(9, nwProtocol);
    }

    public String getNetworkProtocol() {
        return this.spec.getDetail(9);
    }

    public void setroleName(String roleName) {
        this.spec.setDetail(11, roleName);
    }

    public String getroleName() {
        return this.spec.getDetail(11);
    }

    public void setRoleName(String roleName) {
        this.spec.setDetail(11, roleName);
    }

    public String getRoleName() {
        return this.spec.getDetail(11);
    }

    public void setloginTimeOut(String loginTimeOut) {
        this.spec.setDetail(4, loginTimeOut);
    }

    public String getloginTimeOut() {
        return this.spec.getDetail(4);
    }

    public void setLoginTimeOut(String loginTimeOut) {
        this.spec.setDetail(4, loginTimeOut);
    }

    public String getLoginTimeOut() {
        return this.spec.getDetail(4);
    }

    public void setdelimiter(String delim) {
        this.spec.setDetail(21, delim);
    }

    public String getdelimiter() {
        return this.spec.getDetail(21);
    }

    public void setDelimiter(String delim) {
        this.spec.setDetail(21, delim);
    }

    public String getDelimiter() {
        return this.spec.getDetail(21);
    }

    public void setdriverProperties(String driverProps) {
        this.spec.setDetail(19, driverProps);
    }

    public String getdriverProperties() {
        return this.spec.getDetail(19);
    }

    public void setDriverProperties(String driverProps) {
        this.spec.setDetail(19, driverProps);
    }

    public String getDriverProperties() {
        return this.spec.getDetail(19);
    }
}

