/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdkCompat {
    static final String JAVA14_SUPPORT = "org.apache.tomcat.util.compat.Jdk14Compat";
    static Log logger = LogFactory.getLog(class$org$apache$tomcat$util$compat$JdkCompat == null ? (class$org$apache$tomcat$util$compat$JdkCompat = JdkCompat.class$("org.apache.tomcat.util.compat.JdkCompat")) : class$org$apache$tomcat$util$compat$JdkCompat);
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    static String javaVersion;
    static boolean java2;
    static boolean java14;
    static JdkCompat jdkCompat;
    static /* synthetic */ Class class$org$apache$tomcat$util$compat$JdkCompat;

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJava2() {
        return java2;
    }

    public static boolean isJava14() {
        return java14;
    }

    private static void init() {
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            java2 = true;
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
            java14 = true;
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (java14) {
            try {
                Class<?> c = Class.forName(JAVA14_SUPPORT);
                jdkCompat = (JdkCompat)c.newInstance();
            }
            catch (Exception ex) {
                jdkCompat = new JdkCompat();
            }
        } else {
            jdkCompat = new JdkCompat();
        }
    }

    protected JdkCompat() {
    }

    public static JdkCompat getJdkCompat() {
        return jdkCompat;
    }

    public URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURL();
    }

    public long getMaxMemory() {
        return -1L;
    }

    public String getPartialServletStackTrace(Throwable t) {
        StringWriter stackTrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTrace));
        String st = stackTrace.toString();
        int i = st.lastIndexOf("org.apache.catalina.core.ApplicationFilterChain.internalDoFilter");
        if (i > -1) {
            return st.substring(0, i - 4);
        }
        return st;
    }

    public String[] split(String path, String pat) {
        Vector<String> comps = new Vector<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.elementAt(i);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        java2 = false;
        java14 = false;
        JdkCompat.init();
    }
}

