/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.CoyoteRequest;

public class CoyoteRequestFacade
extends RequestFacade
implements HttpServletRequest {
    protected static StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    protected CoyoteRequest request = null;

    public CoyoteRequestFacade(CoyoteRequest request) {
        super(request);
        this.request = request;
    }

    public void clear() {
        this.request = null;
    }

    public Object getAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new GetAttributePrivilegedAction());
        }
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)AccessController.doPrivileged(new GetCharacterEncodingPrivilegedAction());
        }
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        this.request.setCharacterEncoding(env);
    }

    public int getContentLength() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentLength();
    }

    public String getContentType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getInputStream();
    }

    public String getParameter(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (String)AccessController.doPrivileged(new GetParameterPrivilegedAction(name));
        }
        return this.request.getParameter(name);
    }

    public Enumeration getParameterNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new GetParameterNamesPrivilegedAction());
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        String[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = (String[])AccessController.doPrivileged(new GetParameterValuePrivilegedAction(name));
            if (ret != null) {
                ret = (String[])ret.clone();
            }
        } else {
            ret = this.request.getParameterValues(name);
        }
        return ret;
    }

    public Map getParameterMap() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Map)AccessController.doPrivileged(new GetParameterMapPrivilegedAction());
        }
        return this.request.getParameterMap();
    }

    public String getProtocol() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getProtocol();
    }

    public String getScheme() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getScheme();
    }

    public String getServerName() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerName();
    }

    public int getServerPort() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Locale)AccessController.doPrivileged(new GetLocalePrivilegedAction());
        }
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new GetLocalesPrivilegedAction());
        }
        return this.request.getLocales();
    }

    public boolean isSecure() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (RequestDispatcher)AccessController.doPrivileged(new GetRequestDispatcherPrivilegedAction(path));
        }
        return this.request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRealPath(path);
    }

    public String getAuthType() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        Cookie[] ret = null;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            ret = (Cookie[])AccessController.doPrivileged(new GetCookiesPrivilegedAction());
            if (ret != null) {
                ret = (Cookie[])ret.clone();
            }
        } else {
            ret = this.request.getCookies();
        }
        return ret;
    }

    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new GetHeadersPrivilegedAction(name));
        }
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (Enumeration)AccessController.doPrivileged(new GetHeaderNamesPrivilegedAction());
        }
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getMethod();
    }

    public String getPathInfo() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getContextPath();
    }

    public String getQueryString() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getRequestURL();
    }

    public String getServletPath() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        if (SecurityUtil.isPackageProtectionEnabled()) {
            return (HttpSession)AccessController.doPrivileged(new GetSessionPrivilegedAction(create));
        }
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("requestFacade.nullRequest"));
        }
        return this.request.isRequestedSessionIdFromURL();
    }

    public CoyoteRequest getUnwrappedCoyoteRequest() throws AccessControlException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityPermission perm = new SecurityPermission("getUnwrappedCoyoteRequest");
            AccessController.checkPermission(perm);
        }
        return this.request;
    }

    private final class GetSessionPrivilegedAction
    implements PrivilegedAction {
        private boolean create;

        public GetSessionPrivilegedAction(boolean create) {
            this.create = create;
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getSession(this.create);
        }
    }

    private final class GetLocalesPrivilegedAction
    implements PrivilegedAction {
        private GetLocalesPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getLocales();
        }
    }

    private final class GetLocalePrivilegedAction
    implements PrivilegedAction {
        private GetLocalePrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getLocale();
        }
    }

    private final class GetHeaderNamesPrivilegedAction
    implements PrivilegedAction {
        private GetHeaderNamesPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getHeaderNames();
        }
    }

    private final class GetHeadersPrivilegedAction
    implements PrivilegedAction {
        private String name;

        public GetHeadersPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getHeaders(this.name);
        }
    }

    private final class GetCharacterEncodingPrivilegedAction
    implements PrivilegedAction {
        private GetCharacterEncodingPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getCharacterEncoding();
        }
    }

    private final class GetCookiesPrivilegedAction
    implements PrivilegedAction {
        private GetCookiesPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getCookies();
        }
    }

    private final class GetParameterValuePrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterValuePrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getParameterValues(this.name);
        }
    }

    private final class GetParameterNamesPrivilegedAction
    implements PrivilegedAction {
        private GetParameterNamesPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getParameterNames();
        }
    }

    private final class GetParameterPrivilegedAction
    implements PrivilegedAction {
        public String name;

        public GetParameterPrivilegedAction(String name) {
            this.name = name;
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getParameter(this.name);
        }
    }

    private final class GetRequestDispatcherPrivilegedAction
    implements PrivilegedAction {
        private String path;

        public GetRequestDispatcherPrivilegedAction(String path) {
            this.path = path;
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getRequestDispatcher(this.path);
        }
    }

    private final class GetParameterMapPrivilegedAction
    implements PrivilegedAction {
        private GetParameterMapPrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getParameterMap();
        }
    }

    private final class GetAttributePrivilegedAction
    implements PrivilegedAction {
        private GetAttributePrivilegedAction() {
        }

        public Object run() {
            return CoyoteRequestFacade.this.request.getAttributeNames();
        }
    }
}

