/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.provider;

import com.sun.enterprise.security.jauth.AuthException;
import com.sun.enterprise.security.jauth.AuthParam;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.security.jauth.SOAPAuthParam;
import com.sun.enterprise.security.jauth.ServerAuthModule;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.WssProviderSecurityEnvironment;
import com.sun.xml.wss.provider.WssProviderAuthModule;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class ServerSecurityAuthModule
extends WssProviderAuthModule
implements ServerAuthModule {
    public void initialize(AuthPolicy requestPolicy, AuthPolicy responsePolicy, CallbackHandler handler, Map options) {
        super.initialize(requestPolicy, responsePolicy, handler, options, false);
    }

    public void validateRequest(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        SecurableSoapMessage ssm;
        if (this.disableRecipient) {
            return;
        }
        if (!(param instanceof SOAPAuthParam)) {
            throw new AuthException("SOAPAuthParam needs to be passed to validateResquest");
        }
        try {
            ssm = new SecurableSoapMessage(((SOAPAuthParam)param).getRequest());
            ssm.setSubject(subject);
            this._recipient.filterMessage(ssm);
        }
        catch (XWSSecurityException xwsse) {
            throw new AuthException(xwsse.getMessage());
        }
        if (ssm.isInFaultState()) {
            throw new AuthException("Inside validateRequest: Error in filter processing");
        }
        ssm.deleteSecurityHeader();
    }

    public void secureResponse(AuthParam param, Subject subject, Map sharedState) throws AuthException {
        SecurableSoapMessage ssm;
        if (this.disableAnnotator) {
            return;
        }
        if (!(param instanceof SOAPAuthParam)) {
            throw new AuthException("SOAPAuthParam needs to be passed to secureResponse");
        }
        try {
            ssm = new SecurableSoapMessage(((SOAPAuthParam)param).getResponse());
            ((WssProviderSecurityEnvironment)this.securityEnvironment).setSubject(subject);
            this._annotator.filterMessage(ssm);
        }
        catch (XWSSecurityException xwsse) {
            throw new AuthException(xwsse.getMessage());
        }
        if (ssm.isInFaultState()) {
            throw new AuthException("Inside secureResponse: Error in filter processing");
        }
    }

    public void disposeSubject(Subject subject, Map sharedState) throws AuthException {
        if (subject == null) {
            throw new AuthException("Subject is null in disposeSubject");
        }
        if (!subject.isReadOnly()) {
            subject = new Subject();
            return;
        }
        Set<Principal> principals = subject.getPrincipals();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        try {
            principals.clear();
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        Iterator<Object> pi = privateCredentials.iterator();
        while (pi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)pi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
        Iterator<Object> qi = publicCredentials.iterator();
        while (qi.hasNext()) {
            try {
                Destroyable dstroyable = (Destroyable)qi.next();
                dstroyable.destroy();
            }
            catch (DestroyFailedException dfe) {
            }
            catch (ClassCastException cce) {}
        }
    }
}

