/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.helpers;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xml.security.c14n.helper.C14nHelper;
import com.sun.org.apache.xml.security.c14n.implementations.Canonicalizer20010315ExclOmitComments;
import com.sun.org.apache.xml.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.transforms.TransformSpi;
import com.sun.org.apache.xml.security.transforms.TransformationException;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.ReferenceElement;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.SecurityTokenReference;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.reference.DirectReference;
import com.sun.xml.wss.reference.KeyIdentifier;
import com.sun.xml.wss.reference.X509IssuerSerial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TransformSTR
extends TransformSpi {
    public static final String implementedTransformURI = "http://schemas.xmlsoap.org/2003/06/STR-Transform";
    private SecurableSoapMessage secureMessage;
    private Document soapDocument;
    private boolean isXMLToken;
    private static SOAPFactory soapFactory = null;
    protected static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected void setTransform(Transform transform) {
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            Document ownerDocument;
            this.soapDocument = ownerDocument = this.getOwnerDocument(input.getNodeSet());
            this.secureMessage = SecurableSoapMessage.getDocMessageAssociation(ownerDocument);
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            factory.setNamespaceAware(true);
            Document doc = ((DocumentBuilderFactory)factory).newDocumentBuilder().parse(input.getOctetStream());
            DocumentTraversal dt = (DocumentTraversal)((Object)doc);
            Document rootNode = doc;
            AlwaysAcceptNodeFilter nodefilter = new AlwaysAcceptNodeFilter();
            TreeWalker treewalker = dt.createTreeWalker(rootNode, -1, nodefilter, true);
            this.process(treewalker);
            Canonicalizer20010315ExclOmitComments c14n = new Canonicalizer20010315ExclOmitComments();
            byte[] buf = c14n.engineCanonicalizeXPathNodeSet(new XMLSignatureInput(rootNode).getNodeSet());
            Document finalDoc = ((DocumentBuilderFactory)factory).newDocumentBuilder().parse(new ByteArrayInputStream(buf));
            dt = (DocumentTraversal)((Object)finalDoc);
            rootNode = finalDoc;
            treewalker = dt.createTreeWalker(rootNode, -1, nodefilter, true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, "UTF8");
            this.writeBytesForDigestion(treewalker, writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            byte[] bytesToDigest = baos.toByteArray();
            return new XMLSignatureInput(bytesToDigest);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0605.str.transform.exception", e.getMessage());
            throw new TransformationException(e.getMessage(), e);
        }
    }

    public boolean wantsOctetStream() {
        return true;
    }

    public boolean wantsNodeSet() {
        return true;
    }

    public boolean returnsOctetStream() {
        return true;
    }

    public boolean returnsNodeSet() {
        return false;
    }

    private void process(TreeWalker treewalker) throws DOMException, XWSSecurityException {
        Node currentNode = treewalker.getCurrentNode();
        while (currentNode != null) {
            if (currentNode.getNodeType() == 1) {
                if (currentNode.getLocalName().equals("SecurityTokenReference") && currentNode.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
                    Node parentNode = currentNode.getParentNode();
                    Node clonedNode = this.derefSecurityTokenReference(currentNode);
                    parentNode.replaceChild(clonedNode, currentNode);
                } else {
                    treewalker.setCurrentNode(treewalker.firstChild());
                    this.process(treewalker);
                }
            } else if (currentNode.getNodeType() == 9) {
                treewalker.setCurrentNode(treewalker.firstChild());
                this.process(treewalker);
            }
            treewalker.setCurrentNode(currentNode);
            currentNode = treewalker.nextSibling();
        }
    }

    private Document getOwnerDocument(Set nodeSet) throws TransformationException {
        if (nodeSet.isEmpty()) {
            log.log(Level.SEVERE, "WSS0606.str.transform.exception");
            throw new TransformationException();
        }
        Iterator it = nodeSet.iterator();
        Node n = (Node)it.next();
        return n.getOwnerDocument();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node derefSecurityTokenReference(Node element) throws XWSSecurityException {
        SecurityToken secToken = null;
        SOAPElement soapElem = XMLUtil.convertToSoapElement(this.soapDocument, (Element)element);
        ReferenceElement refElement = new SecurityTokenReference(soapElem).getReference();
        SOAPElement tokenElement = null;
        if (refElement instanceof DirectReference) {
            this.isXMLToken = true;
            String uri = ((DirectReference)refElement).getURI();
            String tokenId = uri.substring(1);
            try {
                tokenElement = this.locateSamlAssertion(tokenId);
                return element.getOwnerDocument().importNode((Node)tokenElement, true);
            }
            catch (Exception e) {
                secToken = this.secureMessage.getToken(tokenId);
                tokenElement = secToken.getAsSoapElement();
                return element.getOwnerDocument().importNode((Node)tokenElement, true);
            }
        }
        if (refElement instanceof KeyIdentifier) {
            String valueType = ((KeyIdentifier)refElement).getValueType();
            String keyId = ((KeyIdentifier)refElement).getReferenceValue();
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(valueType)) {
                this.isXMLToken = false;
                X509Certificate cert = this.secureMessage.getSecurityEnvironment().getCertificate(TransformSTR.getDecodedBase64EncodedData(keyId));
                secToken = new X509SecurityToken(this.soapDocument, cert);
                tokenElement = secToken.getAsSoapElement();
                try {
                    tokenElement.removeAttribute("EncodingType");
                    return element.getOwnerDocument().importNode((Node)tokenElement, true);
                }
                catch (DOMException de) {
                    log.log(Level.SEVERE, "WSS0607.str.transform.exception");
                    throw new XWSSecurityRuntimeException(de.getMessage(), de);
                }
            }
            if ("http://docs.oasis-open.org/wss/2004/XX/oasis-2004XX-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType)) {
                this.isXMLToken = true;
                tokenElement = this.locateSamlAssertion(keyId);
                return element.getOwnerDocument().importNode((Node)tokenElement, true);
            }
            log.log(Level.SEVERE, "WSS0334.unsupported.keyidentifier");
            XWSSecurityException xwsse = new XWSSecurityException("WSS0334:unsupported KeyIdentifier Reference Type: " + valueType);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
        }
        if (!(refElement instanceof X509IssuerSerial)) {
            log.log(Level.SEVERE, "WSS0608.illegal.reference.mechanism");
            throw new XWSSecurityException("Cannot handle reference mechanism: " + refElement.getTagName());
        }
        this.isXMLToken = false;
        BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
        String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
        X509Certificate cert = this.secureMessage.getSecurityEnvironment().getCertificate(serialNumber, issuerName);
        secToken = new X509SecurityToken(this.soapDocument, cert);
        tokenElement = secToken.getAsSoapElement();
        try {
            tokenElement.removeAttribute("EncodingType");
            return element.getOwnerDocument().importNode((Node)tokenElement, true);
        }
        catch (DOMException de) {
            log.log(Level.SEVERE, "WSS0607.str.transform.exception");
            throw new XWSSecurityException(de.getMessage(), de);
        }
    }

    private void writeBytesForDigestion(TreeWalker treewalker, Writer writer) throws Exception {
        Node currentNode = treewalker.getCurrentNode();
        while (currentNode != null) {
            switch (currentNode.getNodeType()) {
                case 9: {
                    treewalker.setCurrentNode(treewalker.firstChild());
                    this.writeBytesForDigestion(treewalker, writer);
                    break;
                }
                case 1: {
                    writer.write("<");
                    writer.write(((Element)currentNode).getTagName());
                    this.writeElementAttributes((Element)currentNode, writer);
                    writer.write(">");
                    Node firstChild = treewalker.firstChild();
                    if (firstChild != null) {
                        treewalker.setCurrentNode(firstChild);
                        this.writeBytesForDigestion(treewalker, writer);
                    }
                    writer.write("</");
                    writer.write(((Element)currentNode).getTagName());
                    writer.write(">");
                    break;
                }
                case 3: {
                    String text = currentNode.getNodeValue();
                    Element pNode = (Element)currentNode.getParentNode();
                    if (pNode.getLocalName().equals("BinarySecurityToken") && pNode.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") && !this.isXMLToken) {
                        StringBuffer buffer = new StringBuffer();
                        for (int i = 0; i < text.length(); ++i) {
                            char c = text.charAt(i);
                            if (c == '\n') continue;
                            buffer.append(c);
                        }
                        text = buffer.toString();
                        writer.write(text);
                        break;
                    }
                    if (this.isXMLToken) {
                        writer.write(text);
                        break;
                    }
                    log.log(Level.SEVERE, "WSS0609.unknown.referenced.token");
                    XWSSecurityException e = new XWSSecurityException("The referenced token is not an XML Token and also not a Raw Binary Security Token");
                    throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, e.getMessage(), e);
                }
                case 4: {
                    break;
                }
            }
            treewalker.setCurrentNode(currentNode);
            currentNode = treewalker.nextSibling();
        }
    }

    private void writeElementAttributes(Element inputElement, Writer writer) throws Exception {
        Document document = inputElement.getOwnerDocument();
        NamedNodeMap map = inputElement.getAttributes();
        int attrLen = map.getLength();
        Vector<Attr> inputVector = new Vector<Attr>();
        for (int i = 0; i < attrLen; ++i) {
            Attr attr = (Attr)map.item(i);
            inputVector.add(attr);
        }
        if (inputElement.getParentNode() instanceof Document) {
            Attr xmlnsEqualsEmpty = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
            xmlnsEqualsEmpty.setValue("");
            inputVector.add(xmlnsEqualsEmpty);
        }
        Object[] resultAsArray = inputVector.toArray();
        Object[] sortedResultAsArray = C14nHelper.sortAttributes(resultAsArray);
        for (int i = 0; i < sortedResultAsArray.length; ++i) {
            this.outputAttrToWriter(writer, ((Attr)sortedResultAsArray[i]).getNodeName(), ((Attr)sortedResultAsArray[i]).getNodeValue());
        }
    }

    private void outputAttrToWriter(Writer writer, String name, String value) throws IOException {
        writer.write(" ");
        writer.write(name);
        writer.write("=\"");
        writer.write(value);
        writer.write("\"");
    }

    private SOAPElement locateSamlAssertion(String assertionId) throws XWSSecurityException {
        NodeList nodeList = null;
        try {
            SOAPElement namespaceNode = soapFactory.createElement("namespaceContext");
            namespaceNode.addNamespaceDeclaration("saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            nodeList = XPathAPI.selectNodeList(this.soapDocument, "//saml:Assertion[@AssertionID=\"" + assertionId + "\"]", (Node)namespaceNode);
        }
        catch (TransformerException e) {
            throw new XWSSecurityException(e);
        }
        catch (SOAPException e) {
            throw new XWSSecurityException(e);
        }
        int nodeListLength = nodeList.getLength();
        if (nodeListLength > 1) {
            throw new XWSSecurityException("The SAML Assertion Id given is not unique");
        }
        if (nodeListLength == 0) {
            throw new XWSSecurityException("No SAML Assertion found with  AssertionID = " + assertionId);
        }
        Element assertion = (Element)nodeList.item(0);
        return XMLUtil.convertToSoapElement(this.soapDocument, assertion);
    }

    private static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", e.getMessage());
            throw new XWSSecurityException("Unable to decode Base64 encoded data", e);
        }
    }

    static {
        try {
            soapFactory = SOAPFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            // empty catch block
        }
    }

    public class AlwaysAcceptNodeFilter
    implements NodeFilter {
        public short acceptNode(Node n) {
            return 1;
        }
    }
}

