/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.security.signature.Reference;
import com.sun.org.apache.xml.security.signature.SignedInfo;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.ExtendedMessageFilter;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.PolicyViolationException;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.AllowSignature;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.VerifyRequirement;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.KeyResolver;
import com.sun.xml.wss.helpers.ResolverId;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyFilter
extends FilterBase
implements ExtendedMessageFilter {
    ArrayList optionalTargets = null;
    ArrayList optionalNodeList = null;
    private boolean enableLogging = false;
    SecurityRequirement receiverRequirement = null;

    public VerifyFilter() {
    }

    public VerifyFilter(SecurityRequirement receiverRequirement, ArrayList optionalTargets) {
        this.receiverRequirement = receiverRequirement;
        this.optionalTargets = optionalTargets;
    }

    public void setReceiverRequirement(SecurityRequirement receiverRequirement) {
        this.receiverRequirement = receiverRequirement;
    }

    public void setReceiverRequirements(SecurityRequirements receiverRequirements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void enableOperationsLog(boolean enable) {
        this.enableLogging = enable;
    }

    public void init() throws XWSSecurityException {
    }

    private ArrayList getOptionalNodeList(SecurableSoapMessage ssm) throws XWSSecurityException {
        if (this.optionalTargets == null) {
            return null;
        }
        ArrayList<Node> optionalNodes = new ArrayList<Node>();
        Iterator i = this.optionalTargets.iterator();
        while (i.hasNext()) {
            Target target = (Target)i.next();
            if (target.getType().equals("uri")) {
                optionalNodes.add((Node)ssm.getMessageParts(target));
                continue;
            }
            NodeList nlist = (NodeList)ssm.getMessageParts(target);
            for (int j = 0; j < nlist.getLength(); ++j) {
                optionalNodes.add(nlist.item(j));
            }
        }
        return optionalNodes;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        if (!this.verify(secureMessage)) {
            log.log(Level.SEVERE, "WSS0167.signature.verification.failed");
            XWSSecurityException xwsse = new XWSSecurityException("Signature verification failed");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Signature verification failed", xwsse);
        }
    }

    private boolean verify(SecurableSoapMessage secureMessage) throws XWSSecurityException, PolicyViolationException {
        if (!SecurableSoapMessage.isStrTransformAdded()) {
            try {
                Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.sun.xml.wss.helpers.TransformSTR");
            }
            catch (AlgorithmAlreadyRegisteredException e) {
                throw new XWSSecurityException(e);
            }
            SecurableSoapMessage.setStrTransformAdded(true);
        }
        SecurityHeader secHeader = secureMessage.findSecurityHeader();
        SignatureHeaderBlock sigBlock = null;
        try {
            sigBlock = (SignatureHeaderBlock)secHeader.getCurrentHeaderBlock(SignatureHeaderBlock.class);
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, "WSS0129.no.dssignature.in.security.headerblock", new Object[]{e});
            secureMessage.generateSecurityHeaderException("WSS0129: Could not retrieve the ds:Signature element from the wsse:Security header block");
        }
        try {
            SecurableSoapMessage.setDocMessageAssociation(sigBlock.getOwnerDocument(), secureMessage);
            if (this.receiverRequirement != null) {
                if (this.optionalTargets != null) {
                    this.optionalNodeList = this.getOptionalNodeList(secureMessage);
                }
                this.checkIfReceiverReqsAreMet(this.receiverRequirement, sigBlock, secureMessage);
            }
            this.checkForDsCanonicalizationMethod(sigBlock, secureMessage);
            KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
            PublicKey publicKey = (PublicKey)KeyResolver.getKey(keyInfoBlock, true, secureMessage);
            if (publicKey == null) {
                log.log(Level.SEVERE, "WSS0336.cannot.locate.publickey.for.signature.verification");
                throw new XWSSecurityException("Couldn't locate the public key for signature verification");
            }
            if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
                ResourceResolver.registerAtStart(ResolverId.getResolverName());
                SecurableSoapMessage.setWsuIdResolverAdded(true);
            }
            try {
                boolean retVal = sigBlock.checkSignatureValue(publicKey);
                try {
                    if (this.enableLogging) {
                        this.updateOperationsLog(secureMessage, sigBlock);
                    }
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
                boolean bl = retVal;
                return bl;
            }
            catch (XWSSecurityException e) {
                log.log(Level.SEVERE, "WSS0133.exception.while.verifying.signature", new Object[]{e.getCause().getMessage()});
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Signature Verification Failed", e.getCause());
            }
        }
        finally {
            SecurableSoapMessage.removeDocMessageAssociation(sigBlock.getOwnerDocument());
        }
    }

    private void updateOperationsLog(SecurableSoapMessage secureMessage, SignatureHeaderBlock sigBlock) throws Exception {
        HashSet<SOAPElement> references = new HashSet<SOAPElement>();
        SignedInfo signedInfo = sigBlock.getDSSignedInfo();
        int length = signedInfo.getLength();
        for (int i = 0; i < length; ++i) {
            Reference reference = signedInfo.item(i);
            String uri = reference.getURI();
            String wsuId = uri.substring(1);
            SOAPElement element = secureMessage.getElementByWsuId(wsuId);
            references.add(element);
        }
        secureMessage.logSignatureReferences(references);
    }

    private void checkIfReceiverReqsAreMet(SecurityRequirement receiverRequirement, SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage) throws PolicyViolationException {
        ArrayList targets = null;
        if (receiverRequirement instanceof VerifyRequirement) {
            targets = ((VerifyRequirement)receiverRequirement).getTargets();
        } else if (receiverRequirement instanceof AllowSignature) {
            targets = ((AllowSignature)receiverRequirement).getTargets();
        }
        SignedInfo signedInfo = sigBlock.getDSSignedInfo();
        ArrayList signedElements = this.getListOfSignedElements(signedInfo, secureMessage);
        Iterator it = targets.iterator();
        int numberOfTargetElements = 0;
        while (it.hasNext()) {
            Element elem;
            Target target = (Target)it.next();
            String targetType = target.getType();
            String targetValue = target.getValue();
            if (targetType.equals("qname")) {
                String xpath = XMLUtil.convertToXpath(targetValue);
                NodeList targetsToCheckFor = null;
                try {
                    targetsToCheckFor = XPathAPI.selectNodeList((Node)secureMessage.getSOAPPart(), xpath, secureMessage.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
                numberOfTargetElements += targetsToCheckFor.getLength();
                this.verifyIfTargetsSigned(this.convertToArrayList(targetsToCheckFor), signedElements, xpath);
                continue;
            }
            if (targetType.equals("xpath")) {
                NodeList targetsToCheckFor = null;
                try {
                    targetsToCheckFor = XPathAPI.selectNodeList((Node)secureMessage.getSOAPPart(), targetValue, secureMessage.getNSContext());
                }
                catch (Exception e) {
                    throw new XWSSecurityRuntimeException(e);
                }
                numberOfTargetElements += targetsToCheckFor.getLength();
                this.verifyIfTargetsSigned(this.convertToArrayList(targetsToCheckFor), signedElements, targetValue);
                continue;
            }
            if (!targetType.equals("uri")) continue;
            try {
                elem = XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), targetValue);
            }
            catch (Exception e) {
                throw new XWSSecurityRuntimeException(e);
            }
            ArrayList<Element> targetToCheckFor = new ArrayList<Element>();
            if (elem != null) {
                targetToCheckFor.add(elem);
                ++numberOfTargetElements;
            }
            this.verifyIfTargetsSigned(targetToCheckFor, signedElements, targetValue);
        }
        Iterator i = signedElements.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (this.optionalNodeList.contains(n)) continue;
            throw new PolicyViolationException("Target for Signature: " + n.getLocalName() + " does not meet receiver requirements");
        }
    }

    private ArrayList getListOfSignedElements(SignedInfo signedInfo, SecurableSoapMessage secureMessage) {
        ArrayList<Element> list = new ArrayList<Element>();
        try {
            for (int i = 0; i < signedInfo.getLength(); ++i) {
                Reference reference = signedInfo.item(i);
                String uri = reference.getURI();
                String wsuId = uri.substring(1);
                Element signedElem = XMLUtil.getElementById((Document)secureMessage.getSOAPPart(), wsuId);
                list.add(signedElem);
            }
        }
        catch (Exception e) {
            throw new XWSSecurityRuntimeException(e);
        }
        return list;
    }

    private void verifyIfTargetsSigned(ArrayList targetsToCheckFor, ArrayList signedElements, String concernedTargetXpath) throws PolicyViolationException {
        String errorMessage = "Receiver requirement for signature target: " + concernedTargetXpath + " , has not been met";
        if (targetsToCheckFor.isEmpty()) {
            throw new PolicyViolationException(errorMessage);
        }
        for (int i = 0; i < targetsToCheckFor.size(); ++i) {
            if (!signedElements.contains(targetsToCheckFor.get(i))) {
                throw new PolicyViolationException(errorMessage);
            }
            signedElements.remove(targetsToCheckFor.get(i));
        }
    }

    public void checkForDsCanonicalizationMethod(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        String strTranformXpath = "ds:SignedInfo/ds:Reference/ds:Transforms/ds:Transform[@Algorithm=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform\"]";
        Node strTransformNode = null;
        try {
            strTransformNode = XPathAPI.selectSingleNode((Node)sigBlock.getAsSoapElement(), strTranformXpath, secureMessage.getNSContext());
            if (null == strTransformNode) {
                return;
            }
        }
        catch (TransformerException te) {
            throw new XWSSecurityException(te.getMessage(), te);
        }
        try {
            Node canonicalizationMethod = XPathAPI.selectSingleNode(strTransformNode, "wsse:TransformationParameters/ds:CanonicalizationMethod[@Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"]", secureMessage.getNSContext());
            if (null == canonicalizationMethod) {
                XWSSecurityException xwsse = new XWSSecurityException("http://www.w3.org/2001/10/xml-exc-c14n# CanonicalizationMethod was expected as a TransformationParameter inside the STR-Transform");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_ALGORITHM, xwsse.getMessage(), xwsse);
            }
        }
        catch (TransformerException te) {
            throw new XWSSecurityException(te);
        }
    }

    private ArrayList convertToArrayList(NodeList nodeList) {
        ArrayList<Node> result = new ArrayList<Node>();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                result.add(nodeList.item(i));
            }
        }
        return result;
    }
}

