/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.KeyInfoStrategy;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.ResolverId;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignFilter
extends FilterBase
implements MessageFilter {
    private String strTransformXpath;
    private boolean exportSigBlock = true;
    private String x509TokenId;

    public SignFilter() {
    }

    public SignFilter(String xpath, String strTransformXpath) throws XWSSecurityException {
        if (strTransformXpath == null) {
            throw new XWSSecurityException("STR-XPath can not be null");
        }
        if (xpath != null) {
            this.targets = new ArrayList();
            this.targets.add(new Target("xpath", xpath));
        }
        this.strTransformXpath = strTransformXpath;
        this.exportSigBlock = false;
    }

    public SignFilter(String xpath, String strTransformXpath, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (xpath == null && strTransformXpath == null) {
            throw new XWSSecurityException("Both XPath and STR-XPath can not be null");
        }
        if (null == keyInfoStrategy) {
            throw new XWSSecurityException("KeyInfoStrategy should not be null");
        }
        if (xpath != null) {
            this.targets = new ArrayList();
            this.targets.add(new Target("xpath", xpath));
        }
        this.strTransformXpath = strTransformXpath;
        this.keyInfoStrategy = keyInfoStrategy;
        this.exportSigBlock = true;
    }

    public SignFilter(String xpath, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (xpath == null || keyInfoStrategy == null) {
            throw new XWSSecurityException("XPath and KeyInfoStrategy can not be null");
        }
        this.targets = new ArrayList();
        this.targets.add(new Target("xpath", xpath));
        this.keyInfoStrategy = keyInfoStrategy;
    }

    public SignFilter(KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        this("//S:Body", keyInfoStrategy);
    }

    public SignFilter(ArrayList targets, String strTransformXpath, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (targets == null && strTransformXpath == null) {
            throw new XWSSecurityException("Both Target List and STR-XPath can not be null");
        }
        if (null == keyInfoStrategy) {
            throw new XWSSecurityException("KeyInfoStrategy should not be null");
        }
        this.targets = targets;
        this.strTransformXpath = strTransformXpath;
        this.keyInfoStrategy = keyInfoStrategy;
        this.exportSigBlock = true;
    }

    public SignFilter(ArrayList targets, KeyInfoStrategy keyInfoStrategy) throws XWSSecurityException {
        if (targets == null || keyInfoStrategy == null) {
            throw new XWSSecurityException("Target List and KeyInfoStrategy can not be null");
        }
        this.targets = targets;
        this.keyInfoStrategy = keyInfoStrategy;
    }

    public SignFilter(ArrayList targets, String strTransformXpath) throws XWSSecurityException {
        if (strTransformXpath == null) {
            throw new XWSSecurityException("STR-XPath can not be null");
        }
        this.targets = targets;
        this.strTransformXpath = strTransformXpath;
        this.exportSigBlock = false;
    }

    public void init() throws XWSSecurityException {
        if (this.getParameter("strtransformxpath") != null) {
            this.strTransformXpath = this.getParameter("strtransformxpath");
        }
        if (this.getParameter("exportsigblock") != null) {
            this.exportSigBlock = new Boolean(this.getParameter("exportsigblock"));
        }
        if (this.getParameter("x509TokenId") != null) {
            this.x509TokenId = this.getParameter("x509TokenId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        PrivateKey privKey;
        SignatureHeaderBlock sigBlock = null;
        if (!this.exportSigBlock) {
            sigBlock = (SignatureHeaderBlock)secureMessage.getFilterParameter("Signature");
            if (null == sigBlock) {
                throw new XWSSecurityException("SIGNATURE_BLOCK filter parameter expected, not found");
            }
            this.keyInfoStrategy = (KeyInfoStrategy)secureMessage.getFilterParameter("KeyInfoStrategy");
            if (null == this.keyInfoStrategy) {
                throw new XWSSecurityException("KEYINFO_STRATEGY filter parameter expected, not found");
            }
        }
        if ((privKey = this.getAssociatedPrivateKey(secureMessage)) == null) {
            throw new XWSSecurityException("Couldn't locate private key for signing");
        }
        if (this.exportSigBlock) {
            String algorithm = privKey.getAlgorithm();
            String signMethod = null;
            if (!algorithm.equalsIgnoreCase("RSA")) {
                log.log(Level.SEVERE, "WSS0126.unsupported.privatekey.type");
                throw new XWSSecurityException("Unsupported algorithm type: " + signMethod);
            }
            signMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            sigBlock = new SignatureHeaderBlock((Document)secureMessage.getSOAPPart(), signMethod);
        }
        if (this.targets == null && this.strTransformXpath == null) {
            throw new XWSSecurityException("No Sign targets specified");
        }
        if (this.targets != null) {
            Iterator it = this.targets.iterator();
            while (it.hasNext()) {
                Target target = (Target)it.next();
                String targetType = target.getType();
                String targetValue = target.getValue();
                if (targetType.equals("qname")) {
                    this.addTransforms(sigBlock, secureMessage, this.convertToXpath(targetValue), false);
                    continue;
                }
                if (targetType.equals("xpath")) {
                    this.addTransforms(sigBlock, secureMessage, targetValue, false);
                    continue;
                }
                if (!targetType.equals("uri")) continue;
                Element elem = secureMessage.getElementById(targetValue);
                this.processElement(sigBlock, secureMessage, elem, this.createTransforms(secureMessage, false));
            }
        }
        try {
            if (this.strTransformXpath != null) {
                this.addTransforms(sigBlock, secureMessage, this.strTransformXpath, true);
            }
            if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
                ResourceResolver.registerAtStart(ResolverId.getResolverName());
                SecurableSoapMessage.setWsuIdResolverAdded(true);
            }
            sigBlock.sign(privKey);
            if (this.exportSigBlock) {
                KeyInfoHeaderBlock keyInfoBlock = sigBlock.getKeyInfoHeaderBlock();
                this.keyInfoStrategy.insertKey(keyInfoBlock, secureMessage, this.x509TokenId);
                secureMessage.findOrCreateSecurityHeader().insertHeaderBlock(sigBlock);
            }
            Object var10_9 = null;
            if (this.strTransformXpath == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.strTransformXpath == null) throw throwable;
            SecurableSoapMessage.removeDocMessageAssociation(sigBlock.getOwnerDocument());
            throw throwable;
        }
        SecurableSoapMessage.removeDocMessageAssociation(sigBlock.getOwnerDocument());
    }

    private void addTransforms(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage, String xp, boolean signTokenFlag) throws XWSSecurityException {
        NodeList elemsToSign;
        SOAPPart soapPart = secureMessage.getSOAPPart();
        try {
            elemsToSign = XPathAPI.selectNodeList((Node)soapPart, xp, secureMessage.getNSContext());
        }
        catch (TransformerException e) {
            throw new XWSSecurityException(e);
        }
        if (elemsToSign == null || elemsToSign.getLength() == 0) {
            throw new XWSSecurityException("No elements exist for xpath: " + xp);
        }
        for (int i = 0; i < elemsToSign.getLength(); ++i) {
            Transforms transforms = this.createTransforms(secureMessage, signTokenFlag);
            SOAPElement element = (SOAPElement)elemsToSign.item(i);
            this.processElement(sigBlock, secureMessage, (Element)element, transforms);
        }
        if (signTokenFlag) {
            SecurableSoapMessage.setDocMessageAssociation(sigBlock.getOwnerDocument(), secureMessage);
        }
    }

    private Transforms createTransforms(SecurableSoapMessage secureMessage, boolean signTokenFlag) throws XWSSecurityException {
        Transforms transforms;
        block6: {
            transforms = new Transforms((Document)secureMessage.getSOAPPart());
            try {
                if (signTokenFlag) {
                    if (!SecurableSoapMessage.isStrTransformAdded()) {
                        try {
                            Transform.register("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", "com.sun.xml.wss.helpers.TransformSTR");
                        }
                        catch (AlgorithmAlreadyRegisteredException e) {
                            throw new XWSSecurityException(e);
                        }
                        SecurableSoapMessage.setStrTransformAdded(true);
                    }
                    transforms.addTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform");
                    Transform strTransform = transforms.item(0);
                    SOAPElement strTransformElement = (SOAPElement)strTransform.getElement();
                    SOAPElement transformationParameters = strTransformElement.addChildElement("TransformationParameters", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
                    SOAPElement canonMethod = transformationParameters.addChildElement("CanonicalizationMethod", "ds", "http://www.w3.org/2000/09/xmldsig#");
                    canonMethod.setAttribute("Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
                    break block6;
                }
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            }
            catch (Exception e) {
                throw new XWSSecurityException(e.getMessage(), e);
            }
        }
        return transforms;
    }

    private void processElement(SignatureHeaderBlock sigBlock, SecurableSoapMessage secureMessage, Element element, Transforms transforms) throws XWSSecurityException {
        if (element.getNodeType() != 1) {
            log.log(Level.SEVERE, "WSS0165.unable.to.encrypt");
            throw new XWSSecurityException("XPath does not correspond to a DOM Element");
        }
        String id = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (id.equals("")) {
            id = secureMessage.generateId();
            XMLUtil.setWsuIdAttr(element, id);
        }
        sigBlock.addSignedInfoReference("#" + id, transforms);
    }

    private String convertToXpath(String qname) {
        QName name = QName.valueOf(qname);
        if ("".equals(name.getNamespaceURI())) {
            return "//" + name.getLocalPart();
        }
        return "//*[local-name()='" + name.getLocalPart() + "' and namespace-uri()='" + name.getNamespaceURI() + "']";
    }

    private String convertElemToXpath(Element elem) {
        if ("".equals(elem.getNamespaceURI())) {
            return "//" + elem.getLocalName();
        }
        return "//*[local-name()='" + elem.getLocalName() + "' and namespace-uri()='" + elem.getNamespaceURI() + "']";
    }

    private PrivateKey getAssociatedPrivateKey(SecurableSoapMessage secureMsg) throws XWSSecurityException {
        String alias = this.keyInfoStrategy.getAlias();
        X509Certificate cert = secureMsg.getSecurityEnvironment().getCertificate(alias, true);
        if (cert == null) {
            throw new XWSSecurityException("Couldn't locate the X509 certificate corresponding to this sign operation");
        }
        this.keyInfoStrategy.setCertificate(cert);
        return secureMsg.getSecurityEnvironment().getPrivateKey(alias);
    }
}

