/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import com.sun.xml.wss.KeyInfoHeaderBlock;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SamlAssertionHeaderBlock;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SignatureHeaderBlock;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.helpers.KeyResolver;
import com.sun.xml.wss.helpers.ResolverId;
import com.sun.xml.wss.saml.assertion.NameIdentifier;
import com.sun.xml.wss.saml.assertion.Subject;
import com.sun.xml.wss.saml.assertion.SubjectStatement;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportSamlAssertionFilter
extends FilterBase
implements MessageFilter {
    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        SamlAssertionHeaderBlock samlAssertion = null;
        try {
            samlAssertion = (SamlAssertionHeaderBlock)wsseSecurity.getCurrentHeaderBlock(SamlAssertionHeaderBlock.class);
        }
        catch (ClassCastException ex) {
            log.log(Level.SEVERE, "WSS0406.saml.invalid.element");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Token of invalid class type encountered", ex);
        }
        catch (XWSSecurityException ex) {
            log.log(Level.SEVERE, "WSS0418.saml.import.exception");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception while importing SAML Token", ex);
        }
        secureMessage.setToken(samlAssertion.getAssertionID(), samlAssertion);
        try {
            if (samlAssertion.isSigned() && !this.signatureIsValid(samlAssertion.getSignature(), secureMessage)) {
                log.log(Level.SEVERE, "WSS0416.saml.signature.invalid");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Assertion has invalid Signature", new Exception("SAML Assertion has invalid Signature"));
            }
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, "WSS0419.saml.signature.verify.failed", e);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Exception during Signature verfication in SAML Assertion", e);
        }
        if (!samlAssertion.isTimeValid()) {
            log.log(Level.SEVERE, "WSS0417.saml.timestamp.invalid");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "SAML Condition (notBefore, notOnOrAfter) Validation failed", new Exception("SAML Condition (notBefore, notOnOrAfter) Validation failed"));
        }
        this.validateSamlVersion(samlAssertion);
        this.validateIssuer(secureMessage, samlAssertion);
        this.validateSamlUser(secureMessage, samlAssertion);
    }

    private void validateSamlVersion(SamlAssertionHeaderBlock assertion) {
        int major = assertion.getMajorVersion();
        int minor = assertion.getMinorVersion();
        if (major != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Major version is not 1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Major version is not 1 for SAML Assertion"));
        }
        if (minor != 0 && minor != 1) {
            log.log(Level.SEVERE, "WSS0404.saml.invalid.version");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, "Minor version is not 0/1 for SAML Assertion:" + assertion.getAssertionID(), new Exception("Minor version is not 0/1 for SAML Assertion"));
        }
    }

    private void validateIssuer(SecurableSoapMessage secMessage, SamlAssertionHeaderBlock assertion) {
        boolean issuerValid = secMessage.getSecurityEnvironment().validateSamlIssuer(assertion.getIssuer());
        if (!issuerValid) {
            log.log(Level.SEVERE, "WSS0422.saml.issuer.validation.failed");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "Issuer validation failed for SAML Assertion:" + assertion.getAssertionID(), new Exception("Issuer validation failed for SAML Assertion"));
        }
        log.log(Level.INFO, "SAML issuer validation successful for issuer=" + assertion.getIssuer());
    }

    private void validateSamlUser(SecurableSoapMessage secMessage, SamlAssertionHeaderBlock assertion) {
        String user = null;
        Set statements = assertion.getStatement();
        boolean userValid = false;
        Iterator it = statements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof SubjectStatement)) continue;
            SubjectStatement subjStmt = (SubjectStatement)obj;
            Subject subj = subjStmt.getSubject();
            NameIdentifier nameId = subj.getNameIdentifier();
            String domain = nameId.getNameQualifier();
            String format = nameId.getFormat();
            user = nameId.getName();
            userValid = secMessage.getSecurityEnvironment().validateSamlUser(user, domain, format);
            break;
        }
        if (!userValid) {
            log.log(Level.SEVERE, "WSS0423.saml.subject.nameid.validation.failed");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_AUTHENTICATION, "NameIdentifier validation failed for SAML Assertion:" + assertion.getAssertionID(), new Exception("NameIdentifier validation failed for SAML Assertion"));
        }
        log.log(Level.INFO, "SAML NameIdentifier validation successful user=" + user);
    }

    private boolean signatureIsValid(Element signatureElement, SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SOAPElement sigElement;
        SignatureHeaderBlock signature;
        KeyInfoHeaderBlock keyInfoBlock;
        PublicKey publicKey;
        if (!SecurableSoapMessage.isWsuIdResolverAdded()) {
            ResourceResolver.registerAtStart(ResolverId.getResolverName());
            SecurableSoapMessage.setWsuIdResolverAdded(true);
        }
        if ((publicKey = (PublicKey)KeyResolver.getKey(keyInfoBlock = (signature = new SignatureHeaderBlock(sigElement = XMLUtil.convertToSoapElement((Document)secureMessage.getSOAPPart(), signatureElement))).getKeyInfoHeaderBlock(), true, secureMessage)) == null) {
            log.log(Level.SEVERE, "WSS0336.cannot.locate.publickey.for.signature.verification");
            throw new XWSSecurityException("Couldn't locate the public key for signature verification");
        }
        try {
            boolean verified = signature.checkSignatureValue(publicKey);
            log.log(Level.INFO, "SAML Assertion Enveloped Signature Verified Successfully");
            return verified;
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, "WSS0133.exception.while.verifying.signature", new Object[]{e.getCause().getMessage()});
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_FAILED_CHECK, "Signature Verification Failed", e.getCause());
        }
    }
}

