/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class ExportCertificateTokenFilter
extends FilterBase
implements MessageFilter {
    String alias = null;
    DefaultCertificateToken defaultToken = null;

    public ExportCertificateTokenFilter() {
    }

    public ExportCertificateTokenFilter(String alias) {
        this.alias = alias;
    }

    public ExportCertificateTokenFilter(DefaultCertificateToken token) throws XWSSecurityException {
        this.defaultToken = token;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        SecurityHeader wsseSecurity = secureMessage.findOrCreateSecurityHeader();
        if (this.defaultToken != null) {
            X509Certificate cert = secureMessage.getSecurityEnvironment().getDefaultCertificate();
            this.exportCertificateToken(secureMessage, wsseSecurity, cert);
            return;
        }
        if (this.alias != null) {
            X509Certificate cert = secureMessage.getSecurityEnvironment().getCertificate(this.alias, true);
            this.exportCertificateToken(secureMessage, wsseSecurity, cert);
            return;
        }
        X509SecurityToken token = (X509SecurityToken)secureMessage.getFilterParameter("Token");
        if (token == null) {
            log.log(Level.SEVERE, "WSS0169.token.not.set.parameter.list");
            throw new XWSSecurityException("Token to be exported was not set in Parameter List");
        }
        wsseSecurity.insertHeaderBlock(token);
    }

    private void exportCertificateToken(SecurableSoapMessage ssm, SecurityHeader wsseSecurity, X509Certificate cert) throws XWSSecurityException {
        String wsuId = ssm.generateId();
        X509SecurityToken token = new X509SecurityToken((Document)ssm.getSOAPPart(), cert, wsuId);
        ssm.setToken(wsuId, token);
        wsseSecurity.insertHeaderBlock(token);
    }

    public static class DefaultCertificateToken {
    }
}

