/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.util.logging.Level;

public class AddNamespaceFilter
extends FilterBase
implements MessageFilter {
    private String prefix;
    private String namespace;

    public AddNamespaceFilter(String prefix, String namespace) throws XWSSecurityException {
        if (prefix == null) {
            log.log(Level.SEVERE, "WSS0187.prefix.null");
            throw new XWSSecurityException("Cannot map namespace to null prefix");
        }
        this.prefix = prefix;
        if (namespace == null) {
            log.log(Level.SEVERE, "WSS0188.namespace.null");
            throw new XWSSecurityException("Cannot map prefix to null namespace");
        }
        this.namespace = namespace;
    }

    public AddNamespaceFilter() {
    }

    public void init() throws XWSSecurityException {
        this.prefix = this.getParameter("prefix");
        if (this.prefix == null) {
            log.log(Level.SEVERE, "WSS0187.prefix.null");
            throw new XWSSecurityException("filter parameter 'prefix' was not set");
        }
        this.namespace = this.getParameter("namespace");
        if (this.namespace == null) {
            log.log(Level.SEVERE, "WSS0188.namespace.null");
            throw new XWSSecurityException("filter parameter 'namespace' was not set");
        }
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        secureMessage.addXPathNamespace(this.prefix, this.namespace);
    }
}

