/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.configuration.AllowEncryption;
import com.sun.xml.wss.configuration.AllowSignature;
import com.sun.xml.wss.configuration.ConfigurationConstants;
import com.sun.xml.wss.configuration.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.configuration.DecryptRequirement;
import com.sun.xml.wss.configuration.DirectReferenceStrategyInfo;
import com.sun.xml.wss.configuration.EncryptOperation;
import com.sun.xml.wss.configuration.FilterInfo;
import com.sun.xml.wss.configuration.IdentifierStrategyInfo;
import com.sun.xml.wss.configuration.JAXRPCSecurityConfiguration;
import com.sun.xml.wss.configuration.NameStrategyInfo;
import com.sun.xml.wss.configuration.SecurityConfiguration;
import com.sun.xml.wss.configuration.SecurityConfigurationElement;
import com.sun.xml.wss.configuration.SecurityOperation;
import com.sun.xml.wss.configuration.SecurityRequirement;
import com.sun.xml.wss.configuration.SecurityRequirements;
import com.sun.xml.wss.configuration.SerialNumberStrategyInfo;
import com.sun.xml.wss.configuration.SignOperation;
import com.sun.xml.wss.configuration.StrategyInfo;
import com.sun.xml.wss.configuration.UsernamePasswordOperation;
import com.sun.xml.wss.configuration.UsernamePasswordRequirement;
import com.sun.xml.wss.configuration.VerifyRequirement;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SecurityConfigurationXmlReader
implements ConfigurationConstants {
    protected static Logger log;
    private static final int JAXRPC_SERVICE = 0;
    private static final int JAXRPC_PORT = 1;
    private static final int JAXRPC_OPERATION = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static Document parseXmlString(String sourceXml, boolean turnValidationOff) throws Exception {
        StringBufferInputStream inputStream = new StringBufferInputStream(sourceXml);
        return SecurityConfigurationXmlReader.parseXmlStream(inputStream, turnValidationOff);
    }

    private static void validateX(Element element) {
        NodeList timestamps = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Timestamp");
        if (timestamps.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:Timestamp element in security configuration file");
        }
        NodeList requireTimestamps = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "RequireTimestamp");
        if (requireTimestamps.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:RequireTimestamp element in security configuration file");
        }
        NodeList usernamePasswords = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "UsernameToken");
        if (usernamePasswords.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:UsernameToken element in security configuration file");
        }
        NodeList requireUsernamePasswords = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "RequireUsernameToken");
        if (requireUsernamePasswords.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:RequireUsernameToken element in security configuration file");
        }
        NodeList optionalTargets = element.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "OptionalTargets");
        if (optionalTargets.getLength() > 1) {
            throw new IllegalStateException("More than one xwss:OptionalTargets element in security configuration file");
        }
    }

    public static SecurityConfiguration readString(String sourceXml, boolean turnValidationOff) throws Exception {
        Document configurationDocument = SecurityConfigurationXmlReader.parseXmlString(sourceXml, turnValidationOff);
        return SecurityConfigurationXmlReader.createSecurityConfiguration(configurationDocument.getDocumentElement()).createConfiguration();
    }

    public static JAXRPCSecurityConfiguration readJAXRPCSecurityConfigurationString(String sourceXml, boolean turnValidationOff) throws Exception {
        Document configurationDocument = SecurityConfigurationXmlReader.parseXmlString(sourceXml, turnValidationOff);
        return (JAXRPCSecurityConfiguration)SecurityConfigurationXmlReader.createSecurityConfiguration(configurationDocument.getDocumentElement());
    }

    private static Document parseXmlStream(InputStream xmlStream, boolean turnValidationOff) throws Exception {
        return SecurityConfigurationXmlReader.parseXmlStream(xmlStream, null, turnValidationOff);
    }

    private static Document parseXmlStream(InputStream xmlStream, PrintStream out, boolean turnValidationOff) throws Exception {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        ((DocumentBuilderFactory)factory).setAttribute("http://apache.org/xml/features/validation/dynamic", Boolean.FALSE);
        ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        InputStream is = SecurityConfigurationXmlReader.class.getResourceAsStream("xwssconfig.xsd");
        ((DocumentBuilderFactory)factory).setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
        factory.setValidating(!turnValidationOff);
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(out));
        Document configurationDocument = builder.parse(xmlStream);
        return configurationDocument;
    }

    public static void validate(InputStream xmlStream, PrintStream out) throws Exception {
        SecurityConfigurationXmlReader.parseXmlStream(xmlStream, out, false);
    }

    public static SecurityConfiguration createSecurityConfiguration(InputStream xmlStream, boolean turnValidationOff) throws Exception {
        Document document = SecurityConfigurationXmlReader.parseXmlStream(xmlStream, turnValidationOff);
        Element element = document.getDocumentElement();
        return SecurityConfigurationXmlReader.createSecurityConfiguration(element).createConfiguration();
    }

    public static DeclarativeSecurityConfiguration createDeclarativeConfiguration(InputStream xmlStream, boolean turnValidationOff) throws Exception {
        DeclarativeSecurityConfiguration declarations = new DeclarativeSecurityConfiguration();
        SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(SecurityConfigurationXmlReader.parseXmlStream(xmlStream, turnValidationOff).getDocumentElement(), declarations);
        return declarations;
    }

    public static JAXRPCSecurityConfiguration createJAXRPCSecurityConfiguration(InputStream xmlStream, boolean turnValidationOff) throws Exception {
        return (JAXRPCSecurityConfiguration)SecurityConfigurationXmlReader.createSecurityConfiguration(SecurityConfigurationXmlReader.parseXmlStream(xmlStream, turnValidationOff).getDocumentElement());
    }

    private static DeclarativeSecurityConfiguration createDeclarativeConfiguration(Element configData, DeclarativeSecurityConfiguration declarations) {
        if (declarations == null) {
            declarations = new DeclarativeSecurityConfiguration();
        }
        SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, declarations);
        return declarations;
    }

    private static DeclarativeSecurityConfiguration createSecurityConfiguration(Element configData) throws Exception {
        DeclarativeSecurityConfiguration declarations = null;
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        if (JAXRPC_SECURITY_ELEMENT_QNAME.equals(qname)) {
            boolean readDeclConfig = false;
            declarations = new JAXRPCSecurityConfiguration();
            NodeList environmentHandlers = configData.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "SecurityEnvironmentHandler");
            if (environmentHandlers.getLength() > 1) {
                throw new IllegalStateException("More than one xwss:SecurityEnvironmentHandler element in security configuration file");
            }
            String handlerClsName = XMLUtil.getFullTextFromChildren((Element)environmentHandlers.item(0));
            if (handlerClsName == null || handlerClsName.equals("")) {
                throw new IllegalStateException("A Handler class name has to be specified in security configuration file");
            }
            ((JAXRPCSecurityConfiguration)declarations).setSecurityEnvironmentHandler(handlerClsName);
            NodeList services = configData.getElementsByTagNameNS("http://java.sun.com/xml/ns/xwss/config", "Service");
            if (services.getLength() > 1) {
                throw new IllegalStateException("More than one xwss:Service element in security configuration file");
            }
            Element eachDefinitionElement = (Element)services.item(0);
            boolean bl = SecurityConfigurationXmlReader.readJAXRPCSecurityConfiguration(eachDefinitionElement, declarations, 0, readDeclConfig);
        } else if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
            declarations = new DeclarativeSecurityConfiguration();
            SecurityConfigurationXmlReader.readContainerForBaseConfigurationData(configData, declarations);
        } else {
            log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", configData.getTagName());
            throw new IllegalStateException(configData.getTagName() + " is not a recognized definition type");
        }
        return declarations;
    }

    private static boolean readJAXRPCSecurityConfiguration(Element configData, DeclarativeSecurityConfiguration declarations, int elementIdentifier, boolean readDeclConfig) throws Exception {
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        JAXRPCSecurityConfiguration innerDeclarations = null;
        if (SERVICE_ELEMENT_QNAME.equals(qname)) {
            if (elementIdentifier != 0) {
                log.log(Level.SEVERE, "WSS0414.illegal.nested.element", new Object[]{configData.getTagName(), SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier)});
                throw new IllegalStateException(configData.getTagName() + " is not a recognized element of " + SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier));
            }
            innerDeclarations = new JAXRPCSecurityConfiguration();
            if (configData.hasAttributes()) {
                throw new IllegalStateException("No attributes are allowed on xwss:Service");
            }
            innerDeclarations.setJAXRPCServiceName("");
            ((JAXRPCSecurityConfiguration)declarations).JAXRPCServices().append(innerDeclarations);
            Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(configData);
            readDeclConfig = true;
            while (eachDefinitionElement != null) {
                readDeclConfig = SecurityConfigurationXmlReader.readJAXRPCSecurityConfiguration(eachDefinitionElement, innerDeclarations, 1, readDeclConfig);
                eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
            }
        } else if (PORT_ELEMENT_QNAME.equals(qname)) {
            if (elementIdentifier != 1) {
                log.log(Level.SEVERE, "WSS0414.illegal.nested.element", new Object[]{configData.getTagName(), SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier)});
                throw new IllegalStateException(configData.getTagName() + " is not a recognized element of " + SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier));
            }
            readDeclConfig = true;
            innerDeclarations = new JAXRPCSecurityConfiguration();
            String portName = configData.getAttribute("name");
            if (portName == null || portName.equals("")) {
                throw new IllegalStateException("Attribute 'name' is required to have a valid port name on xwss:Port");
            }
            if (configData.getAttributes().getLength() > 1) {
                throw new IllegalStateException("Only 'name' is a permissible attribute of xwss:Port");
            }
            String serviceName = ((Element)configData.getParentNode()).getAttribute("name");
            innerDeclarations.setJAXRPCPortName(portName);
            innerDeclarations.setParentElementName(serviceName);
            ((JAXRPCSecurityConfiguration)declarations).JAXRPCPorts().append(innerDeclarations);
            Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(configData);
            while (eachDefinitionElement != null) {
                readDeclConfig = SecurityConfigurationXmlReader.readJAXRPCSecurityConfiguration(eachDefinitionElement, innerDeclarations, 2, readDeclConfig);
                eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
            }
        } else if (OPERATION_ELEMENT_QNAME.equals(qname)) {
            if (elementIdentifier != 2) {
                log.log(Level.SEVERE, "WSS0414.illegal.nested.element", new Object[]{configData.getTagName(), SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier)});
                throw new IllegalStateException(configData.getTagName() + " is not a recognized element of " + SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier));
            }
            readDeclConfig = true;
            innerDeclarations = new JAXRPCSecurityConfiguration();
            String opName = configData.getAttribute("name");
            if (opName == null || opName.equals("")) {
                throw new IllegalStateException("Attribute 'name' is required to have a valid operation name on xwss:Operation");
            }
            if (configData.getAttributes().getLength() > 1) {
                throw new IllegalStateException("Only 'name' is a permissible attribute of xwss:Operation");
            }
            String portName = ((Element)configData.getParentNode()).getAttribute("name");
            innerDeclarations.setJAXRPCOperationName(opName);
            innerDeclarations.setParentElementName(portName);
            ((JAXRPCSecurityConfiguration)declarations).JAXRPCOperations().append(innerDeclarations);
            Element firstChild = SecurityConfigurationXmlReader.getFirstChildElement(configData);
            while (firstChild != null) {
                if (!DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(SecurityConfigurationXmlReader.getQName(firstChild))) {
                    log.log(Level.SEVERE, "WSS0414.illegal.nested.element", new Object[]{firstChild.getTagName(), "xwss:Operation"});
                    throw new IllegalStateException(firstChild.getTagName() + " is not a recognized element of xwss:Operation");
                }
                SecurityConfigurationXmlReader.createDeclarativeConfiguration(firstChild, innerDeclarations);
                if ((firstChild = SecurityConfigurationXmlReader.getNextElement(firstChild)) == null) continue;
                log.log(Level.SEVERE, "WSS0417.duplicate.configuration.element", configData.getTagName());
                throw new IllegalStateException("Multiple configuration elements not allowed on xwss:Operation");
            }
        } else {
            if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
                if (elementIdentifier == 0) {
                    log.log(Level.SEVERE, "WSS0414.illegal.nested.element", new Object[]{configData.getTagName(), SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier)});
                    throw new IllegalStateException(configData.getTagName() + " is not a recognized element of " + SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier));
                }
                if (!readDeclConfig) {
                    log.log(Level.SEVERE, "WSS0416.duplicate.configuration.element", new Object[]{configData.getTagName(), SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier)});
                    throw new IllegalStateException(configData.getTagName() + " is a duplicate element of " + SecurityConfigurationXmlReader.resolveParentJAXRPCConfigurationElement(elementIdentifier));
                }
                SecurityConfigurationXmlReader.createDeclarativeConfiguration(configData, declarations);
                return false;
            }
            log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", configData.getTagName());
            throw new IllegalStateException(configData.getTagName() + " is not a recognized definition type of " + "xwss:JAXRPCSecurity");
        }
        return true;
    }

    private static DeclarativeSecurityConfiguration readContainerForBaseConfigurationData(Element configData, DeclarativeSecurityConfiguration declarations) {
        QName qname = SecurityConfigurationXmlReader.getQName(configData);
        if (DECLARATIVE_CONFIGURATION_ELEMENT_QNAME.equals(qname)) {
            SecurityConfigurationXmlReader.validateX(configData);
            NamedNodeMap configurationAttributes = configData.getAttributes();
            int attributeCount = configurationAttributes.getLength();
            String attributeName = null;
            for (int index = 0; index < attributeCount; ++index) {
                Attr configurationAttribute = (Attr)configurationAttributes.item(index);
                attributeName = configurationAttribute.getName();
                if ("dumpMessages".equalsIgnoreCase(attributeName)) {
                    declarations.setDumpMessages(new Boolean(configurationAttribute.getValue()));
                    continue;
                }
                if ("http://www.w3.org/2000/xmlns/".equals(configurationAttribute.getNamespaceURI())) continue;
                log.log(Level.SEVERE, "WSS0412.illegal.attribute.name", new Object[]{attributeName, configData.getTagName()});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of SecurityConfiguration");
            }
        } else {
            log.log(Level.SEVERE, "WSS0413.illegal.configuration.element", configData.getTagName());
            throw new IllegalStateException(configData.getTagName() + " is not a recognized definition type");
        }
        SecurityConfigurationXmlReader.readBaseConfigurationData(configData, declarations);
        return declarations;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void readBaseConfigurationData(Element configData, DeclarativeSecurityConfiguration declarations) {
        Element eachDefinitionElement = SecurityConfigurationXmlReader.getFirstChildElement(configData);
        boolean timestampFound = false;
        while (eachDefinitionElement != null) {
            SecurityOperation operation;
            QName definitionType = SecurityConfigurationXmlReader.getQName(eachDefinitionElement);
            if (TIMESTAMP_ELEMENT_QNAME.equals(definitionType)) {
                if (timestampFound) {
                    log.log(Level.SEVERE, "WSS0516.duplicate.configuration.element", new Object[]{definitionType, configData.getLocalName()});
                    throw new IllegalStateException("Duplicate Timestamp element");
                }
                if (eachDefinitionElement.hasAttribute("timeout")) {
                    declarations.senderSettings().setTimeout(eachDefinitionElement.getAttribute("timeout"));
                } else {
                    declarations.senderSettings().doTimestamp();
                }
                timestampFound = true;
            } else if (ENCRYPT_OPERATION_ELEMENT_QNAME.equals(definitionType)) {
                operation = new EncryptOperation();
                SecurityConfigurationXmlReader.readEncryptionSettings((EncryptOperation)operation, eachDefinitionElement);
                declarations.senderSettings().append(operation);
            } else if (SIGN_OPERATION_ELEMENT_QNAME.equals(definitionType)) {
                operation = new SignOperation();
                SecurityConfigurationXmlReader.readSigningSettings((SignOperation)operation, eachDefinitionElement);
                declarations.senderSettings().append(operation);
                if (((SignOperation)operation).isIncludingTimestamp()) {
                    declarations.senderSettings().doTimestamp();
                }
            } else if (USERNAME_PASSWORD_AUTHENTICATION_ELEMENT_QNAME.equals(definitionType)) {
                operation = new UsernamePasswordOperation();
                SecurityConfigurationXmlReader.readUsernamePasswordSettings((UsernamePasswordOperation)operation, eachDefinitionElement);
                declarations.senderSettings().append(operation);
            } else if (SIGNATURE_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                SecurityConfigurationXmlReader.readVerifySettings(declarations.receiverSettings(), eachDefinitionElement);
            } else if (ENCRYPTION_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                SecurityConfigurationXmlReader.readDecryptSettings(declarations.receiverSettings(), eachDefinitionElement);
            } else if (USERNAMETOKEN_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                UsernamePasswordRequirement requirement = new UsernamePasswordRequirement();
                SecurityConfigurationXmlReader.readUsernamePasswordRequirementSettings(requirement, eachDefinitionElement);
                declarations.receiverSettings().append(requirement);
            } else if (TIMESTAMP_REQUIREMENT_ELEMENT_QNAME.equals(definitionType)) {
                declarations.receiverSettings().requireTimestamp();
            } else {
                if (!OPTIONAL_TARGETS_ELEMENT_QNAME.equals(definitionType)) {
                    log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", definitionType.toString());
                    throw new IllegalStateException(definitionType + " is not a recognized definition type");
                }
                SecurityConfigurationXmlReader.readOptionalTargetSettings(declarations.receiverSettings(), eachDefinitionElement);
            }
            eachDefinitionElement = SecurityConfigurationXmlReader.getNextElement(eachDefinitionElement);
        }
        return;
    }

    private static void readUsernamePasswordSettings(UsernamePasswordOperation operation, Element usernamePasswordSettings) {
        NamedNodeMap signingAttributes = usernamePasswordSettings.getAttributes();
        int attributeCount = signingAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr usernamePasswordAttribute = (Attr)signingAttributes.item(index);
            attributeName = usernamePasswordAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) {
                operation.setTokenId(usernamePasswordAttribute.getValue());
                continue;
            }
            if ("name".equalsIgnoreCase(attributeName)) {
                operation.setUsername(usernamePasswordAttribute.getValue());
                continue;
            }
            if ("password".equalsIgnoreCase(attributeName)) {
                operation.setPassword(usernamePasswordAttribute.getValue());
                continue;
            }
            if ("useNonce".equalsIgnoreCase(attributeName)) {
                operation.setUseNonce(SecurityConfigurationXmlReader.getBooleanValue(usernamePasswordAttribute.getValue()));
                continue;
            }
            if ("digestPassword".equalsIgnoreCase(attributeName)) {
                operation.setDigestPassword(SecurityConfigurationXmlReader.getBooleanValue(usernamePasswordAttribute.getValue()));
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, usernamePasswordSettings.getTagName()});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of username password");
        }
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(usernamePasswordSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of UsernameToken");
        }
    }

    private static boolean getBooleanValue(String valueString) {
        if ("0".equals(valueString) || "false".equalsIgnoreCase(valueString)) {
            return false;
        }
        if ("1".equals(valueString) || "true".equalsIgnoreCase(valueString)) {
            return true;
        }
        log.log(Level.SEVERE, "WSS0511.illegal.boolean.value", valueString);
        throw new IllegalArgumentException(valueString + " is not a valid boolean value");
    }

    private static void readSigningSettings(SignOperation operation, Element signingSettings) {
        NamedNodeMap signingAttributes = signingSettings.getAttributes();
        int attributeCount = signingAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr signingAttribute = (Attr)signingAttributes.item(index);
            attributeName = signingAttribute.getName();
            if ("includeTimestamp".equalsIgnoreCase(attributeName)) {
                if (SecurityConfigurationXmlReader.getBooleanValue(signingAttribute.getValue())) continue;
                operation.dontIncludeTimestamp();
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Sign"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Sign");
        }
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(signingSettings);
        boolean x509TokenSeen = false;
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (TARGET_QNAME.equals(subElementQName)) {
                operation.addTarget(SecurityConfigurationXmlReader.readTargetSettings(eachSubElement));
            } else if (X509TOKEN_ELEMENT_QNAME.equals(subElementQName)) {
                if (x509TokenSeen) {
                    log.log(Level.SEVERE, "WSS0516.duplicate.configuration.element", new Object[]{"xwss:X509Token", "xwss:Sign"});
                    throw new IllegalStateException("Atmost one X509 token can be configured for a sign operation");
                }
                SecurityConfigurationXmlReader.readX509TokenSettings(operation, eachSubElement);
                x509TokenSeen = true;
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of Sign");
            }
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
    }

    private static Target readTargetSettings(Element targetSettings) {
        Target target = new Target();
        NamedNodeMap targetAttributes = targetSettings.getAttributes();
        int attributeCount = targetAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr targetAttribute = (Attr)targetAttributes.item(index);
            attributeName = targetAttribute.getName();
            if ("type".equalsIgnoreCase(attributeName)) {
                String targetType = targetAttribute.getValue();
                if ("qname".equalsIgnoreCase(targetType) || "xpath".equalsIgnoreCase(targetType) || "uri".equalsIgnoreCase(targetType)) {
                    target.setType(targetType);
                    continue;
                }
                log.log(Level.SEVERE, "WSS0519.illegal.attribute.value", "xwss:Target@Type");
                throw new IllegalStateException(targetType + " is not a recognized type of Target");
            }
            if ("contentOnly".equalsIgnoreCase(attributeName)) {
                String contentOnly = targetAttribute.getValue();
                target.setContentOnly(new Boolean(contentOnly));
                continue;
            }
            if ("enforce".equalsIgnoreCase(attributeName)) {
                String enforce_S = targetAttribute.getValue();
                boolean enforce = new Boolean(enforce_S);
                target.setEnforce(enforce);
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Target"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Target");
        }
        String targetValue = XMLUtil.getFullTextFromChildren(targetSettings);
        if (targetValue == null || targetValue.equals("")) {
            throw new IllegalStateException("Value of the Target element is required to be specified");
        }
        if (targetValue.startsWith("#")) {
            targetValue = targetValue.substring(1);
        }
        target.setValue(targetValue);
        return target;
    }

    private static void readSymmetricKeySettings(EncryptOperation operation, Element symmKeyElement) {
        NamedNodeMap symmKeyAttributes = symmKeyElement.getAttributes();
        int attributeCount = symmKeyAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr symmKeyAttribute = (Attr)symmKeyAttributes.item(index);
            attributeName = symmKeyAttribute.getName();
            if (!"keyAlias".equalsIgnoreCase(attributeName)) {
                log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:SymmetricKey"});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of SymmetricKey");
            }
            operation.setSessionKeyAlias(symmKeyAttribute.getValue());
        }
    }

    private static void readX509TokenSettings(SecurityConfigurationElement configElement, Element token) {
        String tokenId = null;
        String certificateAlias = null;
        String keyReferenceStrategy = "Direct";
        NamedNodeMap tokenAttributes = token.getAttributes();
        int attributeCount = tokenAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr tokenAttribute = (Attr)tokenAttributes.item(index);
            attributeName = tokenAttribute.getName();
            if ("id".equalsIgnoreCase(attributeName)) {
                tokenId = tokenAttribute.getValue();
                continue;
            }
            if ("keyReferenceType".equalsIgnoreCase(attributeName)) {
                keyReferenceStrategy = tokenAttribute.getValue();
                continue;
            }
            if ("certificateAlias".equalsIgnoreCase(attributeName)) {
                certificateAlias = tokenAttribute.getValue();
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:X509Token"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of X509Token");
        }
        if (certificateAlias == null) {
            log.log(Level.WARNING, "WSS0519.illegal.attribute.value", "xwss:X509Token@certificateAlias");
        }
        if (configElement instanceof SignOperation) {
            SignOperation signop = (SignOperation)configElement;
            signop.setCertificateAlias(certificateAlias);
            signop.setX509TokenId(tokenId);
            signop.setKeyStrategy(SecurityConfigurationXmlReader.createKeyReferenceStrategy(keyReferenceStrategy));
        } else if (configElement instanceof EncryptOperation) {
            EncryptOperation encryptop = (EncryptOperation)configElement;
            encryptop.setCertificateAlias(certificateAlias);
            encryptop.setX509TokenId(tokenId);
            encryptop.setKeyStrategy(SecurityConfigurationXmlReader.createKeyReferenceStrategy(keyReferenceStrategy));
        }
    }

    private static void readVerifySettings(SecurityRequirements requirements, Element verifySettings) {
        boolean timestampRequired = true;
        NamedNodeMap verifyAttributes = verifySettings.getAttributes();
        int attributeCount = verifyAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr verifyAttribute = (Attr)verifyAttributes.item(index);
            attributeName = verifyAttribute.getName();
            if ("requireTimestamp".equalsIgnoreCase(attributeName)) {
                if (SecurityConfigurationXmlReader.getBooleanValue(verifyAttribute.getValue())) continue;
                timestampRequired = false;
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:requireSignature"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Verify");
        }
        boolean noneEnforced = true;
        ArrayList<Target> targets = new ArrayList<Target>();
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(verifySettings);
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (!TARGET_QNAME.equals(subElementQName)) {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of RequireSignature");
            }
            Target target = SecurityConfigurationXmlReader.readTargetSettings(eachSubElement);
            noneEnforced = noneEnforced && !target.getEnforce();
            targets.add(target);
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
        SecurityRequirement requirement = null;
        if (noneEnforced && !timestampRequired && !targets.isEmpty()) {
            requirement = new AllowSignature();
            ((AllowSignature)requirement).addTargets(targets);
        } else {
            requirement = new VerifyRequirement();
            if (!timestampRequired) {
                ((VerifyRequirement)requirement).doNotRequireTimestamp();
            }
            if (!targets.isEmpty()) {
                ((VerifyRequirement)requirement).addTargets(targets);
            }
        }
        requirements.append(requirement);
    }

    private static void readDecryptSettings(SecurityRequirements requirements, Element decryptSettings) {
        NamedNodeMap decryptAttributes = decryptSettings.getAttributes();
        int attributeCount = decryptAttributes.getLength();
        String attributeName = null;
        int index = 0;
        if (index < attributeCount) {
            Attr decryptAttribute = (Attr)decryptAttributes.item(index);
            attributeName = decryptAttribute.getName();
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:requireEncryption"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of Decrypt");
        }
        boolean noneEnforced = true;
        ArrayList<Target> targets = new ArrayList<Target>();
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(decryptSettings);
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (!TARGET_QNAME.equals(subElementQName)) {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of RequireEncryption");
            }
            Target target = SecurityConfigurationXmlReader.readTargetSettings(eachSubElement);
            noneEnforced = noneEnforced && !target.getEnforce();
            targets.add(target);
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
        SecurityRequirement requirement = null;
        if (noneEnforced && !targets.isEmpty()) {
            requirement = new AllowEncryption();
            ((AllowEncryption)requirement).addTargets(targets);
        } else {
            requirement = new DecryptRequirement();
            if (!targets.isEmpty()) {
                ((DecryptRequirement)requirement).addTargets(targets);
            }
        }
        requirements.append(requirement);
    }

    private static void readOptionalTargetSettings(SecurityRequirements requirements, Element optionalTargetSettings) {
        ArrayList<Target> targets = new ArrayList<Target>();
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(optionalTargetSettings);
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (!TARGET_QNAME.equals(subElementQName)) {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of OptionalTargets");
            }
            targets.add(SecurityConfigurationXmlReader.readTargetSettings(eachSubElement));
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
        requirements.addOptionalTargets(targets);
    }

    private static void readUsernamePasswordRequirementSettings(UsernamePasswordRequirement requirement, Element authenticateUserSettings) {
        NamedNodeMap authenticateUserAttributes = authenticateUserSettings.getAttributes();
        int attributeCount = authenticateUserAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr authenticateUserAttribute = (Attr)authenticateUserAttributes.item(index);
            attributeName = authenticateUserAttribute.getName();
            if ("nonceRequired".equalsIgnoreCase(attributeName)) {
                requirement.setNonceRequired(authenticateUserAttribute.getValue());
                continue;
            }
            if ("passwordDigestRequired".equalsIgnoreCase(attributeName)) {
                requirement.setPasswordDigestRequired(authenticateUserAttribute.getValue());
                continue;
            }
            log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:requireUsernameToken"});
            throw new IllegalStateException(attributeName + " is not a recognized attribute of requireUsernameToken");
        }
        Element someElement = SecurityConfigurationXmlReader.getFirstChildElement(authenticateUserSettings);
        if (someElement != null) {
            log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", SecurityConfigurationXmlReader.getQName(someElement));
            throw new IllegalStateException(SecurityConfigurationXmlReader.getQName(someElement) + " is not a recognized sub-element of RequireUsernameToken");
        }
    }

    private static void readEncryptionSettings(EncryptOperation operation, Element encryptionSettings) {
        NamedNodeMap encryptionAttributes = encryptionSettings.getAttributes();
        int attributeCount = encryptionAttributes.getLength();
        String attributeName = null;
        for (int index = 0; index < attributeCount; ++index) {
            Attr encryptionAttribute = (Attr)encryptionAttributes.item(index);
            attributeName = encryptionAttribute.getName();
            if (!"keyEncryptionAlgorithm".equalsIgnoreCase(attributeName)) {
                log.log(Level.SEVERE, "WSS0512.illegal.attribute.name", new Object[]{attributeName, "xwss:Encrypt"});
                throw new IllegalStateException(attributeName + " is not a recognized attribute of Encrypt");
            }
            operation.setKeyEncryptionAlgorithm(SecurityConfigurationXmlReader.getKeyEncryptionAlgorithmURI(encryptionAttribute.getValue()));
        }
        Element eachSubElement = SecurityConfigurationXmlReader.getFirstChildElement(encryptionSettings);
        boolean x509TokenSeen = false;
        boolean symmetricKeySeen = false;
        while (eachSubElement != null) {
            QName subElementQName = SecurityConfigurationXmlReader.getQName(eachSubElement);
            if (TARGET_QNAME.equals(subElementQName)) {
                operation.addTarget(SecurityConfigurationXmlReader.readTargetSettings(eachSubElement));
            } else if (X509TOKEN_ELEMENT_QNAME.equals(subElementQName)) {
                if (x509TokenSeen) {
                    log.log(Level.SEVERE, "WSS0516.duplicate.configuration.element", new Object[]{"xwss:X509Token", "xwss:Encrypt"});
                    throw new IllegalStateException("Atmost one X509 token can be configured for an encrypt operation");
                }
                SecurityConfigurationXmlReader.readX509TokenSettings(operation, eachSubElement);
                x509TokenSeen = true;
            } else if (SYMMETRIC_KEY_ELEMENT_QNAME.equals(subElementQName)) {
                if (symmetricKeySeen) {
                    log.log(Level.SEVERE, "WSS0516.duplicate.configuration.element", new Object[]{"xwss:SymmetricKey", "xwss:Encrypt"});
                    throw new IllegalStateException("Atmost one symmetric key can be configured for an encrypt operation");
                }
                SecurityConfigurationXmlReader.readSymmetricKeySettings(operation, eachSubElement);
                symmetricKeySeen = true;
            } else {
                log.log(Level.SEVERE, "WSS0513.illegal.configuration.element", subElementQName.toString());
                throw new IllegalStateException(subElementQName + " is not a recognized sub-element of Encrypt");
            }
            eachSubElement = SecurityConfigurationXmlReader.getNextElement(eachSubElement);
        }
        if (x509TokenSeen && symmetricKeySeen) {
            log.log(Level.SEVERE, "WSS0520.illegal.configuration.state");
            throw new IllegalStateException("Both X509Token and SymmetricKey can't occur at the same time under the Encrypt configuration element");
        }
    }

    private static StrategyInfo createKeyReferenceStrategy(String string) {
        if ("Direct".equalsIgnoreCase(string)) {
            return new DirectReferenceStrategyInfo();
        }
        if ("Identifier".equalsIgnoreCase(string)) {
            return new IdentifierStrategyInfo();
        }
        if ("Alias".equalsIgnoreCase(string)) {
            return new NameStrategyInfo();
        }
        if ("IssuerSerialNumber".equalsIgnoreCase(string)) {
            return new SerialNumberStrategyInfo();
        }
        log.log(Level.SEVERE, "WSS0515.illegal.keyreference", string);
        throw new IllegalStateException(string + "is not a recognized key reference strategy");
    }

    public static SecurityConfiguration readProceduralConfiguration(Element configData) throws Exception {
        SecurityConfiguration configuration = new SecurityConfiguration();
        Element eachHolder = SecurityConfigurationXmlReader.getFirstChildElement(configData);
        while (eachHolder != null) {
            QName filterHolderType = SecurityConfigurationXmlReader.getQName(eachHolder);
            if (ANNOTATOR_QNAME.equals(filterHolderType)) {
                SecurityConfigurationXmlReader.readAnnotator(eachHolder, configuration);
            } else if (RECIPIENT_QNAME.equals(filterHolderType)) {
                SecurityConfigurationXmlReader.readRecipient(eachHolder, configuration);
            } else if (PROPERTIES_QNAME.equals(filterHolderType)) {
                SecurityConfigurationXmlReader.readProperties(eachHolder, configuration);
            } else {
                log.log(Level.SEVERE, "WSS0503.bad.reader.state.2", new String[]{ANNOTATOR_QNAME.toString(), RECIPIENT_QNAME.toString(), PROPERTIES_QNAME.toString(), filterHolderType.toString()});
                throw new IllegalStateException("Bad reader state. Expected either:" + ANNOTATOR_QNAME + " or " + RECIPIENT_QNAME + " or " + PROPERTIES_QNAME + " but got: " + filterHolderType);
            }
            eachHolder = SecurityConfigurationXmlReader.getNextElement(eachHolder);
        }
        return configuration;
    }

    private static QName getQName(Node element) {
        return new QName(element.getNamespaceURI(), element.getLocalName());
    }

    private static void readRecipient(Element recipientData, SecurityConfiguration configuration) throws Exception {
        configuration.setHasRecipient();
        SecurityConfigurationXmlReader.readFilters(recipientData, configuration.getRecipientFilters());
    }

    private static void readAnnotator(Element annotatorData, SecurityConfiguration configuration) throws Exception {
        configuration.setHasAnnotator();
        SecurityConfigurationXmlReader.readFilters(annotatorData, configuration.getAnnotatorFilters());
    }

    private static void readFilters(Element correspondentData, List filterList) throws Exception {
        Element eachFilter = SecurityConfigurationXmlReader.getFirstChildElement(correspondentData);
        while (eachFilter != null) {
            if (!$assertionsDisabled && !FILTER_QNAME.equals(SecurityConfigurationXmlReader.getQName(eachFilter))) {
                throw new AssertionError();
            }
            FilterInfo filterInfo = new FilterInfo();
            String typeName = eachFilter.getAttribute("className");
            filterInfo.setTypeName(typeName);
            filterList.add(filterInfo);
            NamedNodeMap filterAttributes = eachFilter.getAttributes();
            int attributeCount = filterAttributes.getLength();
            String parameterName = null;
            for (int index = 0; index < attributeCount; ++index) {
                Attr filterParameter = (Attr)filterAttributes.item(index);
                parameterName = filterParameter.getName();
                if (parameterName.equalsIgnoreCase("className")) continue;
                filterInfo.setInitializationParameter(parameterName, filterParameter.getValue());
            }
            eachFilter = SecurityConfigurationXmlReader.getNextElement(eachFilter);
        }
    }

    private static Element getFirstChildElement(Node node) {
        Node nextSibling;
        for (nextSibling = node.getFirstChild(); nextSibling != null && !(nextSibling instanceof Element); nextSibling = nextSibling.getNextSibling()) {
        }
        return (Element)nextSibling;
    }

    private static Element getNextElement(Node node) {
        Node nextSibling = node;
        while (nextSibling != null && !((nextSibling = nextSibling.getNextSibling()) instanceof Element)) {
        }
        return (Element)nextSibling;
    }

    private static void readProperties(Element propertyData, SecurityConfiguration configuration) throws Exception {
        configuration.setHasProperties();
        for (Element eachProperty = (Element)propertyData.getFirstChild(); eachProperty != null; eachProperty = (Element)eachProperty.getNextSibling()) {
            SecurityConfigurationXmlReader.readProperty(eachProperty, configuration.getProperties());
        }
    }

    private static void readProperty(Element propertyData, Properties properties) throws Exception {
        String propertyName = propertyData.getAttributeNS(null, "name");
        String propertyValue = propertyData.getAttributeNS(null, "value");
        properties.setProperty(propertyName, propertyValue);
    }

    private static String resolveParentJAXRPCConfigurationElement(int identifier) {
        String parent = null;
        switch (identifier) {
            case 0: {
                parent = JAXRPC_SECURITY_ELEMENT_QNAME.toString();
                break;
            }
            case 1: {
                parent = SERVICE_ELEMENT_QNAME.toString();
                break;
            }
            case 2: {
                parent = PORT_ELEMENT_QNAME.toString();
            }
        }
        return parent;
    }

    private static String getKeyEncryptionAlgorithmURI(String keyEncAlgoValue) {
        if ("RSA_OAEP".equalsIgnoreCase(keyEncAlgoValue)) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
        }
        if ("RSA_v1dot5".equalsIgnoreCase(keyEncAlgoValue)) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        log.log(Level.SEVERE, "WSS0522.unrecognized.key.encryption.algorithm", keyEncAlgoValue);
        throw new IllegalArgumentException(keyEncAlgoValue + "is not a recognized keyEncryptionAlgorithm value");
    }

    static {
        $assertionsDisabled = !SecurityConfigurationXmlReader.class.desiredAssertionStatus();
        log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    }

    private static class ErrorHandler
    extends DefaultHandler {
        PrintStream out;

        public ErrorHandler(PrintStream out) {
            this.out = out;
        }

        public void error(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
        }

        public void warning(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (this.out != null) {
                this.out.println(e);
            }
        }
    }
}

