/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.configuration;

import com.sun.xml.wss.configuration.ConfigurationBuilder;
import com.sun.xml.wss.configuration.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.configuration.JAXRPCSettings;
import com.sun.xml.wss.configuration.SecurityConfiguration;

public class JAXRPCSecurityConfiguration
extends DeclarativeSecurityConfiguration {
    private boolean isPort = false;
    private boolean isService = false;
    private boolean isOperation = false;
    private JAXRPCSettings jaxrpcSettings = null;
    private String jaxrpcElementIdentifier = null;
    private String jaxrpcParentIdentifier = null;
    private String environmentHandlerClsName = null;

    public void setSecurityEnvironmentHandler(String clsName) {
        this.environmentHandlerClsName = clsName;
    }

    public String getSecurityEnvironmentHandler() {
        return this.environmentHandlerClsName;
    }

    public JAXRPCSettings JAXRPCSettings() {
        if (this.jaxrpcSettings == null) {
            this.jaxrpcSettings = new JAXRPCSettings();
        }
        return this.jaxrpcSettings;
    }

    public JAXRPCSettings JAXRPCServices() throws Exception {
        if (this.isService || this.isPort || this.isOperation) {
            throw new Exception("Illegal use of method");
        }
        return this.JAXRPCSettings();
    }

    public JAXRPCSettings JAXRPCPorts() throws Exception {
        if (this.isPort || this.isOperation) {
            throw new Exception("Illegal use of method");
        }
        this.isService = true;
        return this.JAXRPCSettings();
    }

    public JAXRPCSettings JAXRPCOperations() throws Exception {
        if (this.isOperation || this.isService) {
            throw new Exception("Illegal use of method");
        }
        this.isPort = true;
        return this.JAXRPCSettings();
    }

    public void setJAXRPCServiceName(String service) throws Exception {
        if (this.isPort || this.isOperation) {
            throw new Exception("Illegal use of method");
        }
        this.jaxrpcElementIdentifier = service;
        this.isService = true;
    }

    public void setJAXRPCPortName(String port) throws Exception {
        if (this.isOperation || this.isService) {
            throw new Exception("Illegal use of method");
        }
        this.jaxrpcElementIdentifier = port;
        this.isPort = true;
    }

    public void setJAXRPCOperationName(String operation) throws Exception {
        if (this.isPort || this.isService) {
            throw new Exception("Illegal use of method");
        }
        this.jaxrpcElementIdentifier = operation;
        this.isOperation = true;
    }

    public String getJAXRPCServiceName() throws Exception {
        if (!this.isService) {
            throw new Exception("Illegal use of method");
        }
        return this.jaxrpcElementIdentifier;
    }

    public String getJAXRPCPortName() throws Exception {
        if (!this.isPort) {
            throw new Exception("Illegal use of method");
        }
        return this.jaxrpcElementIdentifier;
    }

    public String getJAXRPCOperationName() throws Exception {
        if (!this.isOperation) {
            throw new Exception("Illegal use of method");
        }
        return this.jaxrpcElementIdentifier;
    }

    public void setParentElementName(String parent) throws Exception {
        this.jaxrpcParentIdentifier = parent;
    }

    public SecurityConfiguration createConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder(this);
        return builder.buildConfiguration();
    }
}

