/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebPrincipal;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transaction;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceEvent;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Realm;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

public final class J2EEInstanceListener
implements InstanceListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private InvocationManager im = Switch.getSwitch().getInvocationManager();
    private J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
    private static AuthPermission doAsPrivilegedPerm = new AuthPermission("doAsPrivileged");

    public void instanceEvent(InstanceEvent event) {
        String eventType = event.getType();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "*** InstanceEvent: " + eventType);
        }
        if (eventType.equals("beforeService") || eventType.equals("beforeFilter") || eventType.equals("beforeInit") || eventType.equals("beforeDestroy") || eventType.equals("beforeDispatch")) {
            this.handleBeforeEvent(event, eventType);
        } else if (eventType.equals("afterService") || eventType.equals("afterFilter") || eventType.equals("afterInit") || eventType.equals("afterDestroy") || eventType.equals("afterDispatch")) {
            this.handleAfterEvent(event, eventType);
        }
    }

    private void handleBeforeEvent(InstanceEvent event, String eventType) {
        ServletRequest request;
        Object instance = null;
        instance = eventType.equals("beforeFilter") ? event.getFilter() : event.getServlet();
        Context context = (Context)event.getWrapper().getParent();
        final ClassLoader cl = context.getLoader().getClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
        Realm ra = context.getRealm();
        if (ra != null && (request = event.getRequest()) != null && request instanceof HttpServletRequest) {
            Principal prin;
            HttpServletRequest hreq;
            HttpServletRequest base = hreq = (HttpServletRequest)request;
            Principal basePrincipal = prin = hreq.getUserPrincipal();
            boolean wrapped = false;
            while (prin != null && base != null) {
                ServletRequest sr;
                if (base instanceof ServletRequestWrapper && (sr = ((ServletRequestWrapper)base).getRequest()) instanceof HttpServletRequest) {
                    base = (HttpServletRequest)sr;
                    wrapped = true;
                    continue;
                }
                if (wrapped) {
                    basePrincipal = base.getUserPrincipal();
                    break;
                }
                if (base instanceof CoyoteRequestFacade) {
                    if (base.getClass() == CoyoteRequestFacade.class) break;
                    basePrincipal = ((CoyoteRequestFacade)base).getUnwrappedCoyoteRequest().getUserPrincipal();
                    break;
                }
                basePrincipal = base.getUserPrincipal();
                break;
            }
            if (prin != null && prin == basePrincipal && prin instanceof WebPrincipal) {
                SecurityContext.setCurrent(J2EEInstanceListener.getSecurityContextForPrincipal(prin));
            } else if (prin != basePrincipal) {
                J2EEInstanceListener.checkObjectForDoAsPermission(hreq);
                SecurityContext.setCurrent(J2EEInstanceListener.getSecurityContextForPrincipal(prin));
            }
        }
        ComponentInvocation inv = new ComponentInvocation(instance, context);
        try {
            this.im.preInvoke(inv);
            if (eventType.equals("beforeService")) {
                Transaction tran = null;
                tran = this.tm.getTransaction();
                if (tran != null) {
                    inv.setTransaction(tran);
                }
                this.tm.enlistComponentResources();
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "web_server.excep_handle_before_event", ex);
        }
    }

    private static void checkObjectForDoAsPermission(final Object o) throws AccessControlException {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ProtectionDomain pD = o.getClass().getProtectionDomain();
                    Policy p = Policy.getPolicy();
                    if (!p.implies(pD, doAsPrivilegedPerm)) {
                        throw new AccessControlException("permission required to override getUserPrincipal", doAsPrivilegedPerm);
                    }
                    return null;
                }
            });
        }
    }

    private static SecurityContext getSecurityContextForPrincipal(final Principal p) {
        if (p == null) {
            return null;
        }
        if (p instanceof WebPrincipal) {
            return ((WebPrincipal)p).getSecurityContext();
        }
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject s = new Subject();
                s.getPrincipals().add(p);
                return new SecurityContext(p.getName(), s);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleAfterEvent(InstanceEvent event, String eventType) {
        block23: {
            if (AppVerification.doInstrument() && (eventType.equals("afterService") || eventType.equals("afterInit") || eventType.equals("afterDispatch"))) {
                AppVerification.getInstrumentLogger().doInstrumentForWeb(event);
            }
            Object instance = null;
            instance = eventType.equals("afterFilter") ? event.getFilter() : event.getServlet();
            Context context = (Context)event.getWrapper().getParent();
            ComponentInvocation inv = new ComponentInvocation(instance, context);
            this.im.postInvoke(inv);
            Object var8_6 = null;
            if (eventType.equals("afterDestroy")) {
                this.tm.componentDestroyed(instance);
            }
            if (!eventType.equals("afterFilter") && !eventType.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
            try {
                Realm ra = context.getRealm();
                if (ra != null && ra instanceof RealmAdapter) {
                    ((RealmAdapter)ra).logout();
                }
            }
            catch (Exception ex2) {
                _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
            }
            try {
                if (this.tm.getTransaction() != null) {
                    this.tm.rollback();
                }
                break block23;
            }
            catch (Exception ex2) {}
            break block23;
            {
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex);
                    Object var8_7 = null;
                    if (eventType.equals("afterDestroy")) {
                        this.tm.componentDestroyed(instance);
                    }
                    if (!eventType.equals("afterFilter") && !eventType.equals("afterService") || this.im.getCurrentInvocation() != null) break block23;
                    try {
                        Realm ra = context.getRealm();
                        if (ra != null && ra instanceof RealmAdapter) {
                            ((RealmAdapter)ra).logout();
                        }
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                        break block23;
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (eventType.equals("afterDestroy")) {
                    this.tm.componentDestroyed(instance);
                }
                if ((eventType.equals("afterFilter") || eventType.equals("afterService")) && this.im.getCurrentInvocation() == null) {
                    try {
                        Realm ra = context.getRealm();
                        if (ra != null && ra instanceof RealmAdapter) {
                            ((RealmAdapter)ra).logout();
                        }
                    }
                    catch (Exception ex2) {
                        _logger.log(Level.SEVERE, "web_server.excep_handle_after_event", ex2);
                    }
                    try {
                        if (this.tm.getTransaction() != null) {
                            this.tm.rollback();
                        }
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }
}

