/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.catalina.net.ServerSocketFactory;

public class SSLSocketFactory
implements ServerSocketFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private static final boolean clientAuth = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SSLSocketFactory.class);
    private SSLContext context = null;
    private SSLServerSocketFactory factory = null;
    private String[] cipherSuites;
    private static SecureRandom sr = J2EEServer.secureRandom;
    private static KeyManager[] keyManagers = null;
    private static TrustManager[] trustManagers = null;

    public SSLSocketFactory() {
        try {
            if (keyManagers == null || trustManagers == null) {
                SSLUtils.initStoresAtStartup();
            }
            this.context = SSLContext.getInstance("TLS");
            this.context.init(keyManagers, trustManagers, sr);
            this.factory = this.context.getServerSocketFactory();
            this.cipherSuites = this.factory.getSupportedCipherSuites();
            for (int i = 0; i < this.cipherSuites.length; ++i) {
                if (!_logger.isLoggable(Level.FINEST)) continue;
                _logger.log(Level.FINEST, "Suite: " + this.cipherSuites[i]);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web_security.excep_sslsockfact", e.getMessage());
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port);
        this.init(socket);
        return socket;
    }

    private void init(SSLServerSocket socket) {
        socket.setNeedClientAuth(false);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        this.init(socket);
        return socket;
    }

    public static void setManagers(KeyManager[] kmgrs, TrustManager[] tmgrs) {
        keyManagers = kmgrs;
        trustManagers = tmgrs;
    }
}

