/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.web.security.MethodValue;
import com.sun.web.security.WebPermissionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class MapValue {
    int patternType;
    int patternLength;
    boolean irrelevantByQualifier;
    StringBuffer urlPatternSpec;
    MethodValue[] methodValues;
    private static Object[] methodKeys;
    private static HashMap methodHash;
    private static int allMethodSet;
    private static String[][] methodArrays;

    static String[] getMethodArray(int methodSet) {
        if (methodSet > allMethodSet) {
            throw new IllegalArgumentException("constraint translation error-invalid methodSet");
        }
        if (methodSet == 0) {
            return null;
        }
        if (methodArrays[methodSet] == null) {
            int size = 0;
            ArrayList<String> methods = new ArrayList<String>();
            for (int i = 0; i < methodKeys.length; ++i) {
                if ((methodSet & 1 << i) != 1 << i) continue;
                methods.add((String)methodKeys[i]);
                ++size;
            }
            MapValue.methodArrays[methodSet] = methods.toArray(new String[size]);
        }
        return methodArrays[methodSet];
    }

    static int methodArrayToSet(String[] methods) {
        int methodSet = 0;
        if (methods == null || methods.length == 0) {
            methodSet = allMethodSet;
        } else {
            for (int i = 0; i < methods.length; ++i) {
                Integer bit = (Integer)methodHash.get(methods[i]);
                if (bit == null) {
                    throw new IllegalArgumentException("constraint translation error-invalid http method");
                }
                methodSet |= bit.intValue();
            }
        }
        return methodSet;
    }

    MapValue(String urlPattern) {
        this.patternType = WebPermissionUtil.patternType(urlPattern);
        this.patternLength = urlPattern.length();
        this.irrelevantByQualifier = false;
        this.urlPatternSpec = new StringBuffer(urlPattern);
        this.methodValues = new MethodValue[methodKeys.length];
        for (int i = 0; i < methodKeys.length; ++i) {
            this.methodValues[i] = new MethodValue();
        }
    }

    void addQualifier(String urlPattern) {
        if (WebPermissionUtil.implies(urlPattern, this.urlPatternSpec.substring(0, this.patternLength))) {
            this.irrelevantByQualifier = true;
        }
        this.urlPatternSpec.append(":" + urlPattern);
    }

    void setRoleOnMethods(String role, int methodSet, WebBundleDescriptor wbd) {
        if (role.equals("*")) {
            Iterator it = wbd.getRoles().iterator();
            while (it.hasNext()) {
                this.setRoleOnMethods(((Role)it.next()).getName(), methodSet, wbd);
            }
        } else {
            for (int i = 0; i < methodKeys.length; ++i) {
                if ((methodSet & 1 << i) != 1 << i || this.methodValues[i].roleList.contains(role)) continue;
                this.methodValues[i].roleList.add(role);
            }
        }
    }

    void setPredefinedOutcomeOnMethods(int methodSet, boolean outcome) {
        for (int i = 0; i < methodKeys.length; ++i) {
            if ((methodSet & 1 << i) != 1 << i) continue;
            if (!outcome) {
                this.methodValues[i].excluded = true;
                continue;
            }
            this.methodValues[i].authConstrained = false;
        }
    }

    void setConnectOnMethods(String guarantee, int methodSet) {
        for (int i = 0; i < methodKeys.length; ++i) {
            if ((methodSet & 1 << i) != 1 << i) continue;
            int b = MethodValue.connectTypeNone;
            if (guarantee != null) {
                Integer bit = (Integer)MethodValue.connectHash.get(guarantee);
                if (bit == null) {
                    throw new IllegalArgumentException("constraint translation error-illegal trx guarantee");
                }
                b = bit;
            }
            this.methodValues[i].connectSet |= b;
        }
    }

    String[] getMethodsWithPredefinedOutcome(boolean outcome) {
        int methodSet = 0;
        for (int i = 0; i < methodKeys.length; ++i) {
            if (this.methodValues[i].excluded) {
                if (outcome) continue;
                methodSet |= 1 << i;
                continue;
            }
            if (!outcome || this.methodValues[i].authConstrained && !this.methodValues[i].roleList.isEmpty()) continue;
            methodSet |= 1 << i;
        }
        return MapValue.getMethodArray(methodSet);
    }

    HashMap getRoleMap() {
        HashMap<String, Integer> roleMap = new HashMap<String, Integer>();
        for (int i = 0; i < methodKeys.length; ++i) {
            if (this.methodValues[i].excluded || !this.methodValues[i].authConstrained) continue;
            Iterator it = this.methodValues[i].roleList.iterator();
            while (it.hasNext()) {
                String role = (String)it.next();
                Integer methodSet = (Integer)roleMap.get(role);
                methodSet = methodSet == null ? new Integer(1 << i) : new Integer(methodSet | 1 << i);
                roleMap.put(role, methodSet);
            }
        }
        return roleMap;
    }

    String[] getConnectMap(int cType) {
        int methodSet = 0;
        for (int i = 0; i < methodKeys.length; ++i) {
            if (this.methodValues[i].excluded) continue;
            if (this.methodValues[i].connectSet == 0) {
                this.methodValues[i].connectSet = MethodValue.connectTypeNone;
            }
            if ((cType & this.methodValues[i].connectSet) != cType) continue;
            methodSet |= 1 << i;
        }
        return MapValue.getMethodArray(methodSet);
    }

    static {
        int i;
        methodKeys = new Object[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
        methodHash = new HashMap();
        for (i = 0; i < methodKeys.length; ++i) {
            methodHash.put(methodKeys[i], new Integer(1 << i));
        }
        allMethodSet = 0;
        for (i = 0; i < methodKeys.length; ++i) {
            allMethodSet += 1 << i;
        }
        methodArrays = new String[allMethodSet + 1][];
    }
}

