/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.transforms;

import com.sun.org.apache.xml.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.security.transforms.Transform;
import com.sun.org.apache.xml.security.transforms.TransformationException;
import com.sun.org.apache.xml.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Transforms
extends SignatureElementProxy {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$transforms$Transforms == null ? (class$com$sun$org$apache$xml$security$transforms$Transforms = Transforms.class$("com.sun.org.apache.xml.security.transforms.Transforms")) : class$com$sun$org$apache$xml$security$transforms$Transforms).getName());
    public static final String TRANSFORM_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANSFORM_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANSFORM_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANSFORM_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TRANSFORM_XPATH2FILTER04 = "http://www.w3.org/2002/04/xmldsig-filter2";
    public static final String TRANSFORM_XPATH2FILTER = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String TRANSFORM_XPATHFILTERCHGP = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$transforms$Transforms;

    public Transforms(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public Transforms(Element element, String string) throws DOMException, XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        int n = this.getLength();
        if (n == 0) {
            Object[] objectArray = new Object[]{"Transform", "Transforms"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
    }

    public void addTransform(String string) throws TransformationException {
        try {
            log.log(Level.FINE, "Transforms.addTransform(" + string + ")");
            Transform transform = Transform.getInstance(this._doc, string);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, Element element) throws TransformationException {
        try {
            log.log(Level.FINE, "Transforms.addTransform(" + string + ")");
            Transform transform = Transform.getInstance(this._doc, string, element);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, NodeList nodeList) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string, nodeList);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    private void addTransform(Transform transform) {
        log.log(Level.FINE, "Transforms.addTransform(" + transform.getURI() + ")");
        Element element = transform.getElement();
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            for (int i = 0; i < this.getLength(); ++i) {
                Transform transform = this.item(i);
                log.log(Level.FINE, "Preform the (" + i + ")th " + transform.getURI() + " transform");
                xMLSignatureInput = transform.performTransform(xMLSignatureInput);
            }
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
    }

    public int getLength() throws TransformationException {
        int n = 0;
        for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"Transform".equals(node.getLocalName()) || !"http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI())) continue;
            ++n;
        }
        if (n == 0) {
            throw new TransformationException("empty");
        }
        return n;
    }

    public Transform item(int n) throws TransformationException {
        try {
            for (Node node = this._constructionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"Transform".equals(node.getLocalName()) || !"http://www.w3.org/2000/09/xmldsig#".equals(node.getNamespaceURI())) continue;
                if (n == 0) {
                    return new Transform((Element)node, this._baseURI);
                }
                --n;
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
    }

    public String getBaseLocalName() {
        return "Transforms";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

