/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.keys.keyresolver.implementations;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl;
import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.keys.content.RetrievalMethod;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.security.transforms.Transforms;
import com.sun.org.apache.xml.security.utils.XMLUtils;
import com.sun.org.apache.xml.security.utils.resolver.ResourceResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethodResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver == null ? (class$com$sun$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver = RetrievalMethodResolver.class$("com.sun.org.apache.xml.security.keys.keyresolver.implementations.RetrievalMethodResolver")) : class$com$sun$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver).getName());
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$keys$keyresolver$implementations$RetrievalMethodResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        try {
            XMLUtils.guaranteeThatElementInSignatureSpace(element, "RetrievalMethod");
        }
        catch (XMLSignatureException xMLSignatureException) {
            return false;
        }
        return true;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            String string2 = retrievalMethod.getType();
            Transforms transforms = retrievalMethod.getTransforms();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
            if (resourceResolver != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                log.log(Level.FINE, "Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                if (transforms != null) {
                    log.log(Level.FINE, "We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                log.log(Level.FINE, "After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                log.log(Level.FINE, "Resolved to resource " + xMLSignatureInput.getSourceURI());
                byte[] byArray = xMLSignatureInput.getBytes();
                if (string2 != null && string2.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate.getPublicKey();
                    }
                } else {
                    KeyResolver keyResolver;
                    log.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
                    Element element2 = this.getDocFromBytes(byArray);
                    log.log(Level.FINE, "Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                        return keyResolver.resolvePublicKey(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "IOException", iOException);
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            RetrievalMethod retrievalMethod = new RetrievalMethod(element, string);
            Attr attr = retrievalMethod.getURIAttr();
            Transforms transforms = retrievalMethod.getTransforms();
            log.log(Level.FINE, "Asked to resolve URI " + attr);
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, string);
            if (resourceResolver != null) {
                XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, string);
                log.log(Level.FINE, "Before applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                if (transforms != null) {
                    log.log(Level.FINE, "We have Transforms");
                    xMLSignatureInput = transforms.performTransforms(xMLSignatureInput);
                }
                log.log(Level.FINE, "After applying Transforms, resource has " + xMLSignatureInput.getBytes().length + "bytes");
                log.log(Level.FINE, "Resolved to resource " + xMLSignatureInput.getSourceURI());
                byte[] byArray = xMLSignatureInput.getBytes();
                if (retrievalMethod.getType() != null && retrievalMethod.getType().equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                    if (x509Certificate != null) {
                        return x509Certificate;
                    }
                } else {
                    KeyResolver keyResolver;
                    log.log(Level.FINE, "we have to parse " + byArray.length + " bytes");
                    Element element2 = this.getDocFromBytes(byArray);
                    log.log(Level.FINE, "Now we have a {" + element2.getNamespaceURI() + "}" + element2.getLocalName() + " Element");
                    if (element2 != null && (keyResolver = KeyResolver.getInstance(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver)) != null) {
                        return keyResolver.resolveX509Certificate(RetrievalMethodResolver.getFirstElementChild(element2), string, storageResolver);
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.log(Level.FINE, "XMLSecurityException", xMLSecurityException);
        }
        catch (CertificateException certificateException) {
            log.log(Level.FINE, "CertificateException", certificateException);
        }
        catch (IOException iOException) {
            log.log(Level.FINE, "IOException", iOException);
        }
        return null;
    }

    Element getDocFromBytes(byte[] byArray) throws KeyResolverException {
        try {
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryImpl.setNamespaceAware(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            return document.getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new KeyResolverException("empty", sAXException);
        }
        catch (IOException iOException) {
            throw new KeyResolverException("empty", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new KeyResolverException("empty", parserConfigurationException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    public static Element getFirstElementChild(Element element) {
        Node node;
        for (node = element.getFirstChild(); node != null && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (Element)node;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

