/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.keys.content.x509;

import com.sun.org.apache.xml.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.security.keys.content.x509.XMLX509DataContent;
import com.sun.org.apache.xml.security.utils.Base64;
import com.sun.org.apache.xml.security.utils.JavaUtils;
import com.sun.org.apache.xml.security.utils.SignatureElementProxy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import sun.security.util.DerValue;

public class XMLX509SKI
extends SignatureElementProxy
implements XMLX509DataContent {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$keys$content$x509$XMLX509SKI == null ? (class$com$sun$org$apache$xml$security$keys$content$x509$XMLX509SKI = XMLX509SKI.class$("com.sun.org.apache.xml.security.keys.content.x509.XMLX509SKI")) : class$com$sun$org$apache$xml$security$keys$content$x509$XMLX509SKI).getName());
    public static final String SKI_OID = "2.5.29.14";
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$keys$content$x509$XMLX509SKI;

    public XMLX509SKI(Document document, byte[] byArray) {
        super(document);
        this.addBase64Text(byArray);
    }

    public XMLX509SKI(Document document, X509Certificate x509Certificate) throws XMLSecurityException {
        super(document);
        this.addBase64Text(XMLX509SKI.getSKIBytesFromCert(x509Certificate));
    }

    public XMLX509SKI(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public byte[] getSKIBytes() throws XMLSecurityException {
        return this.getBytesFromTextChild();
    }

    public static byte[] getSKIBytesFromCert(X509Certificate x509Certificate) throws XMLSecurityException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(SKI_OID);
            if (x509Certificate.getVersion() < 3) {
                Object[] objectArray = new Object[]{new Integer(x509Certificate.getVersion())};
                throw new XMLSecurityException("certificate.noSki.lowVersion", objectArray);
            }
            DerValue derValue = new DerValue(byArray);
            if (derValue == null) {
                throw new XMLSecurityException("certificate.noSki.null");
            }
            if (derValue.tag != 4) {
                throw new XMLSecurityException("certificate.noSki.notOctetString");
            }
            byte[] byArray2 = derValue.getOctetString();
            byte[] byArray3 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray3, 0, byArray3.length);
            log.log(Level.FINE, "Base64 of SKI is " + Base64.encode(byArray3));
            return byArray3;
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public boolean equals(Object object) {
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        XMLX509SKI xMLX509SKI = (XMLX509SKI)object;
        try {
            return JavaUtils.binaryCompare(xMLX509SKI.getSKIBytes(), this.getSKIBytes());
        }
        catch (XMLSecurityException xMLSecurityException) {
            return false;
        }
    }

    public String getBaseLocalName() {
        return "X509SKI";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

